<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller {

    private $userInfo = array();

    public function __construct()
    {
        parent::__construct();
        $this->user_model->check_login("admin");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }

    public function index()
    {
    redirect('admin/user/view',"refresh");
    }
    
     public function add_timetable()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);

        $this->user_model->check_permissions('admin/user/add');
            $this->load->view('user/timetable_add',$data);
    
    }
    
    public function doo_upload()
        {
        $config['upload_path']='./assets/file/';
        $config['allowed_types'] = 'pdf|doc|docx';
        $this->load->library('upload', $config);
            if ($this->upload->do_upload('img')){
                $data=$this->upload->data();
                return $data['file_name'];
            }
        }
        
     public function timetable_save()
    {
        if($this->input->post())
            {
   
    
         $url=$this->doo_upload();
         $data = array(
       				'day_name' => $this->input->post('fname'),
       				'file'=>$url,
       				'description'=>$this->input->post('des')
                        );
                        $qry=$this->db->insert('timetable',$data);
                        if($qry)
                        {
                            $this->session->set_flashdata('msg','Record successfully add...');
                            redirect('Admin/add_timetable');
                        }
           }


    }
    
     public function view_timetable()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);

         $this->db->select("*"); 
         $this->db->from('timetable');
         $this->db->where('is_delete',0);
         $query = $this->db->get();
         $data['orders'] = $query->result_array();
     
            $this->load->view('user/view_timetable',$data);
    
    }
      public function std_view_timetable()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);

         $this->db->select("*"); 
         $this->db->from('timetable');
         $this->db->where('is_delete',0);
         $query = $this->db->get();
         $data['orders'] = $query->result_array();
     
            $this->load->view('user/std_view_timetable',$data);
    
    }
    public function timetable_delete($id)
    {
      
         $data = array(
                "is_delete"=>"1"
            );

            $this->db->where("id",$id);
            $this->db->update("timetable",$data);
            redirect("admin/view_timetable","refresh");
    }
    
     public function timetable_edit($id)
    {
         $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        
           $this->db->select("*"); 
            $this->db->from('timetable');
            $this->db->where("is_delete","0");
            $this->db->where("id",$id);
            $query = $this->db->get();
            $data['admin'] = $query->result_array()[0];
           
            $this->load->view('user/timetable_edit',$data);
    }

    
     public function timetable_update()
    {
     
               $file=$this->input->post('img');
    
               if(empty($file)){
                  $file=$this->input->post("old_file",true);
               
                 $id = $this->input->post("id",true);
                $name = $this->input->post("fname",true);
                $date = $this->input->post("date",true);
                 $dec = $this->input->post("des",true);
                 
                    $data = array(
                    'day_name'=>$name,
                    'date'=>$date,
                    'file'=>$file,
                    'description'=>$dec
                    );
                    $this->db->where('id',$id);
                    $this->db->update('timetable',$data);
                    redirect("admin/view_timetable","refresh");
               }
               else
               {
              
                $url=$this->doo_upload();
               
                 $id = $this->input->post("id",true);
                $name = $this->input->post("fname",true);
                $date = $this->input->post("date",true);
                 $dec = $this->input->post("des",true);
                  $data2= array(
                    'day_name'=>$name,
                    'date'=>$date,
                    'file'=>$url,
                    'description'=>$dec
                    );
                    $this->db->where('id',$id);
                    $this->db->update('timetable',$data2);
                    redirect("admin/view_timetable","refresh");
           }
                    
    }
      public function order_add()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);

        $this->user_model->check_permissions('admin/user/add');
        $this->load->view('user/order_add',$data);
    
    }
       public function order_save()
    {
        if($this->input->post())
{
   
    
         $url=$this->doo_upload();
         $data = array(
       				'name' => $this->input->post('fname'),
       				'date' =>$this->input->post('date'),
       				'file'=>$url,
       				'description'=>$this->input->post('des')
                        );
                        $qry=$this->db->insert('daily_order',$data);
                        if($qry)
                        {
                            $this->session->set_flashdata('msg','Record successfully add...');
                            redirect('Admin/order_add');
                        }
}


    }
    public function view_order()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);

         $this->db->select("*"); 
         $this->db->from('daily_order');
         $this->db->where('is_delete',0);
         $query = $this->db->get();
         $data['orders'] = $query->result_array();
     
            $this->load->view('user/view_order',$data);
    
    }
    public function std_view_order()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);

         $this->db->select("*"); 
         $this->db->from('daily_order');
         $this->db->where('is_delete',0);
         $query = $this->db->get();
         $data['orders'] = $query->result_array();
     
            $this->load->view('user/std_view_order',$data);
    
    }
     public function order_delete($id)
    {
      
         $data = array(
                "is_delete"=>"1"
            );

            $this->db->where("id",$id);
            $this->db->update("daily_order",$data);
            redirect("admin/view_order","refresh");
    }
    
    public function order_edit($id)
    {
         $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        
           $this->db->select("*"); 
            $this->db->from('daily_order');
            $this->db->where("is_delete","0");
            $this->db->where("id",$id);
            $query = $this->db->get();
            $data['admin'] = $query->result_array()[0];
           
            $this->load->view('user/order_edit',$data);
    }
    
    public function order_update()
    {
     
               $file=$this->input->post('img');
    
               if(empty($file)){
                  $file=$this->input->post("old_file",true);
               
                 $id = $this->input->post("id",true);
                $name = $this->input->post("fname",true);
                $date = $this->input->post("date",true);
                 $dec = $this->input->post("des",true);
                 
                    $data = array(
                    'name'=>$name,
                    'date'=>$date,
                    'file'=>$file,
                    'description'=>$dec
                    );
                    $this->db->where('id',$id);
                    $this->db->update('daily_order',$data);
                    redirect("admin/view_order","refresh");
               }
               else
               {
              
                $url=$this->doo_upload();
               
                $id = $this->input->post("id",true);
                $name = $this->input->post("fname",true);
                $date = $this->input->post("date",true);
                $dec = $this->input->post("des",true);
                  $data2= array(
                    'name'=>$name,
                    'date'=>$date,
                    'file'=>$url,
                    'description'=>$dec
                    );
                    $this->db->where('id',$id);
                    $this->db->update('daily_order',$data2);
                    redirect("admin/view_order","refresh");
           }
                    
    }
    public function student_login()
{
    $this->user_model->check_permissions('admin/student_login');
    $data['edit_delete']=$this->user_model->checkEditDelete('admin/student_login');
    $data['menu'] = $this->load_model->menu();
    $data['base_url'] = base_url();
    $data['userInfo'] = $this->userInfo;
    $this->load->view('header',$data);
    $this->load->view('sidebar',$data);
    
    $branch=$this->user_model->getbranch();
     if($branch != 0){
                $this->db->select("admin.id,class.class_name,section.section_name,first_name,student.father_name,student.father_contact,username,login_status,ch_sh_pas"); 
                $this->db->from('admin');
                $this->db->join('student', 'student.id = admin.student_id');
                $this->db->join('promotion', 'promotion.student_id = student.id');
                $this->db->join('class', 'class.class_id = promotion.class_id');
                $this->db->join('section', 'section.section_id = promotion.section_id');
                $this->db->where('student.branch',$branch);
                $this->db->where('admin.student_id>','0');
                $this->db->where('promotion.is_active',1);
                $this->db->where('promotion.is_delete',0);
                $this->db->where('student.is_delete',0);
                $this->db->where('student.status',0);
                $this->db->where("admin.is_delete","0");
                $query = $this->db->get();
            }
            else{
                $this->db->select("admin.id,class.class_name,section.section_name,first_name,student.father_name,student.father_contact,username,branch.name,login_status,ch_sh_pas"); 
                $this->db->from('admin');
                $this->db->join('student', 'student.id = admin.student_id');
                $this->db->join('branch', 'branch.id = student.branch');
                $this->db->join('promotion', 'promotion.student_id = student.id');
                $this->db->join('class', 'class.class_id = promotion.class_id');
                $this->db->join('section', 'section.section_id = promotion.section_id');
                $this->db->where('admin.student_id>','0');
                $this->db->where("admin.is_delete","0");
                $this->db->where('student.is_delete',0);
                $this->db->where('student.status',0);
                $this->db->where('promotion.is_active',1);
                $this->db->where('promotion.is_delete',0);
                $query = $this->db->get();
            }
                $data['admins'] = $query->result_array();
                // var_dump('<pre>',$this->db->last_query());
                // die();
                $this->load->view('user/student_login',$data);
}

public function student_change_pass()
{
      $pass = $this->input->post("pass");
      $studentid = $this->input->post("studentid");
      
      $data=array
            (
                'password'=>md5($pass),
                'ch_sh_pas'=>$pass
            );
              $this->db->where('id',$studentid)->update('admin',$data);
                         
                         echo json_encode(array('result'=>'success'));
}

public function change_pass($id)
{
    $data['menu'] = $this->load_model->menu();
    $data['base_url'] = base_url();
    $data['userInfo'] = $this->userInfo;
    $data['rec']=$this->db->select('id,ch_sh_pas')
                          ->from('admin')
                          ->where('id',$id)
                          ->get()->row_array();
    $this->load->view('header',$data);
    $this->load->view('sidebar',$data);
    
    $this->load->view('user/student_password',$data);
}

public function update_passwords($id)
{
    $new_pass=$this->input->post('password');
    $data=array(
        'ch_sh_pas'=>$new_pass,
        'password'=>md5($new_pass)
        );
    $this->db->where('id',$id)  
             ->update('admin',$data);
              redirect('admin/student_login');  
}

public function paid_emp()
{
    $ids=$this->input->post('employees_pay');
    $validator=$_POST['sub_button'];

   if(!empty($ids))
   {
       if($validator=="Disable"){
           foreach($ids as $row)
                {
               
                       $data=array(
                        'login_status'=>1
                       );
                    
                $this->db->where('id',$row)  
                         ->update('admin',$data);
                 }
       }else{
            foreach($ids as $row)
                {
               
                       $data=array(
                        'login_status'=>0
                       );
                    
                $this->db->where('id',$row)  
                         ->update('admin',$data);
                 }
       }
       
       }
       redirect('admin/student_login');  
    }
    
    public function disable_login($id)
    {
        $data=array(
            'login_status'=>1
            );
            
        $this->db->where('id',$id)  
                 ->update('admin',$data);
        redirect('admin/student_login');        
    }
    
    public function enable_login($id)
    {
        $data=array(
            'login_status'=>0
            );
            
        $this->db->where('id',$id)  
                 ->update('admin',$data);
        redirect('admin/student_login');        
    }

    public function user($action,$p=1)
    {
        $p = explode(SALT,json_decode(base64_decode($p)))[0];
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        if($action=="add")
        {
        $this->user_model->check_permissions('admin/user/add');
        $this->load->view('user/add',$data);
        }else if($action=="view")
        {
        $this->user_model->check_permissions('admin/user/view');
        $data['edit_delete']=$this->user_model->checkEditDelete('admin/user/view');
        //echo "<pre>";print_r($data['edit_delete']);exit;
            
              $branch=$this->user_model->getbranch();
              //var_dump($branch);
              //die();
            if($branch != 0){
                $this->db->select("admin.id,first_name,last_name,username,email,contact_no,role_id,role.branch_id"); 
                $this->db->from('admin');
                $this->db->join('role', 'role.id = admin.role_id','LEFT');
                $this->db->where('role.branch_id',$branch);
                $this->db->where('admin.student_id ','0');
                $this->db->where("admin.is_delete","0");
                $query = $this->db->get();
            }
            else{
                $this->db->select("admin.id,first_name,last_name,username,email,contact_no,role_id,role.branch_id"); 
                $this->db->from('admin');
                $this->db->join('role', 'role.id = admin.role_id','LEFT');
                $this->db->where('admin.student_id ','0');
                $this->db->where("admin.is_delete","0");
                $query = $this->db->get();
            }
                $data['admins'] = $query->result_array();
//echo"<pre>";print_r($data);die;
                $this->load->view('user/view',$data);
        }else if($action=="save")
        {
            if($this->input->post())
            {
                $fname = $this->input->post("fname",true);
                $lname = $this->input->post("lname",true);
                $email = $this->input->post("email",true);
                $contact = $this->input->post("contact",true);
                $username = $this->input->post("username",true);
                $password = $this->input->post("password",true);
                $cpassword = $this->input->post("password2",true);

                if(!empty($fname) AND !empty($lname) AND !empty($email) AND !empty($contact) AND !empty($username) AND !empty($password))
                {
                    if($password==$cpassword)
                    {
                        $pass = md5($password);
                        $data = array(
                        'first_name'=>$fname,
                        'last_name'=>$lname,
                        'email'=>$email,
                        'username'=>$username,
                        'password'=>$pass,
                        'contact_no'=>$contact
                        );

                        $this->db->insert('admin',$data);
                        redirect("admin/user/view","refresh");
                    }else{
                        redirect("admin/user/add","refresh");
                    }
                }else{
                    redirect("admin/user/add","refresh");
                }
            }
        }else if($action=="delete")
        {
            $data = array(
                "is_delete"=>"1"
            );

            $this->db->where("id",$p);
            $this->db->update("admin",$data);
            redirect("admin/user/view","refresh");
        }else if($action=="edit")
        {
            $this->db->select("id,first_name,last_name,username,email,contact_no"); 
            $this->db->from('admin');
            $this->db->where("is_delete","0");
            $this->db->where("id",$p);
            $query = $this->db->get();
            $data['admin'] = $query->result_array()[0];
            $this->load->view('user/edit',$data);
        }else if($action=="update")
        {
            if($this->input->post())
            {
                $id = $this->input->post("id",true);
                $fname = $this->input->post("fname",true);
                $lname = $this->input->post("lname",true);
                $email = $this->input->post("email",true);
                $contact = $this->input->post("contact",true);
                $username = $this->input->post("username",true);

                if(!empty($fname) AND !empty($lname) AND !empty($email) AND !empty($contact) AND !empty($username))
                {
                    $data = array(
                    'first_name'=>$fname,
                    'last_name'=>$lname,
                    'email'=>$email,
                    'username'=>$username,
                    'contact_no'=>$contact
                    );
                    $this->db->where('id',$id);
                    $this->db->update('admin',$data);
                    redirect("admin/user/view","refresh");
                }else{
                    redirect("admin/user/add","refresh");
                }
            }
        }else if($action=="updatePass")
        {
            if($this->input->post())
            {
                $id = $this->input->post("id",true);
                $pass = $this->input->post("pass",true);
                $cpass = $this->input->post("cpass",true);

                if(!empty($pass) AND !empty($cpass) AND !empty($id))
                {
                    if($cpass==$pass)
                    {
                        $password = md5($pass);
                        $data = array(
                        'password'=>$password
                        );
                        $this->db->where('id',$id);
                        $this->db->update('admin',$data);
                    }
                    redirect("admin/user/view","refresh");
                }else{
                    redirect("admin/user/add","refresh");
                }
            }
        }
    }

    public function role($action,$p=1)
    {
        $p = explode(SALT,json_decode(base64_decode($p)))[0];
        $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['is_super'] = $this->user_model->is_super();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        if($action=="manage")
    {
            $this->user_model->check_permissions('admin/role/manage');
            $data['edit_delete'] = $this->user_model->checkEditDelete('admin/role/manage');
            if($this->user_model->is_super())
                $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
            else
                $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
            if($this->user_model->is_super())
            $data['roles'] = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name`  as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' and admin.is_delete ='0'")->result_array();
            else
            $data['roles'] = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name` as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' AND `role`.`branch_id`='$branch' and admin.is_delete ='0'")->result_array();
            
            if($this->user_model->is_super())
            $data['users'] = $this->db->query("SELECT id,first_name,last_name FROM `admin` WHERE `is_delete`='0' AND `role_id`='0' and `student_id` = '0' ORDER BY `first_name` ASC")->result_array();
            else
            $data['users'] = $this->db->query("SELECT `admin`.id,`admin`.first_name,`admin`.last_name FROM `admin` WHERE `admin`.`is_delete`='0' AND `admin`.`student_id` = 0 AND `role_id`='0' ORDER BY `first_name` ASC")->result_array();
           //var_dump($data['users']);
           //die();
            $this->load->view('user/manage_role',$data);
        }else if($action=="save")
        {
            if($this->input->post())
            {
                $branch = $this->input->post("branch",true);
                $title = $this->input->post("title",true);
                $remarks = $this->input->post("remarks",true);

                if(!empty($branch) AND !empty($title))
                {
                    if($remarks == "")
                    {
                        $remarks ="-";
                    }
                    $data = array(
                    'branch_id'=>$branch,
                    'title'=>$title,
                    'remarks'=>$remarks
                    );

                    $this->db->insert('role',$data);
                    redirect("admin/role/role_view","refresh");
                }else{
                    redirect("admin/role/role_view","refresh");
                }
            }
        }else if($action=="delete")
        {
            $data = array(
                "role_id"=>"0"
            );

            $this->db->where("id",$p);
            $this->db->update("admin",$data);
            redirect("admin/role/manage","refresh");
        }else if($action=="edit")
        {
            $branch = $this->user_model->getBranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->query("SELECT id,name FROM `branch` WHERE `is_delete`='0'")->result_array();
            else
                $data['branch'] = $this->db->query("SELECT id,name FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
            
//            echo $p;exit;
            $this->db->select("admin.id,admin.first_name,admin.role_id,role.branch_id,role.title"); 
            $this->db->from('admin');
            $this->db->join('role','role.id=admin.role_id');
            $this->db->where("admin.id",$p);
            $this->db->where("admin.is_delete","0");
            $query = $this->db->get();
            $data['admin'] = @$query->result_array()[0];
            
            $this->load->view('user/manage_role_edit',$data);
        }else if($action=="role_edit")
        {
            if($this->user_model->is_super())
                $data['branch'] = $this->db->query("SELECT id,name FROM `branch` WHERE `is_delete`='0'")->result_array();
            else
                $data['branch'] = $this->db->query("SELECT id,name FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
            
            $this->db->select("role.*"); 
            $this->db->from('role');
            $this->db->where("role.id",$p);
            $this->db->where("role.is_delete","0");
            $query = $this->db->get();
            $data['role'] = @$query->result_array()[0];
            $this->load->view('user/role_edit',$data);
        }else if($action=="role_update")
        { 
            if($this->input->post())
            {
                $id = $this->input->post("id",true);
                $branch = $this->input->post("branch",true);
                $role = $this->input->post("role",true);
                $remarks = $this->input->post("remarks",true);
                
                if(!empty($branch) AND !empty($role) AND !empty($remarks))
                {
                    $data = array(
                    'branch_id'=>$branch,
                    'title'=>$role,
                    'remarks'=>$remarks
                    );
                
                    $this->db->where('id',$id);
                    $this->db->update('role',$data);
                    redirect("admin/role/role_view","refresh");
                }else{
                    redirect("admin/role/role_view","refresh");
                }
            }
        }else if($action=="role_delete")
        {
            $data = array(
                "is_delete"=>"1"
            );

            $this->db->where("id",$p);
            $this->db->update("role",$data);
            redirect("admin/role/role_view","refresh");
        }else if($action=="update")
        {
            if($this->input->post())
            {
                $branch = $this->input->post("branch",true);
                $role = $this->input->post("role",true);
                $user = $this->input->post("user",true);
                $id = $this->input->post("id",true);

                if(!empty($branch) AND !empty($role) AND !empty($user) AND !empty($id))
                {
                    $upd = array(
                    'role_id'=> $role
                    );
            
                    $this->db->where('id', $id);
                    $this->db->update('admin' ,$upd);
                    redirect("admin/role/manage","refresh");
                }else{
                    redirect("admin/role/manage","refresh");
                }
            }
            
            if($this->input->post())
            {
                $role = $this->input->post("role",true);
                $user = $this->input->post("user",true);
                
                if(!empty($role) AND !empty($user))
                {
                    $data = array(
                    'role_id'=>$role
                    );
                    $this->db->where('id',$user);
                    $this->db->update('admin',$data);
                    redirect("admin/user/manage","refresh");
                }else{
                    redirect("admin/user/manage","refresh");
                }
            }
        }else if($action=="role_view")
        {
        $this->user_model->check_permissions('admin/role/role_view');
        $data['edit_delete']=$this->user_model->checkEditDelete('admin/role/role_view');
                
              $branch=$this->user_model->getbranch(); 
              
            if($branch != 0){
                $this->db->select("role.*"); 
                $this->db->from('role');
                $this->db->where('role.branch_id',$branch);
                $this->db->where("role.is_delete","0");
                $this->db->order_by('id','desc');
                $query = $this->db->get();
            }
            else{
                $this->db->select("role.*"); 
                $this->db->from('role');
                $this->db->where("role.is_delete","0");
                $this->db->order_by('id','desc');
                $query = $this->db->get();
            }
                $data['roles'] = $query->result_array();
                $this->load->view('user/role_view',$data);
        }else if($action=="assign")
        {
            if($this->input->post())
            {
                $branch = $this->input->post("branch",true);
                $role = $this->input->post("role",true);
                $user = $this->input->post("user",true);

                if(!empty($branch) AND !empty($role) AND !empty($user))
                {
                    $data = array(
                    'role_id'=>$role
                    );

                    $this->db->where('id', $user);
                    $this->db->update('admin' ,$data);
                    redirect("admin/role/manage","refresh");
                }else{
                    redirect("admin/role/manage","refresh");
                }
            }
        }
    }

    public function permission($action,$p=1)
    {
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        if($action=="manage")
    {

            $this->user_model->check_permissions('admin/permission/manage');
            $data['edit_delete']=$this->user_model->checkEditDelete('admin/permission/manage');
            if($this->user_model->is_super())
                $data['branch'] = $this->db->query("SELECT id,name,title FROM `branch` WHERE `is_delete`='0'")->result_array();
            else
                $data['branch'] = $this->db->query("SELECT id,name,title FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
            $data['roles'] = $this->db->query("SELECT `role`.`id`,`role`.`title`, branch.name FROM `role` inner join branch on role.branch_id = branch.id  WHERE `role`.`is_delete`='0'")->result_array();
            $data['allowed'] = $this->load_model->sub_menu();
            $data['per_menu'] = $this->load_model->per_menu();
            $this->load->view('user/permissions',$data);
    }
    else if($action=="assign")
    {
            if($this->input->post())
            {
                $role = $this->input->post("role",true);
                $permissions = $this->input->post("permissions",true);
                $edit_permissions = $this->input->post("edit_permissions",true);
		        //var_dump($edit_permissions);die;
                $delete_permissions = $this->input->post("delete_permissions",true);
                if(!empty($role))
                {
                    $this->db->where('role_id', $role);
                    $this->db->delete('permission');
                    if(!empty($permissions))
                    {
                        foreach ($permissions as $k => $v) {
                            $edit=false;
                            $delete=false;
                            if(isset($edit_permissions[$v]))
                            $edit=true;
                            if(isset($delete_permissions[$v]))
                            $delete=true;

                            $d = explode("_",$v);
                            $count_d=count($d);
                            if($count_d==2){
                                $menu_id = $d[0];
                                $submenu_id = $d[1];   

                                $data = array(
                                'role_id'=>$role,
                                'menu_id'=>$menu_id,
                                'submenu_id'=>$submenu_id
                                );
                                if($edit){
                                    $data['editable']=1;
                                }
                                if($delete){
                                    $data['deleteable']=1;
                                }
                            }else{
                                $menu_id = $d[0];
                                $submenu_id = $d[1];   
                                $sub_submenu_id = $d[2];   

                                $data = array(
                                'role_id'=>$role,
                                'menu_id'=>$menu_id,
                                'submenu_id'=>$submenu_id,
                                'sub_submenu_id'=>$sub_submenu_id
                                );
                                if($edit){
                                    $data['editable']=1;
                                }
                                if($delete){
                                    $data['deleteable']=1;
                                }
                            }
                            
                            $this->db->insert('permission', $data);
                        }
                    }
                    redirect("admin/permission/manage","refresh");
                }else{
                    redirect("admin/permission/manage","refresh");
                }
            }
        }
    }

    public function widgets($user_id='')
    {
        if($user_id=='') {
            $this->db->select('*');
            $this->db->where('is_delete',0);
            $wigdets=$this->db->get('dashboard_widgets')->result_array();
            $wigdets_div='';
            foreach ($wigdets as $key => $value) {
                $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='$value[id]'>$value[name]
                        </label>
                    </div>";
            }
                    $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-2'>Session Graph
                        </label>
                    </div>";
                     $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-3'>Student Status
                        </label>
                    </div>";
                     $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-4'>Teacher Status
                        </label>
                    </div>";
                     $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-5'>Active User
                        </label>
                    </div>";
            
            return $wigdets_div;
        }
        else {
            $this->db->select('*');
            $this->db->where('is_delete',0);
            $wigdets=$this->db->get('dashboard_widgets')->result_array();
           
              
            $wigdets_div='';
            foreach ($wigdets as $key => $value) {
                $has_permission=$this->db->query("select id from dashboard_permissions where user_id=$user_id and widget_id=$value[id]")->result_array();
                if(!empty($has_permission))
                $checked="checked";
                else
                $checked="";
                $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' $checked name='widget_permissions[]' value='$value[id]'>$value[name]
                        </label>
                    </div>";
            }
            $has_per=$this->db->query("select id from dashboard_permissions where user_id=$user_id and widget_id='-2'")->result_array();
                if(!empty($has_per))
                {
                
                 $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-2' checked>Session Graph
                        </label>
                    </div>";
                }
                else
                {
                 $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-2' >Session Graph
                        </label>
                    </div>";
                }
               
              $has_per1=$this->db->query("select id from dashboard_permissions where user_id=$user_id and widget_id=-3")->result_array();
                if(!empty($has_per1))
                {
                 $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-3' checked>Student Status
                        </label>
                    </div>";
                }
                else
                {
                 $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-3'>Student Status
                        </label>
                    </div>";
                }
               
                     $has_per2=$this->db->query("select id from dashboard_permissions where user_id=$user_id and widget_id=-4")->result_array();
                if(!empty($has_per2))
                {
                  $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-4' checked>Teacher Status
                        </label>
                    </div>";
                }
                else
                {
                  $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-4'>Teacher Status
                        </label>
                    </div>";
                }
              
                     $has_per5=$this->db->query("select id from dashboard_permissions where user_id=$user_id and widget_id=-5")->result_array();
                if(!empty($has_per5))
                {
                $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-5' checked>Active User
                        </label>
                    </div>";
                }
                else
                {
                $wigdets_div.= "<div class='checkbox'>
                        <label>
                            <input type='checkbox' class='widget_permission' name='widget_permissions[]' value='-5'>Active User
                        </label>
                    </div>";
                }
                
            echo $wigdets_div;
        }
    }

    public function dashboard_permissions()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->user_model->getbranch();
              
        if($this->user_model->is_super())
            $data['branch'] = $this->db->query("SELECT id,name FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT id,name FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
            
        $data['roles'] = $this->db->query("SELECT `role`.`id`,`role`.`title`,`branch`.`name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` WHERE `role`.`is_delete`='0'")->result_array();

        $data['widgets']=$this->widgets();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('user/dashboard_permissions',$data);
    }

    public function update_dashboard_permissions()
    {
        if(!empty($this->input->post('user')) ) {
            $user_id=$this->input->post('user');
            $permissions=$this->input->post('widget_permissions');
            //var_dump('<pre>',$permissions);die();
            $this->db->query("delete from dashboard_permissions where user_id=$user_id");
            if(!empty($permissions)) {
//echo "<pre>";print_r($permissions);exit;
                foreach ($permissions as $key => $value) {
                    $data[]=array(
                                "user_id"=>$user_id,
                                "widget_id"=>$value
                            );
                }
                //var_dump($data);die();
                $this->db->insert_batch('dashboard_permissions', $data);
            }

            redirect("Admin/dashboard_permissions","refresh");
        }
        else {
            redirect("Admin/dashboard_permissions","refresh");
        }
    }
    
    public function saveUser()
    {
        
       /* $fname=rawurldecode($firstname);
        $lname=rawurldecode($lastname);
        $email=rawurldecode($emails);
        $username=rawurldecode($usernames);*/
        
        $fname = $this->input->post('fname');
       
         $lname = $this->input->post('lname');
         $email = $this->input->post('email');
         $username = $this->input->post('username');
         $password = $this->input->post('password');
         $password2 =$this->input->post('password2');
         $number = $this->input->post('number');
        
        $this->db->select();
    	$this->db->from('admin');
    	$this->db->where('username',$username);
    	$this->db->where('is_delete',0);
    	$query = $this->db->get();
    	if($query->num_rows() > 0)
    	{
    		$this->session->set_flashdata('msg', "Invalid Username or Password !");
    		redirect("admin/user/view","refresh");
    		
    	}
            
        if(!empty($fname) AND !empty($lname) AND !empty($email) AND !empty($number) AND !empty($username) AND !empty($password) AND !empty($password2))
        {
            
            
            
            if($password==$password2)
            {
                    $pass = md5($password);
                    $data = array(
                    'first_name'=>$fname,
                    'last_name'=>$lname,
                    'email'=>$email,
                    'username'=>$username,
                    'password'=>$pass,
                    'contact_no'=>$number
                );
                 
               $this->db->insert('admin',$data); 
            $edit_delete=$this->user_model->checkEditDelete('admin/user/view');
            $branch=$this->user_model->getbranch();
              
            
            if(!$this->user_model->is_super()){
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0' AND (`role`.`branch_id` = '$branch' OR `admin`.`role_id` = '0') ORDER BY `admin`.`id` DESC");
            }
            else
            {
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0'  ORDER BY `admin`.`id` DESC");
            }
            
            $admin = $query->result_array(); 
        if(!empty($admin))
        {
            $i=0; 
            foreach ($admin as $key => $value)
            { $i++;
                echo "
                 <tr>
                          <td>$i</td>
                          <td>$value[first_name]</td>
                          <td>$value[last_name]</td>
                          <td>$value[username]</td>
                          <td>$value[email]</td>
                          <td>$value[contact_no]</td>
                          <td>";
                          if($value['role_id'] == 0)
                          {
                              echo "<span style='color:red'>Role Not Assigned</span>";
                          }
                          else{
                          echo @$this->db->select('title')
                                              ->where('id',$value['role_id'])
                                              ->where('is_delete',0)->get('role')
                                              ->row()->title;}
                         echo "</td>";
                         
                         if($this->user_model->is_super()){ 
                         echo "<td>
                         ";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name;   echo "</td>";}
                  if($edit_delete['edit'] == 1){
                            echo "<td>"; 
                            echo " <a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                      echo "</tr>";
                        }
               
            } 
               
            }
            else
            {
                    redirect("admin/user/add","refresh");
            }
        }
    }
    
    public function fetch_user(){
        $edit_delete=$this->user_model->checkEditDelete('admin/user/view');
            $branch=$this->user_model->getbranch();
            if(!$this->user_model->is_super()){
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0' AND (`role`.`branch_id` = '$branch' OR `admin`.`role_id` = '0') ORDER BY `admin`.`id` DESC");
            }
            else
            {
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0'  ORDER BY `admin`.`id` DESC");
            }
            $admin = $query->result_array();
        if(!empty($admin))
         {
            $i=0; 
            foreach ($admin as $key => $value)
            { $i++;
                echo "
                 <tr>
                          <td>$i</td>
                          <td>$value[first_name]</td>
                          <td>$value[last_name]</td>
                          <td>$value[username]</td>
                          <td>$value[email]</td>
                          <td>$value[contact_no]</td>
                          
                          <td>";
                          if($value['role_id'] == 0)
                          {
                              echo "<span style='color:red'>Role Not Assigned</span>";
                          }
                          else{
                          echo @$this->db->select('title')
                                              ->where('id',$value['role_id'])
                                              ->where('is_delete',0)->get('role')
                                              ->row()->title;}
                         echo "</td>";
                        if($this->user_model->is_super()){ 
                         echo "<td>
                         ";
                         echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name;   echo "</td>";}
                  if($edit_delete['edit'] == 1){
                            echo "<td>"; 
                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                echo"</tr>";
                        } 
               
            }        
         
    }
    
    public function get_record($id){
        
      $query=$this->db->select('*')
                     ->from('admin')
                     ->where('id',$id)
                     ->get()->row_array();
                echo json_encode($query);
   }
   
   public function up_user()
    {
         
         $id = $this->input->post('id');
         $fname = $this->input->post('fname');
         $lname = $this->input->post('lname');
         $email = $this->input->post('email');
         $username = $this->input->post('username');
         /*$passwords = $this->input->post('password');
         $password2 =$this->input->post('password2');*/
         $numbers = $this->input->post('number');
         
        
            $data=array(
               'first_name' => $fname,
                'last_name' => $lname ,
                 'email'=>$email ,
                  'username'=>$username,
                  'contact_no'=>$numbers
            );
        
        $query=$this->db->where('id',$id)
                  ->update('admin',$data);
    
        $edit_delete=$this->user_model->checkEditDelete('admin/user/view');
            $branch=$this->user_model->getbranch();
              
            if(!$this->user_model->is_super()){
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0' AND (`role`.`branch_id` = '$branch' OR `admin`.`role_id` = '0') ORDER BY `admin`.`id` DESC");
            }
            else
            {
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0'  ORDER BY `admin`.`id` DESC");
            }
            
            $admin = $query->result_array();
        if(!empty($admin))
         {
            $i=0; 
           foreach ($admin as $key => $value)
            { $i++;
                echo "
                 <tr>
                          <td>$i</td>
                          <td>$value[first_name]</td>
                          <td>$value[last_name]</td>
                          <td>$value[username]</td>
                          <td>$value[email]</td>
                          <td>$value[contact_no]</td>
                          <td>";
                          if($value['role_id'] == 0)
                          {
                              echo "<span style='color:red'>Role Not Assigned</span>";
                          }
                          else{
                          echo @$this->db->select('title')
                                              ->where('id',$value['role_id'])
                                              ->where('is_delete',0)->get('role')
                                              ->row()->title;}
                         echo "</td>";
                         if($this->user_model->is_super()){ 
                         echo "<td>
                         ";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name;   echo "</td>";}
                  if($edit_delete['edit'] == 1){
                            echo "<td>"; 
                            echo " <a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                      echo "</tr>";
                        }
               
            } 
               
            
            else
            {var_dump("fsfs");die;
                    redirect("admin/user/view","refresh");
            }
          
       
    }
    
    
     public function delete_user($id){
        
        $data= array(
            'is_delete' => 1,
            );
      $query=$this->db->where('id',$id)
                     ->update('admin',$data);
                     
        $edit_delete=$this->user_model->checkEditDelete('admin/user/view');
        $branch=$this->user_model->getbranch();
              
            
            if(!$this->user_model->is_super()){
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0' AND (`role`.`branch_id` = '$branch' OR `admin`.`role_id` = '0') ORDER BY `admin`.`id` DESC");
            }
            else
            {
                $query=$this->db->query("SELECT `admin`.`id`, `first_name`, `last_name`, `username`, `email`, `contact_no`, `role_id`, `role`.`branch_id` FROM `admin` LEFT JOIN `role` ON `role`.`id` = `admin`.`role_id` WHERE `admin`.`student_id` = '0' AND `admin`.`is_delete` = '0'  ORDER BY `admin`.`id` DESC");
            }
            
            $admin = $query->result_array();
        if(!empty($admin))
         {
            $i=0; 
           foreach ($admin as $key => $value)
            { $i++;
                echo "
                 <tr>
                          <td>$i</td>
                          <td>$value[first_name]</td>
                          <td>$value[last_name]</td>
                          <td>$value[username]</td>
                          <td>$value[email]</td>
                          <td>$value[contact_no]</td>
                          <td>";
                          if($value['role_id'] == 0)
                          {
                              echo "<span style='color:red'>Role Not Assigned</span>";
                          }
                          else{
                          echo @$this->db->select('title')
                                              ->where('id',$value['role_id'])
                                              ->where('is_delete',0)->get('role')
                                              ->row()->title;}
                         echo "</td>";
                         if($this->user_model->is_super()){ 
                         echo "<td>
                         ";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name;   echo "</td>";}
                  if($edit_delete['edit'] == 1){
                            echo "<td>"; 
                            echo " <a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                      echo "</tr>";
                        }
               
            } 
               
            
            else
            {
                    redirect("admin/user/view","refresh");
            }
                     
                
    }
    
    public function check_useredit($id,$username)
    {
     
    $this->db->select();
	$this->db->from('admin');
	$this->db->where('id!=',$id);
	$this->db->where('username',$username);
	$this->db->where('is_delete',0);
	$query = $this->db->get();
	
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    
    public function check_user($uname)
    {
    $this->db->select();
	$this->db->from('admin');
	$this->db->where('username',$uname);
	$this->db->where('is_delete',0);
	$query = $this->db->get();
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    public function saveRole(){
                $branch = $this->input->post("branch");
                $title = $this->input->post("title");
                $remarks = $this->input->post("remarks");
            
                if(!empty($branch) AND !empty($title))
                {
                    if($remarks == "")
                    {
                        $remarks ="-";
                    }
                    $data = array(
                    'branch_id'=>$branch,
                    'title'=>$title,
                    'remarks'=>$remarks
                    );

                    $this->db->insert('role',$data);
                    
                    $this->user_model->check_permissions('admin/user/role_view');
                    $edit_delete=$this->user_model->checkEditDelete('admin/role/role_view');
                
                    $branch=$this->user_model->getbranch(); 
              
                    if($branch != 0){
                         $this->db->select("role.*"); 
                         $this->db->from('role');
                         $this->db->where('role.branch_id',$branch);
                         $this->db->where("role.is_delete","0");
                         $this->db->order_by('id','desc');
                         $query = $this->db->get();
                    }
                   else{
                        $this->db->select("role.*"); 
                        $this->db->from('role');
                        $this->db->where("role.is_delete","0");
                        $this->db->order_by('id','desc');
                        $query = $this->db->get();
                    }
                    $roles = $query->result_array();
                    if(!empty($roles))
                    {
                            $i=0; 
                            foreach ($roles as $key => $value)
                            { 
                                if($value['id']!=1){
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[title]</td>
                                          <td>$value[remarks]</td>";
                                          if($this->user_model->is_super()){
                                         echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                  if($edit_delete['edit'] == 1){
                                            echo "<td>"; 
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                }
                               } 
                               
                    }    
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
    
    
        public function updateRole(){
                $id = $this->input->post("id");
                $branch = $this->input->post("branch");
                $title = $this->input->post("title");
                $remarks = $this->input->post("remarks");
            
                if(!empty($id) AND !empty($branch) AND !empty($title))
                {
                    if($remarks == "")
                    {
                        $remarks ="-";
                    }
                    $data = array(
                    'branch_id'=>$branch,
                    'title'=>$title,
                    'remarks'=>$remarks
                    );
                    $this->db->where('id',$id);
                    $this->db->update('role',$data);
                    
                    $this->user_model->check_permissions('admin/user/role_view');
                    $edit_delete=$this->user_model->checkEditDelete('admin/role/role_view');
                
                    $branch=$this->user_model->getbranch(); 
              
                    if($branch != 0){
                         $this->db->select("role.*"); 
                         $this->db->from('role');
                         $this->db->where('role.branch_id',$branch);
                         $this->db->where("role.is_delete","0");
                         $this->db->order_by('id','desc');
                         $query = $this->db->get();
                    }
                   else{
                        $this->db->select("role.*"); 
                        $this->db->from('role');
                        $this->db->where("role.is_delete","0");
                        $this->db->order_by('id','desc');
                        $query = $this->db->get();
                    }
                    $roles = $query->result_array();
                    if(!empty($roles))
                    {
                            $i=0; 
                            foreach ($roles as $key => $value)
                            { 
                                if($value['id']!=1){
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[title]</td>
                                          <td>$value[remarks]</td>";
                                          if($this->user_model->is_super()){
                                         echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                  if($edit_delete['edit'] == 1){
                                            echo "<td>"; 
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                }
                               } 
                               
                    }    
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
    
    
     public function get_record_role($id){
        
      $query=$this->db->select('*')
                     ->from('role')
                     ->where('id',$id)
                     ->get()->row_array();
                echo json_encode($query);
   }
    
   /* public function AssignRole()
    {
                $branch = $this->input->post("branch",true);
                $role = $this->input->post("role",true);
                $user = $this->input->post("user",true);

                if(!empty($branch) AND !empty($role) AND !empty($user))
                {
                    $data = array(
                    'role_id'=>$role
                    );

                    $this->db->where('id', $user);
                    $this->db->update('admin' ,$data);
                    
                    $this->user_model->check_permissions('admin/role/manage');
                    $edit_delete = $this->user_model->checkEditDelete('admin/role/manage');
                    if($this->user_model->is_super())
                        $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
                    else
                        $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
                    if($this->user_model->is_super())
                    $data['roles'] = $this->db->query("SELECT `admin`.`id`,`admin`.`first_name`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name`  as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' and admin.is_delete ='0'")->result_array();
                    else
                    $data['roles'] = $this->db->query("SELECT `admin`.`id`,`admin`.`first_name`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name` as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' AND `role`.`branch_id`='$branch' and admin.is_delete ='0'")->result_array();
                    
                    if($this->user_model->is_super())
                    $data['users'] = $this->db->query("SELECT id,first_name,last_name FROM `admin` WHERE `is_delete`='0' AND `role_id`='0' and `student_id` = '0' ORDER BY `first_name` ASC")->result_array();
                    else
                    $data['users'] = $this->db->query("SELECT `admin`.id,`admin`.first_name,`admin`.last_name FROM `admin` WHERE `admin`.`is_delete`='0' AND `admin`.`student_id` = 0 AND `role_id`='0' ORDER BY `first_name` ASC")->result_array();
                          
                }
                else
                {
                    echo "";
                }
    }*/
    
    public function savemanageRole(){
                $branch = $this->input->post("branch");
                $role = $this->input->post("role");
                $user = $this->input->post("user");
            
                if(!empty($branch) AND !empty($role) && !empty($user))
                {
                    
                    $data = array(
                    'role_id'=>$role
                    );
                    
                    $this->db->where('id', $user);
                    $this->db->update('admin' ,$data);

                   
                    
                    $this->user_model->check_permissions('admin/role/manage');
                    $edit_delete = $this->user_model->checkEditDelete('admin/role/manage');
                    $branchs = $this->user_model->getBranch();
                    if($this->user_model->is_super())
                        $branch = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
                    else
                        $branch = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branchs'")->result_array();
                    if($this->user_model->is_super())
                    $roles = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name`  as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' and admin.is_delete ='0'")->result_array();
                    else
                    $roles = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name` as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' AND `role`.`branch_id`='$branchs' and admin.is_delete ='0'")->result_array();
                    
                    if($this->user_model->is_super())
                    $users = $this->db->query("SELECT id,first_name,last_name FROM `admin` WHERE `is_delete`='0' AND `role_id`='0' and `student_id` = '0' ORDER BY `first_name` ASC")->result_array();
                    else
                    $users = $this->db->query("SELECT `admin`.id,`admin`.first_name,`admin`.last_name FROM `admin` WHERE `admin`.`is_delete`='0' AND `admin`.`student_id` = 0 AND `role_id`='0' ORDER BY `first_name` ASC")->result_array();
                    
            
                    
                    if(!empty($roles))
                    {
                            $i=0; 
                            foreach ($roles as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[username]</td>
                                          <td>$value[r_title]</td>";
                                          if($this->user_model->is_super()){
                                         echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                  if($edit_delete['edit'] == 1){
                                            echo "<td>"; 
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                  if($edit_delete['delete'] == 1){
                                            
                                            echo "<a href='' onclick='delete_user_role($value[id],event)'><i class='fa fa-trash'></i></a>";
                                  }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                               } 
                               
                    }    
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
    
    
    public function updateUserRole(){
                $id = $this->input->post("admin");
                $branch = $this->input->post("branch");
                $role = $this->input->post("role");
            
                if(!empty($id) AND !empty($branch) AND !empty($role))
                {
                    
                    $upd = array(
                    'role_id'=> $role
                    );
            
                    $this->db->where('id', $id);
                    $this->db->update('admin' ,$upd);
                    
                    $this->user_model->check_permissions('admin/role/manage');
                    $edit_delete = $this->user_model->checkEditDelete('admin/role/manage');
                    $branchs = $this->user_model->getBranch();
                    if($this->user_model->is_super())
                        $branch = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
                    else
                        $branch = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branchs'")->result_array(); 
                    if($this->user_model->is_super())
                    $roles = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name`  as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' and admin.is_delete ='0'")->result_array();
                    else
                    $roles = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name` as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' AND `role`.`branch_id`='$branchs' and admin.is_delete ='0'")->result_array();
                    
                    if($this->user_model->is_super())
                    $users = $this->db->query("SELECT id,first_name,last_name FROM `admin` WHERE `is_delete`='0' AND `role_id`='0' and `student_id` = '0' ORDER BY `first_name` ASC")->result_array();
                    else
                    $users = $this->db->query("SELECT `admin`.id,`admin`.first_name,`admin`.last_name FROM `admin` WHERE `admin`.`is_delete`='0' AND `admin`.`student_id` = 0 AND `role_id`='0' ORDER BY `first_name` ASC")->result_array();
                
                    if(!empty($roles))
                    {
                            $i=0; 
                            foreach ($roles as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[username]</td>
                                          <td>$value[r_title]</td>";
                                          if($this->user_model->is_super()){
                                         echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                  if($edit_delete['edit'] == 1){
                                            echo "<td>"; 
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                  if($edit_delete['delete'] == 1){
                                            
                                            echo "<a href='' onclick='delete_user_role($value[id],event)'><i class='fa fa-trash'></i></a>";
                                  }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                               } 
                               
                    }    
                        
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
    
    
    public function get_record_user_role($id){
         
         
            $query = $this->db->select("admin.id,admin.first_name,admin.role_id,role.branch_id,role.title")
            ->from('admin')
            ->join('role','role.id=admin.role_id')
            ->where("admin.id",$id)
            ->where("admin.is_delete","0")
            ->get()->row_array();
              echo json_encode($query);
    }
    
     public function delete_user_role($id){
                    $data = array(
                            "role_id"=>"0"
                        );
            
                        $this->db->where("id",$id);
                        $this->db->update("admin",$data);
                    $this->user_model->check_permissions('admin/role/manage');
                    $edit_delete = $this->user_model->checkEditDelete('admin/role/manage'); 
                    $branchs = $this->user_model->getBranch();
                    if($this->user_model->is_super())
                        $branch = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
                    else
                        $branch = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branchs'")->result_array();
                    if($this->user_model->is_super())
                    $roles = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name`  as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' and admin.is_delete ='0'")->result_array();
                    else
                    $roles = $this->db->query("SELECT `admin`.`id`,`admin`.`username`,`admin`.`role_id`,`role`.`branch_id`,`role`.`title` as `r_title`,`branch`.`name` as `b_name` FROM `role` INNER JOIN `branch` ON `branch`.`id`=`role`.`branch_id` INNER JOIN `admin` ON `admin`.`role_id`=`role`.`id` WHERE `role`.`is_delete`='0' AND `admin`.`student_id`='0' AND `role`.`branch_id`='$branchs' and admin.is_delete ='0'")->result_array();
                    
                    if($this->user_model->is_super())
                    $users = $this->db->query("SELECT id,first_name,last_name FROM `admin` WHERE `is_delete`='0' AND `role_id`='0' and `student_id` = '0' ORDER BY `first_name` ASC")->result_array();
                    else
                    $users = $this->db->query("SELECT `admin`.id,`admin`.first_name,`admin`.last_name FROM `admin` WHERE `admin`.`is_delete`='0' AND `admin`.`student_id` = 0 AND `role_id`='0' ORDER BY `first_name` ASC")->result_array();
                    
            
                    
                    if(!empty($roles))
                    {
                            $i=0; 
                            foreach ($roles as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[username]</td>
                                          <td>$value[r_title]</td>";
                                          if($this->user_model->is_super()){
                                         echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                  if($edit_delete['edit'] == 1){
                                            echo "<td>"; 
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                  if($edit_delete['delete'] == 1){
                                            
                                            echo "<a href='' onclick='delete_user_role($value[id],event)'><i class='fa fa-trash'></i></a>";
                                  }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                               } 
                               
                    }    
               
               
            
            else
            {
                    echo "";
            }
                     
                
    }
    
    
    
    

}
