<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Department extends CI_Controller {

	private $userInfo = array();
    private $is_super;
    private $branch;

    public function __construct()
    {
        parent::__construct();
		$this->user_model->check_login("Department");
		$this->userInfo = $this->user_model->userInfo("first_name,last_name");
        $this->is_super = $this->user_model->is_super();
        $this->branch = $this->user_model->getBranch();
    }

	public function add()
	{
		$this->user_model->check_permissions("Department/add");
		$data['menu'] = $this->load_model->menu();
		$data['base_url'] = base_url();
		$data['userInfo'] = $this->userInfo;
		
		$data['department']=$this->db->where('is_delete',0)->get('department')->result_array();

		$this->load->view('header',$data);
		$this->load->view('sidebar',$data);
		$this->load->view('department/add',$data);
		$this->load->view('footer',$data);
	}

	public function save()
	{
		$data=$this->input->post();
		$this->db->insert('department',$data);
		redirect('Department/add','refresh');
	}


	public function edit($id='')
	{
		$data['menu'] = $this->load_model->menu();
		$data['base_url'] = base_url();
		$data['userInfo'] = $this->userInfo;
		
			$data['department']=$this->db->where('id',$id)->get('department')->row_array();
			$this->load->view('header',$data);
			$this->load->view('sidebar',$data);
			$this->load->view('department/edit',$data);
			$this->load->view('footer',$data);
	}

	public function update()
	{
		$data=$this->input->post();
		$this->db->where('id',$data['id']);
		$this->db->update('department',$data);
		redirect('department/add','refresh');
	}
	
	public function delete($id)
	{
		$this->db->where('id',$id);
		$this->db->update('department',array('is_delete'=>1));
		redirect('department/add','refresh');
	}


}
