<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Fee extends CI_Controller {

    private $userInfo = array();

    public function __construct()
    {
        parent::__construct();
        $this->load->model("user_model");
        $this->load->model("class_model");
       // $this->load->model("teacher_model");
        $this->user_model->check_login("admin");

        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }

    public function index($p=1)
    {
        $this->view($p);
    }
    
    public function view($p=1)
    {
        $this->user_model->check_permissions("fee/view");
        $data['edit_delete']=$this->user_model->checkEditDelete('fee/view');
        $branch = $this->user_model->getbranch();
        if($this->user_model->is_super())
            $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
        else
            $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();
        
        $data['menu'] = $this->load_model->menu();
        $this->db->select("fee_def.id,fee_def.name,fee_def.amount,class.class_name as c_name,branch.name as b_name"); 
        $this->db->from('fee_def');
        $this->db->join('class','fee_def.class_id = class.class_id');
        $this->db->join('branch','fee_def.branch_id = branch.id');
        $this->db->where('fee_def.is_delete','0');
        if(!$this->user_model->is_super())
        $this->db->where('fee_def.branch_id',$branch);
        $this->db->order_by('fee_def.id','DESC');
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['fee'] = $query->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('fee/view',$data);
    }
    
    public function fetch_fee_types(){
        $edit_delete=$this->user_model->checkEditDelete('fee/fetch_fee_types');
            $branch=$this->user_model->getbranch();
            $this->db->select("fee_def.id,fee_def.name,fee_def.amount,class.class_name as c_name,branch.name as b_name"); 
            $this->db->from('fee_def');
            $this->db->join('class','fee_def.class_id = class.class_id');
            $this->db->join('branch','fee_def.branch_id = branch.id');
            $this->db->where('fee_def.is_delete','0');
            if(!$this->user_model->is_super())
            $this->db->where('fee_def.branch_id',$branch);
            $this->db->order_by('fee_def.id','DESC');
            $fees = $this->db->get()->result_array();
        if(!empty($fees))
         {
            $i=0; 
            foreach ($fees as $key => $value)
            { $i++;
                echo "
                 <tr>
                  <td>$i</td>
                  <td>$value[name]</td>";
                  if($this->user_model->is_super()){ 
                echo "
                  <td>$value[b_name]</td>";
                   }
                echo "
                  <td>$value[c_name]</td>
                  <td>$value[amount]</td>
                <td>";    
                  if($edit_delete['edit'] == 1){
                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_fee_type($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                echo"</tr>";
                        } 
            }        
         
    }
    
    public function saveFee()
    {
         $branch = $this->input->post('branch_id');
         $class = $this->input->post('class_id');
         $name = $this->input->post('name');
         $amount = $this->input->post('amount');
        $this->db->select();
    	$this->db->from('fee_def');
    	$this->db->where('name',$name);
    	$this->db->where('class_id',$class);
    	$this->db->where('is_delete',0);
    	$query = $this->db->get();
    	if($query->num_rows() > 0)
    	{
    		$this->session->set_flashdata('msg', "Invalid Fee Name !");
    		redirect("fee/view","refresh");
    		
    	}
            
        if(!empty($branch) AND !empty($class) AND !empty($name) AND !empty($amount))
        {
                    $data = array(
                    'name'=>$name,
                    'amount'=>$amount,
                    'branch_id'=>$branch,
                    'class_id'=>$class
                );
                 
            $this->db->insert('fee_def',$data); 
            $edit_delete=$this->user_model->checkEditDelete('fee/view');
            $branch=$this->user_model->getbranch();
            $this->db->select("fee_def.id,fee_def.name,fee_def.amount,class.class_name as c_name,branch.name as b_name"); 
            $this->db->from('fee_def');
            $this->db->join('class','fee_def.class_id = class.class_id');
            $this->db->join('branch','fee_def.branch_id = branch.id');
            $this->db->where('fee_def.is_delete','0');
            if(!$this->user_model->is_super())
            $this->db->where('fee_def.branch_id',$branch);
            $this->db->order_by('fee_def.id','DESC');
            $fees = $this->db->get()->result_array();
        if(!empty($fees))
        {
            $i=0; 
            foreach ($fees as $key => $value)
            { $i++;
                echo "
                 <tr>
                  <td>$i</td>
                  <td>$value[name]</td>";
                  if($this->user_model->is_super()){ 
                echo "
                  <td>$value[b_name]</td>";
                   }
                echo "
                  <td>$value[c_name]</td>
                  <td>$value[amount]</td>
                <td>";    
                  if($edit_delete['edit'] == 1){
                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_fee_type($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                echo"</tr>";
                        } 
            }
               
            }
            else
            {
                    redirect("fee/view","refresh");
            }
        }
        
    public function up_fee_type()
    {
         
         $id = $this->input->post('id');
          $branch = $this->input->post('branch_id');
         $class = $this->input->post('class_id');
         $name = $this->input->post('name');
         $amount = $this->input->post('amount');
        
            if(!empty($branch) AND !empty($class) AND !empty($name) AND !empty($amount))
        {
                    $data = array(
                    'name'=>$name,
                    'amount'=>$amount,
                    'branch_id'=>$branch,
                    'class_id'=>$class
                );
        
        $query=$this->db->where('id',$id)
                  ->update('fee_def',$data);
    
        $edit_delete=$this->user_model->checkEditDelete('fee/view');
            $branch=$this->user_model->getbranch();
              
            $this->db->select("fee_def.id,fee_def.name,fee_def.amount,class.class_name as c_name,branch.name as b_name"); 
            $this->db->from('fee_def');
            $this->db->join('class','fee_def.class_id = class.class_id');
            $this->db->join('branch','fee_def.branch_id = branch.id');
            $this->db->where('fee_def.is_delete','0');
            if(!$this->user_model->is_super())
            $this->db->where('fee_def.branch_id',$branch);
            $this->db->order_by('fee_def.id','DESC');
            $fees = $this->db->get()->result_array();
            
        if(!empty($fees))
         {
            $i=0; 
           foreach ($fees as $key => $value)
            { $i++;
                echo "
                 <tr>
                  <td>$i</td>
                  <td>$value[name]</td>";
                  if($this->user_model->is_super()){ 
                echo "
                  <td>$value[b_name]</td>";
                   }
                echo "
                  <td>$value[c_name]</td>
                  <td>$value[amount]</td>
                <td>";    
                  if($edit_delete['edit'] == 1){
                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_fee_type($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                echo"</tr>";
                        } 
            }
               
            }
            else
            {
                    redirect("fee/view","refresh");
            }
    }
    
    public function get_record($id){
        
      $query=$this->db->select('*')
                     ->from('fee_def')
                     ->where('id',$id)
                     ->get()->row_array();
                echo json_encode($query);
   }
   
   public function check_fee_edit($id,$branch,$class,$name)
    {
     
    $this->db->select();
	$this->db->from('fee_def');
	$this->db->where('id!=',$id);
	$this->db->where('name',$name);
	$this->db->where('branch_id',$branch);
	$this->db->where('class_id',$class);
	$this->db->where('is_delete',0);
	$query = $this->db->get();
	
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    
    public function check_fee($branch,$class,$name)
    {
    $this->db->select();
	$this->db->from('fee_def');
	$this->db->where('name',$name);
	$this->db->where('branch_id',$branch);
	$this->db->where('class_id',$class);
	$this->db->where('is_delete',0);
	$query = $this->db->get();
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    public function delete_fee($id){
        
        $data= array(
            'is_delete' => 1,
            );
      $query=$this->db->where('id',$id)
                     ->update('fee_def',$data);
                     
        $edit_delete=$this->user_model->checkEditDelete('fee/view');
        $branch=$this->user_model->getbranch();
              
            
                       $this->db->select("fee_def.id,fee_def.name,fee_def.amount,class.class_name as c_name,branch.name as b_name"); 
            $this->db->from('fee_def');
            $this->db->join('class','fee_def.class_id = class.class_id');
            $this->db->join('branch','fee_def.branch_id = branch.id');
            $this->db->where('fee_def.is_delete','0');
            if(!$this->user_model->is_super())
            $this->db->where('fee_def.branch_id',$branch);
            $this->db->order_by('fee_def.id','DESC');
            $fees = $this->db->get()->result_array();
       if(!empty($fees))
         {
            $i=0; 
           foreach ($fees as $key => $value)
            { $i++;
                echo "
                 <tr>
                  <td>$i</td>
                  <td>$value[name]</td>";
                  if($this->user_model->is_super()){ 
                echo "
                  <td>$value[b_name]</td>";
                   }
                echo "
                  <td>$value[c_name]</td>
                  <td>$value[amount]</td>
                <td>";    
                  if($edit_delete['edit'] == 1){
                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                  }
                  if($edit_delete['delete'] == 1){
                            echo "<a href='' onclick='delete_fee_type($value[id],event)'><i class='fa fa-trash'></i></a>";
                         echo "</td>";
                        } 
                echo"</tr>";
            }
               
            }
            else
            {
                    redirect("fee/view","refresh");
            }
                     
                
    }
   

    public function add()
    {
        $this->user_model->check_permissions("fee/add");
        $branch = $this->user_model->getbranch();


        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())
            $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
        else
            $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('fee/add',$data);
    }
    
    public function save()
    {
        if($this->input->post())
        {
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $name = $this->input->post("name",true);
            $amount = $this->input->post("amount",true);

            $data = array(
                "branch_id"=>$branch,
                "class_id"=>$class,
                "name"=>$name,
                "amount"=>$amount
            );

            $this->db->insert("fee_def",$data);
            redirect("fee/view","refresh");
        }
    }

    public function delete($p)
    {
        if(!empty($p))
        {
        
            $this->db->where("id",$p);
            $this->db->delete("fee_def");
     
            redirect("fee/view","refresh");
        }
    }

    public function edit($action,$p="")
    {
   
   // var_dump($p);exit;
    $p = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
    //echo $p; exit;
        $branch = $this->user_model->getbranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())
        {
            $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
            $data['class'] = $this->db->select("class_name,class_id")->from("class")->get()->result_array();
        }
        else
        {
            $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();
            $data['class'] = $this->db->select("class_name,class_id")->from("class")->where("branch",$branch)->get()->result_array();
        }
        $data['data'] = @$this->db->select("name,amount,id,class_id,branch_id")->from("fee_def")->where("id",$p)->get()->result_array()[0];
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('fee/edit',$data);
    }

    public function update()
    {
        if($this->input->post())
        {
            $id = $this->input->post("id",true);
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $name = $this->input->post("name",true);
            $amount = $this->input->post("amount",true);

            $data = array(
                "branch_id"=>$branch,
                "class_id"=>$class,
                "name"=>$name,
                "amount"=>$amount
            );

            $this->db->where("id",$id);
            $this->db->update("fee_def",$data);
            redirect("fee/view","refresh");
        }
    }

}
