<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Homework extends CI_Controller {

    private $userInfo = array();
    
    public function __construct()
    {
        parent::__construct();
        $this->load->model("user_model");  
        $this->load->model("api_model");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }

    public function class_wise_form()
    {
        $this->user_model->check_permissions("Homework/class_wise_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('homework/student_homework',$data);
    }

    public function sendClassWise()
    {
        $data=$this->input->post();
       // var_dump($data); die();
        $insert_batch=array();
        foreach ($data['students'] as $key => $value) {
        
        $result = $this->db->query("SELECT * FROM student WHERE id= '$value'")->row_array();

        $tokens = array();

        $tokens[]=$result['token'];
        // var_dump($tokens);
        // die();
   
        $msg = array("message" =>$data['homework'],"id"=>$value,"topic"=>"homework" );
        //$msg = array("msg" => "Your child notic");  
        //var_dump($msg );
        //die();
        //  echo "<pre>";print_r($tokens);
        //  echo "<pre>";print_r($msg);exit;
                    
       $this->api_model->send_notification($tokens,$msg);
 

            $insert_batch[] = array(
                'std_id'=>$value,
                'homework'=>$data['homework'],
                'date'=>date('Y-m-d')
            );
        }
        
        if(!empty($insert_batch)){
            $this->db->insert_batch('homework', $insert_batch);
        }
        redirect('Homework/class_wise_form');
    }

    public function add_homework()
    {
        $this->user_model->check_permissions("Homework/view");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

        $this->db->select('homework.id,homework.date,student.sid,student.student_name,student.father_name,class.class_name,section.section_name,homework.homework');
        $this->db->join('student','homework.std_id=student.id');
        $this->db->join('promotion','student.id=promotion.student_id');
        $this->db->join('class','promotion.class_id=class.class_id');
        $this->db->join('section','promotion.section_id=section.section_id');
        $this->db->where('homework.is_delete',0)->where('promotion.is_active',1);
        $data['homework']=$this->db->get('homework')->result_array();
        
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('homework/view',$data);
    }

    public function hw_view()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $student_id =$this->user_model->userInfo('student_id')['student_id'];

        $this->db->select('homework.id,homework.date,student.sid,student.student_name,student.father_name,class.class_name,section.section_name,homework.homework');
        $this->db->join('student','homework.std_id=student.id');
        $this->db->join('promotion','student.id=promotion.student_id');
        $this->db->join('class','promotion.class_id=class.class_id');
        $this->db->join('section','promotion.section_id=section.section_id');
        $this->db->where('homework.std_id',$student_id);
        $this->db->where('homework.is_delete',0)->where('promotion.is_active',1);
        $data['homework']=$this->db->get('homework')->result_array();
        
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('homework/hw_view',$data);
    }
    
    public function delete($id='')
    {  $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
        if(!empty($id)){
            $this->db->where('id',$id)->update('notice',['is_delete'=>1]);
        }
        redirect('Homework/view');
    }

}