<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * Report Class
 *
 * @package     edusol
 * @subpackage  Report
 * @author      Tahir Nasir & Saqib Sadiq

 */
class Report extends CI_Controller {

    private $userInfo = array();
    private $is_super;
    private $branch;
  
    public function __construct()
    {
        parent::__construct();
        $this->user_model->check_login("report");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        $this->is_super = $this->user_model->is_super();
        $this->branch = $this->user_model->getBranch();
        $this->load->model("report_model");
        $this->load->model("voucher_model");
        $this->load->model("account_model");
        $this->load->model("generic_model");
        $this->load->model('Showexam_model');
        $this->load->model("Teacher_model");
        $this->load->model("Attendance_model");
        $this->load->model("Salary_model","sm");
        $this->load->model("Student_model"); 
     
    }
    
    public function bio_att_daterange()
    {
   
        $data['mydate']=$this->input->post('date');
        $branch=$this->branch;
       
        $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/bio_att_daterange',$data);
        $this->load->view('footer',$data);
    }
    
    
 public function fetch_bio_att_daterange()
    {
          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $branch=$this->user_model->getbranch();
        $data['branch']=$branch; 
        $sdate=$this->input->post('sdate');
        if(empty($sdate))
        {
            $sdate=date("Y-m-d");
        }
        $data['sdate']=$sdate;
        $data['edate']=$this->input->post('edate');
        $edate=$this->input->post('edate');
        $edate=$this->input->post('edate');
        if(empty($edate))
        {
            $edate=date("Y-m-d");
            $data['edate']=$edate;
        }
          
        $type=$this->input->post('type');


            $type=$this->input->post('type');
           
            if($type==1)
            {
                
                $branch=$this->branch;
                $data['is_super'] = $this->is_super;
                $data['menu'] = $this->load_model->menu();
                    
                $data['att']=$this->db->query("
                SELECT teacher.firstname,teacher.lastname,teacher.id as teacher_id,teacher.doj,  
                leave_types.name as st_name,teacherattendance.status_id,
                teacherattendance.date,
                right(teacherattendance.check_in, 9) as check_in,
                right(teacherattendance.check_out, 9) as check_out,
                
                teacher.designation 
                FROM `teacherattendance`
                INNER JOIN teacher ON teacherattendance.teacher_id=teacher.id
                INNER JOIN leave_types ON leave_types.id=teacherattendance.status_id
                WHERE teacherattendance.date >= '$sdate' 
                AND  teacherattendance.date <= '$edate'
                AND teacherattendance.is_deleted=0
                AND teacher.branch='$branch'
                AND leave_types.branch='$branch'
                and teacher.status=0
                AND teacher.is_delete='0'
                 
                ")->result_array();
                
                if(empty($data['att'])){
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/bio_att_daterange", "refresh");
                }
                else{
                $staff_ids = array_column($data['att'],"teacher_id");
                $staff_idss = implode(',', (array)$staff_ids);
                $data['absents']=$this->db->query("
                    SELECT  teacher.firstname,teacher.lastname,teacher.branch,teacher.id,teacher.designation 
                
                                FROM `teacher`
                                Where
                                 teacher.is_delete=0  and teacher.id NOT IN ($staff_idss) and teacher.status=0
                                and teacher.branch=$branch")->result_array();
                }
                //var_dump("<pre>",$data['att']);die;
                
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                //$data['teacher_2']=$data['teacher'];
           
                if(empty( $data['att']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/bio_att_daterange", "refresh");
                }
                $this->load->view('report/fetch_bio_att_daterange',$data);
            }
            else
            {
                
                $branch=$this->branch;
                $data['is_super'] = $this->is_super;
                $data['menu'] = $this->load_model->menu();
               
                $data['att']=$this->db->query("
                SELECT staff.firstname,staff.id as staff_id,staff.lastname,staff.doj, 
                staffatt.status_id,
                staffatt.date,
                right(staffatt.check_in, 9) as check_in,
                right(staffatt.check_out, 9) as check_out,
                staff.designation 
                FROM `staffatt`
                INNER JOIN staff ON staffatt.staff_id=staff.id
                WHERE staffatt.date >= '$sdate' 
                AND  staffatt.date <= '$edate'
                AND staffatt.is_deleted=0
                AND staff.branch='$branch'
                and staff.status=0
                AND staff.is_delete='0'
                ")->result_array();
               
                if(empty($data['att'])){
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/bio_att_daterange", "refresh");
                }
                else{
                
                $staff_ids = array_column($data['att'],"staff_id");
                $staff_idss = implode(',', (array)$staff_ids);
                $data['absents']=$this->db->query("
                    SELECT  staff.firstname,staff.lastname,staff.designation,staff.branch,staff.id
                                FROM `staff`
                                
                                Where staff.is_delete=0  and staff.id NOT IN ($staff_idss) and staff.status=0
                                and staff.branch=$branch")->result_array();
                //var_dump($data['absents']);die;
                
              
                }
                
        
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                if(empty( $data['att']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/bio_att_daterange", "refresh");
                }
           
                $this->load->view('report/fetch_bio_att_daterange',$data);
            }
    }
      public function exam_pass()
    {
        $this->user_model->check_permissions("exam/rollno");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/exam_pass",$data);
    }

    public function viewexampass() 
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        // Getting Values from URI Segments
        $branch = $this->uri->segment('3');
        $class = $this->uri->segment('4');
        $section = $this->uri->segment('5');
        $exam = $this->uri->segment('6');
        //
        $data['exam']=$exam; 
        $data['class']=$class; 
        $data['section']=$section; 
        $d=$this->db->query("SELECT promotion.id as stid,sid,student_name,student.grno, branch.name from rollnoslip INNER JOIN branch on branch.id=rollnoslip.branch_id INNER JOIN promotion on promotion.id=rollnoslip.student_id inner join student on student.id=promotion.student_id inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id WHERE promotion.is_active='1' AND promotion.is_delete='0' AND rollnoslip.class_id='$class' AND rollnoslip.section_id='$section' AND rollnoslip.branch_id='$branch' AND rollnoslip.exam_id='$exam' AND student.status='0'")->result_array();
        $data["data"]=$d;
        $data["i"]=1;


        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/viewexampass",$data);
    }

 public function passdate()
    {
           // $exam = $this->input->post("exam");
           if($this->uri->segment('3')){
            $id=$this->uri->segment('3');
            $exam_id=$this->uri->segment('4');
            $branch=$this->user_model->getbranch();
            $data['branch']=$branch;
            $data['b_header'] = @$this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            //var_dump($data['b_header']);die();
            $rollnoslip = $this->db->query("SELECT seat_no,class_id from rollnoslip where student_id='$id' AND `exam_id`='$exam_id' AND is_delete='0'")->result_array()[0];
            $data['seat_no'] = $rollnoslip['seat_no'];
            $class = $rollnoslip['class_id'];
            $data['classs'] = $rollnoslip['class_id'];
			$data['exams']= $exam_id;
		
    $data['student'] = $this->db->query("SELECT student.id,roll_no,student_name,student.grno,father_name,class.class_name,student.sid,student.img,student.dob,section.section_name from student INNER JOIN promotion on promotion.student_id=student.id

 inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id  WHERE promotion.is_active='1' AND promotion.is_delete='0' AND promotion.id='$id'")->result_array()[0];
           
            $data['exam'] = $this->db->select('id,name')->from("exam")->where("is_delete","0")->where('id',$exam_id)->get()->row_array();
            
            $data['data'] = $this->db->query("SELECT datesheet.date_exam,datesheet.day_exam,datesheet.start_time,datesheet.end_time,subject.name as subject_name,class.class_id FROM `datesheet` INNER JOIN class on datesheet.class_id=class.class_id INNER JOIN subject ON subject.id=datesheet.subject_id  WHERE datesheet.is_delete='0' and datesheet.class_id='$class' and datesheet.exam_id='$exam_id'")->result_array();
			
	 	
            $data['note'] = $this->db->query("SELECT note FROM `note` WHERE branch_id='$branch' and note.is_delete='0'")->result_array();
            $this->load->view("report/passdate",$data);
        }
        else
        {
            redirect('report/exam_pass',refresh);
        }
     
    }
    
     public function printall_pass()
    {
           // $exam = $this->input->post("exam");
        if($this->uri->segment('3')){
            $class=$this->uri->segment('3');
            $section=$this->uri->segment('4');
            $exam_id=$this->uri->segment('5');
            $branch=$this->user_model->getbranch();
            $data['branch'] = $branch;
            $data['exams']= $exam_id;
            
            $data['classs'] = $class;   
            $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            $data['exam'] = $this->db->select('id,name')->from("exam")->where("is_delete","0")->where('id',$exam_id)->get()->row_array();
            $data['data'] = $this->db->query("SELECT datesheet.date_exam,datesheet.day_exam,datesheet.start_time,datesheet.end_time,subject.name as subject_name FROM `datesheet` INNER JOIN class on datesheet.class_id=class.class_id INNER JOIN subject ON subject.id=datesheet.subject_id  WHERE datesheet.is_delete='0' and datesheet.class_id='$class' and datesheet.exam_id='$exam_id'")->result_array();
            $data['note'] = $this->db->query("SELECT note FROM `note` WHERE branch_id='$branch' and note.is_delete='0'")->result_array();
            /**/
            $data['students'] = $this->db->query("SELECT student.id,roll_no,student_name,father_name,class.class_name,student.sid,student.img,student.dob,section.section_name from student INNER JOIN promotion on promotion.student_id=student.id inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id  WHERE promotion.is_active='1' AND promotion.is_delete='0' AND promotion.class_id='$class' AND promotion.section_id='$section' and student.status='0'")->result_array();
            //$rollnoslip = $this->db->query("SELECT seat_no,class_id from rollnoslip where student_id='$id' AND `exam_id`='$exam_id' AND is_delete='0'")->result_array()[0];
              
            //var_dump($data['exam']);die;
            //$data['seat_no'] = $rollnoslip['seat_no'];
            $this->load->view("report/printall_pass",$data);
        }
        else
        {
            redirect('report/exam_pass',refresh);
        }
     
    }
    
      public function exampass_slip()
    {
        if($this->input->post())
        {
            $id = $this->input->post("id",true);
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $section = $this->input->post("section",true);
            $exam = $this->input->post("exam",true);
            $data = $this->db->query("SELECT promotion.id,student.sid 
                                             FROM `promotion` 
                                             INNER JOIN student ON student.id=promotion.student_id 
                                        WHERE student.branch='$branch' and promotion.class_id='$class' and promotion.section_id='$section' and promotion.is_active='1' 
                                        and promotion.is_delete='0' and student.status='0'")->result_array();
            $series = $this->random_numbers(4);
            foreach ($data as $key => $value) {
                $student_id = $value['id'];
                $exam_date = $this->db->select("start")->from("exam")->where("id",$exam)->get()->row_array()['start'];
                $seat_no = $series++; //date("ymd",strtotime($exam_date))..$value['sid']
                $count = $this->db->select("id")->from("rollnoslip")->where("student_id",$student_id)->where("branch_id",$branch)->where("class_id",$class)->where("section_id",$section)->where("exam_id",$exam)->where("is_delete","0")->count_all_results();
                if($count==0)
                {
                    $data = array(
                        "branch_id"=>$branch,
                        "class_id"=>$class,
                        "exam_id"=>$exam,
                        "section_id"=>$section,
                        "student_id"=>$student_id,
                        "seat_no"=>$seat_no
                    );
                    //$this->db->insert("rollnoslip",$data); 
                }
            }
            redirect("report/viewexampass/$branch/$class/$section/$exam","refresh");
        }
    }

    
    public function general_legder()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
         $data['heads']=$this->db->query("SELECT * FROM `account_heads` order by replace(code, '-', '') asc")->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/general_ledger',$data);
         $this->load->view('footer',$data);
    }
    
    
   public function fee_version()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->user_model->check_permissions("voucher/fee_history");
        $branch = $this->user_model->getBranch();
        if($this->user_model->is_super())
        {
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        } else {
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->result_array();
        }

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/fee_version',$data);
        $this->load->view('footer',$data);
    }
    
    
    public function auto_version()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->user_model->check_permissions("voucher/fee_history");
        $branch = $this->user_model->getBranch();
        if($this->user_model->is_super())
        {
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        } else {
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->result_array();
        }

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/auto_version',$data);
        $this->load->view('footer',$data);
    }
    
    
    // public function student_version($q="all",$p=1)
    // {
    //     $data['menu'] = $this->load_model->menu();
    //     $data['base_url'] = base_url();
    //   // $data['userInfo'] = $this->userInfo;
    //     $branch = $this->user_model->getBranch();
    //      $data['branchId']=$this->report_model->getBranch()[0]['id'];
    //     $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
    //     $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
       
    //   if(!$this->user_model->is_super())
    //     { 
    //         $data['branch']=$this->user_model->getBranch(); 
    //      }else {
    //         $data['branch']=$this->student_model->getbranch()->result_array();
    //      }
    //      $data['session'] = $this->db->query("SELECT * FROM `session` WHERE `is_delete`='0'")->result_array();
    //     $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
      
    //     $data['branches']=$this->report_model->getAllBranches();
    //   $data['status']=$this->report_model->getAllRecords('status',array('is_delete'=>0,'type'=>'Student', 'branch'=>$data['branchId']));
    //       $this->user_model->check_permissions("report/bio_data");
    //       $data['is_super'] = $this->user_model->is_super();
    //     $q = urldecode($q);
    //     $p = $p<1?1:$p;
    //     $per_page = 20;
    //     $offset = ($p - 1) * $per_page;
    //       $sq1 = "";
    //     if($q!="all")
    //     {
    //         $sq1 .= "AND (student.grno like '%".$q."%' OR "; 
    //         $sq1 .= "student.student_name like '%".$q."%' OR ";
    //         $sq1 .= "student.father_name like '%".$q."%' OR ";
    //         $sq1 .= "student.father_contact like '%".$q."%' OR ";
    //         $sq1 .= "class.class_name like '%".$q."%' OR ";
    //         $sq1 .= "section.section_name like '%".$q."%' )";
    //     }

    //     $total = @$this->db->query("SELECT count(*) as total FROM `student` inner JOIN promotion ON promotion.student_id=student.id inner JOIN class ON promotion.class_id=class.class_id inner JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' AND student.status='0' AND promotion.is_active='1' $sq1 LIMIT $offset, $per_page")->result_array()[0]['total'];
    //     $query = $this->db->query("SELECT student.*,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' AND student.status='0' AND promotion.is_active='1' $sq1 LIMIT $offset,$per_page");

        
    //     $data['q'] = $q;
    //     $data['curr'] = $p;
    //     $data['searchq'] = $q;
    //     $data['base_url'] = base_url();
    //     $data['userInfo'] = $this->userInfo;
    //     $data['student'] = $query->result_array();
    //     $data['end'] = ceil($total / $per_page);
       
       

    //     $this->load->view('header',$data);
    //     $this->load->view('sidebar',$data);
    //     $this->load->view('report/student_version',$data);
    //     $this->load->view('footer',$data);
    // }
    
     public function others_reports($q="all",$p=1)
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->user_model->check_permissions("report/permission");
        if(!$this->user_model->is_super())
        {
            $data['branch']=$this->user_model->getBranch();
        }else {
            $data['branch']=$this->Teacher_model->getbranch()->result_array();
        }
//        Subject Summary Report and Subject allocation
        if(!$this->user_model->is_super())
        {
            $data['branche']=$this->user_model->getBranch();
            $branche=$this->user_model->getBranch();
        }else {
            $data['branche']=$this->Student_model->getbranch()->result_array();
        }


//        Subject Summary Report and Subject allocation end

        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
       
        
        //student reports
        $branch = $this->user_model->getBranch();
         $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
       
       
         $data['session'] = $this->db->query("SELECT * FROM `session` WHERE `is_delete`='0'")->result_array();
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
      
        $data['branches']=$this->report_model->getAllBranches();
       $data['status']=$this->report_model->getAllRecords('status',array('is_delete'=>0,'type'=>'Student', 'branch'=>$data['branchId']));
          $this->user_model->check_permissions("report/bio_data");
          $data['is_super'] = $this->user_model->is_super();
        $q = urldecode($q);
        $p = $p<1?1:$p;
        $per_page = 20;
        $offset = ($p - 1) * $per_page;
          $sq1 = "";
        if($q!="all")
        {
            $sq1 .= "AND (student.grno like '%".$q."%' OR "; 
            $sq1 .= "student.student_name like '%".$q."%' OR ";
            $sq1 .= "student.father_name like '%".$q."%' OR ";
            $sq1 .= "student.father_contact like '%".$q."%' OR ";
            $sq1 .= "class.class_name like '%".$q."%' OR ";
            $sq1 .= "section.section_name like '%".$q."%' )";
        }

        $total = @$this->db->query("SELECT count(*) as total FROM `student` inner JOIN promotion ON promotion.student_id=student.id inner JOIN class ON promotion.class_id=class.class_id inner JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' AND student.status='0' AND promotion.is_active='1' $sq1 LIMIT $offset, $per_page")->result_array()[0]['total'];
        $query = $this->db->query("SELECT student.*,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' AND student.status='0' AND promotion.is_active='1' $sq1 LIMIT $offset,$per_page");

        
        $data['q'] = $q;
        $data['curr'] = $p;
        $data['searchq'] = $q;
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['student'] = $query->result_array();
        $data['end'] = ceil($total / $per_page);
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/others_report',$data);
        $this->load->view('footer',$data);
    }

    
     public function daily_att()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch = $this->user_model->getBranch();

        if($this->user_model->is_super())
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();

        else $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/daily_att',$data);
        $this->load->view('footer',$data);
    }
    
      public function hr_reports()
    {
         $this->user_model->check_permissions("teacher/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch = $this->user_model->getBranch();
 $query = $this->db->query("SELECT teacher.id,teacher.firstname,teacher.lastname,teacher.designation,teacher.contact,teacher.qualification,teacher.doj,teacher.dob,teacher.salery,teacher.specialization ,status.name FROM `teacher` inner join `status` on teacher.status = status.id   WHERE teacher.branch = '$branch' AND teacher.is_delete='0'");

        $data['teachers'] = $query->result_array();
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/hr_reports',$data);
        $this->load->view('footer',$data);
        
    }
    
     public function students_version()
    {
         $this->user_model->check_permissions("teacher/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch = $this->user_model->getBranch();
 
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/students_version',$data);
        $this->load->view('footer',$data);
        
    }
    
     public function exam_version()
    {
        $branch=$this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
            $this->db->select("exam.name,exam.id");
            $this->db->from("exam");
            $this->db->join("exam_type","exam_type.id= exam.etype_id");
            $this->db->where("exam_type.branch_id",$branch);
            $this->db->where("exam.is_delete",0);
            $this->db->where("exam_type.is_delete",0);
            $data['result'] = $this->db->get()->result_array();
      
        
        $data['branch'] = $this->report_model->getBranch();
        $data['session'] = $this->report_model->getSessions();
        $data['exam']=$this->db->query("SELECT `exam`.id,`exam`.name FROM `exam` INNER JOIN `exam_type` ON `exam_type`.`id`=`exam`.`etype_id` where `exam`.is_delete= 0 AND `exam_type`.is_delete= 0 AND `exam_type`.branch_id='$branch'")->result_array();
        $data['classes']=$this->db->where('is_delete', '0')->where('branch',$branch)->get('class')->result_array();
        
            
		$data['examlist'] = $this->db->query("SELECT distinct(exam.name) as e_name,exam FROM `seating_plans` 
			inner join exam on exam.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and seating_plans.is_delete=0")->result_array();
    //   var_dump('<pre>',$data['examlist']);
    //   die();
              
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/exam_version',$data);
        $this->load->view('footer',$data);
        
    }
    
    public function sitting_plan_view_block_wise()
	{
		
        
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->user_model->check_permissions("branch/view");
        $data['menu'] = $this->load_model->menu();
        $branch = $this->user_model->getBranch();
		$block = $this->input->post('block');
		$exam = $this->input->post('examblock');
		$classblock = $this->input->post('classblock');
		
			
			$this->db->select("*,block.name as block_name,exam.name as e_name")
			         ->from('seating_plans') 
                    ->join('student','student.id=seating_plans.student_id')
                    ->join('promotion','promotion.student_id=seating_plans.student_id')
                    ->join('class','class.class_id=promotion.class_id')
                    ->join('section','section.section_id=promotion.section_id')
        			->join('block','block.id = seating_plans.block')
        			->join('exam','exam.id = seating_plans.exam')
        			->where('seating_plans.branch',$branch)
        			->where('seating_plans.is_delete',0)
        			->where('promotion.is_active',1)
        			->where('seating_plans.is_delete',0)
        			->where('seating_plans.exam',$exam);
        			
        			if(!empty($block))
        			{
        			  $this->db->where('seating_plans.block',$block);  
        			}
        			
        			if(!empty($classblock))
        			{
        			  $this->db->where('seating_plans.class_id',$classblock);  
        			}
        			$this->db->order_by('seating_plans.id','asc');
            $data['seat_plan']=$this->db->get()->result_array();
            
            	if(!empty($block))
        			{
             $data['block'] = $this->db->query("select block.name from block where id = $block")->row_array()['name']; 
        			}else
        			{
        		$data['block'] ="All";	    
        			}
			 $data['exam_type'] = $this->db->query("select exam.name from exam where id = $exam")->row();
			
       		 $this->load->view('report/sitting_plan_view_block_wise_record',$data);
		
       		 
		
	}
	
        public function general_student()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/general_student',$data);
         $this->load->view('footer',$data);
    }
    
    //concern and remove it chart_of_accounts
    
    //  public function chart_of_accounts()
    // {
        
        
    //      if($this->input->post())
    //     {
            
    //         $data['show']=$this->input->post("showbalance",true);
    //         $data['inact']=$this->input->post("inact",true);
    //         $data['comment']=$this->input->post("comment",true);
    //         $data['orient']=$this->input->post("orientation",true);
    //         //$data['chart']=$this->report_model->Chartaccounts($show,$inact);
    //         if($data['show']=='No' and $data['inact']=='No')
    //         {
    //           $data['query']=$this->db->query("SELECT * FROM `account_heads` WHERE `most_parent`=0 AND `is_delete`=0")->result_array();
    //         }
    //         elseif ($data['show']=='Yes' and $data['inact']=='Yes')
    //         {
    //              $data['query1']=$this->db->query("SELECT * FROM `account_heads` WHERE `most_parent`=0 AND `is_delete`=0")->result_array();
    //             foreach($query1 as $val)
    //           {
    //               $er['query2']=$this->db->query("SELECT * FROM `account_heads` WHERE `parent`='$val[id]' AND `is_delete`=0")->result_array();
    //           }
               
               
    //         }
    //         }
            
        //   $data=array( 
        //     $showbal=$this->input->post('showbalance'),
        //     $inact=$this->input->post('inact'),
        //     $comment=$this->input->post('comment'),
        //     $orient=$this->input->post('orientation')
        //   );
           
        // $this->load->view('header',$data);
        // $this->load->view('sidebar',$data);
//         $this->load->view('report/chartofaccounts',$data);
        //  $this->load->view('footer',$data);
//    }
    
    
    
     public function chart_ofaccounts()
    {
        if ($this->input->post()) {
            $data['is_super'] = $this->user_model->is_super();
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['show'] = $this->input->post("showbalance", true);
            // $data['inact'] = $this->input->post("inact", true);
            $data['comment'] = $this->input->post("comment", true);
            $data['orient'] = $this->input->post("orientation", true);
            $data['destination'] = $this->input->post("destination", true);
             if ($data['orient']=='Portrait')
            {
                $data['query']=$this->db->query("SELECT * FROM `account_heads` order by replace(code, '-', '') asc")->result_array();
                $this->load->view('report/chartofaccounts',$data);
            }

            if ($data['orient']=='Landscape')
            {
                $data['query']=$this->db->query("SELECT * FROM `account_heads` order by replace(code, '-', '') asc")->result_array();
                $this->load->view('report/chartofaccountsbal',$data);
            }
    }
    }
    
     

    
    public function progress_report1()
    {
      // $this->user_model->check_permissions("student/studentatt_add");
     // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->student_model->getbranch()->result_array();
         }
         $data['session'] = $this->db->query("SELECT * FROM `session` WHERE `is_delete`='0'")->result_array();
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/progress_report',$data);
    }
    

      public function ProgressReportList1()
    { 
        if($this->input->post())
        {
            $class=$this->input->post('class');
         $section=$this->input->post('section');
          $session=$this->input->post('session');
         $data['class'] = $class;
         $data['section'] = $section;
          $data['session'] = $session;
         

        $students=$this->db->select('student_id')->where('class_id',$class)->where('section_id',$section)->where('session_id',$session)->where('is_active',1)->get('promotion')->result_array();
         foreach($students as $key=>$value){
          $data['student'][]=$this->db->query("SELECT student.id,student.img,section.section_name,student.father_name,class.class_name,student.student_name,student.sid 
                     FROM `student` INNER JOIN promotion on promotion.student_id=student.id 
                                INNER JOIN class on class.class_id=promotion.class_id 
                                INNER JOIN section on section.section_id=promotion.section_id 
                            WHERE student.is_delete=0
                            and student.status=0
                          and class.class_id='$class' 
                          and promotion.student_id=".$value['student_id']."
                          and section.section_id='$section'")->row_array();
}
// echo "<pre>";print_r($data['student']);exit;
             if(empty($data['student']))
           {
              echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
        
           }
           else{
         $branch=$this->user_model->getbranch();
            $data['menu'] = $this->load_model->menu();
            $data['userInfo'] = $this->userInfo;
            $data['base_url'] = base_url();
             $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/ProgressReportList',$data);
            // $this->load->view('footer',$data);
      
           }
    
           
        }
    }


public function fetch_progress_report1($class,$section,$student_id,$session) 
    {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $data['student']=$this->db->query("SELECT 
                     student.id,student.img,section.section_name,student.father_name,class.class_name,student.student_name,student.sid
                     FROM `student` INNER JOIN promotion on promotion.student_id=student.id 
                                INNER JOIN class on class.class_id=promotion.class_id 
                                INNER JOIN section on section.section_id=promotion.section_id 
                                                     WHERE   promotion.session_id=$session
                          and promotion.is_delete=0
                          and class.class_id='$class' 
                          and promotion.student_id=".$student_id."
                          and section.section_id='$section'")->row_array();
      $branch=$this->user_model->getbranch();
      $exam = @$this->db->select('id')->get('exam')->result_array();
if($exam){
$exams[0] = 0;
foreach($exam as $v){
   $exams[] = $v['id'];
}}
//echo "<pre>";print_r($exams);exit;
$exams = base64_encode(json_encode($exams));
         //echo "<pre>";print_r($data['student']);exit;
      
$data['student']['present'] = $this->db->query("SELECT DISTINCT(studentatt.date) FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student_id AND attendancestatus.status = 'P'")->num_rows();

$data['student']['absnt'] = $this->db->query("SELECT DISTINCT(studentatt.date) FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student_id AND attendancestatus.status = 'A'")->num_rows();

$data['student']['leave'] = $this->db->query("SELECT DISTINCT(studentatt.date) FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student_id AND attendancestatus.status = 'L'")->num_rows();
$data['student']['tardy'] = $this->db->query("SELECT DISTINCT(studentatt.date) FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student_id AND attendancestatus.status = 'T'")->num_rows();
// echo "<pre>";print_r($data['student']['present']);exit;
$exam_list=$this->report_model->ExamsResult($exams,$student_id,$session);
 
foreach($exam_list as $k=>$val){
     if($val){
         $data['student']['result_exam'][] =@$this->db->select('result.id,result.total_marks,result.obtained_marks,(result.obtained_marks*100/(result.total_marks)) as percentage,exam.name as exam_name')->join('exam','exam.id=result.exam_id')->where('result.id',$val->id)->get('result')->result_array()[0];
}
}
//echo $student['id'];exit;

$data['student']['invoice'] = @$this->db->query("SELECT SUM(invoice.recieved) as total_fee FROM invoice INNER JOIN promotion on promotion.id=invoice.student_id  WHERE promotion.student_id = $student_id AND invoice.status = '1' AND promotion.session_id = $session")->result_array()[0];
$year=date('Y');
$data['student']['invoice1'] = @$this->db->query("SELECT invoice.recieved as total_fee,submitted_at FROM invoice INNER JOIN promotion on promotion.id=invoice.student_id  WHERE promotion.student_id = $student_id AND invoice.status = '1' AND promotion.session_id = $session AND left(submitted_at,4)=$year order by invoice.recieved DESC ")->result_array();
 
        
        
// echo "<pre>";print_r($data['student']['invoice1']);
 
         $data['subjects']=$this->report_model->getClassSubjectNames($class,$section);
         $result_subjects = [];
         foreach($data['student']['result_exam'] as $key=>$value)
         {
          if(!empty($value)){
          $subjects_ids = $this->report_model->getSubjectNames($value['id']);
          if(!empty($subjects_ids))
           {
            foreach ($subjects_ids as $k => $v) {
             $result_subjects[$v->name][$key] = $v->id;
            }
          }
        }
          }

        //echo "<pre>";print_r($result_subjects);exit;
        foreach($result_subjects as $key => $value){
               $sub_result[$key]['total_marks'] = 0; 
               $count = count($value);
               foreach($value as $k=>$v){
               $mark = $this->report_model->getSubjectMark($v);
               $sub_result[$key]['total_marks'] += ($mark->obtained_marks * 100)/$mark->total_marks;
}
$data['sub_result'][$key]['total_marks'] = round($sub_result[$key]['total_marks'] / $count,2);
}
//echo "<pre>";print_r($sub_result);exit;
  //      echo "<pre>";print_r($result_subjects);exit;

//echo "<pre>";print_r($data);exit;
        
                       // var_dump($data['student']);
                      //  die();
                          
          if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/progress_report1", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/display_progress_report',$data);
           }
    }
    
     public function report_card()
    {
        //$this->user_model->check_permissions("Report/ft_assessment");
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $this->report_model->getBranch();
            $data['session'] = $this->report_model->getSessions();
            
            
        $data['classes']=$this->db->where('is_delete', '0')->get('class')->result_array();
       // var_dump('<pre>',$data['classes']);exit;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
           $this->load->view('report/report_card',$data);
            $this->load->view('footer',$data);
    }
    
      public function get_report_card()
    {
        $checkdata=$this->input->post();
        if(!empty($checkdata))
        {
        $branch=$this->report_model->getBranch()[0];
        $data['b']=$branch;
        $class=$this->input->post('class');
        $section=$this->input->post('section');
        $exam=$this->input->post('exam');

        $student= $this->input->post('student');
        $add_exam=$this->input->post('add_exam');
        $session=$this->input->post('session');
        $pr_id= @$this->db->where('student_id',$student)->where('session_id',$session)->where('is_active',1)->get('promotion')->row()->id;
     
        $data['pr_id']=$pr_id;
        $data['stdd_id']=$pr_id;
        $data['exam_id']=$exam;
        $data['addexam_id']=$add_exam;
        $data['cc']=$class;
        $data['ccsec']=$section;
        $data['session_id']=$session;
        
       
      
        $data['percn']=$this->db->select('*')
                                ->from('result')
                                ->where('exam_id',$exam)
                                ->where('promotion_id',$pr_id)
                                ->where('is_delete',0)
                                ->get()->row_array();
         
        //  var_dump('<pre>',$data['percn']);
        //  die();
         
        $data['subjects_cls']=$this->db->select('*')
                                       ->from('subject')
                                       ->where('class_id',$class)
                                       ->where('is_deleted',0)
                                       ->get()->result_array();
                                      
      
          $data['ad_exm']=$this->db->select('*')
                                 ->from('exam')
                                 ->where('id',$exam)
                                 ->get()->row_array();  
       $datofbirth=$this->db->select('dob')
                                 ->from('promotion')
                                 ->join("student","student.id=promotion.student_id")
                                 ->where("student.status","0")
                                 ->where("student.branch",$branch['id'])
                                 ->where('class_id',$class)
                                 ->where('section_id',$section)
                                 ->where('session_id',$session)
                                 ->where('is_active',1)
                                 ->where('student.is_delete',0)
                                 ->get()->result_array();
          $i=0;
            $sum=0;
        if(!empty($datofbirth))
        {
           
            foreach($datofbirth as $roww=>$keyy){
                
               $birthDate = date("d/m/Y",strtotime($keyy['dob']));
               $birthDate = explode("/", $birthDate);
                $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md")?((date("Y") - $birthDate[2]) - 1): (date("Y") - $birthDate[2]));
                 $sum=$sum+$age;
                $i=$i+1;
            }
        }
  if($sum!=0)
  {
$data['avg_age']=round($sum/$i,2);
}else
{
    $data['avg_age']="";
}
        $tot_std=$this->db->select('count(promotion.id) as stds')
                                 ->from('promotion')
                                 ->join("student","student.id=promotion.student_id")
                                 ->where("student.status","0")
                                 ->where("student.branch",$branch['id'])
                                 ->where('class_id',$class)
                                 ->where('section_id',$section)
                                 ->where('session_id',$session)
                                 ->where('is_active',1)
                                 ->where('student.is_delete',0)
                                 ->get()->row_array();

    if(!empty($tot_std))    
    {
        $data['tot_stds']=$tot_std['stds'];
    }else
    {
        $data['tot_stds']=0;
    }
    $data['dastudent']=@$this->db->where('student_id',$student)->where('session_id',$session)->where('is_active',1)->where('is_delete',0)->get('promotion')->row()->id;
  
  $fect_catid=$this->db->select('*')
                       ->from('exam')
                       ->where('id',$exam)
                       ->get()->row_array()['etype_id'];
                                 
$data['getnew']=$this->db->select('*')
                    ->from('examsubtype')
                    ->where('exam_type',$fect_catid)
                    ->where('is_delete',0)
                    ->get()->result_array();
  $data['tot_subj']=count($data['getnew']); 
     
        $data['seen_exam'] ="";
     
    
        $data['unseen_exam'] ="";
      
        $data['percentage']=$this->input->post('percentage');
      $data['dob']=$this->db->where('id',$student)->get('student')->row()->dob;
    
        $data['students']=$this->db->where('id',$student)->get('student')->row()->student_name;
        $data['class_name']=$this->db->where('class_id',$class)->get('class')->row()->class_name;
        $data['class_name']=$this->db->where('class_id',$class)->get('class')->row()->class_name;
        $data['section_name']=$this->db->where('section_id',$section)->get('section')->row()->section_name;
        $data['first_term']=$this->report_model->StudentWiseExamStudents($branch,$class,$section,$student,$add_exam,$session);
        $data['student']=$this->report_model->StudentWiseExamStudents($branch,$class,$section,$student,$exam,$session);
        $data['highest_grade']=$this->report_model->StudentWiseHighestGrade($branch,$class,$section,$exam,$session);
        $data['highes']=$this->report_model->StudentWiseHighestGraderep($branch,$class,$section,$exam,$session);
        $data['lowest_grade']=$this->report_model->StudentWiselowestGrade($branch,$class,$section,$exam,$session);
        $data['lowes']=$this->report_model->StudentWiselowestGraderep($branch,$class,$section,$exam,$session);
        $data['all_student_lowest_grade']=$this->report_model->StudentWisealllowestGrade($branch,$class,$section,$exam,$session);
        $data['get_att']=$this->report_model->Studentatt($branch,$class,$section,$student,$session);
         $data['tot_att']=$this->report_model->Studentattot($branch,$class,$section,$student,$session);
     
        $data['get_absent']=$this->report_model->StudentattAbsent($branch,$class,$section,$student,$session);
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         
     $this->load->view('report/get_report_card',$data);
        }else
        {
            redirect('Report/report_card');
        }
       
        
    }
    
     public function save_rep()
    {
       
        $mystd_id=$this->input->post('mystd_id');
        $myexm_id=$this->input->post('myexm_id');
        $myaddexam_id=$this->input->post('myaddexam_id');
        $sessoin_id=$this->input->post('sessoin_id');
        $subj_ids=$this->input->post('subj_ids');
        $Coursework=$this->input->post('Coursework');
        $attend=$this->input->post('attend');
        $absent=$this->input->post('absent');
        $class_parti=$this->input->post('class_parti');
        $homework=$this->input->post('homework');
        $classwork=$this->input->post('classwork');
        $Behaviour=$this->input->post('Behaviour');
        $Uniform=$this->input->post('Uniform');
        $HHW=$this->input->post('HHW');
        $teacher_stement=$this->input->post('teacher_stement');
        $art=$this->input->post('art');
        $PE=$this->input->post('PE');
        $Music=$this->input->post('Music');
       
       $data=array(
           'mystd_id'=>$mystd_id,
           'myexm_id'=>$myexm_id,
           'myaddexam_id'=>$myaddexam_id,
           'sessoin_id'=>$sessoin_id,
           'attend'=>$attend,
           'absent'=>$absent,
           'class_parti'=>$class_parti,
           'homework'=>$homework,
           'classwork'=>$classwork,
           'Behaviour'=>$Behaviour,
           'Uniform'=>$Uniform,
           'HHW'=>$HHW,
           'teacher_st'=>$teacher_stement,
           'art'=>$art,
           'PE'=>$PE,
           'Music'=>$Music
           );
         $this->db->insert('rept_crd',$data);  
         $insrt_id=$this->db->insert_id();
         if(!empty($subj_ids))
         {
             foreach($subj_ids as $key=>$val)
             {
                 $data2=array(
                     'report_id'=>$insrt_id,
                     'subject_id'=>$val,
                     'class_mrks'=>$Coursework[$key],
                     );
                 $this->db->insert('report_subj',$data2);
             }
         }
         redirect('Report/report_card');
    }
    
    public function ft_assessment()
    {
            //$this->user_model->check_permissions("Report/ft_assessment");
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $this->report_model->getBranch();
            $data['session'] = $this->report_model->getSessions();
            
            
        $data['classes']=$this->db->where('is_delete', '0')->get('class')->result_array();
        //var_dump('<pre>',$data['classes']);exit;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/ft_assessment',$data);
            $this->load->view('footer',$data);
    }
    
     public function get_ft_assessment()
    {
        //var_dump('<pre>',$this->input->post());exit;
        $class=$this->input->post('class');
        $section=$this->input->post('section');
        $student=$this->input->post('student');
        $session_id=$this->input->post('session');
        
        $data=array(
        'student_id'=>$this->input->post('student'),
        'session_id'=>$session_id,
        'working_days'=>$this->input->post('twd'),
        'days_attended'=>$this->input->post('da'),
        'concepts_eng'=>$this->input->post('eone'),
        'recognition_eng'=>$this->input->post('etwo'),
        'writes_eng'=>$this->input->post('ethree'),
        'concepts_math'=>$this->input->post('mone'),
        'recognition_math'=>$this->input->post('mtwo'),
        'writes_math'=>$this->input->post('mthree'),
        'gk_questions'=>$this->input->post('gkone'),
        'islamic_knowledge'=>$this->input->post('gktwo'),
        'poem_nazam'=>$this->input->post('pnone'),
        'concepts_urdu'=>$this->input->post('uone'),
        'recognition_urdu'=>$this->input->post('utwo'),
        'writes_urdu'=>$this->input->post('uthree'),
        'coloring'=>$this->input->post('acone'),
        'cut_paste'=>$this->input->post('actwo'),
        'recognize_color'=>$this->input->post('acthree'),
        'masnoon_dua'=>$this->input->post('none'),
        'surah_akhlas'=>$this->input->post('ntwo'),
        'sensorial_concepts'=>$this->input->post('sone'),
        'class_discussion'=>$this->input->post('class_discussion'),
        'hw_presentation'=>$this->input->post('hw_presentation'),
        'peers_friends'=>$this->input->post('peers_friends'),
        'outdoor_activities'=>$this->input->post('outdoor_activities'),
        'regular_punctual'=>$this->input->post('regular'),
        'behaviour'=>$this->input->post('behave'),
        'uniform'=>$this->input->post('uniform')
            ); 
        // var_dump('<pre>',$data);exit;
        $this->db->select();
    	$this->db->from('ft_assessment');
    	$this->db->where('student_id',$student);
    	$this->db->where('session_id',$session_id);
    	$query = $this->db->get();
    	if($query->num_rows() > 0)
    			{
    			    $this->db->where('student_id',$student)->update('ft_assessment', $data);
    			}
    		else{
    		      $this->db->insert('ft_assessment', $data);
    		    }
        $data['class_name']=$this->db->where('class_id',$class)->get('class')->row()->class_name;
        $data['section_name']=$this->db->where('section_id',$section)->get('section')->row()->section_name;
        
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();
         
     $this->load->view('report/get_ft_assessment',$data);
        
    }
    
       public function check_ft_assessement_att($std)
    {
        $query=$this->db->select('count(id) as id')
    	              ->from('studentatt')
    	              ->where('student_id',$std)
    	              ->where('status_id',1)
    	              ->where('is_deleted',0)
    	              ->get()->row_array()['id'];
    	   if(!empty($query))  
    	   {
    	       echo $query;
    	   }else
    	   {
    	       echo 0;
    	   }
    
    }
    
      public function check_ft_assessement_data($std)
    {
        $this->db->select();
    	$this->db->from('ft_assessment');
    	$this->db->where('student_id',$std);
    	$query = $this->db->get();
    	//var_dump($query->num_rows());die;
       
    	if($query->num_rows() > 0)
    			{
    				$query=$this->db->select('*')
                     ->from('ft_assessment')
                     ->where('student_id',$std)
                     ->get()->row_array();
                    echo json_encode($query);
    			}
    		else{
    		      $data =  0;
    		    }
    }
     public function position_holder()
    {
            $this->user_model->check_permissions("Report/position_holder");
             $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $this->report_model->getBranch();
            $data['session'] = $this->report_model->getSessions();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/position_holder',$data);
            $this->load->view('footer',$data);
    }
    
     public function PositionWiseResultReport()
    {
        if($this->input->post())
        {
            $data['b_id']=$branch=$this->user_model->getBranch();
            $class=$this->input->post("class",true);
            
            $data['class_order']=$this->db->select('orderr')
                                          ->from('class')
                                          ->where('class_id',$class)
                                          ->get()->row_array()['orderr'];
                                          
            $data['classs']=$this->input->post("class",true);
            $data['exams']=$this->input->post("exam",true);
            
            $section=$this->input->post("section",true);
            
            $data['sections']=$section;
            $exam=$this->input->post("exam",true);
            $data['sessions'] =$session=$this->input->post("session",true);
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['student']=$this->report_model->PositionWiseExamStudents($branch,$class,$section,$exam);
            $data['b_header']= $this->report_model->BranchHeader();
            $data['class']= $this->report_model->ClassInfo($class);
            $data['section']= $this->report_model->SectionInfo($section);
            
            $data['session']= $this->report_model->SessionInfo($session);
            $data['exam']= $this->report_model->ExamInfo($exam);
            //var_dump($data['exam']);die;
            $this->load->view("report/PositionWiseResultReport",$data);
        }
    }
    
     public function bio_data($q="all",$p=1)
   {
       $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
       $data['status']=$this->report_model->getAllRecords('status',array('is_delete'=>0,'type'=>'Student', 'branch'=>$data['branchId']));


          $this->user_model->check_permissions("report/bio_data");
          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
         
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
            
        $q = urldecode($q);
        $p = $p<1?1:$p;
        $per_page = 20;
        $offset = ($p - 1) * $per_page;
          $sq1 = "";
        if($q!="all")
        {
            $sq1 .= "AND (student.grno like '%".$q."%' OR "; 
            $sq1 .= "student.student_name like '%".$q."%' OR ";
            $sq1 .= "student.father_name like '%".$q."%' OR ";
            $sq1 .= "student.father_contact like '%".$q."%' OR ";
            $sq1 .= "class.class_name like '%".$q."%' OR ";
            $sq1 .= "section.section_name like '%".$q."%' )";
        }

        $total = @$this->db->query("SELECT count(*) as total FROM `student` inner JOIN promotion ON promotion.student_id=student.id inner JOIN class ON promotion.class_id=class.class_id inner JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' AND student.status='0' AND promotion.is_active='1' $sq1 LIMIT $offset, $per_page")->result_array()[0]['total'];
        $query = $this->db->query("SELECT student.*,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' AND student.status='0' AND promotion.is_active='1' $sq1 LIMIT $offset,$per_page");

        
        $data['q'] = $q;
        $data['curr'] = $p;
        $data['searchq'] = $q;
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['student'] = $query->result_array();
        $data['end'] = ceil($total / $per_page);
            //calling  pages views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/bio_data',$data);


   }
    
     public function fetch_bio_data()
   {
      
        $branch=$this->input->post('branch');
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

        $cl=$this->input->post('class');
        $se=$this->input->post('section');
        $gender=$this->input->post('gender');
        $order_by=$this->input->post('order_by');
        $status=$this->input->post('status');
        
   
       if($order_by=="sid")
       {
           $query = $this->db->select('student.*,class.*,section.*,CAST(student.sid as SIGNED) AS casted_sid');
                    $this->db->from('student');
                    $this->db->join('promotion','student.id=promotion.student_id'); 
                    $this->db->join('class','class.class_id=promotion.class_id'); 
                    $this->db->join('section','section.section_id=promotion.section_id'); 
                    $this->db->where('promotion.is_active','1');
                    $this->db->where('promotion.is_delete','0');
                    $this->db->where('student.branch',$branch);
                    $this->db->where('student.is_delete','0');
                    $this->db->where('class.is_delete','0');
                      $this->db->where('student.status','0');
                    $this->db->where('section.is_delete','0');
                    if(!empty($cl))
                    $this->db->where('promotion.class_id',$cl);
                    if(!empty($se))
                    $this->db->where('promotion.section_id',$se);
                    if(!empty($gender))
                    $this->db->where('student.gender',$gender);
                    if(!empty($status))
                    $this->db->where('student.status',$status);
                    $this->db->order_by("casted_sid","ASC");
                    $this->db->group_by('student.id');
             $data['student'] = $query->get()->result_array(); 
       }else
       {
           $query = $this->db->select('student.*,class.*,section.*,CAST(student.grno as SIGNED) AS casted_grno');
                    $this->db->from('student');
                    $this->db->join('promotion','student.id=promotion.student_id'); 
                    $this->db->join('class','class.class_id=promotion.class_id'); 
                    $this->db->join('section','section.section_id=promotion.section_id'); 
                    $this->db->where('promotion.is_active','1');
                    $this->db->where('promotion.is_delete','0');
                    $this->db->where('student.branch',$branch);
                    $this->db->where('student.is_delete','0');
                    $this->db->where('class.is_delete','0');
                      $this->db->where('student.status','0');
                    $this->db->where('section.is_delete','0');
                    if(!empty($cl))
                    $this->db->where('promotion.class_id',$cl);
                    if(!empty($se))
                    $this->db->where('promotion.section_id',$se);
                    if(!empty($gender))
                    $this->db->where('student.gender',$gender);
                    if(!empty($status))
                    $this->db->where('student.status',$status);
                    $this->db->order_by("casted_grno","ASC");
                    $this->db->group_by('student.id');
             $data['student'] = $query->get()->result_array(); 
       }
                           
      $this->load->view('report/fetch_bio_data',$data);
   }
   
    public function studentatt_status()
    {
        $this->user_model->check_permissions("report/student_att_status");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->Student_model->getbranch()->result_array();
         }
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/att_statuswise',$data);
    }
    
        public function fetch_att_status()
    {

         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $startdate=date('Y-m-d',strtotime($this->input->post('datefrom')));
        $enddate=date('Y-m-d',strtotime($this->input->post('dateto')));
        //  $startdate =$this->input->post('datefrom', TRUE);
        //   $enddate =$this->input->post('dateto', TRUE);
          

         $class=$this->input->post('branch');
         $section=$this->input->post('section');
         $data['section'] = $section;
         $data['startdate']=$startdate;
          $data['enddate']=$enddate;
          $status=$this->input->post('status');
      $branch=$this->user_model->getbranch();
    //  var_dump('<pre>',$class,$section,$startdate,$enddate,$branch,$status);die();
      $data['month']=$this->input->post('month');
         $data['student']=$this->db->query(" 
         SELECT  promotion.id,section.section_name,class.class_name,attendancestatus.status,studentatt.date,student.student_name, student.sid,student.father_name
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id 
         INNER JOIN student on student.id=studentatt.student_id 
         
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND studentatt.date>='$startdate' 
         AND studentatt.date<='$enddate' 
         AND section.section_id='$section' 
          AND studentatt.status_id='$status'
         AND class.class_id='$class' 
         ")->result_array();
                // var_dump( $data['student']);die();
        if($section){
             $data['student']=$this->db->query(" 
         SELECT  promotion.id,section.section_name,class.class_name,attendancestatus.status,studentatt.date,student.student_name, student.sid,student.father_name
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id 
         INNER JOIN student on student.id=studentatt.student_id 
         
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND studentatt.date>='$startdate' 
         AND studentatt.date<='$enddate' 
         AND section.section_id='$section' 
          
         AND class.class_id='$class' 
         ")->result_array();
            
        }           
         if($class){
             $data['student']=$this->db->query(" 
         SELECT  promotion.id,section.section_name,class.class_name,attendancestatus.status,studentatt.date,student.student_name, student.sid,student.father_name
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id 
         INNER JOIN student on student.id=studentatt.student_id 
         
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
          AND studentatt.date>='$startdate' 
         AND studentatt.date<='$enddate' 
      
         AND class.class_id='$class' 
         ")->result_array();
            
        }           
         if($status){
             $data['student']=$this->db->query(" 
         SELECT  promotion.id,section.section_name,class.class_name,attendancestatus.status,studentatt.date,student.student_name, student.sid,student.father_name
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id 
         INNER JOIN student on student.id=studentatt.student_id 
         
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND studentatt.date>='$startdate' 
         AND studentatt.date<='$enddate' 
       AND studentatt.status_id='$status'
         AND class.class_id='$class'
         
         ")->result_array();
            
        }           
          if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/studentatt_status", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/fetch_studentatt_statuswise',$data);
           }
    }
    
    
   
    public function staff_monthly()
    {
       $this->user_model->check_permissions("report/staff_monthly");
     // var_dump('hello'); die();
        $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
         if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
         
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/staff_monthly_report',$data);
    }
     public function fetch_staff_month() 
    {
         $branch=$this->input->post('branch');
         $staff=$this->input->post('staff');
         $month=$this->input->post('bdaymonth');
         $data['branch_name']=$this->report_model->getBranch()[0]['name'];
         $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

        $data['staff']=$this->db->query("SELECT staff.id, staff.firstname,staff.cnic,staff.doj,staff.contact,staff.designation,staff.lastname,staffatt.date,attendancestatus.status 
              FROM `staffatt` INNER JOIN staff on staff.id=staffatt.staff_id 
               INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
              where staff.branch='$branch' and staffatt.is_deleted=0 and staff.id='$staff' group by staff.id")->result_array();

        foreach ($data['staff'] as $key => $stafff) {
            
            $data['staff'][$key]['dates'] = $this->db->query("SELECT staffatt.date,attendancestatus.status FROM staffatt INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id  WHERE staffatt.staff_id = '$stafff[id]' AND LEFT(staffatt.date,7)='$month'")->result_array(); 
        }
        
//      var_dump($branch);die;
        $data['absnt']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
         and staff_id='$staff'
         and attendancestatus.id=2
          AND staff.branch='$branch'
         AND left(staffatt.date,7)='$month' 
         ")->result_array();

        $data['present']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id 
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id='$staff'
         and attendancestatus.id=1
         AND staff.branch='$branch'
         AND left(staffatt.date,7)='$month' 
         ")->result_array();

        $data['leave']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id='$staff'
         and attendancestatus.id=3
         AND staff.branch='$branch'
         AND left(staffatt.date,7)='$month' 
         ")->result_array();
         
          $data['s_leave']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id='$staff'
         and attendancestatus.id=4
         AND staff.branch='$branch'
         AND left(staffatt.date,7)='$month' 
         ")->result_array();
         
        $data['month'] = $month;
//echo "<pre>";print_r($data);exit;

                       // var_dump($data['student']);
                      //  die();
                          
          if(empty($data['staff']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/staff_monthly", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/display_staffatt',$data);
           }
    }
   
    public function teacher_monthly()
    {
       $this->user_model->check_permissions("report/teacher_monthly");
     // var_dump('hello'); die();
     $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
         
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/teacher_monthly_report',$data);
    }
    
    public function fetch_teacher_month() 
    {
       $branch=$this->input->post('branch');
         $data['branch_name']=$this->report_model->getBranch()[0]['name'];
         $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
        $type=$this->input->post('type');
         $teacher=$this->input->post('teacher');
        
         $month=$this->input->post('bdaymonth');
        
        //  var_dump($type);die;
         if($type=='teacher'){
             if(!empty($teacher)){
                 $data['teacher']=$this->db->query("SELECT teacher.id, teacher.firstname,teacher.cnic,teacher.doj,teacher.contact,teacher.designation,teacher.lastname,teacherattendance.date,leave_types.name as st_name 
              FROM `teacherattendance` INNER JOIN teacher on teacher.id=teacherattendance.teacher_id 
               INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
              where teacher.branch='$branch' and leave_types.branch='$branch' and teacherattendance.is_deleted=0 and teacher.id='$teacher' group by teacher.id")->result_array();
             }else{
                 $data['teacher']=$this->db->query("SELECT teacher.id, teacher.firstname,teacher.cnic,teacher.doj,teacher.contact,teacher.designation,teacher.lastname,teacherattendance.date,leave_types.name as st_name 
              FROM `teacherattendance` INNER JOIN teacher on teacher.id=teacherattendance.teacher_id 
               INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
              where teacher.branch='$branch' and teacher.is_delete=0 and teacher.status=0 and leave_types.branch='$branch' and teacherattendance.is_deleted=0 group by teacher.id")->result_array();
             }
        
            // echo "<pre>";print_r($this->db->last_query());exit;
            //  var_dump($data['teacher']); die();

        foreach ($data['teacher'] as $key => $teachers) {
            
            $data['teacher'][$key]['dates'] = $this->db->query("SELECT teacherattendance.date,leave_types.name as st_name FROM teacherattendance INNER JOIN leave_types on leave_types.id=teacherattendance.status_id  WHERE teacherattendance.teacher_id = '$teachers[id]' AND LEFT(teacherattendance.date,7)='$month' and leave_types.branch='$branch' order by teacherattendance.date ASC")->result_array(); 
        
            //var_dump('<pre>',$data['teacher'][$key]['dates']);
            // echo "<br>";
             //echo "Testing";
        }
         //var_dump($teacher);
        // die();

        
        $data['absnt']=$this->db->query(" 
         SELECT teacher_id
         FROM `teacherattendance` 
         INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
         INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
         WHERE teacherattendance.is_deleted=0 
         and teacher_id='$teacher'
         and leave_types.name='A'
         AND teacher.branch='$branch'
         AND leave_types.branch='$branch'
         AND left(teacherattendance.date,7)='$month' 
         ")->result_array();
        //  var_dump($data['absnt']); die();

        $data['present']=$this->db->query(" 
         SELECT teacher_id
         FROM `teacherattendance` 
         INNER JOIN leave_types on leave_types.id=teacherattendance.status_id 
         INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
         WHERE teacherattendance.is_deleted=0 
         and teacher_id='$teacher'
         and leave_types.name='P'
         AND teacher.branch='$branch'
         AND leave_types.branch='$branch'
         AND left(teacherattendance.date,7)='$month' 
         ")->result_array();
              //var_dump($data['present']); die();

        
         }
         if($type=='staff'){
             
               if(!empty($teacher)){
                   $data['teacher']=$this->db->query("SELECT staff.id, staff.firstname,staff.cnic,staff.doj,staff.contact,staff.designation,staff.lastname,staffatt.date,leave_types.name as st_name 
                     FROM `staffatt` INNER JOIN staff on staff.id=staffatt.staff_id 
                     INNER JOIN leave_types on leave_types.id=staffatt.status_id
                     where staff.branch='$branch' AND leave_types.branch='$branch' and staffatt.is_deleted=0 and staff.id='$teacher' group by staff.id")->result_array();
               }else{
                   $data['teacher']=$this->db->query("SELECT staff.id, staff.firstname,staff.cnic,staff.doj,staff.contact,staff.designation,staff.lastname,staffatt.date,leave_types.name as st_name 
                    FROM `staffatt` INNER JOIN staff on staff.id=staffatt.staff_id 
                    INNER JOIN leave_types on leave_types.id=staffatt.status_id
                    where staff.branch='$branch' and staff.is_delete=0 and staff.status=0 AND leave_types.branch='$branch' and staffatt.is_deleted=0  group by staff.id")->result_array();
               }
              

        foreach ($data['teacher'] as $key => $stafff) {
            
            $data['teacher'][$key]['dates'] = $this->db->query("SELECT staffatt.date,leave_types.name as st_name FROM staffatt INNER JOIN leave_types on leave_types.id=staffatt.status_id  WHERE staffatt.staff_id = '$stafff[id]' AND LEFT(staffatt.date,7)='$month' AND leave_types.branch='$branch'")->result_array(); 
        }
        
//      var_dump($branch);die;
        $data['absnt']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN leave_types on leave_types.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
         and staff_id='$teacher'
         and leave_types.name='A'
          AND staff.branch='$branch'
          AND leave_types.branch='$branch'
         AND left(staffatt.date,7)='$month' 
         ")->result_array();

        $data['present']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN leave_types on leave_types.id=staffatt.status_id 
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id='$teacher'
         and leave_types.name='P'
         AND staff.branch='$branch'
         AND leave_types.branch='$branch'
         AND left(staffatt.date,7)='$month' 
         ")->result_array();

       
         }
             
         
        $data['month'] = $month;
                          
          if(empty($data['teacher']))
           {
                $this->session->set_flashdata('msg','Record Not Found');
                redirect("Report/teacher_monthly", "refresh");
           }else{
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                $this->load->view('report/display_teacheratt',$data);
           }
    }
    
     public function teacher_report()
    {
      // $this->user_model->check_permissions("student/studentatt_add");
     // var_dump('hello'); die();
     $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
         $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/teacher_report',$data);
    }
    
    public function fetch_teacher_report()
    
      {
        	$branch=$this->input->post('branch');
    	$data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];


         $type=$this->input->post('type');
         $teacher=$this->input->post('teacher');
         $month=$this->input->post('bdaymonth');
         $session=$this->input->post('session');
         $start_month = $this->db->select('month')->where('id',$session)->get('session')->row()->month;
         //echo "<pre>";print_r($start_month);exit;
      
         if($type=='teacher'){
      
        $data['teacher']=$this->db->query("SELECT teacher.id, teacher.firstname,teacher.cnic,teacher.doj,teacher.contact,teacher.designation,teacher.lastname,teacherattendance.date,leave_types.name as status 
              FROM `teacherattendance` INNER JOIN teacher on teacher.id=teacherattendance.teacher_id 
               INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
              where teacher.branch='$branch' and leave_types.branch='$branch' and teacherattendance.is_deleted=0 and teacher.id='$teacher'")->result_array();
        //  echo "<pre>";print_r($data['teacher']);exit;
      
            foreach ($data['teacher'] as $key => $teach) {
                $month = date('Y-m',strtotime($teach['date']));
                //  echo "<pre>";print_r($month);exit;
                $data['attn'][$month] = $this->db->query("SELECT teacherattendance.date,leave_types.name as status FROM teacherattendance INNER JOIN leave_types on leave_types.id=teacherattendance.status_id  WHERE teacherattendance.teacher_id = '$teach[id]' AND LEFT(teacherattendance.date,7)='$month'")->result_array(); 
        }
        
         //echo "<pre>";print_r($data['attn']);exit;
      
     
        $data['absnt']=$this->db->query(" 
         SELECT teacher_id
         FROM `teacherattendance` 
         INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
         INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
         WHERE teacherattendance.is_deleted=0 
         and teacher_id=$teacher
         and leave_types.name='A'
         AND teacher.branch='$branch'
         AND leave_types.branch='$branch'
         AND left(teacherattendance.date,7)>='$start_month' 
         ")->result_array();

        $data['present']=$this->db->query(" 
         SELECT teacher_id
         FROM `teacherattendance` 
         INNER JOIN leave_types on leave_types.id=teacherattendance.status_id 
         INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
         WHERE teacherattendance.is_deleted=0 
         and teacher_id=$teacher
         and leave_types.name='P'
         AND teacher.branch='$branch'
         AND leave_types.branch='$branch'
         AND left(teacherattendance.date,7)>='$start_month' 
         ")->result_array();

        // $data['leave']=$this->db->query(" 
        //  SELECT teacher_id
        //  FROM `teacherattendance` 
        //  INNER JOIN attendancestatus on attendancestatus.id=teacherattendance.status_id
        //  INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
        //  WHERE teacherattendance.is_deleted=0 
        //   and teacher_id=$teacher
        //  and attendancestatus.id=3
        //  AND teacher.branch='$branch'
        //  AND left(teacherattendance.date,7)>='$start_month' 
        //  ")->result_array();
         
        //  $data['s_leave']=$this->db->query(" 
        //  SELECT teacher_id
        //  FROM `teacherattendance` 
        //  INNER JOIN attendancestatus on attendancestatus.id=teacherattendance.status_id
        //  INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
        //  WHERE teacherattendance.is_deleted=0 
        //   and teacher_id=$teacher
        //  and attendancestatus.id=4
        //  AND teacher.branch='$branch'
        //  AND left(teacherattendance.date,7)>='$start_month' 
        //  ")->result_array();
}
         if($type=='staff'){
              $data['teacher']=$this->db->query("SELECT staff.id, staff.firstname,staff.cnic,staff.doj,staff.contact,staff.designation,staff.lastname,staffatt.date,leave_types.name as status 
              FROM `staffatt` INNER JOIN staff on staff.id=staffatt.staff_id 
               INNER JOIN leave_types on leave_types.id=staffatt.status_id
              where staff.branch='$branch' and leave_types.branch='$branch' and staffatt.is_deleted=0 and staff.id='$teacher'")->result_array();
        //  echo "<pre>";print_r($data['staff']);exit;
      
            foreach ($data['teacher'] as $key => $teach) {
                $month = date('Y-m',strtotime($teach['date']));
                //  echo "<pre>";print_r($month);exit;
                $data['attn'][$month] = $this->db->query("SELECT staffatt.date,leave_types.name as status FROM staffatt INNER JOIN leave_types on leave_types.id=staffatt.status_id  WHERE staffatt.staff_id = '$teach[id]' AND LEFT(staffatt.date,7)='$month'")->result_array(); 
        }
        
        //  echo "<pre>";print_r($data['attn']);exit;
      
     
        $data['absnt']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN leave_types on leave_types.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
         and staff_id=$teacher
         and leave_types.name='A'
         AND staff.branch='$branch'
         AND leave_types.branch='$branch'
         AND left(staffatt.date,7)>='$start_month' 
         ")->result_array();

        $data['present']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN leave_types on leave_types.id=staffatt.status_id 
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id=$teacher
         and leave_types.name='P'
         AND staff.branch='$branch'
         AND leave_types.branch='$branch'
         AND left(staffatt.date,7)>='$start_month' 
         ")->result_array();

        // $data['leave']=$this->db->query(" 
        //  SELECT staff_id
        //  FROM `staffatt` 
        //  INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
        //  INNER JOIN staff on staff.id=staffatt.staff_id
        //  WHERE staffatt.is_deleted=0 
        //   and staff_id=$teacher
        //  and attendancestatus.id=3
        //  AND staff.branch='$branch'
        //  AND left(staffatt.date,7)>='$start_month' 
        //  ")->result_array();
         
        //   $data['s_leave']=$this->db->query(" 
        //  SELECT staff_id
        //  FROM `staffatt` 
        //  INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
        //  INNER JOIN staff on staff.id=staffatt.staff_id
        //  WHERE staffatt.is_deleted=0 
        //   and staff_id=$teacher
        //  and attendancestatus.id=4
        //  AND staff.branch='$branch'
        //  AND left(staffatt.date,7)>='$start_month' 
        //  ")->result_array();
             
         }
        $data['month'] = $start_month;
//echo "<pre>";print_r($data['teacher']);exit;

                       // var_dump($data['student']);
                      //  die();
                          
          if(empty($data['teacher']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("report/teacher_report", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         //echo "<pre>";print_r($data);exit;
         $this->load->view('report/fetch_teacher_report',$data);
           }
    }
    
         public function staff_report()
    {
    //   $this->user_model->check_permissions("report/staff_report");
     // var_dump('hello'); die();
             $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
            
         $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/staff_report',$data);
    }
     public function fetch_staff_report()
    
      {
            	$branch=$this->input->post('branch');
    	$data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];

       
         $staff=$this->input->post('staff');
         $month=$this->input->post('bdaymonth');
         $session=$this->input->post('session');
         $start_month = $this->db->select('month')->where('id',$session)->get('session')->row()->month;
         //echo "<pre>";print_r($start_month);exit;
      

        $data['staff']=$this->db->query("SELECT staff.id, staff.firstname,staff.cnic,staff.doj,staff.contact,staff.designation,staff.lastname,staffatt.date,attendancestatus.status 
              FROM `staffatt` INNER JOIN staff on staff.id=staffatt.staff_id 
               INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
              where staff.branch='$branch' and staffatt.is_deleted=0 and staff.id='$staff'")->result_array();
        //  echo "<pre>";print_r($data['staff']);exit;
      
            foreach ($data['staff'] as $key => $teach) {
                $month = date('Y-m',strtotime($teach['date']));
                //  echo "<pre>";print_r($month);exit;
                $data['attn'][$month] = $this->db->query("SELECT staffatt.date,attendancestatus.status FROM staffatt INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id  WHERE staffatt.staff_id = '$teach[id]' AND LEFT(staffatt.date,7)='$month'")->result_array(); 
        }
        
        //  echo "<pre>";print_r($data['attn']);exit;
      
     
        $data['absnt']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
         and staff_id=$staff
         and attendancestatus.id=2
         AND staff.branch='$branch'
         AND left(staffatt.date,7)>='$start_month' 
         ")->result_array();

        $data['present']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id 
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id=$staff
         and attendancestatus.id=1
         AND staff.branch='$branch'
         AND left(staffatt.date,7)>='$start_month' 
         ")->result_array();

        $data['leave']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id=$staff
         and attendancestatus.id=3
         AND staff.branch='$branch'
         AND left(staffatt.date,7)>='$start_month' 
         ")->result_array();
         
          $data['s_leave']=$this->db->query(" 
         SELECT staff_id
         FROM `staffatt` 
         INNER JOIN attendancestatus on attendancestatus.id=staffatt.status_id
         INNER JOIN staff on staff.id=staffatt.staff_id
         WHERE staffatt.is_deleted=0 
          and staff_id=$staff
         and attendancestatus.id=4
         AND staff.branch='$branch'
         AND left(staffatt.date,7)>='$start_month' 
         ")->result_array();

        $data['month'] = $start_month;
//echo "<pre>";print_r($data['teacher']);exit;

                       // var_dump($data['student']);
                      //  die();
                          
          if(empty($data['staff']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("report/staff_report(", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         //echo "<pre>";print_r($data);exit;
         $this->load->view('report/fetch_staff_report',$data);
           }
    }
    
       public function grno_report()
        {
           // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
         $data['status']=$this->report_model->getAllRecords('status',array('is_delete'=>0,'type'=>'Student', 'branch'=>$data['branchId']));
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/defaulter_grno',$data);
       // $this->load->view('footer',$data);
        }   


        public function show_grno_report() 
        {
              $branch =$this->input->post('branch', TRUE);
          $class =$this->input->post('class', TRUE);
          $status =$this->input->post('status', TRUE);
          
           $data['from']=$this->input->post('from');
            $from=date('Y-m-d',strtotime($this->input->post('from')));
        
        $data['to']=$this->input->post('to');
         $to=date('Y-m-d',strtotime($this->input->post('to')));
         $to=$this->input->post('to');
          $this->session->set_userdata('from',$from);
         $this->session->set_userdata('to',$to);
         $nts =$from;
$datee = str_replace('/', '-', $nts);
$data['rev_frm']= date('Y-m-d', strtotime($datee));

$ntss =$to;
$datee2 = str_replace('/', '-',$ntss);
$data['rev_to']= date('Y-m-d', strtotime($datee2));
               
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

        if($this->user_model->is_super())
        {
            $data['branch']=$this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        }else{
            $data['branch']=$this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='".$branch."'")->result_array();
        }
        $query = $this->db->query("SELECT student.*,CAST(student.grno as SIGNED) AS casted_grno,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' AND student.status='0' AND promotion.is_active='1' order by trim(replace(casted_grno,'-','')) ASC");
        $data['student'] = $query->result_array();
        // var_dump($data['student']);die;
        //  $query = $this->db->query("SELECT student.*,CAST(student.grno as SIGNED) AS casted_grno,trim(replace(student.grno,'-','')) as t_grno,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch'  AND promotion.is_active='1' and student.grno like '02-%' order by (CAST(t_grno as SIGNED)) ASC ");
        if($class){
             $query = $this->db->query("SELECT student.*,CAST(student.grno as SIGNED) AS casted_grno,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' and class.class_id='$class'  AND promotion.is_active='1' order by trim(replace(casted_grno,'-','')) ASC");
      
        }
        if($status){
              $query = $this->db->query("SELECT student.*,CAST(student.grno as SIGNED) AS casted_grno,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$branch' and class.class_id='$class'  and student.status='$status' AND promotion.is_active='1' order by trim(replace(casted_grno,'-','')) ASC");
     
        }
       
        $data['student'] = $query->result_array();
        //   var_dump($data['student']);die;
        $this->load->view('report/student_report',$data);
    }
    
    //   public function student_report()
    // {
    //      $branch=$this->report_model->getBranch()[0];
    //     $data['branch_name']=$this->report_model->getBranch()[0]['name'];
    //     $data['b_header']= $this->report_model->BranchHeader();
    //     if($this->user_model->is_super())
    //     {
    //         $data['branch']=$this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
    //     }else{
    //         $data['branch']=$this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='".$this->branch."'")->result_array();
    //     }
    //     $b=$this->user_model->getBranch();
    //   /* $query = $this->db->query("SELECT student.*,CAST(student.grno as SIGNED) AS casted_grno,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$b' AND student.status='0' AND promotion.is_active='1' order by trim(replace(casted_grno,'-','')) ASC");
    //     $data['student'] = $query->result_array();*/
        
    //     $query = $this->db->query("SELECT student.*,CAST(student.grno as SIGNED) AS casted_grno,trim(replace(student.grno,'-','')) as t_grno,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$b' AND student.status='0' AND promotion.is_active='1' and student.grno like '02-%' order by (CAST(t_grno as SIGNED)) ASC ");
    //     $data['student'] = $query->result_array();
    //     $this->load->view('report/student_report',$data);
    // }
    



 public function print_custom_chart($id)
    {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        if($id==0)
        {
             $data['heads']=$this->db->query("SELECT * FROM `account_heads` where parent='0' and is_delete='0'")->result_array();
              $this->load->view('account/chartsprint',$data);
        }else
        {
             $data['heads']=$this->db->select('*')
                       ->from('account_heads')
                       ->where('id',$id)
                       ->get()->row_array();
                       $this->load->view('account/chartsprint2',$data);
        }
       // var_dump('<pre>',$data['heads']);
       // die();
       
        
    }
    
          public function salary_slips_report()
    {
          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/salary_slips",$data);
         $this->load->view('footer',$data);
    }
    
      public function print_salary_slip()
    {
        $branchid= $this->user_model->getBranch();
        $type=$this->input->post('type');
        $emp=$this->input->post('emp');
        $month=$this->input->post('month');
        
        $get_id=$this->db->select('*')
                      ->from('salary')
                      ->where('refrence',$type)
                      ->where('branch',$branchid)
                      ->where('month',$month)
                      ->where('bothid',$emp)
                      ->get()->result_array();
                if(empty($get_id))     
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }else
                {
                 
                 $ret=$this->db->select('*')
                      ->from('salary')
                      ->where('refrence',$type)
                      ->where('branch',$branchid)
                      ->where('month',$month)
                      ->where('bothid',$emp)
                      ->get()->row();
                   
                }
        // print_r($ret);
        // die();
       // $ret=$this->sm->id_('salary',$id,'id');
        $branch=$this->user_model->getbranch();
        $data['branch']=$this->sm->id_('branch',$branch,'id');
        $ref=$type;
        $data['stat']=$ret->is_paid;
        //var_dump($data['stat']);
       // die();
        $data['create_date']=$ret->create_date;
        $month=$ret->month;
        $data['sal_id']=$ret->id;
        $bothid=$ret->bothid;
        $data['bothid']=$bothid;
        $data['month']=$month;
        $data['refrence']=$ret->refrence;
        $data['invoice']=$ret->id;
       // var_dump('<pre>',$data['invoice']);
       // die();
        $data['employee']=$this->sm->emp_id($ref,$bothid);
        $data['allonce']=$this->sm->all('allonce');
        $data['assignallonce']=$this->sm->allallonce($ref);
       // $data['deduction_def']=$this->sm->all('deduction_def');
        //Add new
        $data['loan_def']=$this->sm->all('loan_def');
      
        //$data['deduction']=$this->sm->deduction_all($type,$month);
       $data['deduction_def']=$this->sm->all('deductions');

       $data['personal_exp']=$this->sm->all('personal_expense');
       //End
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->load->view("report/print_salary_slip",$data);
     
    }
    
      public function monthly_salary_report()
    {
       $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/saleryview",$data);
        //  $this->load->view('footer',$data);
    }
     
     public function salary_banksheet()
    {
       $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/banksheetview",$data);
        //  $this->load->view('footer',$data);
    }
    
   
     public function print_list()
    {
    
       if($this->input->post()){
            $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $field=$this->input->post();
        $type=$field['type'];
        $month=$field['month'];
        
        $d=$this->sm->get('salary',$month,$type);
        
        $date=date('Y-m');
        $current= date_parse($date);
        $sel=date_parse($month);
        $data['type']=$type;
        $data['month']=$month;
        $data['employee']=$this->sm->salary_emp_actdec($type,$month);
     
         
        $data['allonce']=$this->sm->all('allonce');
        $data['assignallonce']=$this->sm->allallonce($type);
        $data['deduction']=$this->sm->deduction_all($type,$month);
       // $data['deduction_def']=$this->sm->all('deduction_def');
       $data['loan_def']=$this->sm->all('loan_def');
      
        $data['deduction_def']=$this->sm->all('deductions');
         $data['personal_exp']=$this->sm->all('personal_expense');
        //  echo "<pre>";print_r($data['personal_exp']);exit;

        $this->load->view("report/printt_list",$data);
      

       }
     
    }
    
    
    
      public function print_listt()
    {
    
       if($this->input->post()){
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $field=$this->input->post();
       $type=$field['type'];
        $month=$field['month'];
        
        $d=$this->sm->get('salary',$month,$type);
        
        $date=date('Y-m');
        $current= date_parse($date);
        $sel=date_parse($month);
        $data['type']=$type;
        $data['month']=$month;
        //$data['employee']=$this->sm->salary_emp($type,$month);
        $data['employee']=$this->sm->salary_emp_actdec($type,$month);
         
        $data['allonce']=$this->sm->all('allonce');
        $data['assignallonce']=$this->sm->allallonce($type);
        $data['deduction']=$this->sm->deduction_all($type,$month);
        $data['increment']=$this->sm->increment_all($type,$month);
       $data['loan_def']=$this->sm->all('loan_def');
        $data['deduction_def']=$this->sm->all('deductions');
         $data['personal_exp']=$this->sm->all('personal_expense');

        $this->load->view("report/printt_listt",$data);
      

       }
     
    }
    
   public function Increments_report()
    {
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/summary_slips_increments",$data);
         $this->load->view('footer',$data);
    }
    
       public function print_summary_slip_increments()
    {
        $branchid= $this->user_model->getBranch();
        $type=$this->input->post('type');
        $emp=$this->input->post('emp');
        $year=$this->input->post('year');
        $month=$this->input->post('month');
       if(!empty($type) && !empty($emp) && !empty($year) && !empty($month))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
           $mymonth=substr($month,5);
               $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                           $this->db->where('refrence',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                  $data['alow']=$this->db->get()->result_array();

                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_increment",$data); 
                 }
                 else
                {
                    
                    echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                         $this->db->where('refrence',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_increment",$data); 
                 }
                 else
                {
                     echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($emp) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

          $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                                 $this->db->where('refrence',$type)
                                 ->where_in('bothid',$emp)
                                 ->where('month',$month);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_increment",$data); 
                 }
            else
                {
                     echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                }
       }elseif(!empty($type) && !empty($year) && !empty($month))
       {
          $mymonth=substr($month,5);
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

      $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                             $this->db->where('refrence',$type)
                             ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_increment",$data); 
                 }
                 else
                {
                     echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('refrence',$type)
                               ->where_in('bothid',$emp);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_increment",$data);  
                 }
                 else
                {
                     echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('refrence',$type)
                               ->where('left(month,4)',$year);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_increment",$data);   
                 }
            else
                {
                     echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                              $this->db->where('refrence',$type)
                               ->where('month',$month);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_increment",$data);   
                 }
                 else
                {
                   echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

      $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                         $this->db->where('refrence',$type)
                               ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_increment",$data);  
                 }
                 else
                {
                     echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && empty($emp) && empty($year)){
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                       ->from('increments');
                        if($type=="teacher"){
                         $this->db->join('teacher','increments.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','increments.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                          $this->db->where('refrence',$type);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_increment",$data);  
                }
                else
                {
                      echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                } 
       }
        
    }
    
        public function Allowances_report()
    {
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/summary_slips_allowance",$data);
         $this->load->view('footer',$data);
    }
    
     public function print_summary_slip_allowance()
    {
        $branchid= $this->user_model->getBranch();
        $type=$this->input->post('type');
        $emp=$this->input->post('emp');
        $year=$this->input->post('year');
        $month=$this->input->post('month');
       if(!empty($type) && !empty($emp) && !empty($year) && !empty($month))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
           $mymonth=substr($month,5);
       $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('refrence',$type)
                    ->where_in('bothid',$emp)
                    ->where('left(month,4)',$year)
                    ->where('RIGHT(month,2)',$mymonth);
               $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$data['alow']);
               // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_allowance",$data); 
                }else
                {
                  echo "<script>alert('Record Not Found');</script>";
                  echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('refrence',$type)
                    ->where_in('bothid',$emp)
                    ->where('left(month,4)',$year);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_allowance",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; 
                     echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($emp) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

            $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('refrence',$type)
                              ->where_in('bothid',$emp)
                              ->where('month',$month);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_allowance",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>";
                     echo "<script>window.close();</script>";
                }
       }elseif(!empty($type) && !empty($year) && !empty($month))
       {
          $mymonth=substr($month,5);
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('refrence',$type)
                              ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_allowance",$data); 
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; 
                   echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                              $this->db ->where('refrence',$type)
                               ->where_in('bothid',$emp);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_allowance",$data);  
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; 
                     echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

          $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                              $this->db ->where('refrence',$type)
                               ->where('left(month,4)',$year);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_allowance",$data);   
                }else
                {
                    echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

           $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('refrence',$type)
                               ->where('month',$month);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_allowance",$data);   
                }else
                {
                  echo "<script>alert('Record Not Found');</script>"; 
                  echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('refrence',$type)
                               ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_allowance",$data);  
                }else
                {
                    echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && empty($emp) && empty($year)){
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

          $this->db->select('*')
                    ->from('assign_allowance');
                     if($type=="teacher"){
                         $this->db->join('teacher','assign_allowance.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','assign_allowance.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('refrence',$type);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_allowance",$data);  
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; 
                    echo "<script>window.close();</script>";
                } 
       }
        
    }
    
    
     public function deductions_report()
    {
       
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
      //   echo "jhsfd";
        //die();
        $this->load->view("report/summary_slips_deductions",$data);
         $this->load->view('footer',$data);
    }
    
     public function print_summary_slip_dedcutions()
    {
        $branchid= $this->user_model->getBranch();
        $type=$this->input->post('type');
       $emp=$this->input->post('emp');
        $year=$this->input->post('year');
       $month=$this->input->post('month');
       if(!empty($type) && !empty($emp) && !empty($year) && !empty($month))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
   $mymonth=substr($month,5);
                 
       $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                 $this->db->where('refrence',$type)
                    ->where_in('bothid',$emp)
                    ->where('left(month,4)',$year)
                   ->where('RIGHT(month,2)',$mymonth);
              $data['dedu']=$this->db->get()->result_array();
             
                //  var_dump('<pre>',$data['dedu']);
                //  die();
                if(!empty($data['dedu'])) 
                {
                     $this->load->view("report/print_allemp_deductions",$data); 
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                }
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('refrence',$type)
                    ->where_in('bothid',$emp)
                    ->where('left(month,4)',$year);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                     $this->load->view("report/print_allemp_deductions",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                }
       }
        elseif(!empty($type) && !empty($emp) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                  $this->db->where('refrence',$type)
                              ->where_in('bothid',$emp)
                              ->where('month',$month);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                     $this->load->view("report/print_allemp_deductions",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                }
       }elseif(!empty($type) && !empty($year) && !empty($month))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
       $mymonth=substr($month,5);
              
            
        $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('refrence',$type)
                              ->where('left(month,4)',$year)
                               ->where('RIGHT(month,2)',$mymonth);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                     $this->load->view("report/print_allemp_deductions",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                }
       }
       elseif(!empty($type) && !empty($emp))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                       $this->db->where('refrence',$type)
                               ->where_in('bothid',$emp);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                     $this->load->view("report/print_allemp_deductions",$data);  
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                } 
       }
       elseif(!empty($type) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('refrence',$type)
                               ->where('left(month,4)',$year);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                      $this->load->view("report/print_allemp_deductions",$data);   
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; ;
                }
       }
        elseif(!empty($type) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('refrence',$type)
                               ->where('month',$month);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                      $this->load->view("report/print_allemp_deductions",$data);   
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                } 
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('refrence',$type)
                               ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                     $this->load->view("report/print_allemp_deductions",$data);  
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                } 
       }
       elseif(!empty($type) && empty($emp) && empty($year)){
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('*')
                    ->from('deductions_assigned');
                    if($type=="teacher"){
                         $this->db->join('teacher','deductions_assigned.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','deductions_assigned.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                     $this->db->where('refrence',$type);
                  $data['dedu']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['dedu'])) 
                {
                     $this->load->view("report/print_allemp_deductions",$data);  
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>"; 
                } 
       }
        
    }
    
public function advances_report()
    {
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/summary_slips",$data);
         $this->load->view('footer',$data);
    }
    
     public function print_summary_slip()
    {
        $branchid= $this->user_model->getBranch();
        $type=$this->input->post('type');
       $emp=$this->input->post('emp');

        $year=$this->input->post('year');
       $month=$this->input->post('month');
       if(!empty($type) && !empty($emp) && !empty($year) && !empty($month))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
 
                  $mymonth=substr($month,5);
       $data['advnc']=$this->db->select('*')
                    ->from('advance')
                     ->where('branch',$branchid)
                    ->where('type',$type)
                    ->where_in('bothid',$emp)
                    ->where('left(month,4)',$year)
                   ->where('RIGHT(month,2)',$mymonth)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                     $this->load->view("report/print_allemp_advnce",$data); 
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                    ->where_in('bothid',$emp)
                    ->where('left(month,4)',$year)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                     $this->load->view("report/print_allemp_advnce",$data); 
                }else
                {
                  echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($emp) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                    ->where_in('bothid',$emp)
                    ->where('month',$month)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                     $this->load->view("report/print_allemp_advnce",$data); 
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; 
                    echo "<script>window.close();</script>";
                }
       }elseif(!empty($type) && !empty($year) && !empty($month))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
   $mymonth=substr($month,5);
               
       $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                     ->where('left(month,4)',$year)
                     ->where('RIGHT(month,2)',$mymonth)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                     $this->load->view("report/print_allemp_advnce",$data); 
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; 
                    echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                    ->where_in('bothid',$emp)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                     $this->load->view("report/print_emp_all_advnce",$data);  
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                    ->where('left(month,4)',$year)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                      $this->load->view("report/print_allemp_advnce",$data);   
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                    ->where('month',$month)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                      $this->load->view("report/print_allemp_advnce",$data);   
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                    ->where_in('bothid',$emp)
                    ->where('left(month,4)',$year)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                     $this->load->view("report/print_emp_all_advnce",$data);  
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && empty($emp) && empty($year)){
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $data['advnc']=$this->db->select('*')
                    ->from('advance')
                    ->where('branch',$branchid)
                    ->where('type',$type)
                    ->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['advnc'])) 
                {
                     $this->load->view("report/print_allemp_advnce",$data);  
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
        
    }
    
  public function loan_report()
    {
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/summary_slips_loan",$data);
         $this->load->view('footer',$data);
    }
    
     public function print_summary_slip_loan()
    {
        $branchid= $this->user_model->getBranch();
        $type=$this->input->post('type');
        $emp=$this->input->post('emp');
        $year=$this->input->post('year');
        $month=$this->input->post('month');
       if(!empty($type) && !empty($emp) && !empty($year) && !empty($month))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
           $mymonth=substr($month,5);
           
       $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                        $this->db->where('loan_assign.type',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                             $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$data['alow']);
               // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_loan",$data); 
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('loan_assign.type',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                              $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_loan",$data); 
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($emp) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('loan_assign.type',$type)
                                 ->where_in('bothid',$emp)
                                 ->where('month',$month);
                                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_loan",$data); 
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }elseif(!empty($type) && !empty($year) && !empty($month))
       {
          $mymonth=substr($month,5);
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

      $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                        $this->db->where('loan_assign.type',$type)
                              
                             ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                     $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_loan",$data); 
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('loan_assign.type',$type)
                                       ->where_in('bothid',$emp);
                               $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_loan",$data);  
                }else
                {
                  echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                    $this->db->where('loan_assign.type',$type)
                              
                               ->where('left(month,4)',$year);
                     $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_loan",$data);   
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('loan_assign.type',$type)
                                       ->where('month',$month);
                               $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_loan",$data);   
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

      $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('loan_assign.type',$type)
                               ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                             $data['alow']= $this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_loan",$data);  
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && empty($emp) && empty($year)){
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('loan_assign.*')
                              ->from('loan_assign');
                             if($type=="teacher"){
                                 $this->db->join('teacher','loan_assign.bothid=teacher.id')
                                          ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','loan_assign.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                               $this->db->where('loan_assign.type',$type);
                               
                               
                        $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_loan",$data);  
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
        
    }
    
    public function print_summary_security()
    {
        $data['type']=$type=$this->input->post('type');
        $data['emp']=$emp=$this->input->post('emp');
       
        $data['branch']=$branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
       
        $data['salarys']=$this->db->select('*')
                                 ->from('salary')
                                 ->where('refrence',$type)
                                 ->where('bothid',$emp)
                                 ->where('is_delete',0)
                                 ->get()->result_array();
                                 echo $this->db->last_query();
        // die;
        if(!empty($data['salarys'])) 
                {
                     $this->load->view("report/print_allemp_security",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                    
                }
    }
    
    public function print_deduction_summary()
    {
        $data['type']=$type=$this->input->post('type');
        $data['emp']=$emp=$this->input->post('emp');
         $data['tdate']=$emp=$this->input->post('tdate');
       
        $data['branch']=$branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
       
        
         $mymonth=substr($data['tdate'],5);
                 
       $this->db->select('*');
                    if($type=="teacher"){
                         $this->db->from('teacher')
                                  ->where('teacher.branch',$branch['id'])
                                  ;
                             }           
                              if($type=="staff"){ 
                              $this->db->from('staff')
                                         ->where('staff.branch',$branch['id']);
                              }
                    
              $data['employee']=$this->db->get()->result_array();
      
      $data['deduction']=$this->db->where('branch',$branch['id'])->where('is_delete',0)->from('deductions')->get()->result();
      
                               //  echo $this->db->last_query();
         //die;
        if(!empty($data['employee'])) 
                {
                     $this->load->view("report/print_allemp_deduction",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                    
                }
    }
    
    
     public function days_report()
    {
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/summary_slips_days",$data);
         $this->load->view('footer',$data);
    }
    
     public function print_summary_slip_days()
    {
        $branchid= $this->user_model->getBranch();
        $type=$this->input->post('type');
        $emp=$this->input->post('emp');
        $year=$this->input->post('year');
        $month=$this->input->post('month');
       if(!empty($type) && !empty($emp) && !empty($year) && !empty($month))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
           $mymonth=substr($month,5);
           $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                              if($type=="staff"){ 
                              $this->db->join('staff','days_deduction.bothid=staff.id')
                                         ->where('staff.branch',$branchid);
                              }
                      $this->db->where('type',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                 $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$data['alow']);
               // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_emp_all_days",$data); 
                }else
                {
                      echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                    $this->db->where('type',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                 $data['alow']=$this->db->get()->result_array();

                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_emp_all_days",$data); 
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($emp) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                           $this->db->where('type',$type)
                                 ->where_in('bothid',$emp)
                                 ->where('month',$month);
                         $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_emp_all_days",$data); 
                }else
                {
                      echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }elseif(!empty($type) && !empty($year) && !empty($month))
       {
          $mymonth=substr($month,5);
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

      $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                        $this->db->where('type',$type)
                             ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                  $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_days",$data); 
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                        $this->db->where('type',$type)
                               ->where_in('bothid',$emp);
              $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_emp_all_days",$data);  
                }else
                {
                      echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                       $this->db->where('type',$type)
                               ->where('left(month,4)',$year);
                         $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_days",$data);   
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                    $this->db->where('type',$type)
                               ->where('month',$month);
                         $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_days",$data);   
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

      $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                        $this->db->where('type',$type)
                               ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                     $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_emp_all_days",$data);  
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && empty($emp) && empty($year)){
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('days_deduction.*')
                    ->from('days_deduction');
                         if($type=="teacher"){
                         $this->db->join('teacher','days_deduction.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','days_deduction.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                      $this->db->where('type',$type);
                      $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_days",$data);  
                }else
                {
                   echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
        
    }
    
     public function expense_report()
    {
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/summary_slips_expense",$data);
         $this->load->view('footer',$data);
    }
    
    public function print_summary_slip_expense()
    {
        $branchid= $this->user_model->getBranch();
     
        $type=$this->input->post('type');
        $emp=$this->input->post('emp');
        $year=$this->input->post('year');
        $month=$this->input->post('month');
       if(!empty($type) && !empty($emp) && !empty($year) && !empty($month))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
           $mymonth=substr($month,5);
       $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                          $this->db->where('refrence',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$data['alow']);
               // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_expense",$data); 
                }else
                {
                    
                    echo "<script>alert('Record Not Found');</script>"; 
                    echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                        $this->db->where('refrence',$type)
                              ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_expense",$data); 
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($emp) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

           $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                             
                         $this->db->where('refrence',$type)
                                 ->where_in('bothid',$emp)
                                 ->where('month',$month);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_expense",$data); 
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }elseif(!empty($type) && !empty($year) && !empty($month))
       {
          $mymonth=substr($month,5);
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                            
                         $this->db->where('refrence',$type)
                             ->where('left(month,4)',$year)
                              ->where('RIGHT(month,2)',$mymonth);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_expense",$data); 
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
       elseif(!empty($type) && !empty($emp))
       {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                       $this->db->where('refrence',$type)
                               ->where_in('bothid',$emp);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_expense",$data);  
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($year))
       {
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                         $this->db->where('refrence',$type)
                               ->where('left(month,4)',$year);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_expense",$data);   
                }else
                {
                    echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                }
       }
        elseif(!empty($type) && !empty($month))
       {
           $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

          $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                             
                             $this->db->where('refrence',$type)
                               ->where('month',$month);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                      $this->load->view("report/print_allemp_expense",$data);   
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && !empty($emp) && !empty($year))
       {
             $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

       $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                            
                           $this->db->where('refrence',$type)
                               ->where_in('bothid',$emp)
                              ->where('left(month,4)',$year);
                    $data['alow']=$this->db->get()->result_array();
                // var_dump('<pre>',$advnc);
                // die();
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_expense",$data);  
                }else
                {
                    echo "<script>alert('Record Not Found');</script>";
                    echo "<script>window.close();</script>";
                } 
       }
       elseif(!empty($type) && empty($emp) && empty($year)){
          
            $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $this->db->select('expense_assign.*')
                              ->from('expense_assign');
                     if($type=="teacher"){
                         $this->db->join('teacher','expense_assign.bothid=teacher.id')
                                  ->where('teacher.branch',$branchid);
                             }           
                      if($type=="staff"){ 
                      $this->db->join('staff','expense_assign.bothid=staff.id')
                                 ->where('staff.branch',$branchid);
                      }
                           $this->db->where('refrence',$type);
                    $data['alow']=$this->db->get()->result_array();
               
                if(!empty($data['alow'])) 
                {
                     $this->load->view("report/print_allemp_expense",$data);  
                }else
                {
                     echo "<script>alert('Record Not Found');</script>"; echo "<script>window.close();</script>";
                } 
       }
        
    }
    
    public function index()
    {
            $this->user_model->check_permissions("Report/index");
             $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $this->report_model->getBranch();
            $data['session'] = $this->report_model->getSessions();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/index',$data);
            $this->load->view('footer',$data);
    }
  public function AllStudentRecords1()
    { 
	//print_r("hi"); die();
			$this->load->model("generic_model");
            $this->user_model->check_permissions("Report/index");
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
           $branchid= $this->user_model->getBranch();

           $data['branch'] = $this->report_model->getBranch();
      
            $data['session'] = $this->report_model->getSessions();
			$data["b_header"]=$this->generic_model->getSpecificRecord("branch", array("id"=>$branchid));
//			$data["student"]=$this->generic_model->getAllRecords("student",array("branch"=>$branchid,"is_delete"=>0),"id","DESC");
			$data["student"]=$this->generic_model->getAllStudent();
				
         //   $this->load->view('header',$data);
         //   $this->load->view('sidebar',$data);
            $this->load->view('report/AllStudentRecords',$data);
          //  $this->load->view('footer',$data);
    }
    
        public function studentatt_sectionwise_date()
    {
        $this->user_model->check_permissions("student/studentatt_add");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->student_model->getbranch()->result_array();
         }
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/studentatt_sectionwise_date',$data);
    }
    
     public function student_att_status()
    {
        // $this->user_model->check_permissions("report/student_att_status");
        $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
       if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/studentatt_statuswise',$data);
    }
    
    
    
    ///////////////////////////////////////////
    //     Percentage Attendence Report
    ///////////////////////////////////////////
  
        public function per_attendance_report()
    {
        $this->user_model->check_permissions("student/studentatt_add");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->student_model->getbranch()->result_array();
         }
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/percentage_att',$data);
    }
        
    public function fetch_per_studentatt()
    {

        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
         $class=$this->input->post('branch');
         $section=$this->input->post('section');
        //  $month=$this->input->post('month');
        date_default_timezone_set('Asia/Karachi');
         
         
      $branch=$this->user_model->getbranch();
     //var_dump('<pre>',$class,$section,$month,$branch);
     // die();
        //  $data['student']=$this->db->query(" 
        //  SELECT  distinct(studentatt.student_id),promotion.id,section.section_name,class.class_name,attendancestatus.status,studentatt.date,student.student_name, student.grno,student.father_name
        //  FROM `studentatt` 
        //  INNER JOIN promotion on promotion.id=studentatt.promotion_id 
        //  INNER JOIN class on class.class_id=promotion.class_id 
        //  INNER JOIN section on section.section_id=promotion.section_id 
        //  INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
        //  WHERE studentatt.is_deleted=0 
        //  and promotion.is_active=1 
        //  and promotion.is_delete=0 
        //  AND student.branch='$branch'
        //  AND section.section_id='$section' 
        //  AND class.class_id='$class' 
        //  ")->result_array();
      
        //  $data['totalatt']=$this->db->query(" 
        //  SELECT  count(studentatt.status_id) as totalatt,studentatt.student_id
        //  FROM `studentatt` 
        //  INNER JOIN promotion on promotion.id=studentatt.promotion_id 
        //  INNER JOIN class on class.class_id=promotion.class_id 
        //  INNER JOIN section on section.section_id=promotion.section_id 
        //  INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
        //  WHERE studentatt.is_deleted=0 
        //  and promotion.is_active=1 
        //  and promotion.is_delete=0 
        //  AND student.branch='$branch'
        //  AND section.section_id='$section' 
        //  AND class.class_id='$class' 
        //  GROUP BY studentatt.student_id
        //  ")->result_array();
         
            $data['totaldays']=$this->db->query(" 
         SELECT  count(distinct(studentatt.date)) as totaldays,section.section_name
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id
         INNER JOIN student on student.id=studentatt.student_id 
         
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         
         ")->result_array();
        //  echo'<pre>';print_r($data['totaldays']);exit;
         
          $data['absent']=$this->db->query(" 
         SELECT  count(studentatt.status_id) as absent,studentatt.student_id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         AND studentatt.status_id=2
         GROUP BY studentatt.student_id
         ")->result_array();
         
           $data['present']=$this->db->query(" 
         SELECT  count(studentatt.status_id) as present,studentatt.student_id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         AND studentatt.status_id=1
         GROUP BY studentatt.student_id
         ")->result_array();
        
        //  echo "<pre>";print_r($data['present']);exit;
       
       
       
        $data['studall']=$this->db->query(" 
         SELECT  distinct(student.id) as sid,student.grno, promotion.id,section.section_name,class.class_name,student.father_contact as contact,student.student_name, student.grno,student.father_name
         FROM `student` 
         INNER JOIN promotion on promotion.student_id=student.id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
          and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         ")->result_array();
        
        
        //  echo "<pre>";print_r($data['studall']);exit;
         
        //  $data['stdall']=$this->db->query(" 
        //  SELECT promotion.id,section.section_name,class.class_name,student.student_name, student.grno,student.father_name
        //  FROM `promotion` 
        //  INNER JOIN student on student.id=promotion.student_id 
        //  INNER JOIN class on class.class_id=promotion.class_id 
        //  INNER JOIN section on section.section_id=promotion.section_id 
        //   WHERE 
        //   promotion.is_active=1 
        //  and promotion.is_delete=0 
        //  AND student.branch='$branch' 
        //  AND section.section_id='$section' 
        //  AND class.class_id='$class' 
        //  ")->result_array();
        //       var_dump('<pre>', $data['stdall']);
        //         die();
                          
          if(empty($data['studall']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/per_attendance_report", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
       
         $this->load->view('report/display_studentatt_per',$data);
           }


        //  $data['base_url'] = base_url();
        //  $data['userInfo'] = $this->userInfo;
        //  $this->load->view('report/display_studentatt_sec',$data);
    }
    
    
    



    ///////////////////////////////////////////
    //     END Percentage Attendence Report
    ///////////////////////////////////////////

    
     public function fetch_studentatt_status()
    {

        	$branch=$this->input->post('branch');
    	    $data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
         $data['branch_name']=$data['b_header']['name'];
         $data['class'] = $class=$this->input->post('class');
         $data['section'] = $section=$this->input->post('section');
        $data['dat']=$this->input->post('month');
         $month=date('Y-m-d',strtotime($this->input->post('month')));
         //var_dump($month); 
          $status=$this->input->post('status');
    //  var_dump('<pre>',$class,$section,$month,$branch,$status);die();
          $data['month']=$this->input->post('month');
      
          $this->db->select('promotion.id,section.section_name,class.class_name,attendancestatus.status,studentatt.date,student.student_name, student.sid,student.father_name');
          $this->db->join('promotion','promotion.id=studentatt.promotion_id');
          $this->db->join('class','class.class_id=promotion.class_id');
          $this->db->join('section','section.section_id=promotion.section_id');
          $this->db->join('attendancestatus','attendancestatus.id=studentatt.status_id');
          $this->db->join('student','student.id=studentatt.student_id');
          $this->db->where('studentatt.is_deleted','0');
          $this->db->where('promotion.is_active','1'); 
          $this->db->where('promotion.is_delete','0');
          $this->db->where('student.branch',$branch);
          $this->db->where('studentatt.date',$month);
          if($class)
          $this->db->where('class.class_id',$class);
          if($section)
          $this->db->where('section.section_id',$section);
          if($status)
          $this->db->where('studentatt.status_id',$status);
          $data['student']= $this->db->get('studentatt')->result_array();
                          
          //echo "<pre>";print_r($data['student']);exit;
//          if(empty($data['student']))
//           {
//               $this->session->set_flashdata('msg','Record Not Found');
//               redirect("Report/student_att_status", "refresh");
//
//           }
//           else{
               //echo "<pre>";print_r($data);exit;

         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/display_studentatt_statuswise',$data);
          // }
    }
    
    
    
    
    
      public function fetch_studentatt_section_date()
    {

         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

         $class=$this->input->post('branch');
         $section=$this->input->post('section');
         $month=$this->input->post('month');
      $branch=$this->user_model->getbranch();
     //var_dump('<pre>',$class,$section,$month,$branch);
     // die();
      $data['month']=$this->input->post('month');
         $data['student']=$this->db->query(" 
         SELECT  promotion.id,section.section_name,class.class_name,attendancestatus.status,studentatt.date,student.student_name, student.sid,student.father_name
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND studentatt.date='$month' 
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         ")->result_array();

      
               //   var_dump( $data['student']);
               // die();
                          
          if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/studentatt_sectionwise_date", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/display_studentatt_sec_date',$data);
           }


        //  $data['base_url'] = base_url();
        //  $data['userInfo'] = $this->userInfo;
        //  $this->load->view('report/display_studentatt_sec',$data);
    }
    
    
       public function student_roll()
    {
      // $this->user_model->check_permissions("student/studentatt_add");
     // var_dump('hello'); die();
     $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array(); 
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/studentatt_roll',$data);
    }




     public function fetch_student_roll() 
    {
        $branch=$this->input->post('branch');
    	$data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];


         $class=$this->input->post('class');
         $section=$this->input->post('section');
         $students=$this->input->post('students');
         $month=$this->input->post('bdaymonth');
        // var_dump($class,$section,$students,$month);
        // die();


    
    // var_dump('<pre>',$class,$section,$month,$branch);
      //die();
      
        $data['student']=$this->db->query("SELECT student.id,section.section_name,student.father_name,class.class_name,student.student_name,student.grno,student.sid  
                     FROM `student` INNER JOIN promotion on promotion.student_id=student.id 
                                INNER JOIN class on class.class_id=promotion.class_id 
                                INNER JOIN section on section.section_id=promotion.section_id 
                                                     WHERE  promotion.is_active=1 
                          and promotion.is_delete=0
                          and class.class_id='$class' 
                          and promotion.student_id='$students'
                          and section.section_id='$section'")->result_array();

        foreach ($data['student'] as $key => $student) {
            
            $data['student'][$key]['dates'] = $this->db->query("SELECT DISTINCT (studentatt.date),attendancestatus.status FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student[id] AND LEFT(studentatt.date,7)='$month'")->result_array(); 
        }
        
        $data['absnt']=$this->db->query(" 
         SELECT promotion.id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         and attendancestatus.id=2
         and promotion.student_id= $students
         AND student.branch='$branch'
         AND left(studentatt.date,7)='$month' 
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         ")->result_array();

        $data['present']=$this->db->query(" 
         SELECT promotion.id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         and promotion.student_id= $students
         and attendancestatus.id=1
         AND student.branch='$branch'
         AND left(studentatt.date,7)='$month' 
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         ")->result_array();

        $data['leave']=$this->db->query(" 
         SELECT promotion.id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id
          INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         and attendancestatus.id=3
         and promotion.student_id= $students
         AND student.branch='$branch'
         AND left(studentatt.date,7)='$month' 
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         ")->result_array();
         
          $data['s_leave']=$this->db->query(" 
         SELECT promotion.id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id
          INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         and attendancestatus.id=4
         and promotion.student_id= $students
         AND student.branch='$branch'
         AND left(studentatt.date,7)='$month' 
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         ")->result_array();

        $data['month'] = $month;
//echo "<pre>";print_r($data);exit;

                       // var_dump($data['student']);
                      //  die();
                          
          if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/studentatt_sectionwise", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/display_studentatt_roll',$data);
           }
    }
   

  public function progress_report()
    {
      // $this->user_model->check_permissions("student/studentatt_add");
     // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->student_model->getbranch()->result_array();
         }
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/progress_report',$data);
    }

      public function ProgressReportList()
    {
        if($this->input->post())
        {
            $class=$this->input->post('class');
         $section=$this->input->post('section');
         $data['class'] = $class;
         $data['section'] = $section;

         $students=$this->db->select('student_id')->where('class_id',$class)->where('section_id',$section)->where('session_id',3)->where('is_delete',0)->where('is_active',0)->get('promotion')->result_array();
         foreach($students as $key=>$value){
          $data['student'][]=@$this->db->query("SELECT student.id,student.img,section.section_name,student.father_name,class.class_name,student.student_name,student.grno  
                     FROM `student` INNER JOIN promotion on promotion.student_id=student.id 
                                INNER JOIN class on class.class_id=promotion.class_id 
                                INNER JOIN section on section.section_id=promotion.section_id 
                                                     WHERE  promotion.session_id=3 
                          and promotion.is_delete=0
                          and class.class_id='$class' 
                          and promotion.student_id=".$value['student_id']."
                          and section.section_id='$section'")->row_array();
}
//echo "<pre>";print_r($data['student']);exit;

      $branch=$this->user_model->getbranch();
            $data['menu'] = $this->load_model->menu();
            $data['userInfo'] = $this->userInfo;
            $data['base_url'] = base_url();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/ProgressReportList',$data);
            $this->load->view('footer',$data);
        }
    }


public function fetch_progress_report($class,$section,$student_id) 
    {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $data['student']=@$this->db->query("SELECT 
                     student.id,student.img,section.section_name,student.father_name,class.class_name,student.student_name,student.grno  
                     FROM `student` INNER JOIN promotion on promotion.student_id=student.id 
                                INNER JOIN class on class.class_id=promotion.class_id 
                                INNER JOIN section on section.section_id=promotion.section_id 
                                                     WHERE  promotion.session_id=3 
                          and promotion.is_delete=0
                          and class.class_id='$class' 
                          and promotion.student_id=".$student_id."
                          and section.section_id='$section'")->row_array();
      $branch=$this->user_model->getbranch();
      $exam = @$this->db->select('id')->where('class_id',$class)->get('exam')->result_array();
if($exam){
$exams[0] = 0;
foreach($exam as $v){
   $exams[] = $v['id'];
}}
//echo "<pre>";print_r($exams);exit;
$exams = base64_encode(json_encode($exams));
         //echo "<pre>";print_r($data['student']);exit;
      
$data['student']['present'] = $this->db->query("SELECT DISTINCT(studentatt.date) FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student_id AND attendancestatus.status = 'P'")->num_rows();

$data['student']['absnt'] = $this->db->query("SELECT DISTINCT(studentatt.date) FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student_id AND attendancestatus.status = 'A'")->num_rows();

$data['student']['leave'] = $this->db->query("SELECT DISTINCT(studentatt.date) FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student_id AND attendancestatus.status = 'L'")->num_rows();

$exam_list=$this->report_model->ExamsResult($exams,$student_id);
 //echo "<pre>";print_r($exam_list);exit;
foreach($exam_list as $k=>$val){
     if($val){
         $data['student']['result_exam'][] =@$this->db->select('result.id,result.total_marks,result.obtained_marks,(result.obtained_marks*100/(result.total_marks)) as percentage,exam.name as exam_name')->join('exam','exam.id=result.exam_id')->where('result.id',$val->id)->get('result')->result_array()[0];
}
}
//echo $student['id'];exit;
$data['student']['invoice'] = @$this->db->query("SELECT SUM(invoice.recieved) as total_fee FROM invoice INNER JOIN promotion on promotion.id=invoice.student_id  WHERE promotion.student_id = $student_id AND invoice.status = '1' AND promotion.session_id = 3")->result_array()[0];

        
//echo "<pre>";print_r($data['student']['result_exam']);
 
         $data['subjects']=$this->report_model->getClassSubjectNames($class,$section);
         $result_subjects = [];
         foreach($data['student']['result_exam'] as $key=>$value)
         {
          if(!empty($value)){
          $subjects_ids = $this->report_model->getSubjectNames($value['id']);
          if(!empty($subjects_ids))
           {
            foreach ($subjects_ids as $k => $v) {
             $result_subjects[$v->name][$key] = $v->id;
            }
          }
        }
          }

        //echo "<pre>";print_r($result_subjects);exit;
        foreach($result_subjects as $key => $value){
               $sub_result[$key]['total_marks'] = 0; 
               $count = count($value);
               foreach($value as $k=>$v){
               $mark = $this->report_model->getSubjectMark($v);
               $sub_result[$key]['total_marks'] += ($mark->obtained_marks * 100)/$mark->total_marks;
}
$data['sub_result'][$key]['total_marks'] = round($sub_result[$key]['total_marks'] / $count,2);
}
//echo "<pre>";print_r($sub_result);exit;
  //      echo "<pre>";print_r($result_subjects);exit;

//echo "<pre>";print_r($data);exit;
        
                       // var_dump($data['student']);
                      //  die();
                          
          if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/progress_report", "refresh");
        
           }
           else{
         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/display_progress_report',$data);
           }
    }
   
    
    
    
    
    
    public function class_section_wisedefaultReport()
    { 
       // var_dump("hello");
    //    die();
          //  $this->user_model->check_permissions("Report/class_section_wisedefaultReport");
            $data['menu'] = $this->load_model->menu();
             $data['is_super'] = $this->is_super;
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $this->report_model->getBranch();
            $data['session'] = $this->report_model->getSessions();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/class_section_wisedefaultReport',$data);
            // $this->load->view('footer',$data);

    }
    
     public function showclass_section_wisedefaultReport()
    {
    $class =$this->input->post('class');
    $section=$this->input->post('section');
   
         $branch=$this->report_model->getBranch()[0];
         $m = $this->input->post('month');
       $month = date(strtotime("Y-m", $m));
       $date = date("Y-m-d");
       
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();


   // $month= $this->input->post('status');

         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();
         
    $qu=$this->db->query("SELECT `student`.`student_name`, `student`.`sid`, `student`.`father_name`,`student`.`father_contact`,`invoice`.`id` as `invoice_no`,`class`.`class_name`,`section`.`section_name` 
FROM `invoice` INNER JOIN `promotion` ON `promotion`.`id` = `invoice`.`student_id`
INNER JOIN `student` ON `student`.`id` = `promotion`.`student_id` INNER JOIN `class` ON `promotion`.`class_id` = `class`.`class_id`
INNER JOIN `section` ON `promotion`.`section_id` = `section`.`section_id`
WHERE `invoice`.`is_delete`='0' 
	AND `invoice`.`branch_id`='$branch' 
    and invoice.status=0 
    AND `class`.`class_id` = '$class'
    And `section`.`section_id`='$section'
    AND invoice.date_expire< '$date'
	AND LEFT(`invoice`.`date`,7)='$month'");
     $data['student'] = $qu->result_array();
     
    // var_dump("<pre>", $data['student']);
    // die();
     
      if(empty($data['student']))
           {
               
              $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/class_section_wisedefaultReport", "refresh");
        
           }
           else{
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/show_classwisedefulat.php',$data);
           }
     
     // $this->load->view('report/monthly_dafulter',$data);
    }
     
        
        
        
    
    
    
    
    
    public function Allteacher_attendence_report()
    { 
          
       $this->load->model("Teacher_model");
       $data['report']=$this->Teacher_model->t_attendece_report();
       //var_dump();die();
	//print_r($data['report']); die();
	
	
            $this->load->view('report/Allteacher_attendence_report',$data);
           
			//$this->load->model("generic_model");
           /* $this->user_model->check_permissions("Report/index");
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
           $branchid= $this->user_model->getBranch();

           $data['branch'] = $this->report_model->getBranch();
      
            $data['session'] = $this->report_model->getSessions();*/
			//$data["b_header"]=$this->generic_model->getSpecificRecord("branch", array("id"=>$branchid));
//			$data["student"]=$this->generic_model->getAllRecords("student",array("branch"=>$branchid,"is_delete"=>0),"id","DESC");
			//$data["student"]=$this->generic_model->getAllStudent();
				
         //   $this->load->view('header',$data);
         //   $this->load->view('sidebar',$data);
            //$this->load->view('report/AllStudentRecords',$data);
          //  $this->load->view('footer',$data);
    }
    
    
      public function StudentRegisterationReport()
    { 
	//print_r("hi"); die();
		 $startd=$data["startdate"]=$this->input->post('startdate');
	$endd= $data["enddate"]=$this->input->post('enddate');
	
			$this->load->model("generic_model");
            $this->user_model->check_permissions("Report/index");
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
           $branchid= $this->user_model->getBranch();

           $data['branch'] = $this->report_model->getBranch();
      
            $data['session'] = $this->report_model->getSessions();
			$data["b_header"]=$this->generic_model->getSpecificRecord("branch", array("id"=>$branchid));
			$data["class"]=$this->generic_model->getAllRecords("class",array("branch"=>$branchid,"is_delete"=>0),"class_id","DESC");
			
	//$data["student1"]=$this->generic_model->getCount("class",array("is_delete"=>0));
	//$data["student"]=$this->generic_model->getStudentRegisteration();
	//$s=$this->generic_model->getCount("class",array("is_delete"=>0));
//	echo count($s);die();	
		
         //   $this->load->view('header',$data);
         //   $this->load->view('sidebar',$data);
            $this->load->view('report/StudentRegisterationReport',$data);
          //  $this->load->view('footer',$data);
    
    
    }
    
    public function SectionWiseResultReport()
    {
        if($this->input->post())
        {
            $data['b_id']=$branch=$this->user_model->getBranch();
            $class=$this->input->post("class",true);
            $data['class_order']=$this->db->select('orderr')
                                         ->from('class')
                                         ->where('class_id',$class)
                                         ->get()->row_array()['orderr'];
            $data['classs']=$this->input->post("class",true);
            $data['exams']=$this->input->post("exam",true);
            $data['sections']=$section=$this->input->post("section",true);
            $exam=$this->input->post("exam",true);
            $data['sessions'] = $session=$this->input->post("session",true);
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['student']=$this->report_model->SectionWiseExamStudents($branch,$class,$section,$exam);
           // var_dump('<pre>',$data['student']);
            //die();
            $data['b_header']= $this->report_model->BranchHeader();
            $data['class']= $this->report_model->ClassInfo($class);
            $data['section']= $this->report_model->SectionInfo($section);
            $data['session']= $this->report_model->SessionInfo($session);
            $data['exam']= $this->report_model->ExamInfo($exam);
            $this->load->view("report/SectionWiseResultReport",$data);
        }
    }

 public function AssessmentReportSelection()
    {
         $branch=$this->user_model->getBranch();
            $this->user_model->check_permissions("Report/MultiExamReportSelection");
             $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $this->report_model->getBranch();
            $data['session'] = $this->report_model->getSessions();
            $data['exam']=$this->db->query("SELECT `exam`.id,`exam`.name FROM `exam` INNER JOIN `exam_type` ON `exam_type`.`id`=`exam`.`etype_id` where `exam`.is_delete= 0 AND `exam_type`.is_delete= 0 AND `exam_type`.branch_id='$branch'")->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/AssessmentReportSelection',$data);
            //$this->load->view('footer',$data);
    }
    
    public function MultiExamReportSelection()
    {
            $this->user_model->check_permissions("Report/MultiExamReportSelection");
             $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $this->report_model->getBranch();
            $data['session'] = $this->report_model->getSessions();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/MultiExamReportSelection',$data);
            //$this->load->view('footer',$data);
    }

    public function MultiExamReportList()
    {
        if($this->input->post())
        {
            $this->user_model->check_permissions("Report/MultiExamReportSelection");
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $section = $this->input->post("section",true);
            $session = $this->input->post("session",true);
            $exams = $this->input->post("exams",true);
          
          
            $data['menu'] = $this->load_model->menu();
            $data['userInfo'] = $this->userInfo;
            $data['base_url'] = base_url();
            $data['exams'] =base64_encode(json_encode($exams));
             // var_dump('<pre>',$data['exams']);
           // die();
            $data['printAllEncoded'] = base64_encode(json_encode(array($branch,$class,$section,$session)));
            $data['student']=$this->report_model->SectionWiseStudents($branch,$class,$section,$session);
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/MultiExamReportList',$data);
            $this->load->view('footer',$data);
        }
    }
    
    public function AssesmentReportList()
    {
         if($this->input->post())
        {
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $section = $this->input->post("section",true);
            $session = $this->input->post("session",true);
            $exam = $this->input->post("exam",true);
            $sub_types = $this->input->post("subexams",true);
        //   var_dump('<pre>',$sub_types);
        //   die();
            $data['menu'] = $this->load_model->menu();
            $data['userInfo'] = $this->userInfo;
            $data['base_url'] = base_url();
            $data['exams'] =$exam;
            $data['sub_types'] =base64_encode(json_encode($sub_types));
             // var_dump('<pre>',$data['exams']);
           // die();
            $data['printAllEncoded'] = base64_encode(json_encode(array($branch,$class,$section,$session)));
          
            $data['student']=$this->report_model->SectionWiseStudents($branch,$class,$section,$session);
            //var_dump($data['student']);die;
           
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/AssesmentReportList',$data);
            $this->load->view('footer',$data);
        }
    }

  public function AssesmentReportPrint()
    {
        if($this->uri->segment(3) AND $this->uri->segment(4) AND $this->uri->segment(5) AND $this->uri->segment(6))
        {
            $exam=$this->uri->segment(3);
             
            $subexams =$this->uri->segment(4);
           $subexams = json_decode(base64_decode($subexams),true);
           
            $data['subexams']=$subexams;
        
            $printAllEncoded = json_decode(base64_decode($this->uri->segment(5)));
            $student = $this->uri->segment(6);
          
           
            $data['result']=$this->db->select("result.id,exam.name")
                                     ->from('result')
                                     ->join('exam',"exam.id=result.exam_id")
                                     ->join('result_subject',"result.id=result_subject.result_id")
                                     ->where('promotion_id',$student)
                                     ->where('result.exam_id',$exam)
                                     ->where('result.is_delete',"0")
                                     //->where('result_subject.subexam_id >',"0")
                                     ->get()->row();
          // var_dump('<pre>',$data['result']);
          // die();
            $data['student']=$this->report_model->StudentDetails($student);
            
            $data['subjects']=$this->report_model->getClassSubjectNames($printAllEncoded[1],$printAllEncoded[2]);
            // var_dump("<pre>",$data['subjects']);die();
            $data['b_header']= $this->report_model->BranchHeader();
            $this->load->view('report/AssementReportPrint',$data);
        }
    }
    public function MultiExamReportPrint()
    {
        $this->user_model->check_permissions("Report/MultiExamReportSelection");
        if($this->uri->segment(3) AND $this->uri->segment(4) AND $this->uri->segment(5))
        {
            $exams =$this->uri->segment(3);
        
            $printAllEncoded = json_decode(base64_decode($this->uri->segment(4)));
            $student = $this->uri->segment(5);
           
            $data['result']=$this->report_model->Examscustom($exams,$student);
         
            $data['student']=$this->report_model->StudentDetails($student);
            $data['subjects']=$this->report_model->getClassSubjectNames($printAllEncoded[1],$printAllEncoded[2]);
            // var_dump("<pre>",$data['subjects']);die();
            $data['b_header']= $this->report_model->BranchHeader();
            $this->load->view('report/MultiExamReportPrint',$data);
        }
    }

    public function MultiExamReportPrintAll()
    {
        $this->user_model->check_permissions("Report/MultiExamReportSelection");
        if($this->uri->segment(3) AND $this->uri->segment(4))
        {
            $exams = $this->uri->segment(3);
            $printAllEncoded = json_decode(base64_decode($this->uri->segment(4)));
            $data['students']=$this->report_model->SectionWiseStudents($printAllEncoded[0],$printAllEncoded[1],$printAllEncoded[2],$printAllEncoded[3]);
            $data['b_header']= $this->report_model->BranchHeader();
            $data['subjects']=$this->report_model->getClassSubjectNames($printAllEncoded[1],$printAllEncoded[2]);
            $data['exams']= $exams;
            $this->load->view('report/MultiExamReportPrintAll',$data);
        }
    }
    
       public function AssesmentReportPrintAll()
    {
        if($this->uri->segment(3) AND $this->uri->segment(4) AND $this->uri->segment(5))
        {
            $exams= $this->uri->segment(3);
            $subexams= $this->uri->segment(5);
            $printAllEncoded = json_decode(base64_decode($this->uri->segment(4)));
            $data['students']=$this->report_model->SectionWiseStudents($printAllEncoded[0],$printAllEncoded[1],$printAllEncoded[2],$printAllEncoded[3]);
            $data['b_header']= $this->report_model->BranchHeader();
            $data['subjects']=$this->report_model->getClassSubjectNames($printAllEncoded[1],$printAllEncoded[2]);
            $data['exam']= $exams;
             $subexams = json_decode(base64_decode($subexams),true);
            $data['subexams']=$subexams;
            $this->load->view('report/AssesmentReportPrintAll',$data);
        }
    }

    public function YearlyFeeReport_select_month()
      {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        //===========================================
        
        //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/select_yearly_FeeReport_month',$data);

      }

     public function YearlyFeeReport($year='')
    {
        if($this->input->post('year'))
    	$year=$this->input->post('year');
    	$branch=$this->input->post('branch');
    	$data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];
        if($year=='')
        $year=date('Y');
        $yearly_month_array=array("$year-01"=>'',"$year-02"=>'',"$year-03"=>'',"$year-04"=>'',"$year-05"=>'',"$year-06"=>'',"$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'');
        $monthly_values=array("$year-01"=>'',"$year-02"=>'',"$year-03"=>'',"$year-04"=>'',"$year-05"=>'',"$year-06"=>'',"$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'');
        //var_dump('<pre>',$yearly_month_array);die();
        foreach ($yearly_month_array as $selected_month=>$value) {
            $this->db->select('invoice.*');
            $this->db->from('invoice');
            $this->db->join('promotion','invoice.student_id=promotion.id');
            $this->db->join('student','student.id=promotion.student_id');
            $this->db->join('class','class.class_id=promotion.class_id');
            $this->db->join('section','section.section_id=promotion.section_id');//$this->db->where('student.status',0);
            $this->db->where('promotion.is_delete',0);
           // $this->db->where('promotion.is_active',1);
            $this->db->where('left(invoice.date,7)',$selected_month);
            $this->db->where('invoice.branch_id',$branch);
             $this->db->where('invoice.is_auto',0);
            $this->db->where('invoice.is_delete',0);
            $this->db->where('class.is_delete',0);
            $this->db->where('section.is_delete',0);
            $yearly_month_array[$selected_month]=$this->db->get()->result_array();
        }
        // echo "<pre>";print_r($yearly_month_array);exit;
        // var_dump('<pre>',$yearly_month_array);die();
        foreach ($yearly_month_array as $selected_month=>$all_vouchers) {
            //var_dump($selected_month);die();    
            //if($selected_month=='2016-08')
            //var_dump('<pre>',$all_vouchers);
            $monthly_values[$selected_month]['total_fee']=0;
            $monthly_values[$selected_month]['fee_recieved']=0;
            $monthly_values[$selected_month]['fee_remaining']=0;
            $monthly_values[$selected_month]['fine']=0;
            $monthly_values[$selected_month]['discount']=0;
            $monthly_values[$selected_month]['advance']=0;
            foreach ($all_vouchers as $key => $voucher) {
           
                if($voucher['remaining'] == 0 && $voucher['status'] == 1){$calc_fee=(($voucher['recieved']+$voucher['discount']) - ($voucher['fine'] + $voucher['advance']));}
                  elseif($voucher['remaining'] > 0 && $voucher['status'] !=0){$calc_fee=(($voucher['recieved']+$voucher['discount']+$voucher['remaining']) - $voucher['fine']);}
                  else{$calc_fee=$this->voucher_model->countTotalFee($voucher['id']);}
         
                $monthly_values[$selected_month]['total_fee']+=$calc_fee;
                $monthly_values[$selected_month]['fee_recieved']+=$voucher['recieved'];
                if($voucher['status'] == 0){
                    $monthly_values[$selected_month]['fee_remaining']+=$calc_fee;
                }else{
                    $monthly_values[$selected_month]['fee_remaining']+=$voucher['remaining'];
                }
                $monthly_values[$selected_month]['fine']+=$voucher['fine'];                
                $monthly_values[$selected_month]['discount']+=$voucher['discount'];                
                $monthly_values[$selected_month]['advance']+=$voucher['advance'];                
                
            }
        }//end of yealy vouchers foreach

//=====================================get total expense month wise=====================================================================
        reset($monthly_values);
        // echo "<pre>";print_r($monthly_values);exit;
        foreach ($monthly_values as $month_name => $v) {
            $this->db->select('sum(amount)');
            $this->db->where('left(date,7)',$month_name);
            $this->db->where('branch',$branch);
            $monthly_values[$month_name]['total_expense']=$this->db->get('cash_receipt')->result_array()[0]['sum(amount)'];
        }
        
//======================================================================================================================================

//====================================monthly profit= monthly fee recieved - monthly expense============================================
        // reset($monthly_values);
        // foreach ($monthly_values as $month_namee => $va) {
        //      $monthly_values[$month_namee]['monthly_profit']=$monthly_values[$month_namee]['fee_recieved']-$monthly_values[$month_namee]['total_expense'];
        // }

//=======================================================================================================================================
        //var_dump('<pre>',$monthly_values);die();
        $data['monthly_values']=$monthly_values;
        $this->load->view('report/YearlyFeeReport',$data);
    }
   
    public function FinalAccountReport_select_month()
      {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        //===========================================
        
        //calling views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/select_final_accountReport_month',$data);

      }
   
    public function FinalAccountReport($year='')
    {
    	if($this->input->post('year'))
    	$year=$this->input->post('year');
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        if($year=='')
        $year=date('Y');
        $next_year=(string)$year+1;
        $yearly_month_array=array("$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'',"$next_year-01"=>'',"$next_year-02"=>'',"$next_year-03"=>'',"$next_year-04"=>'',"$next_year-05"=>'',"$next_year-06"=>'');
        $monthly_values=array("$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'',"$next_year-01"=>'',"$next_year-02"=>'',"$next_year-03"=>'',"$next_year-04"=>'',"$next_year-05"=>'',"$next_year-06"=>'');
        foreach ($yearly_month_array as $selected_month=>$value) {
            $this->db->select('invoice.*');
            $this->db->from('invoice');
            $this->db->join('promotion','invoice.student_id=promotion.id');
            $this->db->join('student','student.id=promotion.student_id');
            //$this->db->where('student.status',0);
            //$this->db->where('promotion.is_delete',0);
            //$this->db->where('promotion.is_active',1);
            $this->db->where('left(invoice.date,7)',$selected_month);
            $this->db->where('invoice.branch_id',$branch['id']);
            $this->db->where('invoice.is_delete',0);
            $yearly_month_array[$selected_month]=$this->db->get()->result_array();
        }
        //echo "<pre>";print_r($yearly_month_array);exit;
        foreach ($yearly_month_array as $selected_month=>$all_vouchers) {
            $monthly_values[$selected_month]['fee_recieved']=0;
            foreach ($all_vouchers as $key => $voucher) {       
                $monthly_values[$selected_month]['fee_recieved']+=$voucher['recieved'];                           
            }
        }//end of yealy vouchers foreach

//=====================================get total cash receipts(table cash vouchers) month wise=====================================================================

        reset($monthly_values);
        foreach ($monthly_values as $month_name => $v) {
            $this->db->select('sum(amount)');
            $this->db->where('left(date,7)',$month_name);
            $this->db->where('is_delete',0);
            $this->db->where('main_head_id',5);
            $this->db->where('branch',$branch['id']);
            $monthly_values[$month_name]['total_cash_receipts']=$this->db->get('cash_voucher')->result_array()[0]['sum(amount)'];
        }

//======================================================================================================================================

//=====================================get total cash Deposit month wise=====================================================================

        reset($monthly_values);
        foreach ($monthly_values as $month_name => $v) {
            $this->db->select('sum(amount)');
            $this->db->where('left(date,7)',$month_name);
            $this->db->where('is_delete',0);
            $this->db->where('branch',$branch['id']);
            $monthly_values[$month_name]['total_cash_deposit']=$this->db->get('cash_deposit')->result_array()[0]['sum(amount)'];
        }

//======================================================================================================================================

//=====================================get total Bank Recept(BHR) month wise=====================================================================

        reset($monthly_values);
        foreach ($monthly_values as $month_name => $v) {
            $this->db->select('sum(amount)');
            $this->db->where('left(date,7)',$month_name);
            $this->db->where('is_delete',0);
            $this->db->where('branch',$branch['id']);
            $monthly_values[$month_name]['total_bank_receipt']=$this->db->get('bank_recpt')->result_array()[0]['sum(amount)'];
        }

//======================================================================================================================================

//=====================================get total expense month wise=====================================================================
        reset($monthly_values);
        foreach ($monthly_values as $month_name => $v) {
            $this->db->select('sum(amount)');
            $this->db->where('left(date,7)',$month_name);
            $this->db->where('is_delete',0);
            $this->db->where('main_head_id',4);
            $this->db->where('branch',$branch['id']);
            $monthly_values[$month_name]['total_expense']=$this->db->get('cash_receipt')->result_array()[0]['sum(amount)'];
        }
        
//======================================================================================================================================

//=====================================get total salary paid month wise=====================================================================

        reset($monthly_values);
        foreach ($monthly_values as $month_name => $v) {
            $this->db->select('sum(total_amount)');
            $this->db->where('month',$month_name);
            $this->db->where('is_paid',1);
            $this->db->where('is_delete',0);
            $this->db->where('branch',$branch['id']);
            $monthly_values[$month_name]['total_salary']=$this->db->get('salary')->result_array()[0]['sum(total_amount)'];
        }

//======================================================================================================================================

//====================================monthly profit= monthly fee recieved - monthly expense============================================
        reset($monthly_values);
        foreach ($monthly_values as $month_namee => $va) {
             $monthly_values[$month_namee]['monthly_profit']=($monthly_values[$month_namee]['fee_recieved']+$monthly_values[$month_namee]['total_cash_receipts'])-$monthly_values[$month_namee]['total_salary']-$monthly_values[$month_namee]['total_expense'];
        }

//=======================================================================================================================================
        //var_dump('<pre>',$monthly_values);die();
        $data['monthly_values']=$monthly_values;
        $this->load->view('report/FinalAccountReport',$data);
    }
    
    public function OtherFeeReport($year='')
    {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        if($year=='')
        $year=date('Y');
        $yearly_month_array=array("$year-01"=>'',"$year-02"=>'',"$year-03"=>'',"$year-04"=>'',"$year-05"=>'',"$year-06"=>'',"$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'');
        $monthly_values=array("$year-01"=>'',"$year-02"=>'',"$year-03"=>'',"$year-04"=>'',"$year-05"=>'',"$year-06"=>'',"$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'');
        foreach ($yearly_month_array as $selected_month=>$value) {
            $this->db->select('invoice.*');
            $this->db->from('invoice');
            $this->db->join('promotion','invoice.student_id=promotion.id');
            $this->db->join('student','student.id=promotion.student_id');
            //$this->db->where('student.status',0);
            //$this->db->where('promotion.is_delete',0);
            //$this->db->where('promotion.is_active',1);
            $this->db->where('left(invoice.date,7)',$selected_month);
            $this->db->where('invoice.branch_id',$branch['id']);
            $this->db->where('invoice.is_delete',0);
            $yearly_month_array[$selected_month]=$this->db->get()->result_array();
        }
        foreach ($yearly_month_array as $selected_month=>$all_vouchers) {

            $monthly_values[$selected_month]['total_fee_WithoutOtherFee']=0;
            $monthly_values[$selected_month]['total_other_fee']=0;
            foreach ($all_vouchers as $key => $voucher) {
                if($voucher['remaining'] == 0 && $voucher['status'] == 1){$calc_fee=(($voucher['recieved']+$voucher['discount']) - ($voucher['fine'] + $voucher['advance']));}
          elseif($voucher['remaining'] > 0 && $voucher['status'] !=0){$calc_fee=(($voucher['recieved']+$voucher['discount']+$voucher['remaining']) - $voucher['fine']);}
          else{$calc_fee=$this->voucher_model->countTotalFee($voucher['id']);}
         $other_fees=$this->voucher_model->other_fee($voucher['id']);
    
                $monthly_values[$selected_month]['total_fee_WithoutOtherFee']+=$voucher['fee_pack'];
                if($other_fees) {
                    foreach ($other_fees as $selected_other_fee) {
                        $monthly_values[$selected_month]['total_other_fee']+=$selected_other_fee['amount'];
                    } 
                }
            }
        }//end of yealy vouchers foreach


        //var_dump('<pre>',$monthly_values);die();
        $data['monthly_values']=$monthly_values;
        $this->load->view('report/OtherFeeReport',$data);
    }

   public function billing_summary()
    {
        $data['month']=$month=$this->input->post('month');
		$this->user_model->check_permissions("report/billing_summary");
		$data['is_super'] = $this->user_model->is_super();
		$branch = $this->user_model->getBranch();
		$data['menu'] = $this->load_model->menu();
		$data['base_url'] = base_url();
		$data['userInfo'] = $this->userInfo;
        $voucher_classwise=[];
        $values_classwise=[];

        if(!empty($month)) {
            if($data['is_super']){
            $classes=$this->db->where('is_delete',0)->get('class')->result_array();
             }else{
               $classes=$this->db->where('is_delete',0)->where('branch',$branch)->get('class')->result_array();
             }
            foreach ($classes as $key => $selected_class) {
                $this->db->select('class.class_name,invoice.*');
                $this->db->join('promotion','promotion.id=invoice.student_id');
                $this->db->join('class','promotion.class_id=class.class_id');
                $this->db->where('invoice.is_delete',0);
                $this->db->where('invoice.branch_id',$branch);
                $this->db->where('promotion.class_id',$selected_class['class_id']);
                $this->db->where('left(invoice.date,7)',$month);
                $voucher_classwise[$selected_class['class_name']]=$this->db->get('invoice')->result_array();
                //var_dump($voucher_classwise);die();
            }
            //var_dump('<pre>',$voucher_classwise);die();
            foreach ($voucher_classwise as $k => $selected_class) {
                $total_expected_fee=0;
                $total_fee_recieved=0;
                $total_other_fee=0;
                $total_arrear=0;
                $total_remaining=0;
                foreach ($selected_class as $key => $selected_voucher) {
                    $total_expected_fee+=$this->voucher_model->countTotalFee_WithoutArears_WithoutOtherFee($selected_voucher['id']);
                    //$total_expected_fee+=$selected_voucher['fee_pack'];
                    $total_fee_recieved+=$selected_voucher['recieved'];
                    $total_other_fee+=$this->voucher_model->total_other_fee($selected_voucher['id']);
                    $total_arrear+=$this->voucher_model->getArrearsAmount($selected_voucher['id'],$selected_voucher['student_id']);
                }
                //var_dump($total_remaining);die();
                $values_classwise[$k]['total_expected_fee']=$total_expected_fee;
                $values_classwise[$k]['total_fee_recieved']=$total_fee_recieved;
                $values_classwise[$k]['total_other_fee']=$total_other_fee;
                $values_classwise[$k]['total_arrear']=$total_arrear;
                $values_classwise[$k]['total_remaining']=$total_expected_fee+$total_other_fee+$total_arrear-$total_fee_recieved;
            }
            //var_dump($values_classwise);die();
        }

        $data['values_classwise']=$values_classwise;
          //var_dump("<pre>",$data['values_classwise']);die();
		$this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/billing_summary',$data);
    }


    public function billing_summary_print($month='')
    {
    $month=$this->input->post('month');
        $data['month']=$month;
		//$this->user_model->check_permissions("report/billing_summary_print");
        $data['b_header']= $this->report_model->BranchHeader();
		$data['is_super'] = $this->user_model->is_super();
		$branch = $this->user_model->getBranch();
		$data['base_url'] = base_url();
		$data['userInfo'] = $this->userInfo;
        $voucher_classwise=[];
        $values_classwise=[];

        if(!empty($month)) {
            if($data['is_super']){
            $classes=$this->db->where('is_delete',0)->get('class')->result_array();
             }else{
               $classes=$this->db->where('is_delete',0)->where('branch',$branch)->get('class')->result_array();
             }
            foreach ($classes as $key => $selected_class) {
                $this->db->select('class.class_name,invoice.*');
                $this->db->join('promotion','promotion.id=invoice.student_id');
                $this->db->join('class','promotion.class_id=class.class_id');
                $this->db->where('invoice.is_delete',0);
                $this->db->where('invoice.branch_id',$branch);
                $this->db->where('promotion.class_id',$selected_class['class_id']);
                $this->db->where('left(invoice.date,7)',$month);
                $voucher_classwise[$selected_class['class_name']]=$this->db->get('invoice')->result_array();
                //var_dump($voucher_classwise);die();
            }
            //var_dump('<pre>',$voucher_classwise);die();
            foreach ($voucher_classwise as $k => $selected_class) {
                $total_expected_fee=0;
                $total_fee_recieved=0;
                $total_other_fee=0;
                $total_arrear=0;
                $total_remaining=0;
                foreach ($selected_class as $key => $selected_voucher) {
                    $total_expected_fee+=$this->voucher_model->countTotalFee_WithoutArears_WithoutOtherFee($selected_voucher['id']);
                    //$total_expected_fee+=$selected_voucher['fee_pack'];
                    $total_fee_recieved+=$selected_voucher['recieved'];
                    $total_other_fee+=$this->voucher_model->total_other_fee($selected_voucher['id']);
                    $total_arrear+=$this->voucher_model->getArrearsAmount($selected_voucher['id'],$selected_voucher['student_id']);
                }
                //var_dump($total_remaining);die();
                $values_classwise[$k]['total_expected_fee']=$total_expected_fee;
                $values_classwise[$k]['total_fee_recieved']=$total_fee_recieved;
                $values_classwise[$k]['total_other_fee']=$total_other_fee;
                $values_classwise[$k]['total_arrear']=$total_arrear;
                $values_classwise[$k]['total_remaining']=$total_expected_fee+$total_other_fee+$total_arrear-$total_fee_recieved;
            }
            //var_dump($values_classwise);die();
        }

        $data['values_classwise']=$values_classwise;

        $this->load->view('report/billing_summary_print',$data);
    }
    



   public function all_users()
    {
            $this->user_model->check_permissions("Report/all_users");
             $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                $data['b_header']= $this->report_model->BranchHeader();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['admins'] = $this->report_model->get_all_users();
            $this->load->view('report/all_users_print',$data);
            //$this->load->view('footer',$data);
    }


    public function print_all_users()
        {
                $branch=$this->report_model->getBranch()[0];
                $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                $data['b_header']= $this->report_model->BranchHeader();
                $this->user_model->check_permissions("Report/all_users");
                $data['menu'] = $this->load_model->menu();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                $data['admins'] = $this->report_model->get_all_users();
                $this->load->view('report/all_users_print',$data);
        }

    public function all_roles()
    {
            $this->user_model->check_permissions("Report/all_roles");
             $branch=$this->report_model->getBranch()[0];
              $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                $data['b_header']= $this->report_model->BranchHeader();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['admins'] = $this->report_model->get_all_roles();
           
            $this->load->view('report/all_roles',$data);
          
    
    }

    
     public function permission()
    {
       $this->user_model->check_permissions("report/permission");
     // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->teacher_model->getbranch()->result_array();
         }
         
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/permission',$data);
    }
 
    
    public function fetch_permission()
    {

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        $data['base_url'] =  base_url();
        $data['userInfo'] = $this->userInfo;
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $role=$this->input->post('role');
        $user=$this->input->post('user');
        $qu=$this->db->query("SELECT `admin`.`id`,`first_name`,`last_name`, `username`,`email`, `contact_no` ,`role`.`title`
        FROM `admin` INNER JOIN `role` ON `role`.`id` = `admin`.`role_id`

        WHERE `admin`.`is_delete`='0'

        	AND `role`.`branch_id`='$branch'");
        $data['role'] = $qu->result_array();
        if(!empty($role)){
            $qu=$this->db->query("SELECT `admin`.`id`,`first_name`,`last_name`, `username`,`email`, `contact_no` ,`role`.`title`
        FROM `admin` INNER JOIN `role` ON `role`.`id` = `admin`.`role_id`

        WHERE `admin`.`is_delete`='0'

        	AND `role`.`branch_id`='$branch'
        	AND `admin`.`role_id`='$role'");
            $data['role'] = $qu->result_array();

        }
        if(!empty($role) && !empty($user) ){
            $qu=$this->db->query("SELECT `admin`.`id`,`first_name`,`last_name`, `username`,`email`, `contact_no` ,`role`.`title`
        FROM `admin` INNER JOIN `role` ON `role`.`id` = `admin`.`role_id`

        WHERE `admin`.`is_delete`='0'

        	AND `role`.`branch_id`='$branch'
        	AND `admin`.`role_id`='$role'
        		AND `admin`.`id`='$user'");
            $data['role'] = $qu->result_array();

        }
        $this->load->view('report/permission_report',$data);

    }
         

     public function select_bad_debtors()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/select_bad_debtors',$data);
    }
   public function bad_debtors()
        {
            $start_date = $this->input->post('date');
            $end_date = $this->input->post('edate');
            $data['s_date']= $start_date;
            $data['e_date']= $end_date;
            $branch=$this->report_model->getBranch()[0];
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $this->user_model->check_permissions("Report/all_users");
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['bad_debtors'] = $this->voucher_model->getBadDebtorss($start_date,$end_date);
            $this->load->view('report/bad_debtors_print',$data);
        }



    public function view_branch($p=1)
    {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->user_model->check_permissions("branch/view");
        $data['menu'] = $this->load_model->menu();
        $total = $this->db->query("SELECT count(*) as total FROM `branch`")->result_array()[0]['total'];
        $per_page = 10;
        $offset = ($p - 1) * $per_page;
        $this->db->select("id,name,address,contact,b_head,b_h_contact,c_person,is_delete"); 
        $this->db->from('branch');
        $this->db->limit($per_page,$offset);
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['branches'] = $query->result_array();
        $data['total'] = ceil($total / $per_page);
        //$this->load->view('header',$data);
		//$this->load->view('sidebar',$data);
        $this->load->view('report/Total_branch',$data);
    }

    public function All_classes()
    {

        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        
        $b=$this->report_model->getBranch()[0]['id'];
         $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$b' AND is_delete='0'")->row_array();
         $data['branch_name']=$this->report_model->getBranch()[0]['name'];
         $class = $this->input->post('class');
            $data['section_validator']=$section = $this->input->post('section');
            $query = $this->db->query("SELECT class.class_id,class.tution_fee,class.admin_fee,class.class_name,description,prefix FROM `class`  WHERE class.is_delete='0' and class.branch = '$b' Order By class.orderr ASC");
            if(!empty($class)){
                  $query = $this->db->query("SELECT class.class_id,class.tution_fee,class.admin_fee,class.class_name,description,prefix FROM `class` WHERE class.is_delete='0' and class.branch = '$b' and class.class_id='$class'");
            }
            if(!empty($class) && !empty($section) ){
                  $query = $this->db->query("SELECT class.class_id,class.tution_fee,class.admin_fee,class.class_name,section.description,prefix FROM `class` inner join `section` on section.class_id=class.class_id  WHERE class.is_delete='0' and section.is_delete='0'  and class.branch = '$b' and section.class_id='$class' and section.section_id='$section'");
            }
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['teachers'] = $query->result_array();
        // echo "<pre>";print_r($data['teachers']);exit;
        $this->load->view('report/Class_View',$data);
    }
    
     public function All_sections($q="all",$p=1)
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        if($data['is_super']){
         $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where is_delete='0'")->row_array();
         $data['branch_name']=$data['b_header']['name'];
            $query = $this->db->query("SELECT class.class_name,section.description,section.section_id,section.section_name FROM `section` inner join `class` on class.class_id=section.class_id  WHERE section.is_delete='0'");
        }else{
         $b=$this->report_model->getBranch()[0]['id'];
         $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$b' AND is_delete='0'")->row_array();
         $data['branch_name']=$this->report_model->getBranch()[0]['name'];
         $query = $this->db->query("SELECT class.class_name,section.description,section.section_id,section.section_name FROM `section` inner join `class` on class.class_id=section.class_id  WHERE section.branch = '$b' AND section.is_delete='0'");
        }
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['teachers'] = $query->result_array();
        //echo "<pre>";print_r($data['teachers']);exit;
        $this->load->view('report/Section_View',$data);

     
    }
    
     public function sectionwise_student($q="all",$p=1)
   {
       $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();


          $this->user_model->check_permissions("student/status");
          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
         
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
            
        $q = urldecode($q);
        $p = $p<1?1:$p;
        $per_page = 20;
        $offset = ($p - 1) * $per_page;
          $sq1 = "";
        if($q!="all")
        {
            $sq1 .= "AND (student.grno like '%".$q."%' OR "; 
            $sq1 .= "student.student_name like '%".$q."%' OR ";
            $sq1 .= "student.father_name like '%".$q."%' OR ";
            $sq1 .= "student.father_contact like '%".$q."%' OR ";
            $sq1 .= "class.class_name like '%".$q."%' OR ";
            $sq1 .= "status.name like '%".$q."%' OR ";
            $sq1 .= "section.section_name like '%".$q."%' )";
        }

        $total = @$this->db->query("SELECT count(*) as total FROM `student` inner JOIN promotion ON promotion.student_id=student.id inner JOIN class ON promotion.class_id=class.class_id inner JOIN section ON promotion.section_id=section.section_id  inner join `status` on student.status = status.id WHERE student.branch = '$branch' AND student.status!='0' AND promotion.is_active='1' $sq1 LIMIT $offset, $per_page")->result_array()[0]['total'];
        $query = $this->db->query("SELECT student.*,class.*,section.*,status.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id inner join `status` on student.status = status.id  WHERE student.branch = '$branch' AND student.status!='0' AND promotion.is_active='1' $sq1 LIMIT $offset,$per_page");

        
        $data['q'] = $q;
        $data['curr'] = $p;
        $data['searchq'] = $q;
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['student'] = $query->result_array();
        $data['end'] = ceil($total / $per_page);
            //calling  pages views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/section_wise',$data);


   }
   
    public function fetch_student()
   {
      
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $cl=$this->input->post('class');
        $se=$this->input->post('section');

        if(!empty($cl && $se))
            {
                    $branch=$this->user_model->getbranch();
            //    $data['student'] = $this->db->query("select student.id,student.student_name,student.grno,student.father_name,student.father_contact from `student` inner join `promotion` on student.id=promotion.student_id where promotion.class_id='$cl' and promotion.section_id='$se' AND promotion.is_active='1' AND student.status='0' AND student.branch='$branch'")->result_array();
             $data['student'] = $this->db->query("select student.id,student.student_name,student.sid,student.grno,student.father_name,student.father_contact,class.*,section.* 
             FROM student JOIN promotion
              ON promotion.student_id=student.id 
              JOIN class
              ON promotion.class_id=class.class_id 
              JOIN section 
             ON promotion.section_id=section.section_id 
             where promotion.class_id='$cl' and promotion.section_id='$se' AND promotion.is_active='1' AND student.status='0' AND student.branch='$branch' and class.is_delete=0 and section.is_delete=0")->result_array();

            }
      $this->load->view('report/show_sectionwise',$data);
   }
   
   public function grno_wise()
    {
    	
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->user_model->check_permissions("student/show");
    	$b=$this->user_model->getbranch();
        $query = $this->db->query("SELECT student.*,class.*,section.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id WHERE student.branch = '$b' AND student.status='0' AND promotion.is_active='1' and class.is_delete=0 and section.is_delete=0 ORDER BY student.date_of_admission ASC");
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       $data['branch']=$this->db->select("*")->from("branch")->where('id',$b)->get()->result_array();
    
        $data['student'] = $query->result_array();
	$data['menu'] = $this->load_model->menu();
      
        $this->load->view('report/grno_wise',$data);
    }
    
    public function status_wise($q="all",$p=1)
   {
       $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();


          $this->user_model->check_permissions("student/status");
          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
         
            // if($this->user_model->is_super())
            //     $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            // else
            //     $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
            
        $q = urldecode($q);
        $p = $p<1?1:$p;
        $per_page = 20;
        $offset = ($p - 1) * $per_page;
          $sq1 = "";
        if($q!="all")
        {
            $sq1 .= "AND (student.grno like '%".$q."%' OR "; 
            $sq1 .= "student.student_name like '%".$q."%' OR ";
            $sq1 .= "student.father_name like '%".$q."%' OR ";
            $sq1 .= "student.father_contact like '%".$q."%' OR ";
            $sq1 .= "class.class_name like '%".$q."%' OR ";
            $sq1 .= "status.name like '%".$q."%' OR ";
            $sq1 .= "section.section_name like '%".$q."%' )";
        }

        $total = @$this->db->query("SELECT count(*) as total FROM `student` inner JOIN promotion ON promotion.student_id=student.id inner JOIN class ON promotion.class_id=class.class_id inner JOIN section ON promotion.section_id=section.section_id  inner join `status` on student.status = status.id WHERE student.branch = '$branch' AND student.status!='0' AND promotion.is_active='1' $sq1 LIMIT $offset, $per_page")->result_array()[0]['total'];
        $query = $this->db->query("SELECT student.*,class.*,section.*,status.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id inner join `status` on student.status = status.id  WHERE student.branch = '$branch' AND student.status!='0' AND promotion.is_active='1' $sq1 LIMIT $offset,$per_page");

        
        $data['q'] = $q;
        $data['curr'] = $p;
        $data['searchq'] = $q;
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['student'] = $query->result_array();
        $data['end'] = ceil($total / $per_page);
            //calling  pages views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/status_wise',$data);
    }
    
     public function fetch_status($p=1)
    {
         $q=$this->input->post('status');
                  

        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();


         $this->user_model->check_permissions("student/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();
           
        $query = $this->db->query("SELECT student.*,class.*,section.*,status.*,student.id as stid FROM student JOIN promotion ON promotion.student_id=student.id JOIN class ON promotion.class_id=class.class_id JOIN section ON promotion.section_id=section.section_id inner join `status` on student.status = status.id  WHERE student.branch = '$branch' AND student.status!='0' AND student.status='$q' AND promotion.is_active='1' ");
   
        $data['q'] = $q;
        $data['curr'] = $p;
        $data['searchq'] = $q;
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['student'] = $query->result_array();
  
         $this->load->view('report/show_status',$data);
    }
    
    //add new reports
     public function best_students()
    {
    	 $this->user_model->check_permissions("report/best_students");
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
             if($this->is_super)
            $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0'")->result_array();
            else{
            $data['branch']=$this->db->query("SELECT id,name FROM branch where is_delete=0 AND id='$branch'")->result_array();}
            $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
            $data['exam']=$this->db->query("SELECT `exam`.id,`exam`.name FROM `exam` INNER JOIN `exam_type` ON `exam_type`.`id`=`exam`.`etype_id` where `exam`.is_delete= 0 AND `exam_type`.is_delete= 0 AND `exam_type`.branch_id='$branch'")->result_array();
             $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/best_students',$data);
        //  $this->load->view('footer',$data);
    } 
    
     public function save_best_students()
    {
         $branch=$this->report_model->getBranch();
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;

         $bnch=$this->input->post('branch',true);
         $exam 	= $this->input->post('exam',true);
         $name  = $this->db->select('name')->where('id',$exam)->from('exam')->get()->row_array()['name'];
        // var_dump("<pre>",$name);die;
        $qu=$this->db->query("SELECT student.sid,student.student_name,student.father_name,class.class_name,student.father_contact,best_students.exam_name,result.position FROM best_students
                               JOIN promotion on promotion.id=best_students.promotion_id
                                 JOIN class on class.class_id=promotion.class_id
                                JOIN result on result.promotion_id=best_students.promotion_id
                               join student on student.id=promotion.student_id 
                              WHERE promotion.is_delete=0 and student.is_delete=0 and promotion.is_active=1 and exam_name='$name' and result.exam_id='$exam' ORDER BY result.position ASC ");
      $data['student'] = $qu->result_array();
      
    // var_dump("<pre>",$data['student']);die;
      if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/best_students", "refresh");
        
           }
           else{
        
         $this->load->view('report/show_best_students',$data);
           }

	// $this->load->view('report/show_best_students',$data);
        }
        
        public function fee_defination()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        
        if($data['is_super']){
         $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where is_delete='0'")->row_array();
         $data['branch_name']=$data['b_header']['name'];
        }else{
         $branch=$this->report_model->getBranch()[0]['id'];
         $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->row_array();
         $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        }
        $this->db->select("fee_def.id,fee_def.name,fee_def.amount,class.class_name as c_name,branch.name as b_name"); 
        $this->db->from('fee_def');
        $this->db->join('class','fee_def.class_id = class.class_id');
        $this->db->join('branch','fee_def.branch_id = branch.id');
        $this->db->where('fee_def.is_delete','0');
        if(!$data['is_super'])
        $this->db->where('fee_def.branch_id',$branch);
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['fee'] = $query->result_array();
        $this->load->view('report/fee_defination',$data);
    } 
    
     public function show_month()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/show_month',$data);
    }
    
     public function fetch_defualter()
    {

         $branch=$this->report_model->getBranch()[0];
       // var_dump($branch);
        // die();
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();


    $month= $this->input->post('status');

         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();
         
    $qu=$this->db->query("SELECT `student`.`student_name`, `student`.`sid`, `student`.`grno`, `student`.`father_name`,`student`.`father_contact`,`invoice`.`id` as `invoice_no`,`invoice`.`date`,`class`.`class_name`,`section`.`section_name` 
FROM `invoice` INNER JOIN `promotion` ON `promotion`.`id` = `invoice`.`student_id`
INNER JOIN `student` ON `student`.`id` = `promotion`.`student_id`
INNER JOIN `class` ON `promotion`.`class_id` = `class`.`class_id`
INNER JOIN `section` ON `promotion`.`section_id` = `section`.`section_id`
WHERE `invoice`.`is_delete`='0' 
	AND `invoice`.`branch_id`='$branch' 
    and invoice.status=0 
	AND LEFT(`invoice`.`date`,7)='$month'");
     $data['student'] = $qu->result_array();
      if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/show_month", "refresh");
        
           }
           else{
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/monthly_dafulter',$data);
           }
     
    //  $this->load->view('report/monthly_dafulter',$data);
    }
    
    
    public function fetch_unpaid_voucher()
    {

         $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();

          //  $month=date("Y-m");

		$month_last = date("Y-m",strtotime(date('Y-m')." -1 month"));
     //var_dump($month);
     //  var_dump($month_last);
      // die();
         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();
         
    $qu=$this->db->query("SELECT `student`.`student_name`, `student`.`sid`, `student`.`father_name`,`student`.`father_contact`,`invoice`.`id` as `invoice_no`,`class`.`class_name`,`section`.`section_name` 
FROM `invoice` INNER JOIN `promotion` ON `promotion`.`id` = `invoice`.`student_id`
INNER JOIN `student` ON `student`.`id` = `promotion`.`student_id`
INNER JOIN `class` ON `promotion`.`class_id` = `class`.`class_id`
INNER JOIN `section` ON `promotion`.`section_id` = `section`.`section_id`
WHERE `invoice`.`is_delete`='0' 
	AND `invoice`.`branch_id`='$branch' 
    and invoice.status=0 
	AND LEFT(`invoice`.`date`,7)='$month_last'");
     $data['student'] = $qu->result_array();
    
     $this->load->view('report/last_month_unpadvoucher',$data);
    }
    
     public function show_addmission()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/show_addmission',$data);
    }
    
   public function fetch_addmision_fee()
    {
          $data['s_date'] = $s_date=date('Y-m-d',strtotime($this->input->post('start_date')));
          $data['e_date'] = $e_date=date('Y-m-d',strtotime($this->input->post('end_date')));
      
        $branch= $this->input->post('branch');
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
            $this->db->select('*,invoice.admin_fee as addmission_fee')
                     ->join('promotion','promotion.id=invoice.student_id')
                     ->join('class','promotion.class_id=class.class_id')
                     ->join('section','promotion.section_id=section.section_id')
                     ->join('student','student.id = promotion.student_id');
            $this->db->where('submitted_at >=',$s_date);
            $this->db->where('submitted_at <=',$e_date);
            $this->db->where('invoice.is_admitted','1');
            $this->db->where('invoice.branch_id',$branch);
            $this->db->where('invoice.is_delete',0);
            $this->db->where('invoice.status',1);
 
            $qu= $this->db->get('invoice');        
            $data['student'] = $qu->result_array();
        //   var_dump('<pre>',$data['student']);
        //   die();
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/addmission_fee',$data);
        
    }
    
     public function fee_range()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();

        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/fee_range',$data);
    }
    
      public function fetch_feerange()
    {
          $data['from'] = $from=$this->input->post('from');
          $data['to'] = $to=$this->input->post('to');
      
        $branch= $this->input->post('branch');
        
       $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $this->db->select("student.*,class.*,section.*,invoice.fee_pack,student.id as stid");
                 $this->db->from('student')
                         ->JOIN('promotion','promotion.student_id=student.id')
                         ->JOIN('invoice','invoice.student_id=promotion.id')
                         ->JOIN('class','promotion.class_id=class.class_id')
                         ->JOIN('section','promotion.section_id=section.section_id')
                         ->where('student.branch',$branch)
                         ->where('student.status',0)
                         ->where('student.is_delete',0)
                         ->where('promotion.is_active',1)
                         ->where('class.is_delete',0)
                         ->where('section.is_delete',0)
                         ->where('section.is_delete',0);
                    if(!empty($from)) 
                    {
                        $this->db->where('invoice.fee_pack>=',$from);
                    }
                    if(!empty($to)) 
                    {
                        $this->db->where('invoice.fee_pack<=',$to);
                    }
                    $this->db->group_by('student.id');
                     $this->db->order_by('class.orderr','asc');

            $data['student'] =$this->db->get()->result_array();
            
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/fetch_feerange',$data);

    
    }
     public function month_fee_history()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/month_fee',$data);
    }
    
    public function fetch_monthly_fee()
    {
//echo "Hello";exit;
        // echo "<pre>";print_r($this->input->post());exit;
        $data['branch'] = $branch= $this->input->post('branch');
        $data['class'] = $class= $this->input->post('class');
        $data['section'] = $section= $this->input->post('section');
        $data['month'] = $month= $this->input->post('month');
        $data['status'] = $status= $this->input->post('status');
         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];
        $this->db->select('student.student_name,class.class_name,student.father_name , student.sid,student.grno,invoice.submitted_at,invoice.date_expire,invoice.status,invoice.advance,invoice.recieved,invoice.discount,invoice.is_fine,invoice.fine, invoice.id as invoice_id , student.father_contact,invoice.remaining');
        $this->db->join('promotion','invoice.student_id=promotion.id','inner');
        $this->db->join('student','student.id=promotion.student_id','inner');
        $this->db->join('class','class.class_id=promotion.class_id','inner');
        $this->db->join('section','section.section_id=promotion.section_id','inner');
        $this->db->where('promotion.is_active',1); 
        $this->db->where('class.is_delete',0); 
        $this->db->where('section.is_delete',0); 
        if($branch!=""){
            $this->db->where('student.branch', $branch);
        }
        if($class!=""){
            $this->db->where('promotion.class_id', $class);
        }
        if($section!=""){
            $this->db->where('promotion.section_id', $section);
        }
        if($month!=""){
            $this->db->where('left(invoice.date,7)=',$month);
        }
        if($status == 1){
            $this->db->where('invoice.status',1);
            $this->db->where('invoice.remaining',0);
        }elseif($status == 2){
            $this->db->where('invoice.status',1);
            $this->db->where('invoice.remaining >',0);
        }elseif($status == 3){
            $this->db->where('invoice.status',0);
        }
        $this->db->where('invoice.is_auto',0);
        $query = $this->db->get('invoice');
     $data['student'] = $query->result_array();
     //echo "<pre>";print_r($data['student']);exit;
    $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='".$branch."' AND `is_delete`='0'")->result_array()[0];
	foreach ($data['student'] as $key => $value) {
          if($value['remaining'] == 0 && $value['status'] == 1){$data['student'][$key]['fee_total']=(($value['recieved']+$value['discount']) - ($value['fine'] + $value['advance']));}
          elseif($value['remaining'] > 0 && $value['status'] !=0){$data['student'][$key]['fee_total']=(($value['recieved']+$value['discount']+$value['remaining']) - $value['fine']);}
          else{$data['student'][$key]['fee_total']=$this->voucher_model->countTotalFee($value['invoice_id']);}
	}

         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
          $this->load->view('report/monthly_fee_history',$data);
         
    }
    
    public function studentatt_reportview()
    {
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $mydate=null;
        if($this->input->post()){
            $postdata=$this->input->post();
            if(isset($postdata['Datesubmit'])) {
                //var_dump($this->input->post('date'));die();
                $mydate=$this->input->post('date');
              //  var_dump($mydate);
            //    die();
            }
        }
            $branch=$this->branch;
            //$branch=2;
         //   var_dump('<pre>',$branch,$mydate);
          // die();
            //$exam=$this->input->post('exam');
            //$data['examtype']=$exam;
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['student']=$this->db->query("
          SELECT section.section_name,class.class_name,attendancestatus.status,studentatt.date,COUNT(attendancestatus.status) as totalst
FROM `studentatt` INNER JOIN promotion on promotion.id=studentatt.promotion_id 
INNER JOIN class on class.class_id=promotion.class_id 
INNER JOIN section on section.section_id=promotion.section_id 
INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id 
INNER JOIN student on student.id=studentatt.student_id
 WHERE studentatt.is_deleted=0 and promotion.is_active=1 and promotion.is_delete=0 AND studentatt.date='$mydate' AND student.branch='$branch'
 GROUP BY  section.section_name , class.class_name, attendancestatus.status
 ")->result_array();
            
          //  var_dump($data['student']);
          // die();
        
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
           
            $this->load->view('report/student_att',$data);
          
    }
    
      public function studentatt_datewise()
    {
        //  $branch=$this->report_model->getBranch()[0];
        // $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        // $data['b_header']= $this->report_model->BranchHeader();


        if($this->input->post()){
            $postdata=$this->input->post();
            if(isset($postdata['Datesubmit'])) {
                //var_dump($this->input->post('date'));die();
                $data['mydate']=$this->input->post('date');
            }
        }
            $branch=$this->branch;
           
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
           
            
           // var_dump($data['att_present']);die();
            // SELECT count(id) FROM promotion WHERE class_id=5 AND section_id=5 and is_active=1 AND is_delete=0
            // $this->db->order_by("name", "asc");
            //var_dump($data);die();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
             $this->load->view('header',$data);
             $this->load->view('sidebar',$data);
            $this->load->view('report/studentatt_datewise',$data);
             $this->load->view('footer',$data);
    }
    
     public function studentatt_classwise()
    {
        $this->user_model->check_permissions("student/studentatt_add");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->student_model->getbranch()->result_array();
         }
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/studentatt_classwise',$data);
    }
    
public function fetch_studentatt_classwise()
    {

         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $class=$this->input->post('branch');
        $month=$this->input->post('date');
        $branch=$this->user_model->getbranch();

        $data['student']=$this->db->query("SELECT section.section_name,student.father_name,class.class_name,studentatt.date,student.grno ,attendancestatus.status,student.student_name 
                     FROM `studentatt` INNER JOIN promotion on promotion.id=studentatt.promotion_id 
                                INNER JOIN class on class.class_id=promotion.class_id 
                                INNER JOIN section on section.section_id=promotion.section_id 
                                INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id 
                                INNER JOIN student on student.id=studentatt.student_id
             WHERE studentatt.is_deleted=0 and promotion.is_active=1 
             and promotion.is_delete=0
             and class.class_id='$class' 
                          and LEFT(date,7)='$month'
                          and student.branch='$branch'")->result_array();

          if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/studentatt_classwise", "refresh");
        
           }
           else{
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
          $this->load->view('report/display_monthly_studentatt',$data);
           }
         
        //  $data['base_url'] = base_url();
        //  $data['userInfo'] = $this->userInfo;
        
       
        //  $this->load->view('report/display_monthly_studentatt',$data);
    }
    
    public function studentatt_sectionwise()
    {
        $this->user_model->check_permissions("student/studentatt_add");
         $branch = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
      if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array(); 
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/studentatt_sectionwise',$data); 
    }

    
      public function fetch_studentatt_sectionannual()
    {
          $this->user_model->check_permissions("Report/studentatt_sectionwise");
        $data['menu'] = $this->load_model->menu();
        
            	$branch=$this->input->post('branch');
    	$data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];
         $class=$this->input->post('class');
         $section=$this->input->post('section');
       
    // var_dump('<pre>',$class,$section,$month,$branch);
      //die();

         $data['class'] = $class;
         $data['section'] = $section;
         $data['month']=$this->db->query(" 
         SELECT left(studentatt.date,7) as month,count(studentatt.id) as total
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id
         INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class'    
         AND left(studentatt.date,4) = left(CURDATE(),4)
         GROUP BY LEFT(studentatt.date,7) 
         ")->result_array();
         $data['student'] = $this->db->query("SELECT count(*) as total FROM `student` INNER JOIN `promotion` ON `promotion`.`student_id`=`student`.`id` inner join `class` on `class`.`class_id`=`promotion`.`class_id` inner join `section` on `section`.`section_id`=`promotion`.`section_id`  WHERE `student`.`status`='0' AND `student`.`branch`='$branch' AND `promotion`.`class_id`='$class' AND `promotion`.`section_id`='$section' AND `promotion`.`is_active`='1' AND `promotion`.`is_delete`='0' and `class`.`is_delete`=0 and `section`.`is_delete`=0")->result_array()[0]['total'];

                       // var_dump($data['student']);
                         // die();
          if(empty($data['month']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/studentatt_sectionwise", "refresh");
        
           }
           else{
             $data['base_url'] = base_url();
             $data['userInfo'] = $this->userInfo;
             $this->load->view('header',$data);
             $this->load->view('sidebar',$data); 
             $this->load->view('report/studentatt_sectionannual',$data);
           }


        //  $data['base_url'] = base_url();
        //  $data['userInfo'] = $this->userInfo;
        //  $this->load->view('report/display_studentatt_sec',$data);
    }

    public function fetch_studentatt_sectionmonth($month="",$class="",$section="")
    {
        
        $data['class']=$this->db->query("SELECT class.class_name
         FROM `class`
         where class.is_delete='0'
         and class.class_id=$class")->result_array();
         $data['section']=$this->db->query("SELECT section.section_name
         FROM `section`
         where section.is_delete='0'
         and section.section_id=$section")->result_array();
        $data['month'] = $month;
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
    
      $branch=$this->user_model->getbranch();
        
         $data['totaldays']=@$this->db->query("SELECT count(distinct(studentatt.date)) as totaldays,section.section_name
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id
         INNER JOIN student on student.id=studentatt.student_id 
         
         WHERE studentatt.is_deleted=0 
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         
         ")->result_array();
         
          $data['present']=@$this->db->query("SELECT  count(studentatt.status_id) as present,studentatt.student_id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and student.is_delete=0  
          and student.status=0  
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         AND studentatt.status_id=1
         GROUP BY studentatt.student_id
         ")->result_array();
        // var_dump($data['present']);die;
         $data['absnt']=@$this->db->query("SELECT  count(studentatt.status_id) as absent,studentatt.student_id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and student.is_delete=0  
          and student.status=0  
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         AND studentatt.status_id=2
         GROUP BY studentatt.student_id
         ")->result_array();
          $data['leave']=@$this->db->query("SELECT  count(studentatt.status_id) as leav,studentatt.student_id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and student.is_delete=0  
          and student.status=0  
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         AND studentatt.status_id=3
         GROUP BY studentatt.student_id
         ")->result_array();
         $data['holiday']=@$this->db->query("SELECT  count(studentatt.status_id) as leav,studentatt.student_id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and student.is_delete=0  
          and student.status=0  
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         AND studentatt.status_id=7
         GROUP BY studentatt.student_id
         ")->result_array();
          $data['tardy']=@$this->db->query("SELECT  count(studentatt.status_id) as tardy,studentatt.student_id
         FROM `studentatt` 
         INNER JOIN promotion on promotion.id=studentatt.promotion_id 
         INNER JOIN class on class.class_id=promotion.class_id 
         INNER JOIN section on section.section_id=promotion.section_id 
         INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id INNER JOIN student on student.id=studentatt.student_id 
         WHERE studentatt.is_deleted=0 
         and student.is_delete=0  
          and student.status=0  
         and promotion.is_active=1 
         and promotion.is_delete=0 
         AND student.branch='$branch'
         AND section.section_id='$section' 
         AND class.class_id='$class' 
         AND studentatt.status_id=4
         GROUP BY studentatt.student_id
         ")->result_array();
         $data['studall']=@$this->db->query("SELECT distinct(student.id) as sid,student.grno, promotion.id,section.section_name,class.class_name,student.father_contact as contact,student.student_name, student.grno,student.father_name
                     FROM `student` INNER JOIN promotion on promotion.student_id=student.id 
                     INNER JOIN class on class.class_id=promotion.class_id 
                     INNER JOIN section on section.section_id=promotion.section_id 
                                                     WHERE student.is_delete=0  
                                  and student.status=0  
                                                     
                                                     and promotion.is_active=1 
                                                     and promotion.is_delete=0 
                                                     AND student.branch='$branch'
                                                     AND section.section_id='$section' 
                                                     AND class.class_id='$class'
                                                    and section.section_id='$section'")->result_array();
        $data['student']=$this->db->query("SELECT student.id,section.section_name,student.father_name,class.class_name,student.student_name,student.sid  
                     FROM `student` INNER JOIN promotion on promotion.student_id=student.id 
                                INNER JOIN class on class.class_id=promotion.class_id 
                                INNER JOIN section on section.section_id=promotion.section_id 
                                                     WHERE  promotion.is_active=1 
                                and student.is_delete=0  
                                  and student.status=0  
                          and promotion.is_delete=0
                          and class.class_id='$class' 
                          and section.section_id='$section'")->result_array();

        foreach ($data['student'] as $key => $student) {
            $data['student'][$key]['dates'] = $this->db->query("SELECT DISTINCT (studentatt.date),attendancestatus.status FROM studentatt INNER JOIN attendancestatus on attendancestatus.id=studentatt.status_id  WHERE studentatt.student_id = $student[id] AND LEFT(studentatt.date,7)='$month'")->result_array(); 
        }
        
        //   echo'<pre>'; print_r($data['student']);die;  
        
        if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/studentatt_sectionwise", "refresh");
        
           }
        else{

         $data['base_url'] = base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/display_studentatt_sec',$data);
           }
    }
    
    
     public function staffatt_daily()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();    
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/staffatt_daily',$data);
    }
    
     public function fetch_staff_daily()
    {
            
           	$branch=$this->input->post('branch');
    	$data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];

         $date=date('Y-m-d',strtotime($this->input->post('date')));
       
          $status=$this->input->post('status');
        
        
     

//var_dump( $branch);
//die();
        $data['staff']=$this->db->query("SELECT staff.firstname,staff.cnic,staff.contact,staff.designation,staffatt.date,attendancestatus.status 
                                  FROM `staffatt` INNER JOIN `staff` on staff.id=staffatt.staff_id 
                                   INNER JOIN `attendancestatus` on attendancestatus.id=staffatt.status_id
                                   where staffatt.is_deleted=0 and staff.branch='$branch' and staffatt.status_id='$status' and staffatt.date='$date'")->result_array();
                                   if($date){
                                       $data['staff']=$this->db->query("SELECT staff.firstname,staff.cnic,staff.contact,staff.designation,staffatt.date,attendancestatus.status 
                                  FROM `staffatt` INNER JOIN `staff` on staff.id=staffatt.staff_id 
                                   INNER JOIN `attendancestatus` on attendancestatus.id=staffatt.status_id
                                   where staffatt.is_deleted=0 and staff.branch='$branch' and staffatt.date='$date'")->result_array();
                                   }
                                   if($status){
                                       $data['staff']=$this->db->query("SELECT staff.firstname,staff.cnic,staff.contact,staff.designation,staffatt.date,attendancestatus.status 
                                  FROM `staffatt` INNER JOIN `staff` on staff.id=staffatt.staff_id 
                                   INNER JOIN `attendancestatus` on attendancestatus.id=staffatt.status_id
                                   where staffatt.is_deleted=0 and staff.branch='$branch' and staffatt.status_id='$status' and staffatt.date='$date'")->result_array();
                                   }
         

           if(empty($data['staff']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/staffatt_daily", "refresh");
        
           }
           else{
                      $data['base_url'] = base_url();
                      $data['userInfo'] = $this->userInfo;
                      $this->load->view('report/fetch_staffatt_daily',$data);
           }

        // $data['base_url'] = base_url();
        // $data['userInfo'] = $this->userInfo;
        // $this->load->view('report/fetch_staffatt_daily',$data);
    }
    
     public function teacheratt_daily()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
                  
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
                   
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/teacheratt_daily',$data);
    }
    
    public function fetch_teacher_daily()
    {
            
                      $type=$this->input->post('type');
            	$branch=$this->input->post('branch');
    	$data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];
        $date=date('Y-m-d',strtotime($this->input->post('date')));
        //  $date=$this->input->post('date');
          $status=$this->input->post('status');
        
      $branch=$this->user_model->getbranch();
         if($type=='teacher'){
        $data['teacher']=$this->db->query("SELECT teacher.firstname,teacher.cnic,teacher.contact,teacher.designation,teacherattendance.date,leave_types.name as status 
                                  FROM `teacherattendance` INNER JOIN teacher on teacher.id=teacherattendance.teacher_id 
                                   INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
                                   where teacherattendance.date='$date' and teacherattendance.status_id='$status' and teacher.branch='$branch' and leave_types.branch='$branch' and teacherattendance.is_deleted=0")->result_array();
                                   if($date){
                                       $data['teacher']=$this->db->query("SELECT teacher.firstname,teacher.cnic,teacher.contact,teacher.designation,teacherattendance.date,leave_types.name as status 
                                  FROM `teacherattendance` INNER JOIN teacher on teacher.id=teacherattendance.teacher_id 
                                   INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
                                   where teacherattendance.date='$date' and teacher.branch='$branch' and leave_types.branch='$branch' and teacherattendance.is_deleted=0")->result_array();
                                       
                                   }
                                   if($status){
                                       $data['teacher']=$this->db->query("SELECT teacher.firstname,teacher.cnic,teacher.contact,teacher.designation,teacherattendance.date,leave_types.name as status 
                                  FROM `teacherattendance` INNER JOIN teacher on teacher.id=teacherattendance.teacher_id 
                                   INNER JOIN leave_types on leave_types.id=teacherattendance.status_id
                                   where teacherattendance.date='$date' and teacherattendance.status_id='$status' and teacher.branch='$branch' and leave_types.branch='$branch' and teacherattendance.is_deleted=0")->result_array();
                                       
                                   }
                                   
         }        
          if($type=='staff'){
                $data['teacher']=$this->db->query("SELECT staff.firstname,staff.cnic,staff.contact,staff.designation,staffatt.date,leave_types.name as status 
                                  FROM `staffatt` INNER JOIN `staff` on staff.id=staffatt.staff_id 
                                   INNER JOIN `leave_types` on leave_types.id=staffatt.status_id
                                   where staffatt.is_deleted=0 and staff.branch='$branch' and leave_types.branch='$branch' and staffatt.status_id='$status' and staffatt.date='$date'")->result_array();
                                   if($date){
                                       $data['teacher']=$this->db->query("SELECT staff.firstname,staff.cnic,staff.contact,staff.designation,staffatt.date,leave_types.name as status
                                  FROM `staffatt` INNER JOIN `staff` on staff.id=staffatt.staff_id 
                                   INNER JOIN `leave_types` on leave_types.id=staffatt.status_id
                                   where staffatt.is_deleted=0 and staff.branch='$branch' and leave_types.branch='$branch' and staffatt.date='$date'")->result_array();
                                   }
                                   if($status){
                                       $data['teacher']=$this->db->query("SELECT staff.firstname,staff.cnic,staff.contact,staff.designation,staffatt.date,leave_types.name as status 
                                  FROM `staffatt` INNER JOIN `staff` on staff.id=staffatt.staff_id 
                                   INNER JOIN `leave_types` on leave_types.id=staffatt.status_id
                                   where staffatt.is_deleted=0 and staff.branch='$branch' and leave_types.branch='$branch' and staffatt.status_id='$status' and staffatt.date='$date'")->result_array();
                                   }
         
          }
           if(empty($data['teacher']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/teacheratt_daily", "refresh");
        
           }
           else{
                     $data['base_url'] = base_url();
                   $data['userInfo'] = $this->userInfo;
                    $this->load->view('report/fetch_teacheratt_daily',$data);
           }

       
    }
    
     public function all_teacher()
    {
          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->user_model->check_permissions("teacher/show");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
       
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        
        $query = $this->db->query("
        SELECT id,firstname,lastname,designation,contact,qualification,doj,dob,salery,specialization 
        FROM `teacher`
        WHERE branch = '$branch' 
        AND status='0' 
        AND is_delete='0'");

        $data['teachers'] = $query->result_array();

             $this->load->view('report/All_teacher',$data);
    }
    
     public function teacher_status()
   {
        $this->user_model->check_permissions("teacher/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->user_model->getbranch();      

        $query = $this->db->query("SELECT teacher.id,teacher.firstname,teacher.lastname,teacher.designation,teacher.contact,teacher.qualification,teacher.doj,teacher.dob,teacher.salery,teacher.specialization ,status.name FROM `teacher` inner join `status` on teacher.status = status.id   WHERE teacher.branch = '$branch' AND teacher.is_delete='0'");

        $data['teachers'] = $query->result_array();
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/teacher_status',$data);


   }
   
    public function fetch_teacher_status()
   {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $status=$this->input->post('status');
        $teacher=$this->input->post('teacher');
        $data['from']=$this->input->post('from');
        $from=$this->input->post('from');
        
        $data['to']=$this->input->post('to');
        $to=$this->input->post('to');
        //  var_dump($status);die;
        
        $this->user_model->check_permissions("teacher/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->user_model->getbranch();      

          $this->db->select('teacher.*');
                    $this->db->from('teacher');
                    $this->db->where('teacher.is_delete','0');
                    $this->db->where('teacher.branch',$branch);
                    if(!empty($status))
                    {
                    $this->db->where('teacher.status',$status);
                    }
                    if(!empty($teacher))
                    {
                    $this->db->where_in('teacher.id',$teacher);
                    }
                    if(!empty($from))
                    {
                    $this->db->where('teacher.doj >',$from);
                    }
                    if(!empty($to))
                    {
                    $this->db->where('teacher.doj <',$to);
                    }
                  $this->db->order_by('s_level',"DESC");  
        $data['teachers'] = $this->db->get()->result_array();
        
        $this->load->view('report/status_wise_teacher',$data);
   }
   
    public function best_teacher()
    {
          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        $this->user_model->check_permissions("teacher/show");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        
       
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        
        $query = $this->db->query("SELECT teacher.firstname,teacher.designation,teacher.contact,teacher.qualification,teacher.specialization
        FROM `best_teachers` inner join teacher on teacher.id=best_teachers.teacher_id 
        WHERE teacher.branch = '$branch' AND teacher.is_delete='0' and teacher.id=best_teachers.teacher_id");

        $data['teachers'] = $query->result_array();

             $this->load->view('report/best_teacher',$data);
    }
    
    public function All_staff()
     {
          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $this->user_model->check_permissions("staff/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $branch=$this->user_model->getBranch();
        
        $query = $this->db->query("SELECT id,firstname,lastname,designation,contact,qualification,doj,dob,salery 
        FROM `staff` WHERE branch = '$branch' AND status='0'");
        
        $data['staffs'] = $query->result_array();
        $this->load->view('report/All_staff_report',$data);
    }
    
    public function Staff_status()
     {
        $this->user_model->check_permissions("staff/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->user_model->getBranch();
     
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/staff_status',$data);


    }
    
    //  public function fetch_All_staff()
    //  {
    //       $branch=$this->report_model->getBranch()[0];
    //     $data['branch_name']=$this->report_model->getBranch()[0]['name'];
    //     $data['b_header']= $this->report_model->BranchHeader();

        
    //      $status=$this->input->post('status');
    //     //  var_dump($status);
    //     //  die();
    //     $this->user_model->check_permissions("staff/status");
    //     $data['is_super'] = $this->user_model->is_super();
    //     $data['menu'] = $this->load_model->menu();
    //     $data['base_url'] = base_url();
    //     $data['userInfo'] = $this->userInfo;
        
    //     $branch=$this->user_model->getBranch();
        
    //       $query = $this->db->query("SELECT staff.id,staff.firstname,staff.lastname,staff.designation,staff.contact,staff.qualification,staff.doj,staff.dob,staff.salery,status.name
    //      FROM `staff` inner join `status` on staff.status = status.id
    //      WHERE staff.branch = '$branch' AND status!='0' and staff.status='$status'");
        
    //     $data['staffs'] = $query->result_array();
    //     $this->load->view('report/fetch_All_staff',$data);
    // }
     public function fetch_All_staff()
   {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
       $status=$this->input->post('status');
       $staff=$this->input->post('staff');
        $data['from']=$this->input->post('from');
            $from=$this->input->post('from');
        
        $data['to']=$this->input->post('to');
         $to=$this->input->post('to');
        //  var_dump($status);die;
        
        $this->user_model->check_permissions("staff/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->user_model->getbranch();      

          $this->db->select('staff.*');
                    $this->db->from('staff');
                    // $this->db->join('status', 'staff.status=status.id');
                    $this->db->where('staff.is_delete','0');
                    $this->db->where('staff.branch',$branch);
                    if(!empty($status))
                    {
                    $this->db->where('staff.status',$status);
                    }
                    if(!empty($staff))
                    {
                    $this->db->where_in('staff.id',$staff);
                    }
                    if(!empty($from))
                    {
                    $this->db->where('staff.doj >',$from);
                    }
                    if(!empty($to))
                    {
                    $this->db->where('staff.doj <',$to);
                    }
                $this->db->order_by('s_level',"DESC");   
        $data['staffs'] = $this->db->get()->result_array();
        //  var_dump($data['teachers']);die;
         
       
        $this->load->view('report/fetch_All_staff',$data);
   }
    
    public function Subject_allocation()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
            $branch=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->studentmo->getbranch()->result_array();
            // $branch=$this->studentmo->getbranch()->result_array();
         }
     
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/allocation",$data);
        $this->load->view("footer");
    }

         public function fetch_allocation()
    {
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

          $class=$this->input->post('class');
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
            $branch=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->studentmo->getbranch()->result_array();
           
            // $branch=$this->studentmo->getbranch()->result_array();
         }
       
        $query = $this->db->query("SELECT teacher.firstname as fname, teacher.lastname as lname, class.class_name, subject.name FROM `teacheralloc` inner join teacher on teacher.id = teacheralloc.teacher_id INNER JOIN class on class.class_id = teacheralloc.class_id INNER JOIN subject on subject.id = teacheralloc.subject_id WHERE class.branch = '$branch' AND teacher.is_delete = '0' AND subject.is_deleted = '0' AND class.is_delete = '0'");

        $data['subject'] = $query->result_array();
        if($class){
             $query = $this->db->query("SELECT teacher.firstname as fname, teacher.lastname as lname, class.class_name, subject.name FROM `teacheralloc` inner join teacher on teacher.id = teacheralloc.teacher_id INNER JOIN class on class.class_id = teacheralloc.class_id INNER JOIN subject on subject.id = teacheralloc.subject_id WHERE class.class_id=$class and class.branch = '$branch' AND teacher.is_delete = '0' AND subject.is_deleted = '0' AND class.is_delete = '0'");

        $data['subject'] = $query->result_array();
        }
        
        //var_dump($data['subject']);die();
    
        $this->load->view("report/subject_allocation",$data);
     
    }

     public function all_subject_report()
    {
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
            $branch=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->studentmo->getbranch()->result_array();
           
            // $branch=$this->studentmo->getbranch()->result_array();
         }
       
        $query = $this->db->query("SELECT subject.id, subject.name
        FROM `subject` inner join `class` on class.class_id=subject.class_id 
         WHERE class.branch = '$branch' AND is_deleted='0'");

        $data['subject'] = $query->result_array();
    
        $this->load->view("report/all_subject",$data);
     
    }
    
     public function Subject_class_wise()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
            $branch=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->studentmo->getbranch()->result_array();
            // $branch=$this->studentmo->getbranch()->result_array();
         }
     
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/subject_class_wise",$data);
        $this->load->view("footer");
    }
    
     public function fetch_subject_alloc()
    {
        $branch = $this->report_model->getBranch()[0];
        $data['branch_name'] = $this->report_model->getBranch()[0]['name'];
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['is_super'] = $this->user_model->is_super();
        $b=$this->report_model->getBranch()[0]['id'];
        $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$b' AND is_delete='0'")->row_array(); $data['branch_name']=$this->report_model->getBranch()[0]['name'];

        if ($this->input->post()) {
            $branch = $this->input->post('branch');
            $class = $this->input->post('class');
            $section = $this->input->post('section');
            $teacher = $this->input->post('teacher');
            $subject = $this->input->post('subject');

            if(empty($branch))
            {
                $branch =$this->report_model->getBranch()[0]['id'];
            }
            $data['branch']=$branch;
            $data['class']=$class;
            $data['section']=$section;
            $data['teacher']=$teacher;
            $data['subject']=$subject;

            $this->db->SELECT('teacher.firstname as fir,teacher.status as st,class.class_name as clas,subject.name as sub,section.section_name as sec')->FROM('teacher');
            $this->db->JOIN('teacheralloc', 'teacher.id=teacheralloc.teacher_id');
            $this->db->JOIN('class', 'teacheralloc.class_id=class.class_id');
            $this->db->JOIN('subject' , 'teacheralloc.subject_id=subject.id');
            $this->db->JOIN('section','teacheralloc.section_id=section.section_id');
            $this->db->where('teacher.is_delete',0);
            $this->db->where('teacheralloc.is_deleted',0);
            $this->db->where('class.is_delete',0);
            $this->db->where('subject.is_deleted',0);
            $this->db->where('section.is_delete',0);
            $this->db->where('section.is_delete',0);


            if($class!=""){
                $this->db->where('teacheralloc.class_id', $class);
            }

            if($subject!=""){
                $this->db->where('teacheralloc.subject_id', $subject);
            }

            if($section!=""){
                $this->db->where('teacheralloc.section_id', $section);
            }

            if($teacher!=""){
                $this->db->where('teacheralloc.teacher_id', $teacher);
            }
            $data['query']=$this->db->get()->result_array();
        $this->load->view("report/fetch_subject_alloc", $data);
    }
    }
    
    public function fetch_subject_classwise()
    {
              $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $class=$this->input->post('class');
        //var_dump($class);
        //die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
            $branch=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->studentmo->getbranch()->result_array();
           
            // $branch=$this->studentmo->getbranch()->result_array();
         }
         
         $query = $this->db->query("SELECT subject.name,class.class_name
         FROM `subject` 
         inner join class on class.class_id=subject.class_id 
          WHERE class.branch='$branch' and subject.is_deleted=0 and class.is_delete=0");
         
         
        $data['subject'] = $query->result_array();
        if($class){
            $query = $this->db->query("SELECT subject.name,class.class_name
         FROM `subject` 
         inner join class on class.class_id=subject.class_id 
          WHERE subject.class_id='$class' and class.branch='$branch' and subject.is_deleted=0 and class.is_delete=0");
         
         
        $data['subject'] = $query->result_array();
        }
       
          $this->load->view("report/fetch_subject_class_wise",$data);
    }
    
     public function Subject_section_wise()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
            $branch=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->studentmo->getbranch()->result_array();
            // $branch=$this->studentmo->getbranch()->result_array();
         }
     
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/subject_section_wise",$data);
        $this->load->view("footer");
    }
    
    public function fetch_subject_sectionwise()
    {
              $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        $class=$this->input->post('class');
        $section=$this->input->post('section');
        //var_dump($class);
        //die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
            $branch=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->studentmo->getbranch()->result_array();
           
            // $branch=$this->studentmo->getbranch()->result_array();
         }
         
         $query = $this->db->query("SELECT subject.name,class.class_name,section.section_name 
         FROM `subject` 
         inner join class on class.class_id=subject.class_id 
         inner join section on section.section_id=subject.section_id 
          WHERE subject.class_id='$class' and subject.section_id='$section' and class.branch='$branch' and subject.is_deleted=0 and class.is_delete=0");
         
         
        $data['subject'] = $query->result_array();
       
          $this->load->view("report/fetch_subject_section_wise",$data);
    }
    
     public function Exam_notes()
    {
     $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        
        $this->user_model->check_permissions("exam/viewnote");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        
           $d=$this->db->select("note.id,note.note")->from("note")->where("note.is_delete","0")->get()->result_array();
        else
            $d=$this->db->select("note.id,note.note")->from("note")->where("note.is_delete","0")->where("branch_id",$this->branch)->get()->result_array();
        

        $data["data"]=$d;
        $data["i"]=1;

        $this->load->view("report/exam_notes",$data);
    }
    
    public function view_salary_staff()
    {
        $this->user_model->check_permissions("salary/view_salary");
        $data=$this->sm->up();
       $this->sm->down("report/view_staff_salary",$data);
    }
    
     public function monthly_salary_view_staff()
    {
       if($this->input->post()){
         
        
        $data=$this->input->post();
        //$data=$this->sm->up();
        $field=$this->input->post();
        //$type=$field['type'];
        $type="staff";
        $month=$field['month'];
       
        $d=$this->sm->get('salary',$month,$type);
        $date=date('Y-m');
        $current= date_parse($date);
        $sel=date_parse($month);
        $data['type']=$type;
        $data['month']=$month;
        $data['allonce']=$this->sm->get_assign_allonce($type,$month);
        $data['employee']=$this->sm->salary_emp($type,$month);
        $data['advance']=$this->sm->advance_all($type,$month);
        $data['deduction']=$this->sm->deduction_all($type,$month);
        $data['security']=$this->sm->security_all($type,$month);
       
       
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
         //$this->sm->down("report/fetch_monthly_salery_staff",$data);
        $this->load->view("report/fetch_monthly_salery_staff",$data);
       }
       }
       
        public function view_salary_teacher()
    {
        $this->user_model->check_permissions("salary/view_salary");
        $data=$this->sm->up();
       $this->sm->down("report/view_teacher_salary",$data);
    }
    
     public function monthly_salary_view_teacher()
    {
       if($this->input->post()){
         
        
        $data=$this->input->post();
        //$data=$this->sm->up();
        $field=$this->input->post();
        //$type=$field['type'];
        $type="teacher";
        $month=$field['month'];
       
        $d=$this->sm->get('salary',$month,$type);
        $date=date('Y-m');
        $current= date_parse($date);
        $sel=date_parse($month);
        $data['type']=$type;
        $data['month']=$month;
        $data['allonce']=$this->sm->get_assign_allonce($type,$month);
        $data['employee']=$this->sm->salary_emp($type,$month);
        $data['advance']=$this->sm->advance_all($type,$month);
        $data['deduction']=$this->sm->deduction_all($type,$month);
        $data['security']=$this->sm->security_all($type,$month);
       
       
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
         //$this->sm->down("report/fetch_monthly_salery_staff",$data);
        $this->load->view("report/fetch_monthly_salery_teacher",$data);
       }
       }
       
       public function payroll_advance()
    {
        $this->user_model->check_permissions("salary/index");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/advance",$data);
        $this->load->view("footer");
    }
    
     public function getemp_advance()
    {
     
        
     $value=$this->input->post('type');
      $month=$this->input->post('month');
     
                 if($value=="teacher")
                 {
                 
        
                    // $data=$this->salary_model->Advance_teacher($value);
                      $this->db->select('advancesal.id,advancesal.refrence,teacher.firstname,teacher.salery,teacher.lastname,advancesal.Amount,advancesal.month');    
                        $this->db->from('advancesal');
                         $this->db->join('teacher', 'teacher.id=advancesal.bothid');
                    $this->db->where('advancesal.refrence',$value )->where('advancesal.is_delete',0)->where('advancesal.is_used',0)->where('advancesal.month',$month);
                    $query = $this->db->get();
                       $data['res']= $query->result_array();
                       if( empty($data['res']))
                       {
                       $this->session->set_flashdata('msg','Record Not Found');
                           redirect("Report/payroll_advance", "refresh");
                      }
                      else{
                      $branch=$this->report_model->getBranch()[0];
                     $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                      $data['b_header']= $this->report_model->BranchHeader();
                       $this->load->view("report/fetch_payroll_advance",$data);
                       }
                 }
                
            
             else if($value=="staff"){
             
        
                    // $data=$this->salary_model->Advance_staff($value);
                     $this->db->select('advancesal.id,advancesal.refrence,staff.firstname,staff.lastname,advancesal.Amount,advancesal.month');    
                        $this->db->from('advancesal');
                             $this->db->join('staff', 'staff.id=advancesal.bothid');
                          $this->db->where('advancesal.refrence',$value )->where('advancesal.is_delete',0)->where('advancesal.is_used',0)->where('advancesal.month',$month);
                                  $query = $this->db->get();
                               $data['res']= $query->result_array();
                               if( empty($data['res']))
                       {
                             $this->session->set_flashdata('msg','Record Not Found');
                           redirect("Report/payroll_advance", "refresh");
                      }
                      else{
                      $branch=$this->report_model->getBranch()[0];
                     $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                      $data['b_header']= $this->report_model->BranchHeader();
                       $this->load->view("report/fetch_payroll_advance",$data);
                       }
                               
          
             }
    }
    
    
  public function direct_sentence()
     {

 $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        //$this->user_model->check_permissions("staff/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/direct_sentence',$data);
          $this->load->view("footer");
    }

 public function select_direct_sentence_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=32 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/direct_sentence", "refresh");
        
           }
else{
    $this->load->view('report/fetch_direct_key',$data);
    }
}

 public function indirect_sentence()
     {
           $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
        //$this->user_model->check_permissions("staff/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/indirect_sentence',$data);
          //$this->load->view("footer");
    }

    public function select_indirect_sentence_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=33 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/indirect_sentence", "refresh");
        
           }
else{
    $this->load->view('report/fetch_indirect_key',$data);
    }
}
    
    public function select_fee_received()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/show_date_fee',$data);
        // $this->load->view('footer',$data);
    
    }
    
     public function fetch_daily_fee()
    {
        $class =$this->input->post('class', TRUE);
        $date=date('Y-m-d',strtotime($this->input->post('date')));
        $to_date=date('Y-m-d',strtotime($this->input->post('to_date')));
        $data['status'] = $status= $this->input->post('status');
        $branch= $this->input->post('branch');
        $data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];
    // var_dump($date);
    // die();
        $data['menu'] = $this->load_model->menu();
    $data['mydate']=$date;
    
         $this->db->select('student.student_name,fee_submit_logs.student_id as s_id,fee_submit_logs.id as flog_id,invoice.fee_deposit_type,invoice.status, student.father_name , student.sid,invoice.submitted_at,fee_submit_logs.inv_id,fee_submit_logs.fine as fine,fee_submit_logs.discount as discount,fee_submit_logs.advance,fee_submit_logs.recieved as recieved, invoice.id as invoice_id , student.father_contact,fee_submit_logs.remaining,class_name,section_name');
         $this->db->from('`invoice`');
        $this->db->join('fee_submit_logs','fee_submit_logs.inv_id= invoice.id');
        $this->db->join('promotion','promotion.id=invoice.student_id');
        $this->db->join('section','promotion.section_id = section.section_id');
        $this->db->join('class','class.class_id = promotion.class_id');
        $this->db->join('student','student.id=promotion.student_id');
        $this->db->where('LEFT(fee_submit_logs.date,11) >=',$date);
        $this->db->where('LEFT(fee_submit_logs.date,11) <=',$to_date);
        $this->db->where('invoice.branch_id',$branch);
        $this->db->where('invoice.is_delete',0);
        $this->db->where('invoice.is_auto',0);
         if($class!=""){
            $this->db->where('promotion.class_id', $class);
            }
            
        if($status == 2)
        $this->db->where('invoice.fee_deposit_type','bank');
        elseif($status == 3)
        $this->db->where('invoice.fee_deposit_type','cash');
        $this->db->order_by('fee_submit_logs.inv_id','ASC');
        $data['student'] = $this->db->get()->result_array();
   // echo "<pre>";print_r($data['student']);exit;
     foreach ($data['student'] as $key => $value) {
          if($value['remaining'] == 0 && $value['status'] == 1){$data['student'][$key]['fee_total']=(($value['recieved']+$value['discount']) - ($value['fine'] + $value['advance']));}
          elseif($value['remaining'] > 0 && $value['status'] !=0){$data['student'][$key]['fee_total']=(($value['recieved']+$value['discount']+$value['remaining']) - $value['fine']);}
          else{$data['student'][$key]['fee_total']=$this->voucher_model->countTotalFee($value['invoice_id']);}
     }
          //var_dump($data['student'][$key]['fee_total']);die();
     
//        if(empty($data['student']))
//           {
//               $this->session->set_flashdata('msg','Record Not Found');
//               redirect("Report/fee_version", "refresh");
//
//           }
//           else{
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/fee_received_daily',$data);
          // }

    //  $this->load->view('report/addmission_fee',$data);
    }

    public function daily_expense()
     {
         $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/show_date_expense',$data);
      }

    public function fetch_daily_expense()
    {

         $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();

    $date= $this->input->post('status');

         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         $branch=$this->user_model->getbranch();

   // $query=$this->db->query("SELECT * FROM `invoice`INNER JOIN promotion on promotion.id=invoice.student_id INNER JOIN student on 
   //student.id=promotion.student_id 
    // where date = '$date' and invoice.is_admitted=1 and invoice.branch_id=$branch and invoice.is_delete=0");

     $this->db->select("program.name as programename,project.p_name,main_head.name as headname,level_2.name as level2name,level_3.name as level3name,cash_receipt.amount,cash_receipt.date,cash_receipt.to_receipt,cash_receipt.id"); 
        $this->db->from('cash_receipt');
        $this->db->join('project', 'project.id=cash_receipt.project_id');
        $this->db->join('main_head', 'main_head.id=cash_receipt.main_head_id');
        $this->db->join('level_2', ' level_2.id=cash_receipt.level_2_id');
        $this->db->join('level_3', ' level_3.id=cash_receipt.level_3_id');
        $this->db->join('program','program.id=project.program_id');
        $this->db->where('cash_receipt.is_delete',0)->where('cash_receipt.branch',$branch)->where('cash_receipt.date =',$date);
        $query = $this->db->get()->result_array();


     $data['student'] = $query;
  // var_dump($data['student']);
       //  die();

        if(empty($data['student']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/daily_expense", "refresh");
        
           }
           else{
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
         $this->load->view('report/expense_received_daily',$data);
           }

    //  $this->load->view('report/addmission_fee',$data);
    }
    
  public function active_sentence()
               {
                   $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
     
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/active_sentence_key',$data);
          $this->load->view("footer");    
                   
            }

public function select_active_sentence_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=30 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/active_sentence", "refresh");
        
           }
else{
    $this->load->view('report/fetch_active_key',$data);
    }
}

public function passive_sentence()
               {
                   $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
     
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/passive_sentence_key',$data);
          //$this->load->view("footer");    
                   
            }

public function select_passive_sentence_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=31 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/passive_sentence", "refresh");
        
           }
else{
    $this->load->view('report/fetch_passive_key',$data);
    }
}


public function match_column()
               {
                   $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
     
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/match_column',$data);
         // $this->load->view("footer");    
                   
            }

 public function select_match_column_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=27 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/match_column", "refresh");
        
           }
else{
    $this->load->view('report/fetch_match_column_key',$data);
    }
}

public function match_word()
               {
                   $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
     
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/match_word',$data);
          $this->load->view("footer");    
                   
            }

   public function select_match_word_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=28 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/match_word", "refresh");
        
           }
else{
    $this->load->view('report/fetch_match_word_key',$data);
    }
}


public function masculine_femi()
               {
          $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
     
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/masculine_femi',$data);
          $this->load->view("footer");    
                   
            }

 public function select_masculine_femi_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=21 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/masculine_femi", "refresh");
        
           }
else{
    $this->load->view('report/fetch_masculine_femi_key',$data);
    }
}

public function form_verbs()
               {
          $data['is_super'] = $this->user_model->is_super();
          $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;


          $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        
     
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
      

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);  
        $this->load->view('report/form_verbs',$data);
          $this->load->view("footer");    
                   
            }
public function select_form_verbs_question()
{
   $branch=$this->input->post('branch');
    $class=$this->input->post('class');
  $section=$this->input->post('section');
    $subject=$this->input->post('subject');
$chapter=$this->input->post('chapter');
    $level=$this->input->post('level'); 
     

 $query=$this->db->query("select *,subject.name as sub_name from general_questions 
                    inner join class on class.class_id=general_questions.class 
                    inner join section on section.section_id=general_questions.section
                    inner join subject on subject.id=general_questions.subject 
                    inner join chapters on chapters.id=general_questions.chapter 
                   where general_questions.branch='$branch' and general_questions.class='$class' and 
                     general_questions.section='$section' and general_questions.chapter='$chapter' and  general_questions.level='$level' and 
                      general_questions.question_type=25 and general_questions.is_delete=0");
   
        $branch=$this->report_model->getBranch()[0]; 
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
       $data['qu_result']=$query->result_array();
        
      if(empty($data['qu_result']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/masculine_femi", "refresh");
        
           }
else{
    $this->load->view('report/fetch_form_verbs_key',$data);
    }
}

 public function gender_wise_students()
    {
         $this->user_model->check_permissions("student/studentatt_add");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
       
           // $data['branch']=$this->db->query("select * from branch where is_delete='0'")->result_array();
           
      // var_dump($data['branch']);
       //die();
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/student_grno',$data);
    }


public function print_gender()
    {
        $branch=$this->input->post('branch');
        $gender=$this->input->post('gender');
        
        $class=$this->input->post('class');
        if($section=$this->input->post('section'))
        {
            
                 $section=$this->input->post('section');

        $this->db->select('student.*,class.class_name,section.section_name');    
        $this->db->from('student');
        $this->db->join('promotion pro', 'pro.student_id=student.id');
        $this->db->join('class', 'class.class_id=pro.class_id');
        $this->db->join('session ', 'session.id=pro.session_id');
        $this->db->join('section', 'section.section_id=pro.section_id')
        ->where('student.branch',$branch)
          ->where('student.gender',$gender)
           ->where('student.status',0)
           ->where('pro.class_id',$class)
            ->where('pro.section_id',$section);
                $this->db->where('pro.is_active',1)
                ->where('pro.is_delete',0);
               $data['get_data'] = $this->db->get()->result_array();
        }
        else{
              
               $this->db->select('student.*,class.class_name,section.section_name');    
        $this->db->from('student');
        $this->db->join('promotion pro', 'pro.student_id=student.id');
        $this->db->join('class', 'class.class_id=pro.class_id');
        $this->db->join('session ', 'session.id=pro.session_id');
        $this->db->join('section', 'section.section_id=pro.section_id')
        ->where('student.branch',$branch)
          ->where('student.gender',$gender)
           ->where('student.status',0)
           ->where('pro.class_id',$class)
           ->where('pro.is_active',1)
                ->where('pro.is_delete',0);
               $data['get_data'] = $this->db->get()->result_array();
        }
       
       $data['branch_name']=$this->db->query("select name from branch where id='$branch'")->row_array();
       
       //$data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        

       $this->load->view('report/print_gender',$data);

    }

 public function attendance_sheet()
    {
         $this->user_model->check_permissions("student/studentatt_add");
         $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
          $branch=$this->user_model->getbranch();
            if($this->user_model->is_super())
                $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result();
            else
                $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result();
       
           // $data['branch']=$this->db->query("select * from branch where is_delete='0'")->result_array();
           
      // var_dump($data['branch']);
       //die();
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/attends_sheet',$data);
    }



public function print_attends_sheet()
    {
        $branch=$this->input->post('branch');
        $class=$this->input->post('class');
        $section=$this->input->post('section');
        $gender=$this->input->post('gender');
        
    if($this->input->post('class')){
        
        $this->db->select('student.branch,student.id,student.sid,student.student_name,student.father_name,student.roll_no,student.grno,class.class_name,section.section_name,seat_no');    
        $this->db->from('student');
        $this->db->join('promotion pro', 'pro.student_id=student.id');
        $this->db->join('class', 'class.class_id=pro.class_id');
        $this->db->join('session ', 'session.id=pro.session_id');
        $this->db->join('section', 'section.section_id=pro.section_id');
        $this->db->join('seating_plans', 'seating_plans.student_id=student.id');
        
        $this->db->order_by('section.section_id asc');
        if(!empty($section))
        {
            $this->db->where('pro.section_id',$section);
        }
         if(!empty($gender))
        {
            $this->db->where('student.gender',$gender);
        }
        $this->db->where('student.branch',$branch)
                 ->where('student.status',0)
                 ->where('pro.class_id',$class);
       $this->db->where('pro.is_active',1)
                 ->where('pro.is_delete',0);
         $data['get_data'] = $this->db->get()->result_array();
              
        
       $data['branch_name']=$this->db->query("select name from branch where id='$branch'")->row_array();
     
        $data['b_header']= $this->report_model->BranchHeader();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       $this->load->view('report/print_attends_sheet',$data);
    }
    
    else{
        redirect('Report/attendance_sheet');
        }
    }

    public function cash_deposit_view()
     {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['pay']=$this->account_model->All_cashdeposit();
        $this->account_model->down("report/cash_depositview",$data);
     }



     public function cash_depositprint()
     {
        $year = $this->input->post('year');
        $branch=$this->user_model->getbranch();
        $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
        $data['recipt']=$this->report_model->All_cashdeposit($year);
        $this->load->view("report/cash_depositprint",$data);
     }





    public function Bank_recpt_view()
         {
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->account_model->down("report/bank_recpt_view",$data);
         }


    public function Bank_recipt_print()
         {
            $year = $this->input->post('year');
            $branch=$this->user_model->getbranch();
            $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            $data['recipt']=$this->account_model->All_bankrecipt($year);
            $this->load->view("report/bank_recipt_print",$data);
         }





    public function total_expense_view()
         {
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view("report/all_expenses_view",$data);
            $this->load->view("footer");

         }


    public function total_expense_print()
         {
            $year = $this->input->post('year');
            $branch=$this->user_model->getbranch();
            $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            $data['recipt']=$this->report_model->All_expenses($year);
            $this->load->view("report/all_expenses_print",$data);
         }




    public function yearly_income_report()
      {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/yearly_income_report',$data);

      }

public function Seating_Plan()
{
     $this->user_model->check_permissions("exam/rollno");
      $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/seating_plan",$data);
}

 public function Print_SeatingPlan()
 {
   $branch=$this->input->post('branch');
   $class=$this->input->post('class');
   $exam=$this->input->post('exam');
   
   
       $data['seat_plan'] = $this->db->query("SELECT * FROM `seating_plan` 
            inner join student on student.id=seating_plan.student_id
            inner join promotion on promotion.student_id=seating_plan.student_id
            inner join class on class.class_id=promotion.class_id
            inner join section on section.section_id=promotion.section_id
             WHERE seating_plan.branch=$branch and promotion.is_active=1 and promotion.class_id=$class
             
              ORDER BY class.class_number DESC,section.section_id ASC,gender DESC
              
              ")->result_array();
              
              if(empty($data['seat_plan']))
              {
                  $this->session->set_flashdata('my_2msg2','Seating Plan not genrated for this class...');
                  
                 echo "<h2>Seating Plan not genrated for this class...</h2>";
                             //redirect("Report/masculine_femi", "refresh");
   // echo "yahoo";
   
                 //redirect("Report/Seating_Plan");
              }else{
              
               $data['branch_name']=$this->report_model->getBranch()[0]['name'];
               
       $data['exam_name']=$this->db->select('name')
                                   ->from('exam')
                                    ->where('is_delete','0')
                                   ->where('id',$exam)
                                   ->where('class_id',$class)
                                 ->get()->row();
        
                
               $data['b_header']= $this->report_model->BranchHeader();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
  
      $this->load->view('report/Print_SeatingPlan',$data);
              }
 }

   public function yearly_income_print($year='')
    {
        if($this->input->post('year'))
        $year=$this->input->post('year');
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        if($year=='')
        $year=date('Y');
        $next_year=(string)$year+1;
        $yearly_month_array=array("$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'',"$next_year-01"=>'',"$next_year-02"=>'',"$next_year-03"=>'',"$next_year-04"=>'',"$next_year-05"=>'',"$next_year-06"=>'');
        $monthly_values=array("$year-07"=>'',"$year-08"=>'',"$year-09"=>'',"$year-10"=>'',"$year-11"=>'',"$year-12"=>'',"$next_year-01"=>'',"$next_year-02"=>'',"$next_year-03"=>'',"$next_year-04"=>'',"$next_year-05"=>'',"$next_year-06"=>'');
        foreach ($yearly_month_array as $selected_month=>$value) {
            $this->db->select('invoice.*');
            $this->db->from('invoice');
            $this->db->join('promotion','invoice.student_id=promotion.id');
            $this->db->join('student','student.id=promotion.student_id');
            //$this->db->where('student.status',0);
            //$this->db->where('promotion.is_delete',0);
            //$this->db->where('promotion.is_active',1);
            $this->db->where('left(invoice.date,7)',$selected_month);
            $this->db->where('invoice.branch_id',$branch['id']);
            $this->db->where('invoice.is_delete',0);
            $yearly_month_array[$selected_month]=$this->db->get()->result_array();
        }
        foreach ($yearly_month_array as $selected_month=>$all_vouchers) {

            $monthly_values[$selected_month]['fee_recieved']=0;
            foreach ($all_vouchers as $key => $voucher) {       
                $monthly_values[$selected_month]['fee_recieved']+=$voucher['recieved'];                           
            }
        }//end of yealy vouchers foreach

//================= get total cash receipts(table cash vouchers) month wise ==========================

        reset($monthly_values);
        foreach ($monthly_values as $month_name => $v) {
            $this->db->select('sum(amount)');
            $this->db->where('left(date,7)',$month_name);
            $this->db->where('is_delete',0);
            $this->db->where('main_head_id',5);
            $this->db->where('branch',$branch['id']);
            $monthly_values[$month_name]['total_cash_receipts']=$this->db->get('cash_voucher')->result_array()[0]['sum(amount)'];
        }

        //var_dump('<pre>',$monthly_values);die();
        $data['monthly_values']=$monthly_values;
        $this->load->view('report/yearly_income_print',$data);
    }

 /* Roll No Slip */ 

    /* Helper Functions */ 

    private function random_numbers($digits) {
        $min = pow(10, $digits - 1);
        $max = pow(10, $digits) - 1;
        return mt_rand($min, $max);
    }
    
    
    public function rollno()
    {
        $this->user_model->check_permissions("exam/rollno");
         $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/rollno",$data);
    }
    public function rollnoslip()
    {
        
        if($this->input->post())
        {
            $id = $this->input->post("id",true);
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $section = $this->input->post("section",true);
            $exam = $this->input->post("exam",true);
            $data = $this->db->query("SELECT promotion.id,student.grno FROM `promotion` INNER JOIN student ON student.id=promotion.student_id WHERE student.branch='$branch' and promotion.class_id='$class' and promotion.section_id='$section' and promotion.is_active='1' and promotion.is_delete='0' and student.status='0'")->result_array();
            $series = $this->random_numbers(4);
            foreach ($data as $key => $value) {
                $student_id = $value['id'];
                $exam_date = $this->db->select("start")->from("exam")->where("id",$exam)->get()->row_array()['start'];
                $seat_no = $series++; //date("ymd",strtotime($exam_date))..$value['grno']
                $count = $this->db->select("id")->from("rollnoslip")->where("student_id",$student_id)->where("branch_id",$branch)->where("class_id",$class)->where("section_id",$section)->where("exam_id",$exam)->where("is_delete","0")->count_all_results();
                if($count==0)
                {
                    $data = array(
                        "branch_id"=>$branch,
                        "class_id"=>$class,
                        "exam_id"=>$exam,
                        "section_id"=>$section,
                        "student_id"=>$student_id,
                        "seat_no"=>$seat_no
                    );
                    $this->db->insert("rollnoslip",$data); 
                }
            }
          redirect("Report/viewrollno/$branch/$class/$section/$exam","refresh");
        //redirect('report/myfun');
        }
    }

public function myfun(){
 echo "hit";
}
 public function viewrollno() 
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        // Getting Values from URI Segments
        $branch = $this->uri->segment('3');
        $class = $this->uri->segment('4');
        $section = $this->uri->segment('5');
        $exam = $this->uri->segment('6');
        //
        $data['exam']=$exam; 
        $data['class']=$class; 
        $data['section']=$section; 
        $d=$this->db->query("SELECT promotion.id as stid,sid,student_name from rollnoslip INNER JOIN promotion on promotion.id=rollnoslip.student_id inner join student on student.id=promotion.student_id inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id WHERE promotion.is_active='1' AND promotion.is_delete='0' AND rollnoslip.class_id='$class' AND rollnoslip.section_id='$section' AND rollnoslip.branch_id='$branch' AND rollnoslip.exam_id='$exam' AND student.status='0' order by gender DESC")->result_array();
        $data["data"]=$d;
        $data["i"]=1;


        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/viewrollno",$data);
    }
    
    
       public function rolldate()
    {
           // $exam = $this->input->post("exam");
           if($this->uri->segment('3')){
            $id=$this->uri->segment('3');
            $exam_id=$this->uri->segment('4');
            $branch=$this->user_model->getbranch();
            $data['exams']= $exam_id;
            
            $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            $rollnoslip = $this->db->query("SELECT seat_no,class_id from rollnoslip where student_id='$id' AND `exam_id`='$exam_id' AND is_delete='0'")->result_array()[0];
            $data['seat_no'] = $rollnoslip['seat_no'];
            
            $class = $rollnoslip['class_id'];
           $data['classs'] =$class;
           $data['class_order']=$this->db->select('orderr')
                                         ->from('class')
                                         ->where('class_id',$class)
                                         ->get()->row_array()['orderr'];
          // var_dump($data['class_order']);die;
    $data['student'] = $this->db->query("SELECT student.branch,student.id,roll_no,student_name,father_name,class.class_name,student.sid,student.img,student.dob,section.section_name from student INNER JOIN promotion on promotion.student_id=student.id

 inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id  WHERE promotion.is_active='1' AND student.status='0' AND promotion.is_delete='0' AND promotion.id='$id' and student.branch ='$branch'")->result_array()[0];
           //var_dump($data['student']);die;
            $data['exam'] = $this->db->select('id,name')->from("exam")->where("is_delete","0")->where('id',$exam_id)->get()->row_array();
            $data['data'] = $this->db->query("SELECT datesheet.date_exam,datesheet.day_exam,datesheet.start_time,datesheet.end_time,subject.name as subject_name FROM `datesheet` INNER JOIN class on datesheet.class_id=class.class_id INNER JOIN subject ON subject.id=datesheet.subject_id  WHERE datesheet.is_delete='0' and datesheet.class_id='$class' and datesheet.exam_id='$exam_id'")->result_array();
            $data['note'] = $this->db->query("SELECT note FROM `note` WHERE branch_id='$branch' and note.is_delete='0'")->result_array();
            $this->load->view("report/previewroll",$data);
        }
        else
        {
            redirect('report/rollno',refresh);
        }
     
    }
    
    public function rolldatesection()
    {
           // $exam = $this->input->post("exam");
        if($this->uri->segment('3')){
            $class=$this->uri->segment('3');
            $section=$this->uri->segment('4');
            $exam_id=$this->uri->segment('5');
            $branch=$this->user_model->getbranch();
            $data['exams']= $exam_id;
            $data['class_order']=$this->db->select('orderr')
                                         ->from('class')
                                         ->where('class_id',$class)
                                         ->get()->row_array()['orderr'];
            $data['classs'] = $class; 
            $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            $data['exam'] = $this->db->select('id,name')->from("exam")->where("is_delete","0")->where('id',$exam_id)->get()->row_array();
            $data['data'] = $this->db->query("SELECT datesheet.date_exam,datesheet.day_exam,datesheet.start_time,datesheet.end_time,subject.name as subject_name FROM `datesheet` INNER JOIN class on datesheet.class_id=class.class_id INNER JOIN subject ON subject.id=datesheet.subject_id  WHERE datesheet.is_delete='0' and datesheet.class_id='$class' and datesheet.exam_id='$exam_id'")->result_array();
            $data['note'] = $this->db->query("SELECT note FROM `note` WHERE branch_id='$branch' and note.is_delete='0'")->result_array();
            /**/
            $data['students'] = $this->db->query("SELECT student.branch,student.id,roll_no,student_name,father_name,class.class_name,student.sid,student.img,student.dob,section.section_name from student  INNER JOIN promotion on promotion.student_id=student.id inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id  WHERE promotion.is_active='1' AND promotion.is_delete='0' AND promotion.class_id='$class' AND promotion.section_id='$section' and student.status='0' and student.is_delete='0' order by gender DESC")->result_array();
            //$rollnoslip = $this->db->query("SELECT seat_no,class_id from rollnoslip where student_id='$id' AND `exam_id`='$exam_id' AND is_delete='0'")->result_array()[0];
            //$data['seat_no'] = $rollnoslip['seat_no'];
            $this->load->view("report/rollnoslip_section",$data);
        }
        else
        {
            redirect('report/rollno',refresh);
        }
     
    }
    
    public function overallatt()
    {
        
        //var_dump("hello");
        //die();
       $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();


            if($this->input->post()){
            $postdata=$this->input->post();
            if(isset($postdata['Datesubmit'])) {
                //var_dump($this->input->post('date'));die();
                $data['mydate']=$this->input->post('date');
            }
        }
            $branch=$this->branch;
            //$exam=$this->input->post('exam');
            //$data['examtype']=$exam;
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['student']=$this->db->query("SELECT  class.class_id as cid,class.class_name,section.section_id as sid,section.section_name,count(promotion.id) as total_students from `promotion` join `class` on class.class_id=`promotion`.`class_id` join `student` on student.id=`promotion`.`student_id` join section on 
            section.section_id=promotion.section_id where student.branch=$branch and class.is_delete=0 and section.is_delete=0 and promotion.is_active=1 AND promotion.is_delete=0 and student.status=0 group by section.section_name , class.class_name order by class.class_name asc")->result_array();
             $data['att_present']=$this->db->query("SELECT  COUNT(studentatt.id) as att_count,(Select COUNT(student.id) as total from student WHERE  student.status='0') as std_count from studentatt INNER join student on student.id=studentatt.student_id WHERE is_deleted='0' AND status_id='1'")->result_array()[0];
            
        
              $data['base_url'] = base_url();
              $data['userInfo'] = $this->userInfo;
           
          // var_dump($data['student']);
           //die();
               $this->load->view('report/display_OverAll',$data);
    }

// ========================== Admission Reports ==========================


      public function branchWise_admission_report()
        {
          $data['menu'] = $this->load_model->menu();
          $data['base_url'] = base_url();
          $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
          $is_super = $this->user_model->is_super();
          if($is_super) {
            $data['branchh']=$this->db->query("SELECT id, name FROM `branch` WHERE is_delete = 0");
          }else{
            $data['branchh']=$this->report_model->getBranch();
          }
          $this->load->view('header',$data);
          $this->load->view('sidebar',$data);
          $this->load->view('report/branch_wise_admission',$data);
        //   $this->load->view('footer',$data);
      }

      public function print_branchWise_admission_report()
        {
          $branchid = $this->input->post('branch', TRUE);
          $startdate =$this->input->post('datefrom', TRUE);
          $enddate =$this->input->post('dateto', TRUE);

          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branchid' AND is_delete='0'")->row_array();

          $this->db->select('COUNT(student.id) as stdTotal, branch.name')->from('student');
          $this->db->join('branch', 'branch.id = student.branch');

          if($startdate!=""){
           $this->db->where('date_of_admission>=', $startdate);
           }
          if($enddate!=""){
          $this->db->where('date_of_admission <=', $enddate);
          }
          $this->db->where('student.branch', $branchid);
          $data['student'] = $this->db->get()->result_array();

          $this->db->select('student.sid,student.grno, branch.name, student.date_of_admission, student.student_name, student.branch')->from('student');
          $this->db->join('branch', 'branch.id = student.branch');

          if($startdate!=""){
           $this->db->where('date_of_admission>=', $startdate);
          }
          if($enddate!=""){
          $this->db->where('date_of_admission <=', $enddate);
          }
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branchid);
          $data['data'] = $this->db->get()->result_array();

          $this->load->view('report/branch_wise_admission_print',$data);
        }
     

      public function genderWise_admission_report()
        {
          $data['menu'] = $this->load_model->menu();
          $data['base_url'] = base_url();
          $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
          $this->load->view('header',$data);
          $this->load->view('sidebar',$data);
          $this->load->view('report/gender_wise_admission',$data);
          $this->load->view('footer',$data);
      }

      public function print_genderWise_admission_report()
        { 

          $gender = $this->input->post('gender', TRUE);
          $startdate =$this->input->post('datefrom', TRUE);
          $enddate =$this->input->post('dateto', TRUE);

          $branch =$this->report_model->getBranch()[0]['id'];
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->row_array();

          $this->db->select('COUNT(student.id) as stdTotal, student.gender')->from('student');
          if($startdate!=""){
            $this->db->where('date_of_admission>=', $startdate);
           }
          if($enddate!=""){
            $this->db->where('date_of_admission <=', $enddate);
          }
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('student.gender', $gender);
          $data['student'] = $this->db->get()->result_array();

          $this->db->select('student.id, student.sid,student.grno, student.date_of_admission, student.student_name, student.gender')->from('student');

          if($startdate!=""){
            $this->db->where('date_of_admission>=', $startdate);
          }
          if($enddate!=""){
            $this->db->where('date_of_admission <=', $enddate);
          }

          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('student.gender', $gender);
          $data['data'] = $this->db->get()->result_array();
          $this->load->view('report/gender_wise_admission_print',$data);

        }


      public function classWise_admission_report()
        {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/class_wise_admission',$data);
        $this->load->view('footer',$data);

        }

 


        public function print_classWise_admission_report()
        {

          $classid =$this->input->post('class_id', TRUE);
          $startdate =$this->input->post('datefrom', TRUE);
          $enddate =$this->input->post('dateto', TRUE);

          $branch =$this->report_model->getBranch()[0]['id'];
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

          $this->db->select('class.class_name, COUNT(student.id) as stdTotal')->from('student');
          $this->db->join('class', 'class.class_id = student.class_admited ');
          if($startdate!=""){
            $this->db->where('date_of_admission>=', $startdate);
           }
          if($enddate!=""){
            $this->db->where('date_of_admission <=', $enddate);
          }
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.class_admited', $classid);
          $this->db->where('student.branch', $branch);
          $data['student'] = $this->db->get()->result_array();


          $this->db->select('student.sid, student.date_of_admission, student.student_name, class.class_name')->from('student');
          $this->db->join('class', 'class.class_id = student.class_admited ');
          if($startdate!=""){
            $this->db->where('date_of_admission>=', $startdate);
           }
          if($enddate!=""){
            $this->db->where('date_of_admission <=', $enddate);
          }
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('student.class_admited', $classid);
          $data['data'] = $this->db->get()->result_array();
          $this->load->view('report/class_wise_admission_print',$data);

        }


        public function sectionWise_admission_report()
        {

        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/section_wise_admission',$data);
        $this->load->view('footer',$data);

        }

        public function print_sectionWise_admission_report()
        {

          $classid =$this->input->post('classid', TRUE);
          $sectionid =$this->input->post('section_id', TRUE);
          $startdate =$this->input->post('datefrom', TRUE);
          $enddate =$this->input->post('dateto', TRUE);

          $branch =$this->report_model->getBranch()[0]['id'];
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

          $this->db->select('class.class_name, section.section_name, COUNT(student.id) as stdTotal')->from('student');
          $this->db->join('promotion', 'promotion.student_id = student.id ');
          $this->db->join('class', 'class.class_id = promotion.class_id ');
          $this->db->join('section', 'section.section_id = promotion.section_id');


          if($startdate!=""){
           $this->db->where('date_of_admission>=', $startdate);
           }
          if($enddate!=""){
          $this->db->where('date_of_admission <=', $enddate);
          }
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          
        //   if($classid!=""){
        //   $this->db->where('student.class_admited', $classid);
        //   }
        //   if($sectionid!=""){
        //   $this->db->where('promotion.section_id', $sectionid);
        //   }
        //   $data['student'] = $this->db->get()->result_array();
        //   var_dump($data['student']);die;
          
          $this->db->where('student.class_admited', $classid);
          $this->db->where('promotion.section_id', $sectionid);
          $data['student'] = $this->db->get()->result_array();

          $this->db->select('student.sid, student.grno, student.date_of_admission, student.student_name, class.class_name, section.section_name,')->from('student');
          $this->db->join('promotion', 'promotion.student_id = student.id ');
          $this->db->join('class', 'class.class_id = promotion.class_id ');
          $this->db->join('section', 'section.section_id = promotion.section_id');

          if($startdate!=""){
           $this->db->where('date_of_admission>=', $startdate);
          }
          if($enddate!=""){
            $this->db->where('date_of_admission <=', $enddate);
          }
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('student.class_admited', $classid);
          $this->db->where('promotion.section_id', $sectionid);
          $data['data'] = $this->db->get()->result_array();
          $this->load->view('report/section_wise_admission_print',$data);

        }



        public function getSections()
          {
              $classId = $this->input->post('classId', TRUE);

              $res = $this->db->query("SELECT * FROM `section` WHERE class_id = '$classId' AND  `is_delete` = 0")->result_array();   
              echo json_encode($res) ;
          }




          public function overall_admission_report()
        {

          $data['menu'] = $this->load_model->menu();
          $data['base_url'] = base_url();
          $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
          $data['is_super'] = $this->user_model->is_super();
          $data['branchId']=$this->report_model->getBranch()[0]['id'];
          $data['branches']=$this->report_model->getAllBranches();
          $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
          $this->load->view('header',$data);
          $this->load->view('sidebar',$data);
          $this->load->view('report/overall_admission',$data);
          $this->load->view('footer',$data);

        }

    public function print_overall_admission_report()
        {

          $branch = $this->report_model->getBranch()[0]['id'];
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

          $data['title']="Admission Report";

                if($this->input->post()){

                        $formdata=$this->input->post();
                        $params=array();
                        $startdate="";
                        $enddate="";

                        foreach ($formdata as $key => $value) {
                            
                            if($value!="" && $value!="submit" && $key!="datefrom" && $key!="dateto"){
                              $params[$key] =$value;
                              $data[$key]=$value;
                            }
                            if($key=="datefrom" && $value!=""){
                              $startdate=$value;
                              $data[$key]=$value;
                            }
                            if($key=="dateto" && $value!=""){
                              $enddate=$value;
                              $data[$key]=$value;
                            }
                        }
                      
                      $data['data']= $this->report_model->getReportData('get_all_admissions',$params,$startdate,$enddate);

                    }else{

          $data['data']=$this->report_model->get_all_addmissions();
        }
          $this->load->view('report/overall_admission_print',$data);

      }



//================================= End Admission Reports ===============================

//================================= Late Fee Fine Reports ===============================

      public function late_fee_report()
        {
          $data['menu'] = $this->load_model->menu();
          $data['base_url'] = base_url();
          $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
          $data['branchId']=$this->report_model->getBranch()[0]['id'];
          $data['is_super'] = $this->user_model->is_super();
          $is_super = $this->user_model->is_super();
          if($is_super){
            $data['branches']=$this->db->query("SELECT id, name FROM `branch` WHERE is_delete = 0")->result_array();
          }
          $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
          $this->load->view('header',$data);
          $this->load->view('sidebar',$data);
          $this->load->view('report/late_fee',$data);
          $this->load->view('footer',$data);

    
        }

        public function print_late_fee_report()
        {
          $classid =$this->input->post('classid', TRUE);
          $sectionid =$this->input->post('section_id', TRUE);
          $month =$this->input->post('month', TRUE);
          if (!empty($this->input->post('branch', TRUE))) {
            $branch =  $this->input->post('branch', TRUE);
            $data['branch_name']=$this->db->query("SELECT name FROM `branch` WHERE id = '$branch' AND  is_delete = 0")->row_array();
          }else{
            $branch =$this->report_model->getBranch()[0]['id'];
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          }
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];


          $this->db->select('SUM(invoice.late_fine) as totalfine')->from('student');
          $this->db->join('promotion', 'promotion.student_id = student.id ');
          $this->db->join('class', 'class.class_id = promotion.class_id ');
          $this->db->join('section', 'section.section_id = promotion.section_id');
          $this->db->join('invoice', 'invoice.student_id = promotion.student_id');
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('promotion.class_id', $classid);
          $this->db->where('promotion.section_id', $sectionid);
          $this->db->where('invoice.status', 1);
          $this->db->where('invoice.date >', 'invoice.date_expire');
          $this->db->where('left(invoice.date,7)',$month);
          $data['fine'] = $this->db->get()->result_array();

          $this->db->select('student.sid,student.grno, student.date_of_admission, student.student_name, class.class_name, section.section_name, invoice.date, invoice.submitted_at, invoice.late_fine')->from('student');
          $this->db->join('promotion', 'promotion.student_id = student.id ');
          $this->db->join('class', 'class.class_id = promotion.class_id ');
          $this->db->join('section', 'section.section_id = promotion.section_id');
          $this->db->join('invoice', 'invoice.student_id = promotion.student_id');
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('promotion.class_id', $classid);
          $this->db->where('promotion.section_id', $sectionid);
          $this->db->where('invoice.status', 1);
          $this->db->where('invoice.date >', 'invoice.date_expire');
          $this->db->where('left(invoice.date,7)',$month);
          $data['data'] = $this->db->get()->result_array();
        
          $this->load->view('report/late_fee_print',$data);

        }
        
        public function print_yearly_exam_report()
        {
            
          $classid =$this->input->post('class_yearly', TRUE);
          $month =$this->input->post('datefromyearly', TRUE);
          if (!empty($this->input->post('branch', TRUE))) {
            $branch =  $this->input->post('branch', TRUE);
            $data['branch_name']=$this->db->query("SELECT name FROM `branch` WHERE id = '$branch' AND  is_delete = 0")->row_array();
          }else{
            $branch =$this->report_model->getBranch()[0]['id'];
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          }
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
           
          $this->db->select('id')
                   ->from('fee_def');
                if(!empty($classid))
                {
                    $this->db->where('class_id',$classid);
                }
          $this->db->where("(name='YEARLY EXAM FEES' OR name='Yearly Exam Fees')");
         $fee_ids=$this->db->get()->result_array();

         $id_ar=array();
         if(!empty($fee_ids))
         {
             foreach($fee_ids as $row)
             {
                $id_ar[]=$row['id'];
             }
         }
    
          $this->db->select('student.sid,student.student_name, class.class_name, section.section_name,fee_installment.amount')
                   ->from('invoice');
          
          $this->db->join('fee_installment','fee_installment.invoice=invoice.id');           
          $this->db->join('promotion','promotion.id =invoice.student_id');
          $this->db->join('student','student.id =promotion.student_id');
          $this->db->join('class','class.class_id = promotion.class_id');
          $this->db->join('section','section.section_id = promotion.section_id');
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          
          if(!empty($classid))
          {
             $this->db->where('promotion.class_id', $classid); 
          }
          
          $this->db->where('invoice.status', 1);
          $this->db->where('left(invoice.date,7)',$month);
          $this->db->where_in('fee_installment.fee_id',$id_ar);
          $data['data'] = $this->db->get()->result_array();
        
          $this->load->view('report/yearly_exam_print',$data);

        }

 public function monthly_late_fee_report()
        {
          $data['menu'] = $this->load_model->menu();
          $data['base_url'] = base_url();
          $data['is_super'] = $this->user_model->is_super();
          $is_super = $this->user_model->is_super();
          if($is_super){
            $data['branches']=$this->db->query("SELECT id, name FROM `branch` WHERE is_delete = 0")->result_array();
          }
          $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
          $data['branchId']=$this->report_model->getBranch()[0]['id'];
          $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
          $this->load->view('header',$data);
          $this->load->view('sidebar',$data);
          $this->load->view('report/monthly_late_fee',$data);
          $this->load->view('footer',$data);
        }


      public function print_monthly_late_fee_report()
        {
          $month =$this->input->post('month', TRUE);
          if (!empty($this->input->post('branch', TRUE))) {
            $branch =  $this->input->post('branch', TRUE);
            $data['branch_name']=$this->db->query("SELECT name FROM `branch` WHERE id = '$branch' AND  is_delete = 0")->row_array();
          }else{
            $branch =$this->report_model->getBranch()[0]['id'];
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          }
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

          $this->db->select('SUM(invoice.late_fine) as totalfine')->from('student');
          $this->db->join('promotion', 'promotion.student_id = student.id ');
          $this->db->join('class', 'class.class_id = promotion.class_id ');
          $this->db->join('section', 'section.section_id = promotion.section_id');
          $this->db->join('invoice', 'invoice.student_id = promotion.student_id');
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('invoice.status', 1);
          $this->db->where('invoice.date >', 'invoice.date_expire');
          $this->db->where('left(invoice.date,7)',$month);
          $data['fine'] = $this->db->get()->result_array();


          $this->db->select('student.sid,student.grno, student.date_of_admission, student.student_name, class.class_name, section.section_name, invoice.date, invoice.submitted_at, invoice.late_fine')->from('student');
          $this->db->join('promotion', 'promotion.student_id = student.id ');
          $this->db->join('class', 'class.class_id = promotion.class_id ');
          $this->db->join('section', 'section.section_id = promotion.section_id');
          $this->db->join('invoice', 'invoice.student_id = promotion.student_id');
          $this->db->where('student.is_delete', '0');
          $this->db->where('student.branch', $branch);
          $this->db->where('invoice.status', 1);
          $this->db->where('invoice.date >', 'invoice.date_expire');
          $this->db->where('left(invoice.date,7)',$month);
          $this->db->order_by('class.class_id', 'DESC');
          $this->db->order_by('section.section_id', 'DESC');
          $data['data'] = $this->db->get()->result_array();
          $this->load->view('report/monthly_late_fee_print',$data);

        }









//================================= End Late Fee Fine Reports ===============================
       
        public function g_admission_report()
        {
           // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/ganaric_admission',$data);
        // $this->load->view('footer',$data);
        }

       
        public function print_g_admission_report()
    {
        $branch =$this->input->post('branch', TRUE);
        $class =$this->input->post('class', TRUE);
        $section =$this->input->post('section', TRUE);
        $gender =$this->input->post('gender', TRUE);
        $startdate=date('Y-m-d',strtotime($this->input->post('datefrom')));
        $enddate=date('Y-m-d',strtotime($this->input->post('dateto')));

        if(empty($branch))
        {
            $branch =$this->report_model->getBranch()[0]['id'];
        }

        $data['branch']=$branch;
        $data['class']=$class;
        $data['section']=$section;
        $data['gender']=$gender;
        $data['startdate']=$startdate;
        $data['enddate']=$enddate;
        // var_dump($data['branch'],$data['class'],$data['section'],$data['gender'],$data['startdate'],$data['enddate']); die();

        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

        $this->db->select('Distinct(student.sid),class.class_name, section.section_name,
            student.student_name,student.date_of_admission,student.status,student.father_contact,
            student.grno,student.father_name, student.admission, student.class_admited,
            student.gender')
            ->from('student');
        // $this->db->join('promotion', 'promotion.class_id = student.class_admited');
        $this->db->join('promotion', 'student.id = promotion.student_id');
        $this->db->join('class', 'class.class_id = student.class_admited');
        $this->db->join('section', 'section.section_id = promotion.section_id');

        if($startdate!=""){
            $this->db->where('date_of_admission>=', $startdate);
        }

        if($enddate!=""){
            $this->db->where('date_of_admission <=', $enddate);
        }
        if($class!=""){
            $this->db->where('student.class_admited', $class);
        }
        // var_dump($class);die;
        if($section!=""){
            $this->db->where('promotion.section_id', $section);
        }
        if($branch!=""){

            $this->db->where('student.branch', $branch);
        }
        if($gender!=""){

            $this->db->where('student.gender', $gender);
        }
        $this->db->where('student.is_delete', 0);
        $this->db->where(' promotion.is_active',1);
        $this->db->where(' promotion.is_delete',0);
        // $this->db->where(' student.status',0);
        $this->db->where(' class.is_delete',0);
        $this->db->where(' section.is_delete',0);
        $data['student'] = $this->db->get()->result_array();
        //   var_dump($data['student']);die;
//        if(empty($data['student']))
//        {
//            $this->session->set_flashdata('msg','Record Not Found');
//            redirect("Report/g_admission_report", "refresh");
//
//        }
//        else{
            $data['base_url'] =  base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('report/g_admission_print',$data);

            //   $this->load->view('report/g_admission_print',$data);
        //}
    }
       
       
           public function cnic_report()
        {
           // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/defaulter_cnic',$data);
       // $this->load->view('footer',$data);
        }   


        public function show_cnic_report($cl="",$se="") 
        {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        if($cl==""){

          $branch =$this->input->post('branch', TRUE);
          $class =$this->input->post('class', TRUE);
          $section =$this->input->post('section', TRUE);
          
          if(empty($branch))
             {
              $branch =$this->report_model->getBranch()[0]['id'];
            }

              $data['branch']=$branch;
              $data['class']=$class;
              $data['section']=$section;
        }
        else{
            $class =$cl;
            $section =$se;
            $branch =$this->report_model->getBranch()[0]['id'];
            
              $data['branch']=$branch;
              $data['class']=$class;
              $data['section']=$section;
            
        }
      // var_dump($data['branch'],$data['class'],$data['section'],$data['gender'],$data['startdate'],$data['enddate']); die();

          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

            $this->db->select('student.id,class.class_id,class.class_name, section.section_id, section.section_name,student.grno,student.father_cnic,  
            student.student_name,student.date_of_admission,
            student.grno,student.father_name, student.admission, student.class_admited,
            student.gender')
            ->from('student');
            $this->db->join('promotion', 'promotion.student_id = student.id ');
            $this->db->join('class', 'class.class_id = promotion.class_id ');
            $this->db->join('section', 'section.section_id = promotion.section_id');
            if($section!=""){
            $this->db->where('promotion.section_id', $section);
            }
            if($branch!=""){

            $this->db->where('student.branch', $branch);
            }
            
           // $this->db->where('student.is_delete', 0);
            $this->db->where(' promotion.is_active',1);
           // $this->db->where(' student.status',0);
            $this->db->where(' class.class_id',$class);
            $this->db->where(' section.section_id',$section);
          $data['student'] = $this->db->get()->result_array();

          $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/show_cnic',$data);
        }

       
        
    public function edit_cnic($id,$cl,$se)
    {
        $data['menu'] = $this->load_model->menu();
        $id = $this->uri->segment(3);
        
        $this->db->select('student.id,student.grno,student.father_cnic,student.student_name,student.father_name')
            ->from('student');
        $this->db->where(' student.status',0);
        $this->db->where(' student.id',$id);
        $data['class'] = $cl;
        $data['section'] = $se;
        $data['selected'] = $this->db->get()->result_array();

        $data['userInfo'] = $this->userInfo;
        $data['base_url'] = base_url();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/cnic_edit',$data);       
    }

        public function update_cnic()
    {
        $id = $this->input->post('id');
        $cnic = $this->input->post('f_cnic');
        $class = $this->input->post('class');
        $section = $this->input->post('section');

        $this->db->where('id',$id);
        $this->db->update('student',array('father_cnic'=>$cnic));
        $this->show_cnic_report($class,$section);
   }

  public function month_fee_summary()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/summary_fee',$data);
    }


      public function fees_status_overall()
       {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $month= $this->input->post('month');
        $branch= $this->input->post('branch');
        $data['branchId']= $this->input->post('branch');
        $data['month']=$month;    
      
        $data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];
        

        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
       $data['class']=$this->db->query("SELECT   class.class_id as id,count(student.id)as std , count(promotion.id) as ptd , class.class_name,class.orderr
                                FROM `promotion`
                                INNER join class on class.class_id = promotion.class_id
                                INNER join section on section.section_id = promotion.section_id
                                INNER join student on student.id = promotion.student_id
                               
                                where promotion.is_active=1
                                and promotion.is_delete=0
                                and section.is_delete=0
                                and student.is_delete=0
                                and student.branch= '$branch'
                                and class.is_delete=0
                                GROUP by class.class_name
                                order by class.orderr asc
                                ")->result_array();
        // echo "<pre>";print_r($data['class']);exit;

        $this->load->view('report/Fee_monhtly_status',$data);

       }
        public function att_summary()
    {
         

          $data['is_super'] = $this->user_model->is_super();
         $data['menu'] = $this->load_model->menu();
          $branch=$this->user_model->getbranch();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/att_summary',$data);
    }


       public function att_status_overall($id=0,$month='',$branch='')
       {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
         $month=date('Y-m-d',strtotime($this->input->post('date')));
       //var_dump($month);
        $branch= $this->input->post('branch');
        $data['branchId']= $this->input->post('branch');
        $data['month']=$month;    
      
        $data['b_header'] = $this->db->query("SELECT 
            name,title,tagline,short_address,phone_no,email,logo1,logo2 
            from branch where id='$branch' AND is_delete='0'")->row_array();
        $data['branch_name']=$data['b_header']['name'];
        

        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
       $data['class']=$this->db->query("SELECT   class.class_id as id,count(student.id)as std , count(promotion.id) as ptd , class.class_name,class.orderr
                                FROM `promotion`
                                INNER join class on class.class_id = promotion.class_id
                                INNER join section on section.section_id = promotion.section_id
                                INNER join student on student.id = promotion.student_id
                               
                                where promotion.is_active=1
                                and promotion.is_delete=0
                                and section.is_delete=0
                                and student.is_delete=0
                                and student.branch= '$branch'
                                and class.is_delete=0
                                GROUP by class.class_name
                                order by class.orderr asc
                                ")->result_array();
        // echo "<pre>";print_r($data['class']);exit;
 
        $this->load->view('report/attendance_status',$data);

       }
       
        public function discount()
        {
           // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/discount',$data);
       // $this->load->view('footer',$data);
        }

 public function print_discount($month='') 
        {
          $branch =$this->input->post('branch', TRUE);
           $class =$this->input->post('class', TRUE);
          $section =$this->input->post('section', TRUE);
          $month =$this->input->post('month', TRUE);
           $student =$this->input->post('student', TRUE);
          
          if(empty($branch))
         {
          $branch =$this->report_model->getBranch()[0]['id'];
      }
       $data['student']=$student;
      $data['branch']=$branch;
      $data['class']=$class;
      $data['section']=$section;
      $data['month']=$month;
                // var_dump($data['branch'],$data['class'],$data['section'],$data['month']); die();
          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

            $this->db->select('student.student_name,student.father_name ,student.sid,student.grno,invoice.discount,
             class.class_name, section.section_name,invoice.date')
            ->from('student');
            $this->db->join('promotion', 'promotion.student_id = student.id ');
            $this->db->join('class', 'class.class_id = promotion.class_id ');
            $this->db->join('section', 'section.section_id = promotion.section_id');
             $this->db->join('invoice', 'invoice.student_id  = promotion.id');

            if($class!=""){
            $this->db->where('promotion.class_id', $class);
            }
            
            if($student!=""){
            $this->db->where('student.id', $student);
            }
           
            if($branch!=""){

            $this->db->where('student.branch', $branch);
            }
             if($section!=""){
            $this->db->where('promotion.section_id', $section);
            }
             if($month!=""){
            $this->db->where('left(invoice.date,7)=',$month);
            }
             $this->db->where(' invoice.discount!= ',0);
            $this->db->where('student.is_delete', 0);
            $this->db->where(' promotion.is_active',1);
            //$this->db->where(' student.status',0);
            $this->db->where(' class.is_delete',0);
            
            
          $data['student'] = $this->db->get()->result_array();
           // var_dump($data['student']); die();
             if(empty($data['student']))
               {
                             $this->session->set_flashdata('msg', "No Data Found!");     
                             redirect('Report/discount');
                              
               }
               else {
            
         $this->load->view('report/print_discount',$data);}
        }   


              public function late_fine_report()
        {
           // var_dump('hello'); die();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] =$this->user_model->userInfo("first_name,last_name");
        $data['branchId']=$this->report_model->getBranch()[0]['id'];
        $data['branches']=$this->report_model->getAllBranches();
        $data['classes']=$this->report_model->getAllRecords('class',array('is_delete'=>0, 'branch'=>$data['branchId']));
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/late_fine',$data);
       // $this->load->view('footer',$data);
        }


        public function print_late_fine_report() 
        {
          $branch =$this->input->post('branch', TRUE);
           $class =$this->input->post('class', TRUE);
          $section =$this->input->post('section', TRUE);
          $startdate =$this->input->post('datefrom', TRUE);
          
          if(empty($branch))
         {
          $branch =$this->report_model->getBranch()[0]['id'];
      }

      $data['branch']=$branch;
      $data['class']=$class;
      $data['section']=$section;
      $data['startdate']=$startdate;

      // var_dump($data['branch'],$data['class'],$data['section'],$data['gender'],$data['startdate'],$data['enddate']); die();

          $data['branch_name']=$this->report_model->getBranch()[0]['name'];
          $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];

            $this->db->select('student.student_name, student.father_name ,student.grno,student.sid,
             class.class_name, section.section_name,
              invoice.fine,fee_submit_logs.inv_id,invoice.date_expire, fee_submit_logs.date as submit_date')
            ->from('student');
            $this->db->join('promotion', 'promotion.student_id = student.id ');
            $this->db->join('class', 'class.class_id = promotion.class_id ');
            $this->db->join('section', 'section.section_id = promotion.section_id');
            $this->db->join('invoice', 'invoice.student_id  = promotion.id');
            $this->db->join(' fee_submit_logs', 'invoice.id  =  fee_submit_logs.inv_id');

            if($startdate!=""){
            $this->db->where('left(invoice.date,7)=',$startdate);
            }
            if($class!=""){
            $this->db->where('promotion.class_id', $class);
            }
            if($section!=""){
            $this->db->where('promotion.section_id', $section);
            }
            if($branch!=""){

            $this->db->where('student.branch', $branch);
            }
            $this->db->where(' promotion.is_active',1);
            $this->db->where(' invoice.is_delete',0);
            $this->db->where(' class.is_delete',0);
            $this->db->where(' section.is_delete',0);
            $this->db->where(' fee_submit_logs.fine!=',0);
          $data['student'] = $this->db->get()->result_array();
            
         $this->load->view('report/late_fine_print',$data);
        }   



        public function result_sheet()
    {
    
       
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['class'] = $this->db->query("SELECT * from class where branch = $branch and is_delete = 0")->result_array();
		//var_dump("<pre>", $data['class']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('exam/result_sheet.php',$data);
    }
    
   public function view_result_sheet()
	{
		
        $branch = $this->user_model->getBranch();
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->user_model->check_permissions("branch/view");
        $data['branch_id'] = $branch;
        $data['menu'] = $this->load_model->menu();
		$class = $this->input->post('class',true);
		$exam = $this->input->post('exam',true);

        $section = $this->input->post('section',true);
		if(!empty($class) && !empty($exam) && !empty($section))
		{
			$class_order=$this->db->select('orderr')
                                         ->from('class')
                                         ->where('class_id',$class)
                                         ->get()->row_array()['orderr'];
            if($class_order<=5)
            {
                $data['seat_plan'] = $this->db->query("SELECT *,result.id as resid,exam_type.name as e_name ,section.section_name
                                                            FROM seating_plans 
                                                            inner join student on student.id=seating_plans.student_id
                                                            inner join promotion on promotion.student_id=student.id
                                                            inner join result on result.promotion_id=promotion.id
                                                            inner join class on class.class_id=promotion.class_id
                                                            inner join section on section.section_id=promotion.section_id
                                                	        inner join exam_type on exam_type.id = seating_plans.exam
                                                            WHERE seating_plans.branch=$branch and promotion.is_active=1 and section.section_id = $section 
                                                            and seating_plans.exam =$exam and seating_plans.is_delete = 0 and student.status=0
                                                            ORDER BY right(seating_plans.seat_no,2) asc,seating_plans.id DESC")->result_array();
                     
                     $data['section_name'] = $this->db->select('section_name')->where('section_id',$section)->get('section')->row_array()['section_name'];
                    
			         $data['exam_name'] = $this->db->select('name')->where('is_delete',0)->where('id',$exam)->get('exam')->row(); 

                            $this->load->view('report/view_result_sheet.php',$data);
            }else{
                $data['seat_plan'] = $this->db->query("SELECT * ,result.id as resid,block.name as block_name,exam_type.name as e_name ,section.section_name 
			FROM seating_plans 
             join student on student.id=seating_plans.student_id
             join promotion on promotion.student_id=seating_plans.student_id
             join result on result.promotion_id=promotion.id
             join class on class.class_id=promotion.class_id
             join section on section.section_id=promotion.section_id
             join block  on block.id = seating_plans.block
	         join exam_type on exam_type.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and promotion.is_active=1 and section.section_id = $section and seating_plans.exam =$exam and seating_plans.class_id = $class and seating_plans.is_delete = 0 and student.status=0
            ORDER BY right(seating_plans.seat_no,2) asc,seating_plans.id DESC")->result_array();
                var_dump($class); die;
                $data['section_name'] = $data['seat_plan'][0]['section_name'];
			    $data['exam_name'] = $this->db->select('name')->where('is_delete',0)->where('id',$exam)->get('exam')->row();
			  
       		    $this->load->view('report/view_result_sheet.php',$data);
            }    
                                         
			
              

			
	       }
	       
           
	}
              
             
     public function ledger_accounts()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['heads']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('parent',0)
                                ->get()->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/ledger",$data);
       // $this->load->view('footer',$data);
    }
    
      public function print_custom_ledgerajax($head)
    {
        $ar=array();
         $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
         $branch=$this->report_model->getBranch()[0];
      $data['from']= $this->session->userdata('from');
      $data['to']=$this->session->userdata('to');
         $from= $data['from'];

         $to= $data['to'];
         
             $nts =$from;
$datee = str_replace('/', '-', $nts);
$data['rev_frm']= date('Y-m-d', strtotime($datee));

$ntss =$to;
$datee2 = str_replace('/', '-',$ntss);
$data['rev_to']= date('Y-m-d', strtotime($datee2));

        $data['h_name']=$this->db->select('*')
                            ->from('account_heads')
                            ->where('id',$head)
                            ->get()->row_array(); 
                           
        if(empty($head))
        {
           $pti=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->order_by('id','ASC')
                                ->get()->result_array();
                  $newarry = array();
                 foreach ($pti as $key=>$row)
                 {
            
                     $newarry[] = $row['id'];
                     
                 } 
                $data['heads']=$newarry; 
        }else
        {
            $heads=$this->db->select('*')
                            ->from('account_heads')
                            ->where('id',$head)
                            ->get()->result_array();
                    $check_levl=$heads[0]['has_child'];
                    $check_id=$heads[0]['id'];
                if($check_levl==0) 
                {
                    array_push( $ar,$heads);
                   // $arr[]=$heads;
                }else
                {
                    $lev_2_child=$this->db->select('*')
                                          ->from('account_heads')
                                          ->where('parent',$check_id)
                                          ->get()->result_array();
                        
                       if(!empty($lev_2_child))
                       {
                           foreach($lev_2_child as $key=>$lv2)
                           {
                               $chk_child=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$lv2['id'])
                                                   ->get()->result_array();
                                  $check_inr_chld=$chk_child[0]['has_child']; 
                             
                                  if($check_inr_chld==0)
                                  {
                                      array_push( $ar,$chk_child);
                                    //$arr[]=$chk_child;  
                                  }else
                                  {
                                $lev_3=$this->db->select('*')
                                          ->from('account_heads')
                                          ->where('parent',$lv2['id'])
                                          ->get()->result_array();
                                          
                                    if(!empty($lev_3)) 
                                    {
                                        foreach($lev_3 as $key=>$non_c)
                                        {
                                            $non_chl=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$non_c['id'])
                                                   ->get()->result_array();
                                     $check_non_chld=$non_chl[0]['has_child'];     
                                         if($check_non_chld==0)
                                         {
                                           array_push( $ar,$non_chl);
                                       // $arr[]=$non_chl;  
                                           }else
                                           {
                                        $lev_4=$this->db->select('*')
                                                     ->from('account_heads')
                                                  ->where('parent',$non_c['id'])
                                                     ->get()->result_array();
                                        if(!empty($lev_4)) 
                                        {
                                            foreach($lev_4 as $key=>$no_inr)
                                            {
                                             $non_innr=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$no_inr['id'])
                                                   ->get()->result_array();
                                     $check_non_prnt=$non_innr[0]['has_child'];
                                     if($check_non_prnt==0)
                                     {
                                       array_push( $ar,$non_innr);
                                       //$arr[]=$non_innr;    
                                     }else
                                     {
                                       $lev_5=$this->db->select('*')
                                                 ->from('account_heads')
                                               ->where('parent',$no_inr['id'])
                                                ->get()->result_array();
                                      if(!empty($lev_5)) 
                                      {
                                          foreach($lev_5 as $key=>$tpl)
                                          {
                                        $non_ptcl=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$tpl['id'])
                                                   ->get()->result_array();
                                     $check_non_prnt2=$non_ptcl[0]['has_child'];
                                     if($check_non_prnt2==0)
                                     {
                                          array_push($ar,$non_ptcl);
                                        //$arr[]=$non_ptcl;   
                                     }else
                                     {
                                        
                                    $lev_6=$this->db->select('*')
                                                 ->from('account_heads')
                                               ->where('parent',$tpl['id'])
                                                ->get()->result_array(); 
                                    if(!empty($lev_6)) 
                                    {
                                       foreach($lev_6 as $key=>$smtp) 
                                       {
                                        $non_raw=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$smtp['id'])
                                                   ->get()->result_array();
                                     $check_non_prnt3=$non_raw[0]['has_child'];
                                     if($check_non_prnt3==0)
                                     {
                                         array_push( $ar,$non_raw);
                                       // $arr[]=$non_raw;    
                                     }else
                                     {
                                        $lev_7=$this->db->select('*')
                                                 ->from('account_heads')
                                               ->where('parent',$smtp['id'])
                                                ->get()->result_array(); 
                                        if(!empty($lev_7))
                                        {
                                            foreach($lev_7 as $key=>$issb)
                                            {
                                              $non_fbi=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$issb['id'])
                                                   ->get()->result_array(); 
                                       $check_non_prnt4=$non_fbi[0]['has_child'];
                                       if($check_non_prnt4==0)
                                       {
                                           array_push( $ar,$non_fbi);
                                         // $arr[]=$non_fbi;  
                                       }//i think here is end if add more heads then continue from here in else statment
                                         }
                                        }
                                     }
                                       }
                                    }
                                         
                                     }
                                       }
                                      }
                                     }
                                            }
                                        }
                                           }
                                        }
                                    }
                                  }
                           }
                       }
                                          
                }
                $newarr = array();
                 foreach ($ar as $key=>$row)
                 {
            
                     $newarr[] = $row[0]['id'];
                     
                 }
           
            $data['heads']=$newarr;              
        }
 
        $this->load->view("report/ledger_history",$data);
     }
     
    public function fetch_subhead($c)
    {
        $sub_head=$this->db->select('*')
                           ->from('account_heads')
                           ->where('parent',$c)
                           ->get()->result_array();
         if(!empty($sub_head))
         {
            echo "
               <div class='item form-group'>
               <label class='control-label col-md-4 col-sm-3 col-xs-12' for='name'>Head</label>
                <div class='col-md-4 col-sm-6 col-xs-6'>
                <select name='head[]' id='head' class='form-control'>
                   <option value=''>Select Sub Head</option>";
             foreach($sub_head as $key=>$val)
             {
                 echo "<option value='$val[id]'>$val[name]</option>";
             }
             echo "</select></div>";
         }
    }
    
    
//    remove it when all accounts reports complete
    
  public function print_summary_ledgerajax()
    {
        $ar=array();
           $branch=$this->report_model->getBranch()[0];
                $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                $data['b_header']= $this->report_model->BranchHeader();
          $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
         $data['from']=$this->input->post('from');
         $from=$this->input->post('from');
        $data['to']=$this->input->post('to');
        $data['comment']=$this->input->post('comment');
        $data['ori']=$this->input->post('ori');
         $to=$this->input->post('to');
         $this->session->set_userdata('from',$from);
         $this->session->set_userdata('to',$to);
         $nts =$from;
            $datee = str_replace('/', '-', $nts);
        $data['rev_frm']= date('Y-m-d', strtotime($datee));
$ntss =$to;
$datee2 = str_replace('/', '-',$ntss);
$data['rev_to']= date('Y-m-d', strtotime($datee2));

        $head=$this->input->post('last_val');


        if($head<0)
        {
            $data['h_name']="All";

           $pti=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->get()->result_array();
                  $newarry = array();
                 foreach ($pti as $key=>$row)
                 {
            
                     $newarry[] = $row['id'];
                     
                 } 
                $data['heads']=$newarry; 
//       $data['quet']=$this->db->query("SELECT account_heads.name,transction.* FROM account_heads INNER JOIN transction ON account_heads.id=transction.head WHERE account_heads.id='$head'")->result_array();

        }else
        {

            $heads=$this->db->select('*')
                            ->from('account_heads')
                            ->where('id',$head)
                            ->get()->row_array();

            $data['h_name']=$heads['name'];
                    $check_levl=$heads['has_child'];
                    $check_id=$heads['id'];
                if($check_levl==0) 
                {

                    array_push( $ar,$heads);

                   // $arr[]=$heads;
                }else
                {
                    $lev_2_child=$this->db->select('*')
                                          ->from('account_heads')
                                          ->where('parent',$check_id)
                                          ->get()->result_array();
                        
                       if(!empty($lev_2_child))
                       {
                           foreach($lev_2_child as $key=>$lv2)
                           {
                               $chk_child=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$lv2['id'])
                                                   ->get()->result_array();
                                  $check_inr_chld=$chk_child[0]['has_child']; 
                             
                                  if($check_inr_chld==0)
                                  {
                                      array_push( $ar,$chk_child);
                                    //$arr[]=$chk_child;  
                                  }else
                                  {
                                $lev_3=$this->db->select('*')
                                          ->from('account_heads')
                                          ->where('parent',$lv2['id'])
                                          ->get()->result_array();
                                          
                                    if(!empty($lev_3)) 
                                    {
                                        foreach($lev_3 as $key=>$non_c)
                                        {
                                            $non_chl=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$non_c['id'])
                                                   ->get()->result_array();
                                     $check_non_chld=$non_chl[0]['has_child'];     
                                         if($check_non_chld==0)
                                         {
                                           array_push( $ar,$non_chl);
                                       // $arr[]=$non_chl;  
                                           }else
                                           {
                                        $lev_4=$this->db->select('*')
                                                     ->from('account_heads')
                                                  ->where('parent',$non_c['id'])
                                                     ->get()->result_array();
                                        if(!empty($lev_4)) 
                                        {
                                            foreach($lev_4 as $key=>$no_inr)
                                            {
                                             $non_innr=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$no_inr['id'])
                                                   ->get()->result_array();
                                     $check_non_prnt=$non_innr[0]['has_child'];
                                     if($check_non_prnt==0)
                                     {
                                       array_push( $ar,$non_innr);
                                       //$arr[]=$non_innr;    
                                     }else
                                     {
                                       $lev_5=$this->db->select('*')
                                                 ->from('account_heads')
                                               ->where('parent',$no_inr['id'])
                                                ->get()->result_array();
                                      if(!empty($lev_5)) 
                                      {
                                          foreach($lev_5 as $key=>$tpl)
                                          {
                                        $non_ptcl=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$tpl['id'])
                                                   ->get()->result_array();
                                     $check_non_prnt2=$non_ptcl[0]['has_child'];
                                     if($check_non_prnt2==0)
                                     {
                                          array_push($ar,$non_ptcl);
                                        //$arr[]=$non_ptcl;   
                                     }else
                                     {
                                        
                                    $lev_6=$this->db->select('*')
                                                 ->from('account_heads')
                                               ->where('parent',$tpl['id'])
                                                ->get()->result_array(); 
                                    if(!empty($lev_6)) 
                                    {
                                       foreach($lev_6 as $key=>$smtp) 
                                       {
                                        $non_raw=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$smtp['id'])
                                                   ->get()->result_array();
                                     $check_non_prnt3=$non_raw[0]['has_child'];
                                     if($check_non_prnt3==0)
                                     {
                                         array_push( $ar,$non_raw);
                                       // $arr[]=$non_raw;    
                                     }else
                                     {
                                        $lev_7=$this->db->select('*')
                                                 ->from('account_heads')
                                               ->where('parent',$smtp['id'])
                                                ->get()->result_array(); 
                                        if(!empty($lev_7))
                                        {
                                            foreach($lev_7 as $key=>$issb)
                                            {
                                              $non_fbi=$this->db->select('*')
                                                   ->from('account_heads')
                                                   ->where('id',$issb['id'])
                                                   ->get()->result_array(); 
                                       $check_non_prnt4=$non_fbi[0]['has_child'];
                                       if($check_non_prnt4==0)
                                       {
                                           array_push( $ar,$non_fbi);
                                         // $arr[]=$non_fbi;  
                                       }//i think here is end if add more heads then continue from here in else statment
                                         }
                                        }
                                     }
                                       }
                                    }
                                         
                                     }
                                       }
                                      }
                                     }
                                            }
                                        }
                                           }
                                        }
                                    }
                                  }
                           }
                       }
                                          
                }
                $newarr = array();
                  $tot=count($ar);

            if($tot<=1)
            {
                foreach ($ar as $key=>$row)
                {

                    $newarr[] = $row['id'];

                }
            }
            if($tot>1)
            {
                foreach ($ar as $key=>$row)
                {

                    $newarr[] = $row[0]['id'];

                }
            }

           
            $data['heads']=$newarr;              
        }
        if($data['ori']=='Landscape') {
            $this->load->view("report/ledgerviewLan", $data);
        }
        else{
            $this->load->view("report/ledgerview", $data);
        }
     }
	
 
 
     public function print_summary_ledgerajax1()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $from=$this->input->post('from');
        $to=$this->input->post('to');
        $data['ori']=$this->input->post('ori');
        $data['comments']=$this->input->post('comment');
        $data['chart']=$this->input->post('chart');
//        $ch=$data['chart'];
//       $re=str_replace("-","",$ch);

        $data['from']=$from;
        $data['to']=$to;
        if($data['ori']=='Portrait') {
            $this->load->view("report/ledgerpor", $data);
        }
        else {
            $this->load->view("report/ledgerLan", $data);
        }


    }
 
      public function print_bank_summary()
    {
        if ($this->input->post()) {

            $data['is_super'] = $this->user_model->is_super();
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['from'] = $this->input->post("from", true);
              $data['bank'] = $this->input->post("bank", true);
            $data['to'] = $this->input->post("to", true);
            $data['comment'] = $this->input->post("comment", true);
            $data['orient'] = $this->input->post("ori", true);
            if($data['orient']=='Landscape') {
                $this->load->view('report/banksummaryLan', $data);
            }
            else{
                $this->load->view('report/banksummarypor', $data);

            }


        }
    }
      public function vouchers()
        {
            if($this->input->post())
            {
                $data=$this->account_model->up();
                $post=$this->input->post();
                $branch=$this->user_model->getbranch(); 
                $type=$post['type'];
                $data['type']=$type;
              if($type=="petty cash")
              {
              $dataa['b_header'] = $this->db->query("SELECT `title`,`tagline`,`short_address`,`phone_no`,`email`,`logo1`,`logo2` FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->result_array()[0];
         $dataa['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->result_array()[0];
         
              $data['transcc']=$this->db->select('*')
                                       ->from('transction')
                                       ->where('type',$type)
                                       ->where('is_checked',1)
                                       ->where('branch',$branch)
                                        ->group_by('sht_no')
                                       ->get()->result_array();
            $this->account_model->down('account/petty_sheets',$data);
              }else
              {
              $data['transc']=$this->db->select('*')
                                       ->from('transction')
                                       ->where('type',$type)
                                       ->group_by('transction_id')
                                       ->where('branch',$branch)
                                       ->get()->result_array();
               $this->account_model->down('account/jv',$data);
              } 
             }
        }

 
 
 //remove and concern it
 public function trail_balance()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['heads']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('parent',0)
                                ->get()->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/trail_blnc",$data);
       // $this->load->view('footer',$data);
    }
    
        public function trial_balance()
    {
        if ($this->input->post()) {

            $data['is_super'] = $this->user_model->is_super();
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            //$data['onlybal'] = $this->input->post("onlybal", true);
            $data['sdate'] = $this->input->post("from", true);
            $data['enddate'] = $this->input->post("to", true);
            $data['zerovalues'] = $this->input->post("zerovalues", true);
            $data['comment'] = $this->input->post("comment", true);
            $data['orient'] = $this->input->post("ori", true);
            $data['destination'] = $this->input->post("dest", true);
            if($data['orient']=='Landscape') {
                $data['query'] = $this->db->query("SELECT * FROM `account_heads` order by replace(code, '-', '') asc")->result_array();
                $this->load->view('report/trialbalancelan', $data);
            }
            else{
                $data['query'] = $this->db->query("SELECT * FROM `account_heads` order by replace(code, '-', '') asc")->result_array();
                $this->load->view('report/trialbalance', $data);

            }


        }
    }
    
            public function trial_balance2()
    {
        if ($this->input->post()) {

            $data['is_super'] = $this->user_model->is_super();
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            //$data['onlybal'] = $this->input->post("onlybal", true);
            $data['sdate'] = $this->input->post("from", true);
            $data['enddate'] = $this->input->post("to", true);
            // $data['zerovalues'] = $this->input->post("zerovalues", true);
            $data['comment'] = $this->input->post("comment", true);
            $data['orient'] = $this->input->post("ori", true);
            if($data['orient']=='Landscape') {
                $data['query'] = $this->db->query("SELECT * FROM `account_heads` order by replace(code, '-', '') asc")->result_array();
                $this->load->view('report/trialbalancelan2', $data);
            }
            else{
                $data['query'] = $this->db->query("SELECT * FROM `account_heads` order by replace(code, '-', '') asc")->result_array();
                $this->load->view('report/trialbalance2', $data);

            }


        }
    }
    
              public function print_cash_flow()
    {
        if ($this->input->post()) 
        {

            $data['is_super'] = $this->user_model->is_super();
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            //$data['onlybal'] = $this->input->post("onlybal", true);
            $data['from'] = $this->input->post("from", true);
            $data['to'] = $this->input->post("to", true);
            // $data['zerovalues'] = $this->input->post("zerovalues", true);
            $data['comment'] = $this->input->post("comment", true);
            $this->load->view('report/cashflow', $data);
           
}

    }
    
    
    
    
                public function print_bank_statement()
    {
        if ($this->input->post()) {

            $data['is_super'] = $this->user_model->is_super();
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['from'] = $this->input->post("from", true);
              $data['bank'] = $this->input->post("bank", true);
            $data['to'] = $this->input->post("to", true);
            $data['zerovalues'] = $this->input->post("zerovalues", true);
            $data['comment'] = $this->input->post("comment", true);
            $data['orient'] = $this->input->post("ori", true);
            if($data['orient']=='Landscape') {
                $this->load->view('report/bankstatementLan', $data);
            }
            else{
                $this->load->view('report/bankstatementpor', $data);

            }


        }
    }
    
      public function bankstatement_wr()
    {
        if ($this->input->post()) {

            $data['is_super'] = $this->user_model->is_super();
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
            $data['branch_name']=$this->report_model->getBranch()[0]['name'];
            $data['b_header']= $this->report_model->BranchHeader();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['from'] = $this->input->post("from", true);
            $data['to'] = $this->input->post("to", true);
             $data['bank'] = $this->input->post("bank", true);
            $data['comment'] = $this->input->post("comment", true);
            $this->load->view('report/bankstatementwr', $data);
            
            
        }
    }
    

  public function fetch_custm_trial()
    {
    $id=$_POST['ids'];
   $heads=$this->db->query("SELECT * FROM `account_heads` where  `is_delete` = 0 AND has_child = '0'
        ORDER BY most_parent ASC,SUBSTRING(code, 3, 4) ASC,SUBSTRING(code, 6, 7) ASC,SUBSTRING(code, 9, 10) ASC")->result_array();
$smdr=0;
$smcr=0;

$datee = str_replace('/', '-', $id);
$dateto= date('Y-m-d', strtotime($datee));

if(!empty($heads))
{
     $branch=$this->user_model->getbranch();
    foreach($heads as $key=>$values)
    {
   $totdr=0;
   $totcr=0;
         $tot_dr_amt=$this->db->select('sum(amount) as amount')
                              ->from('transction')
                              ->where('head',$values['id'])
                               ->where('date <=',$dateto)
                              ->where('branch',$branch)
                              ->where('has_cr',1)
                              ->get()->row_array()['amount']; 
                              
        $tot_cr_amt=$this->db->select('sum(amount) as amount')
                              ->from('transction')
                              ->where('head',$values['id'])
                               ->where('date <=',$dateto)
                              ->where('branch',$branch)
                              ->where('has_cr',0)
                              ->get()->row_array()['amount']; 
          if(!empty($tot_dr_amt))
             {
                 $totdr=$tot_dr_amt;
             }else
             {
                 $totdr=0;
             }
                    
           if(!empty($tot_cr_amt))
              {
                   $totcr=$tot_cr_amt;
              }else
             {
                 $totcr=0;
             }
        $op_blnc=$this->db->select('*')
                                ->from('opening_balance')
                                ->where('head',$values['id'])
                                ->where('branch',$branch)
                                ->get()->row();
            if(!empty($op_blnc))
            {
                   if($op_blnc->has_cr == 0)
                    {
                        $totcr=$totcr+$op_blnc->amount;
                    }else
                    { 
                        $totdr=$totdr+$op_blnc->amount;
                    } 
            }
           
            $diff=$totdr-$totcr;
            if(!empty($diff))
                 {
                  
                   if($diff >=0)  
                            {
                                $smdr=$smdr+$diff;
                              echo " <tr>
                              <td>";
                              $cod=$this->db->select('code')
                                                 ->from('account_heads')
                                                 ->where('id',$values['id'])
                                                 ->get()->row_array()['code'];
                                                 echo $cod;
                              echo "</td>";
                             echo"<td>";
                       if($values['parent'] !=0) 
                       {        
                         $fetch_parents_lev0=0;
                         $fetch_parents_lev1=0;
                         $fetch_parents_lev2=0;
                         $fetch_parents_lev3=0;
                         $fetch_parents_lev4=0;
                         $fetch_parents_lev5=0;
                         $fetch_parents_lev6=0;
                         $fetch_parents_lev7=0;
                       
                          $fetch_parents_lev0=$this->db->select('*')
                                                 ->from('account_heads')
                                                 ->where('id',$values['id'])
                                                 ->get()->row();
                              $names[]=$fetch_parents_lev0->name;
                              $fetch_parents_lev0=$fetch_parents_lev0->parent;
                          if($fetch_parents_lev0!= 0)
                              {                       
                        $fetch_parents_lev1=$this->db->select('*')
                                                 ->from('account_heads')
                                                 ->where('id',$fetch_parents_lev0)
                                                 ->get()->row();
                              $names[]=$fetch_parents_lev1->name;
                              $fetch_parents_lev1=$fetch_parents_lev1->parent;
                              }
                         if($fetch_parents_lev1!= 0)
                         
                              {
                           $fetch_parents_lev2=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev1)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev2->name;
                                 $fetch_parents_lev2=$fetch_parents_lev2->parent;
                              }
                              if($fetch_parents_lev2!= 0)
                              {
                           $fetch_parents_lev3=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev2)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev3->name;     
                                 $fetch_parents_lev3=$fetch_parents_lev3->parent;     
                              }
                           if($fetch_parents_lev3 != 0)
                              {
                           $fetch_parents_lev4=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev3)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev4->name;            
                                 $fetch_parents_lev4=$fetch_parents_lev4->parent;     
                              }
                              
                              if($fetch_parents_lev4 != 0)
                              {
                           $fetch_parents_lev5=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev4)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev5->name;           
                                 $fetch_parents_lev5=$fetch_parents_lev5->parent;     
                              }
                              
                              if($fetch_parents_lev5 != 0)
                              {
                           $fetch_parents_lev6=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev5)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev6->name;            
                                 $fetch_parents_lev6=$fetch_parents_lev6->parent;     
                              }
                              
                               if($fetch_parents_lev6 != 0)
                              {
                           $fetch_parents_lev7=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev6)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev7->name;                 
                              }
                            
                             $names= array_reverse($names);
                              if(!empty($names)){
                               
                                 $i=1;
                              $len=count($names);
                                 foreach($names as $key=>$valtm)
                                 {
                                     
                                     echo  " ".$valtm;
                                     if($i != $len)
                                     {
                                      echo  "-";
                                     }
                                     $i++;
                                 }
                                 unset($names); 
                             }
                             
                              }else
                              {  
                                echo $values['name'];
                               } 
                               
                                echo "</td> 
                            <td style= 'text-align: right;'>";
                              echo  number_format($diff);
                            echo "</td>
                                <td></td>
                                </tr>";
                             }else
                            {
                                $smcr=$smcr+$diff;
                              echo " <tr>
                              <td>";
                              $cod=$this->db->select('code')
                                                 ->from('account_heads')
                                                 ->where('id',$values['id'])
                                                 ->get()->row_array()['code'];
                                   echo $cod;
                              echo "</td>";
                             echo"<td>";
                               
                       if($values['parent'] !=0) 
                       {        
                         $fetch_parents_lev0=0;
                         $fetch_parents_lev1=0;
                         $fetch_parents_lev2=0;
                         $fetch_parents_lev3=0;
                         $fetch_parents_lev4=0;
                         $fetch_parents_lev5=0;
                         $fetch_parents_lev6=0;
                         $fetch_parents_lev7=0;
                       
                          $fetch_parents_lev0=$this->db->select('*')
                                                 ->from('account_heads')
                                                 ->where('id',$values['id'])
                                                 ->get()->row();
                              $names[]=$fetch_parents_lev0->name;
                              $fetch_parents_lev0=$fetch_parents_lev0->parent;
                          if($fetch_parents_lev0!= 0)
                              {                       
                        $fetch_parents_lev1=$this->db->select('*')
                                                 ->from('account_heads')
                                                 ->where('id',$fetch_parents_lev0)
                                                 ->get()->row();
                              $names[]=$fetch_parents_lev1->name;
                              $fetch_parents_lev1=$fetch_parents_lev1->parent;
                              }
                         if($fetch_parents_lev1!= 0)
                         
                              {
                           $fetch_parents_lev2=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev1)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev2->name;
                                 $fetch_parents_lev2=$fetch_parents_lev2->parent;
                              }
                              if($fetch_parents_lev2!= 0)
                              {
                           $fetch_parents_lev3=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev2)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev3->name;       
                                 $fetch_parents_lev3=$fetch_parents_lev3->parent;     
                              }
                           if($fetch_parents_lev3 != 0)
                              {
                           $fetch_parents_lev4=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev3)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev4->name;           
                                 $fetch_parents_lev4=$fetch_parents_lev4->parent;     
                              }
                              
                              if($fetch_parents_lev4 != 0)
                              {
                           $fetch_parents_lev5=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev4)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev5->name;           
                                 $fetch_parents_lev5=$fetch_parents_lev5->parent;     
                              }
                              
                              if($fetch_parents_lev5 != 0)
                              {
                           $fetch_parents_lev6=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev5)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev6->name;            
                                 $fetch_parents_lev6=$fetch_parents_lev6->parent;     
                              }
                              
                               if($fetch_parents_lev6 != 0)
                              {
                           $fetch_parents_lev7=$this->db->select('*')
                                                 ->from('account_heads')
                                              ->where('id',$fetch_parents_lev6)
                                                 ->get()->row();
                                 $names[]=$fetch_parents_lev7->name;                 
                              }
                            
                             $names= array_reverse($names);
                              if(!empty($names)){
                               
                                 $i=1;
                               $len=count($names);
                                 foreach($names as $key=>$valtm)
                                 {
                                     
                                     echo  " ".$valtm;
                                  if($i != $len)
                                     {
                                      echo  "-";
                                     }
                                    
                                     $i++;
                                 }
                                 unset($names); 
                             }
                             
                              }else
                              {  
                                echo $values['name'];
                               } 
                               
                        echo "</td> 
                                <td></td>
                <td style ='text-align: right;'>";
                echo  number_format(abs($diff));
                echo "</td></tr>";
                        }
                }   //end if
                
           
    }
}
  echo "<tr>";
  echo "<td>";
 echo "-";
  echo "</td>";
      echo "<td  style='font-weight:700'>";
      echo "Total";
      echo "</td>";
         echo "<td style='font-weight:700;text-align: right;'>";
         echo number_format($smdr);
         echo "</td>";
         echo "<td style='font-weight:700;text-align: right;'>";
          echo number_format(abs($smcr));
          echo "</td>";
     echo "</tr>";
     
     
    }
    
    // remove it after reports complete of profit  loss statement
       public function pls()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/pls",$data);
        //$this->load->view('footer',$data);   
    }
    
     public function print_summary_pls()
    {
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
     $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
         $data['comment']=$this->input->post('comment');
        $from=$this->input->post('from');
        $to=$this->input->post('to');
         $data['ori']=$this->input->post('ori');
        $data['from']=$from;
        $data['to']=$to;
        
        $data['heads_inc']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',10)
                                ->get()->result_array();
                    
        $data['heads_exp']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',11)
                                ->get()->result_array();   
                                
                        if($data['ori']=='Portrait') {
                            $this->load->view("report/pls_view", $data);
                        }
        else{

            $this->load->view("report/pls_viewlan", $data);
        }
       
    }
    
    
    //remove it after reports complete of profit loss statement
 public function print_custom_pls($from,$to)
    {
    $data['branch']=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
     

        $data['from']=$from;
        $data['to']=$to;
        
        $data['heads_inc']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',10)
                                ->get()->result_array();
                    
        $data['heads_exp']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',11)
                                ->get()->result_array();                        
                              
        $this->load->view("report/pls_history",$data);
         
    }

public function blnc_sheeet()
    {
         $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("report/balance_sheet",$data);
       // $this->load->view('footer',$data); 
    }
    
  public function print_summary_balance()
    {
      $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
                 $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
      
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        $from=$this->input->post('from');
        $to=$this->input->post('to');
        $data['comment']=$this->input->post('comment');
        $data['from']=$from;
        $data['to']=$to;
        
         $data['heads']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',1)
                                ->group_by('parent')
                                ->get()->result_array();
                                  
        $data['heads_lib']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',8)
                                ->get()->result_array();
                      
          $this->load->view("report/balance_view",$data);
                        
      
    }
    
     public function print_custom_balance($from,$to)
    {
    $data['branch']=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
      

        $data['from']=$from;
        $data['to']=$to;
        
        $data['heads']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',1)
                                ->group_by('parent')
                                ->get()->result_array();
                                  
        $data['heads_lib']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->where('most_parent',8)
                                ->get()->result_array();                        
                              
        $this->load->view("report/balance_history",$data);
         
    }
    public function print_summary_trailajax($dat)
    {
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
       
        $data['to']=$dat;
      
        $data['heads']=$this->db->select('*')
                                ->from('account_heads')
                                ->where('has_child',0)
                                ->get()->result_array();
              
        $this->load->view("report/trail_history",$data);
    }
    
    public function book_datewise()
    {
    
        $data['mydate']=$this->input->post('date');
        $branch=$this->branch;
        $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $data['writer'] = $this->db->select('*')->from('writer')->where('is_delete',0)->get()->result_array();
        $data['catagory'] = $this->db->select('*')->from('catagory')->where('is_delete',0)->get()->result_array();
        $this->load->view('report/book_datewise',$data);
         $this->load->view('footer',$data);
    }
    
    public function get_books_report()
    {
        $cat=$this->input->post('cat');
        $writer=$this->input->post('writer');
        $w =  implode(',', (array)$writer);
        if(!empty($w) && !empty($cat))
        {      
                $branch=$this->report_model->getBranch()[0];
                $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                $data['b_header']= $this->report_model->BranchHeader();
                $branch=$this->user_model->getbranch();
                $data['branch']=$branch; 
                $writer = array();
                foreach ($cat as $key => $value) {
                $writer[] = $this->db->query("
                SELECT item.pub_name as p_name,item.cat_name as c_name,item.writer_name as w_name,item.edition , item.name as it_name,item.isbn,price,alm_name
                FROM `item`
                where item.writer_id IN ($w)
                and  item.cat_id = $value
                and  item.is_delete = '0'
                ORDER BY item.writer_id and ORDER BY cast(item.isbn as unsigned) asc")->result_array();
                }
                $data['writer']= $writer;
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                // var_dump("fasdf");die;
                if(empty( $data['writer']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                    redirect("Report/book_datewise", "refresh");
                }
                    $this->load->view('report/book_datewiseList',$data);
        }
        else if(!empty($w) && empty($cat))
        {
                $branch=$this->report_model->getBranch()[0];
                $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                $data['b_header']= $this->report_model->BranchHeader();
                $branch=$this->user_model->getbranch();
                $data['branch']=$branch; 
                $data['writer'] = $this->db->query("
                SELECT item.pub_name as p_name,item.cat_name as c_name,item.writer_name as w_name,item.edition , item.name as it_name,item.isbn,price,alm_name
                FROM `item`
                where item.writer_id IN ($w)
                and  item.is_delete = '0'
                ORDER BY item.writer_id and ORDER BY cast(item.isbn as unsigned) asc")->result_array();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                if(empty( $data['writer']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                    redirect("Report/book_datewise", "refresh");
                }
                    $this->load->view('report/book_datewiseLists',$data);
        }
        else if(!empty($cat) && empty($w)) 
        {
           
                $branch=$this->report_model->getBranch()[0];
                $data['branch_name']=$this->report_model->getBranch()[0]['name'];
                $data['b_header']= $this->report_model->BranchHeader();
                $branch=$this->user_model->getbranch();
                $data['branch']=$branch; 
                $c =  implode(',', (array)$cat);
                $data['writer'] = $this->db->query("
                SELECT item.pub_name as p_name,item.cat_name as c_name,item.writer_name as w_name,item.edition , item.name as it_name,item.isbn,price,alm_name
                FROM `item`
                where item.cat_id IN ($c)
                and  item.is_delete = '0'
                ORDER BY item.isbn asc")->result_array();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                if(empty( $data['writer']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                    redirect("Report/book_datewise", "refresh");
                }
                    $this->load->view('report/book_datewiseLists',$data);
        }
    }
    
    public function att_selected_datewise()
    {
        // 

        if($this->input->post()){
            $postdata=$this->input->post();
            if(isset($postdata['Datesubmit'])) {
                // var_dump($this->input->post('date'));die();
                $data['mydate']=$this->input->post('date');
            }
        }
            $branch=$this->branch;
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            //$data['department']=$this->db->where('is_delete',0)->get('department')->result_array();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('report/att_selected_datewise',$data);
           // $this->load->view('footer',$data);
    }
    
    public function fetch_att_selected_datewise()
    {
         
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $data['department'] = $this->input->post('department');
        
        $data['person']=$this->input->post('person');
        
        $department=$this->input->post('department');
       // var_dump($department);
       
       $dataperson = array();
       
       $dataperson = $data['person'];
               //var_dump($dataperson );die;

        $person_idList = implode(',', (array)$dataperson );
        
        
        $sdate=$this->input->post('sdate');
        $edate=$this->input->post('edate');
        $stime=$this->input->post('stime');
        $etime=$this->input->post('etime');
       
        if(empty($edate) )
        {
            $edate= date("Y-m-d");
        }
      
            $type=$this->input->post('type');
            if($type==1)
            {
                
                //$department=$this->input->post('department');
                $data['department_name']=$this->db->select('department_name')->where('is_delete',0)->where('id',$department)->get('department')->row_array();
                
                $data['sdate']=$sdate;
                $data['edate']=$edate;
                $branch=$this->branch;
                $data['is_super'] = $this->is_super;
                $data['menu'] = $this->load_model->menu();
           
                $data['teacher']=$this->db->query("
                SELECT teacher.firstname,teacher.lastname,
                teacherattendance.status,
                teacherattendance.date,
                right(teacherattendance.check_in, 9) as check_in,
                right(teacherattendance.check_out, 9) as check_out,
                
                department.name, teacher.designation 
                FROM `teacherattendance`
                INNER JOIN teacher ON teacherattendance.teacher_id=teacher.id
                inner join department on teacher.department = department.id
                WHERE teacherattendance.date >= '$sdate' 
                AND  teacherattendance.date <= '$edate'
                AND teacherattendance.is_deleted=0
                AND teacher.branch='$branch'
                AND department.id ='$department'
                AND teacher.id IN ($person_idList)
                and teacher.status=0
                 AND teacher.is_delete='0'
                 
                ORDER BY teacher.seniority_level asc
                
                
                ")->result_array();
        
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                $data['teacher_2']=$data['teacher'];
           
                if(empty( $data['teacher']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/att_selected_datewise", "refresh");
                }
                $this->load->view('report/teacher_date_wise_att',$data);
            }
            else
            {
                
                //$department=$this->input->post('department');
                $data['department_name']=$this->db->select('department_name')->where('is_delete',0)->where('id',$department)->get('department')->row_array();
                
                $data['sdate']=$sdate;
                $data['edate']=$edate;
                $branch=$this->branch;
                $data['is_super'] = $this->is_super;
                $data['menu'] = $this->load_model->menu();
               
                $data['staff']=$this->db->query("
                SELECT staff.firstname,staff.lastname, 
                
                 staffatt.status_id,
                staffatt.date,
                right(staffatt.check_in, 9) as check_in,
                right(staffatt.check_out, 9) as check_out,
                
                
                department.name, staff.designation 
                FROM `staffatt`
                INNER JOIN staff ON staffatt.staff_id=staff.id
                inner join department on staff.department = department.id
                WHERE staffatt.date >= '$sdate' 
                AND  staffatt.date <= '$edate'
                AND staffatt.is_deleted=0
                AND staff.branch='$branch'
                AND department.id ='$department'
                AND staff.is_delete='0'
                AND staff.id IN ($person_idList)
                ORDER BY staff.seniority_level asc
                  
                  ")->result_array();
                  
                  if(!$data['staff']){
                       $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/att_selected_datewise", "refresh");

                     }
                 
            
        
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                if(empty( $data['staff']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/att_selected_datewise", "refresh");
                }
           
                $this->load->view('report/staff_date_wise_att',$data);
            }
    }
    
    public function monthlyatt_staff()
    {
        $this->user_model->check_permissions("student/studentatt_add");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        
        if(!$this->user_model->is_super())
        { 
            $data['branch']=$this->user_model->getBranch(); 
         }else {
            $data['branch']=$this->student_model->getbranch()->result_array();
         }
        
        $data['Attendancestatus']=$this->Teacher_model->AttendanceStatus();
        $data['department'] = $this->db->select('department_name,id')->from('department')->get()->result_array();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('report/monthlyatt_staff',$data);
    }
    
    public function fetch_monthlyatt_staff()
    {

        @$branch=$this->report_model->getBranch()[0];
        @$data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();

        
        $date=$this->input->post('date');
        $branch=$this->user_model->getbranch();
        $month=  date("Y-m",strtotime($date));
          
          $first_date= date('Y-m-1',strtotime($month));
          $last_date =date('Y-m-t',strtotime($month));
          $current_date= date('Y-m-d');
          $data['month'] = $month;
          $data['month_name'] = date("F", strtotime($current_date));
          $data['year'] = date('Y', strtotime($current_date));
          $temp_first_date= $first_date;
          $data['first_date']=$first_date;
          $data['last_date']=$last_date;
          //var_dump($data['first_date']);die;
          //echo $branch; echo '<br>'; echo $first_date;echo '<br>'; echo $last_date;echo '<br>';echo $current_date;echo '<br>'; 
          $total_days=1;
          while (strtotime($temp_first_date ) <= strtotime($last_date ))
          {
                    
                    $timestamp = strtotime($temp_first_date);
                    //var_dump($timestamp);die;
                    $day= strtolower( date('l',$timestamp) );
                   // var_dump($day);die;
                    
                    if( $day !='sunday')
                    {
                        $total_days++;
                    }
                    
                 
                    
                    $temp_first_date = date ("Y-m-d", strtotime("+1 day", strtotime($temp_first_date )));
              }

//echo 'Total days : '; echo $total_days; die;
        
        $data['total_days']=$total_days;
        $data['staff']=$this->db->query("
            SELECT  staff.firstname as name,staff.designation,staff.branch,department.department_name as d_name, staffatt.staff_id,staffatt.date, COUNT(staffatt.date) as present_days
                                FROM `staff`
                                INNER JOIN staffatt on staff.id=staffatt.staff_id
                                INNER JOIN department on staff.department=department.id 
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status_id=1
                                and staffatt.date >= '$first_date' and staffatt.date <= '$last_date' and staff.branch=$branch
                                GROUP BY staff.firstname,staffatt.status_id,staff.doj asc")->result_array();
                                 
        
                                 
            //var_dump('<pre>',$data['staff']);die;

        //var_dump('<pre>',$data['outdoor_duty']);die;
            
          if(empty($data['staff']))
           {
               $this->session->set_flashdata('msg','Record Not Found');
               redirect("Report/monthlyatt_staff", "refresh");
        
           }
           else{
         $data['base_url'] =  base_url();
         $data['userInfo'] = $this->userInfo;
          $this->load->view('report/display_monthlyatt_staff',$data);
           }
         
    }
    
    public function department_att_daterange()
    {
   
        $data['mydate']=$this->input->post('date');
            
      
        $branch=$this->branch;
       
        $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/department_att_daterange',$data);
        //$this->load->view('footer',$data);
    }
    public function fetch_department_att_daterange()
    {
         $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $branch=$this->user_model->getbranch();
        $data['branch']=$branch; 
     
        $data['department'] = $this->input->post('department');
        $sdate=$this->input->post('sdate');
        if(empty($sdate))
        {
            $sdate=date("Y-m-d");
        }
        $data['sdate']=$sdate;
        $data['edate']=$this->input->post('edate');
        $edate=$this->input->post('edate');
        $edate=$this->input->post('edate');
        if(empty($edate))
        {
            $edate=date("Y-m-d");
            $data['edate']=$edate;
        }
          
        
        $idList = implode(',', (array)$data['department']);
                
        
        $type=$this->input->post('type');


            $type=$this->input->post('type');
           
            if($type==1)
            {
                
                $data['department_name']=$this->db->select('name')->where('is_delete',0)->where_in('id',$idList)->get('department')->row_array();
                $branch=$this->branch;
                $data['is_super'] = $this->is_super;
                $data['menu'] = $this->load_model->menu();
                    
                $data['att']=$this->db->query("
                SELECT teacher.firstname,teacher.lastname,teacher.id as teacher_id,teacher.emp_id,teacher.doj,teacher.grade,  
                teacherattendance.status,
                teacherattendance.date,
                right(teacherattendance.check_in, 9) as check_in,
                right(teacherattendance.check_out, 9) as check_out,
                
                department.name, teacher.designation 
                FROM `teacherattendance`
                INNER JOIN teacher ON teacherattendance.teacher_id=teacher.id
                inner join department on teacher.department = department.id
                WHERE teacherattendance.date >= '$sdate' 
                AND  teacherattendance.date <= '$edate'
                AND teacherattendance.is_deleted=0
                AND teacher.branch='$branch'
                AND department.id IN ($idList)
                
                and teacher.status=0
                AND teacher.is_delete='0'
                 
                ORDER BY teacher.seniority_level asc
                ")->result_array();
                
                if(empty($data['att'])){
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/department_att_daterange", "refresh");
                }
                else{
                $staff_ids = array_column($data['att'],"teacher_id");
                $staff_idss = implode(',', (array)$staff_ids);
                $data['absents']=$this->db->query("
                    SELECT  teacher.firstname,teacher.lastname,teacher.designation,teacher.emp_id,teacher.branch,teacher.id,teacher.grade,department.name
                                FROM `teacher`
                                inner join department on teacher.department = department.id
                                and teacher.is_delete=0  AND department.id IN ($idList) and teacher.id NOT IN ($staff_idss) and teacher.status=0
                                and teacher.branch=$branch ORDER BY teacher.seniority_level asc
                                ")->result_array();
                }
                //var_dump("<pre>",$data['att']);die;
                
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                //$data['teacher_2']=$data['teacher'];
           
                if(empty( $data['att']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/department_att_daterange", "refresh");
                }
                $this->load->view('report/fetch_department_att_daterange',$data);
            }
            else
            {
                
                //$department=$this->input->post('department');
                $data['department_name']=$this->db->select('name')->where('is_delete',0)->where_in('id',$idList)->get('department')->row_array();
                
                
                $branch=$this->branch;
                $data['is_super'] = $this->is_super;
                $data['menu'] = $this->load_model->menu();
               
                $data['att']=$this->db->query("
                SELECT staff.firstname,staff.id as staff_id,staff.lastname,staff.emp_id,staff.doj,staff.grade, 
                
                staffatt.status,
                staffatt.date,
                right(staffatt.check_in, 9) as check_in,
                right(staffatt.check_out, 9) as check_out,
                
                
                department.name, staff.designation 
                FROM `staffatt`
                INNER JOIN staff ON staffatt.staff_id=staff.id
                inner join department on staff.department = department.id
                WHERE staffatt.date >= '$sdate' 
                AND  staffatt.date <= '$edate'
                AND staffatt.is_deleted=0
                AND staff.branch='$branch'
                AND department.id IN ($idList)
                and staff.status=0
                AND staff.is_delete='0'
                ORDER BY staff.seniority_level asc
                  
                  ")->result_array();
                // var_dump($data['att']);die;
                if(empty($data['att'])){
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/department_att_daterange", "refresh");
                }
                else{
                
                $staff_ids = array_column($data['att'],"staff_id");
                $staff_idss = implode(',', (array)$staff_ids);
                $data['absents']=$this->db->query("
                    SELECT  staff.firstname,staff.lastname,staff.designation,staff.emp_id,staff.branch,staff.id,staff.grade,department.name
                                FROM `staff`
                                inner join department on staff.department = department.id
                                and staff.is_delete=0  AND department.id IN ($idList) and staff.id NOT IN ($staff_idss) and staff.status=0
                                and staff.branch=$branch ORDER BY staff.seniority_level asc
                                ")->result_array();
                // var_dump($data['absents']);die;
                
              
                }
                
        
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                if(empty( $data['att']) )
                {
                    $this->session->set_flashdata('msg','Record not found!');
                   redirect("Report/department_att_daterange", "refresh");
                }
           
                $this->load->view('report/fetch_department_att_daterange',$data);
            }
    }
    
     public function all_department_report()
    {
        $branch=$this->branch;
        $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['status'] = $this->db->select("*")->from('attendancestatus')->get()->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/all_department_report',$data);
    }
    
    public function all_department_report_data()
    {
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $branch=$this->user_model->getbranch();
        $data['branch']=$branch; 
        $data['department'] = $this->input->post('department');
        $data['sdate']=$this->input->post('sdate');
        $startdate=$this->input->post('sdate');
        $status=$this->input->post('status');
        $data['name'] = $this->db->select("name")->where('id',$status)->from('attendancestatus')->get()->result_array();
        $sdate =$startdate;
        $data['edate']=$this->input->post('edate');
        $edate=$this->input->post('edate');
        if(empty($edate))
        {
            $edate=date("Y-m-d");
            $data['edate']=$edate;
        }         
         
            $total_days=1;
            while (strtotime($sdate) <= strtotime($edate))
            {

                    $timestamp = strtotime($sdate);
                    $day= strtolower( date('l',$timestamp) );
                    
                    if($day !='sunday')
                    {
                        $total_days++;
                    }      
                    $sdate = date ("Y-m-d", strtotime("+1 day", strtotime($sdate)));
            }

                $data['total_days']=$total_days;
                $idList = implode(',', (array)$data['department']);
                $type=$this->input->post('type');
                if($type==1)
                {
                    $data['department_name']=$this->db->select('name')->where('is_delete',0)->where_in('id',$idList)->get('department')->row_array();
                    $branch=$this->branch;
                    $data['is_super'] = $this->is_super;
                    $data['menu'] = $this->load_model->menu();
                    
                    //calculating total teacher in departments
                    $data['a']=$this->db->query("
                    SELECT  teacher.firstname,teacher.lastname,teacher.seniority_level,teacher.designation,teacher.emp_id,teacher.grade,department.name,teacher.id
                                FROM `teacher`
                                inner join department on teacher.department = department.id
                                and teacher.is_delete=0  AND department.id IN ($idList)
                                and teacher.branch=$branch and teacher.status=0
                                GROUP BY teacher.id  ORDER BY teacher.seniority_level asc")->result_array();
                                //var_dump("<pre>",$data['a']);die;
                                $aa =  implode(', ', array_column($data['a'], 'id'));
                                if(empty($aa))
                                { 
                                    $this->session->set_flashdata('msg','Record not found!');
                                    redirect("Report/all_department_report", "refresh");
                                }
                                else
                                {
                                    
                                //calculating Present/absent/cl/cl/ml etc  teacher in attendace
                                
                                
                                 $data['ab']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,COUNT(teacherattendance.date) as absent_days,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=2 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname order by teacher.grade asc")->result_array(); 
                                $data['total_absent'] =0;
                                    foreach($data['ab'] as $value){
                                            $data['total_absent'] =  $data['total_absent'] +$value['absent_days'];
                                        
                                    }
                                
                                $data['p']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,teacherattendance.date,COUNT(teacherattendance.date) as present_days,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=1 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname")->result_array();
                                
                                 $data['total_present'] =0;
                                    foreach($data['p'] as $value){
                                            $data['total_present'] =  $data['total_present'] +$value['present_days'];
                                        
                                    }
                                 
                                 
                                 $data['leave']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,teacherattendance.date,COUNT(distinct(teacherattendance.date)) as leave_data,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=3 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname")->result_array();
                                $data['total_leave'] =0;
                                    foreach($data['leave'] as $value){
                                            $data['total_leave'] =  $data['total_leave'] +$value['leave_data'];
                                        
                                    }
                               
                                  $data['cl']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,teacherattendance.date,COUNT(teacherattendance.date) as casual_Leave,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=4 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname")->result_array();
                                $data['total_casual_leave'] =0;
                                    foreach($data['cl'] as $value){
                                            $data['total_casual_leave'] =  $data['total_casual_leave'] +$value['casual_Leave'];
                                        
                                    }
                               
                                $data['ml']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,teacherattendance.date,COUNT(teacherattendance.date) as Medical_Leave,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=5 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname")->result_array();
                                 $data['total_medical_leave'] =0;
                                    foreach($data['ml'] as $value){
                                            $data['total_medical_leave'] =  $data['total_medical_leave'] +$value['Medical_Leave'];
                                        
                                    }
                                $data['duty']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,teacherattendance.date,COUNT(teacherattendance.date) as Duty,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=6 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname")->result_array();
                                $data['total_duty'] =0;
                                    foreach($data['duty'] as $value){
                                            $data['total_duty'] =  $data['total_duty'] +$value['Duty'];
                                        
                                    }
                                    
                                    
                                $data['night']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,teacherattendance.date,COUNT(teacherattendance.date) as Night,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=7 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname")->result_array();
                                $data['total_night'] =0;
                                    foreach($data['night'] as $value){
                                            $data['total_night'] =  $data['total_night'] +$value['Night'];
                                        
                                    }
                                    
                                    
                                $data['rest']=$this->db->query("
                    SELECT  teacherattendance.teacher_id,teacherattendance.date,COUNT(teacherattendance.date) as Rest,teacherattendance.status
                                FROM `teacherattendance`
                                INNER JOIN teacher on teacher.id=teacherattendance.teacher_id
                                WHERE teacherattendance.is_deleted=0   and teacher.is_delete=0 and teacherattendance.status=8 AND teacher.id in ($aa)
                                and teacherattendance.date >= '$startdate' and teacherattendance.date <= '$edate'  and teacher.branch=$branch
                                GROUP BY teacher.firstname")->result_array();
                                $data['total_rest'] =0;
                                    foreach($data['night'] as $value){
                                            $data['total_rest'] =  $data['total_rest'] +$value['Rest'];
                                        
                                    }       
                                }
            
                    $data['base_url'] = base_url();
                    $data['userInfo'] = $this->userInfo;
               
                    if(empty($data['a']) )
                    {
                        $this->session->set_flashdata('msg','Record not found!');
                       redirect("Report/all_department_report", "refresh");
                    }
                    $this->load->view('report/selected_date_attendane_report',$data);
                }
                else
                {

                    $data['department_name']=$this->db->select('name')->where('is_delete',0)->where_in('id',$idList)->get('department')->row_array();
                    $branch=$this->branch;
                    $data['is_super'] = $this->is_super;
                    $data['menu'] = $this->load_model->menu();
                    $data['a']=$this->db->query("
                    SELECT  staff.firstname,staff.lastname,staff.emp_id,staff.designation,staff.seniority_level,staff.branch,staff.doj, staff.grade,department.name,staff.id
                                FROM `staff`
                                inner join department on staff.department = department.id
                                and staff.is_delete=0 AND department.id IN ($idList)
                                and staff.branch=$branch and staff.status=0
                                GROUP BY staff.id  ORDER BY staff.seniority_level asc ")->result_array();
                                //var_dump("<pre>",$data['a']);die;
                                $aa =  implode(', ', array_column($data['a'], 'id'));
                                if(empty($aa))
                                {
                                    $this->session->set_flashdata('msg','Record not found!');
                                    redirect("Report/all_department_report", "refresh");
                                }
                                else{
                                $data['ab']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as absent_days ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 2 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                 $data['total_absent'] =0;
                                    foreach($data['ab'] as $value){
                                            $data['total_absent'] =  $data['total_absent'] +$value['absent_days'];
                                        
                                    }
                                
                                
                                
                                $data['p']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as present_days ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 1 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                
                                $data['total_present'] =0;
                                    foreach($data['p'] as $value){
                                            $data['total_present'] =  $data['total_present'] +$value['present_days'];
                                        
                                    }
                                
                                $data['leave']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as leave_data ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 3 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                
                                $data['total_leave'] =0;
                                    foreach($data['leave'] as $value){
                                            $data['total_leave'] =  $data['total_leave'] +$value['leave_data'];
                                        
                                    }
                                
                                $data['cl']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as casual_Leave ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 4 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                $data['total_casual_leave'] =0;
                                    foreach($data['cl'] as $value){
                                            $data['total_casual_leave'] =  $data['total_casual_leave'] +$value['casual_Leave'];
                                        
                                    }
                                
                                $data['ml']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as Medical_Leave ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 5 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                $data['total_medical_leave'] =0;
                                    foreach($data['ml'] as $value){
                                            $data['total_medical_leave'] =  $data['total_medical_leave'] +$value['Medical_Leave'];
                                        
                                    }
                                
                                $data['duty']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as Duty ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 6 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                $data['total_duty'] =0;
                                    foreach($data['duty'] as $value){
                                            $data['total_duty'] =  $data['total_duty'] +$value['Duty'];
                                        
                                    }
                                    
                                 $data['night']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as Night ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 7 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                $data['total_night'] =0;
                                    foreach($data['night'] as $value){
                                            $data['total_night'] =  $data['total_night'] +$value['Night'];
                                        
                                    } 
                                    
                                $data['rest']=$this->db->query("
                    SELECT  staffatt.staff_id,count(staffatt.date) as Rest ,staffatt.status
                                FROM `staffatt`
                                INNER JOIN staff on staff.id=staffatt.staff_id
                                WHERE staffatt.is_deleted=0   and staff.is_delete=0 and staffatt.status = 8 and staff.id in($aa)
                                and staffatt.date >= '$startdate' and staffatt.date <= '$edate'  and staff.branch=$branch
                                GROUP BY staff.id")->result_array();
                                $data['total_rest'] =0;
                                    foreach($data['rest'] as $value){
                                            $data['total_rest'] =  $data['total_rest'] +$value['Rest'];
                                        
                                    }        
                                }
                                
                                //var_dump("<pre>",$data['att']);die;
            
                    $data['base_url'] = base_url();
                    $data['userInfo'] = $this->userInfo;
               
                    if(empty($data['a']) )
                    {
                        $this->session->set_flashdata('msg','Record not found!');
                       redirect("Report/all_department_report", "refresh");
                    }
                    $this->load->view('report/selected_date_report',$data); 
                }
    }
    
     public function all_department_report_grade()
    {
        $branch=$this->branch;
        $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['status'] = $this->db->select("*")->from('attendancestatus')->get()->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('report/all_department_report_grade',$data);
    }
    
    

}//end of file


?>