class RoomController extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('RoomModel');
    }

    public function index() {
        $data['rooms'] = $this->RoomModel->get_all_rooms();
        $this->load->view('rooms/index', $data);
    }

    public function create() {
        $this->load->view('rooms/create');
    }

    public function store() {
        $data = array(
            'room_number' => $this->input->post('room_number'),
            'room_type' => $this->input->post('room_type'),
            'capacity' => $this->input->post('capacity'),
            'available' => 1
        );
        $this->RoomModel->insert_room($data);
        redirect('RoomController/index');
    }

    public function edit($id) {
        $data['room'] = $this->RoomModel->get_room_by_id($id);
        $this->load->view('rooms/edit', $data);
    }

    public function update($id) {
        $data = array(
            'room_number' => $this->input->post('room_number'),
            'room_type' => $this->input->post('room_type'),
            'capacity' => $this->input->post('capacity')
        );
        $this->RoomModel->update_room($id, $data);
        redirect('RoomController/index');
    }

    public function delete($id) {
        $this->RoomModel->delete_room($id);
        redirect('RoomController/index');
    }
}

