<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SeatPlan extends CI_Controller {

    private $userInfo = array();
    
    public function __construct()
    {
        parent::__construct();
       
        $this->load->model("user_model");
        $this->load->model("api_model");
		 $this->load->model("report_model");
    
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }
	
	public function view_block()
	{
		
        $branch = $this->user_model->getBranch();
		$data['branch'] = $this->db->where('id',$branch)->get('branch')->result_array();
		$data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
		$this->db->select('*');	
		$this->db->where('is_delete', 0);	
		$data['block'] = $this->db->where('is_delete','0')->where('branch',$branch)->get('block')->result_array();
		//var_dump($data['block']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/view_block.php',$data);
	}
	
	public function edit_block($id='')
    {
$id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$this->db->select('*');
		$this->db->where('is_delete', 0);
		$this->db->where('id' , $id);
		$data['block'] = $this->db->get('block')->result_array();
		//var_dump($data['block']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/edit_block.php',$data);
        
    }
	public function save_edit_block()
    {
       $id = $this->input->post('id',true);
       $name = $this->input->post('name',true);
       if(!empty($name) && !empty($id))
       {
          $data  = array(
              'name' => $name,
              );
            $this->db->where('id',$id);
            $this->db->update('block',$data);
            $this->session->set_flashdata('success', 'Block Is Edit..');
			redirect('SeatPlan/view_block');
       }
    
    }
    
	public function create_Block()
    {
    
        
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$this->db->select('*');
		$this->db->where('is_delete', 0);
                $this->db->where('branch',$branch);	
		$data['block'] = $this->db->get('block')->result_array();
		//var_dump($data['block']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/create_block.php',$data);
    }
	
	public function delete_block($id="")
	{
$id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
		$data = array(
			'is_delete' =>1 ,
		);
	   $this->db->where('id',$id);
           $this->db->update('block',$data);
	   $this->db->where('block',$id);
	   $this->db->update('seating_plans',$data);
	   $this->db->where('block_id',$id);
	   $this->db->update('duty_roster',$data);
	   redirect('SeatPlan/view_block');		
	}
	
	
public function empty_block()
	{
	    //var_dump($id);die;
    	$branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['exam'] = $this->db->query("SELECT distinct(exam_type.name) as e_name,exam FROM `seating_plans` 
			inner join exam_type on exam_type.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and seating_plans.is_delete=0")->result_array();
		//var_dump($data['exam']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/empty_block.php',$data);	
	}
	public function done_empty_block()
    {
        $branch = $this->user_model->getBranch();
        $exam = $this->input->post('exam',true);
        if(!empty($exam))
        {
            $update = array(
                'is_delete' =>1,
                );
            $this->db->where('exam',$exam)->where('branch',$branch);
            $this->db->update('seating_plans',$update);
            $this->session->set_flashdata('success', 'Block Are Empty..');
			redirect('SeatPlan/empty_block');
            
        }
        
        
    }
    
    
	public function Assign_Block()
    {
    
     
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['exam'] = $this->db->query("SELECT distinct(exam.name) as e_name,exam FROM `seating_plans` 
			inner join exam on exam.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and seating_plans.is_delete=0
              
              ")->result_array();
		//var_dump("<pre>", $data['exam']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/Assign_Block.php',$data);
    }
	
	
	public function generate_block()
	{
		$branch = $this->user_model->getBranch();
                $b_name = $this->input->post('b_name');
		$max_len = $this->input->post('max_len');
		$min_len = $this->input->post('min_len');
		$this->db->select('*');
		$this->db->where('name',$b_name);
		$this->db->where('is_delete',0);
		$num = $this->db->get('block')->num_rows();
		if($num>0)
		{
			$this->session->set_flashdata('error', 'Block Is Already Exist..');
			redirect('SeatPlan/create_Block');
		}
		else{
			if(!empty($b_name) && !empty($max_len) && !empty($min_len))
			{
				$data = array(
					'name' => $b_name,
					'max_len' => $max_len,
					'min_len' => $min_len,
                                        'branch'   =>$branch
				);
				$this->db->insert('block',$data);
				$this->session->set_flashdata('msg', 'Data Inserted Successfuly..');
				redirect('SeatPlan/create_Block');
			}
			else
			{
				$this->session->set_flashdata('msg', 'Data Not Inserted Successfuly..');
				redirect('SeatPlan/create_Block');
			}
		}
	}

	public function generate_duty_roster()
	{
		$exam = $this->input->post('exam');
		$block = $this->input->post('block');
		$date = $this->input->post('date');
		$teacher = $this->input->post('teacher');
		$branch = $this->user_model->getBranch();
		if(!empty($exam) && !empty($block) && !empty($date) && !empty($teacher))
		{
		$data = array(
		    'branch' =>$branch,
			'exam' => $exam,
			'teacher_id' => $teacher,
			'block_id' => $block,
			'date' => $date,
		);
			$this->db->insert('duty_roster',$data);
			$this->session->set_flashdata('msg', 'Data Inserted Successfuly..');
			redirect('SeatPlan/Assign_Block');
		}
		else
		{
			$this->session->set_flashdata('error', 'Data Not Inserted Successfuly..');
			redirect('SeatPlan/Assign_Block');
		}

	}
	
	
	public function generate_seating_plan()
    {
    
        
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		
		$data['exam'] = $this->db->query("SELECT exam.* FROM `exam` join exam_type on exam_type.id= exam.etype_id WHERE exam.is_delete='0' and exam_type.branch_id='$branch' and exam_type.is_delete='0'")->result_array();	
		
		//var_dump($data['exam']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/seating_form.php',$data);
    }
     
	
	public function view_seating_plan()
    {
     
      
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['seat_plan'] = $this->db->query("SELECT *, block.name,exam.name as e_name FROM `seating_plans` WHERE `branch`=$branch")->result_array();
        else
            $data['seat_plan'] = $this->db->query("SELECT * ,block.name,exam.name as e_name FROM `seating_plans` 
            inner join student on student.id=seating_plans.student_id
            inner join promotion on promotion.student_id=seating_plans.student_id
            inner join class on class.class_id=promotion.class_id
            inner join section on section.section_id=promotion.section_id
			inner join block  on block.id = seating_plans.block
			inner join exam on exam.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and promotion.is_active=1
             
              ORDER BY block
              
              ")->result_array();
           
        $this->load->view('header',$data);
	$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/view_seating_plan',$data);
    
    }
	
	
	public function view_duty_roster()
    {
    
       
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['exam'] = $this->db->query("SELECT distinct(exam_type.name) as e_name,exam FROM `seating_plans` 
			inner join exam_type on exam_type.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and seating_plans.is_delete=0
              
              ")->result_array();
		//var_dump("<pre>", $data['exam']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/view_duty_roster.php',$data);
    }


	public function print_duty_roster()
	{
        $branch = $this->user_model->getBranch();
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->user_model->check_permissions("branch/view");
        $data['menu'] = $this->load_model->menu();
		$teacher = $this->input->post('teacher');
		$exam = $this->input->post('exam');
		if(!empty($teacher) && !empty($exam))
		{
			$data['result'] = $this->db->select('teacher.firstname,teacher.lastname, exam_type.name , duty_roster.date,block.name as b_name')
			->from('duty_roster')
			->join('teacher', 'teacher.id = duty_roster.teacher_id')
			->join('exam_type','exam_type.id = duty_roster.exam')
			->join('block','block.id = duty_roster.block_id')
			->where('duty_roster.teacher_id',$teacher)
			->where('duty_roster.exam',$exam)
			->where('block.is_delete',0)
			->where('duty_roster.is_delete',0)
			->order_By('duty_roster.id','asc')
			->get()->result_array();
			$data['first_name'] = $data['result'][0]['firstname'];
			$data['father_name'] = $data['result'][0]['lastname']; 
       		 $this->load->view('SeatPlan/duty_roster_report.php',$data);
			
		}
		else 
		{
				redirect('SeatPlan/view_duty_roster');
		}
	}
	
	
	public function all_teacher_duty_roster()
    {
    
        
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['exam'] = $this->db->query("SELECT distinct(exam_type.name) as e_name,exam FROM `seating_plans` 
			inner join exam_type on exam_type.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and seating_plans.is_delete=0
              
              ")->result_array();
		//var_dump("<pre>", $data['exam']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/all_teacher_duty_roster.php',$data);
    }
	
	
	public function print_all_teacher_duty_roster()
	{
		
        //$branch = $this->user_model->getBranch();
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->user_model->check_permissions("branch/view");
        $data['menu'] = $this->load_model->menu();
        $branch = $this->input->post('branch');
		$exam = $this->input->post('exam');
		$date = $this->input->post('date');
		$teacher = $this->input->post('teacher');
		//var_dump($teacher);die;
		if(!empty($exam))
		{
			$data['result'] = $this->db->select('teacher.firstname,teacher.lastname,teacher.specialization, exam_type.name , duty_roster.date,block.name as b_name')
			->from('duty_roster')
			->join('teacher', 'teacher.id = duty_roster.teacher_id')
			->join('exam_type','exam_type.id = duty_roster.exam')
			->join('block','block.id = duty_roster.block_id')
			//->where('duty_roster.teacher_id',$teacher)
			->where('duty_roster.exam',$exam)
			->where('duty_roster.date',$date)
                        ->where('duty_roster.is_delete','0')
			->order_By('duty_roster.id','asc')
			->get()->result_array();
			//$data['first_name'] = $data['result'][0]['firstname'];
			//$data['father_name'] = $data['result'][0]['lastname']; 
			if($teacher == 1){
       		 $this->load->view('SeatPlan/print_all_teacher_duty_roster.php',$data);}
       		 else
       		 {
       		     $this->load->view('SeatPlan/print_all_teacher.php',$data);
       		 }
			
		}
		else 
		{
				redirect('SeatPlan/all_teacher_duty_roster');
		}
	}
	
	public function print_sitting_plan()
    {
    
        
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['class'] = $this->db->query("SELECT * from class where branch = $branch and is_delete = 0")->result_array();
		//var_dump("<pre>", $data['class']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/print_sitting_plan.php',$data);
    }


	public function print_sitting_plan_view()
	{
		
        $branch = $this->user_model->getBranch();
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->user_model->check_permissions("branch/view");
        $data['menu'] = $this->load_model->menu();
		$class = $this->input->post('class');
		$exam = $this->input->post('exam');
		$gender = $this->input->post('gender');
		if($gender == 1)
		{
			$g ="Male";
			$data['g'] = $g;
 		}
		else
		{
			$g = "Fe-male";
			$data['g'] = $g;
		}
		if(!empty($class) && !empty($exam))
		{
			
			$data['seat_plan'] = $this->db->query("SELECT * ,block.name as block_name,exam.name as e_name FROM `seating_plans` 
            inner join student on student.id=seating_plans.student_id
            inner join promotion on promotion.student_id=seating_plans.student_id
            inner join class on class.class_id=promotion.class_id
            inner join section on section.section_id=promotion.section_id
			inner join block  on block.id = seating_plans.block
			inner join exam on exam.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and promotion.is_active=1 and seating_plans.exam =$exam and seating_plans.class_id = $class and seating_plans.gender = '$g' and  seating_plans.is_delete=0
             
             ORDER BY right(seating_plans.seat_no,2) asc
              
              ")->result_array();
			
			$data['class'] = $this->db->query("select class.class_name from class where class_id = $class and branch=$branch")->row();
		    $data['exam_type'] = $this->db->query("select exam_type.name from exam_type where id = $exam and branch_id=$branch")->row();
			 //var_dump("<pre>", $data['exam_type']);die;
			
       		 $this->load->view('SeatPlan/print_sitting_plan_view.php',$data);
			
		}
		else 
		{
				redirect('SeatPlan/print_sitting_plan');
		}
	}
	
	
	public function print_sitting_plan_class_wise()
    {
    
       
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['class'] = $this->db->query("SELECT * from class where branch = $branch and is_delete = 0")->result_array();
		//var_dump("<pre>", $data['class']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/print_sitting_plan_class_wise.php',$data);
    }
	
	public function print_sitting_plan_class_view()
	{
		
        $branch = $this->user_model->getBranch();
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->user_model->check_permissions("branch/view");
        $data['menu'] = $this->load_model->menu();
		$class = $this->input->post('class',true);
		$exam = $this->input->post('exam',true);
        $section = $this->input->post('section',true);
		
		$this->db->select('*,block.name as block_name,exam.name as e_name')
		                           ->from('seating_plans')
		                           ->join('student','student.id=seating_plans.student_id')
		                           ->join('promotion','promotion.student_id=seating_plans.student_id')
		                           ->join('class','class.class_id=promotion.class_id')
		                           ->join('section','section.section_id=promotion.section_id')
		                           ->join('block','block.id=seating_plans.block')
		                           ->join('exam','exam.id = seating_plans.exam')
		                           ->join('exam_type','exam_type.id = exam.etype_id')
		                           ->where('seating_plans.branch',$branch)
		                           ->where('promotion.is_active',1);
		          if(!empty($class)) 
		          {
		              $this->db->where('seating_plans.class_id',$class);
		          }
		          if(!empty($exam))
		          {
		             $this->db->where('seating_plans.exam',$exam); 
		          }
		          if(!empty($section))
		          {
		             $this->db->where('section.section_id',$section); 
		          }
		$this->db->where('seating_plans.is_delete',0);
	$data['seat_plan']=$this->db->get()->result_array();
	
	       
              if(empty($data['seat_plan']))
               {
                             redirect('SeatPlan/print_sitting_plan_class_wise');
               }
		else{	
			
				$branch = $this->user_model->getBranch();
        		$data['is_super'] = $this->user_model->is_super();
        		$data['menu'] = $this->load_model->menu();
        		$data['base_url'] = base_url();
        		$data['userInfo'] = $this->userInfo;
        		$this->load->view('header',$data);
				$this->load->view('sidebar',$data);
				$this->load->view('SeatPlan/view_seating_plan_section_wise.php',$data);
		

			}
			
		
	
	
	}
	
	public function sitting_plan_block_wise()
    {
    
       
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();     
		$data['exam'] = $this->db->query("SELECT distinct(exam.name) as e_name,exam FROM `seating_plans` 
			inner join exam on exam.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and seating_plans.is_delete=0
              
              ")->result_array();
		//var_dump("<pre>", $data['exam']);die;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/sitting_plan_block_wise.php',$data);
    }
	
	public function sitting_plan_view_block_wise()
	{
		
        
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $this->user_model->check_permissions("branch/view");
        $data['menu'] = $this->load_model->menu();
        //$branch = $this->user_model->getBranch();
        $branch = $this->input->post('branch');
		$block = $this->input->post('block');
		$exam = $this->input->post('exam');
		$student = $this->input->post('student');
		//var_dump($student);die;
		if(!empty($block) && !empty($exam))
		{
			
			$data['seat_plan'] = $this->db->query("SELECT * ,block.name as block_name,exam.name as e_name FROM `seating_plans` 
            inner join student on student.id=seating_plans.student_id
            inner join promotion on promotion.student_id=seating_plans.student_id
            inner join class on class.class_id=promotion.class_id
            inner join section on section.section_id=promotion.section_id
			inner join block  on block.id = seating_plans.block
			inner join exam on exam.id = seating_plans.exam
            WHERE seating_plans.branch=$branch and promotion.is_active=1 and seating_plans.exam =$exam and seating_plans.block = $block and seating_plans.is_delete = 0   order by seating_plans.id asc
              
              ")->result_array();
              
             $data['block'] = $this->db->query("select block.name from block where id = $block")->row(); 
             
			 $data['exam_type'] = $this->db->query("select exam.name from exam where id = $exam")->row();
			 //var_dump("<pre>", $data['block']);die;
			if($student == 1){
			    
       		 $this->load->view('SeatPlan/sitting_plan_view_block_wise.php',$data);
			}
			else
			{
			    
			      $this->load->view('SeatPlan/sitting_plan_view_block_wise_record.php',$data);
			}
       		 
			
		}
		else 
		{
				redirect('SeatPlan/sitting_plan_block_wise');
		}
	}
	
    public function generate_seat()
    {
    
      
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        
        $data['exam'] = $this->db->query("SELECT exam.* FROM `exam` join exam_type on exam_type.id= exam.etype_id WHERE exam.is_delete='0' and exam_type.branch_id='$branch' and exam_type.is_delete='0'")->result_array();	
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/Seat_form',$data);
    }
     
	 
	 	

  
    public function Generate_No()
    {
    
        if($this->input->post()) {
        $branch = $this->user_model->getBranch();
        
        
       //$query=$this->db->where('branch',$branch)
                           //->delete('seating_plan');
                        
            $data=$this->input->post();
            $class_no=$data['class'];
            $exam=$data['exam'];
        //   var_dump($exam);die;
          
           
          
          foreach ($class_no as $key => $selected_class_ids){
         
          $sections=$this->db->select('section_id')
                 ->from('section')
                 ->where('is_delete',0)
                 ->where('branch',$branch)
                 ->where('class_id',$selected_class_ids)
                 ->get()->result_array();
                 
                    $male_start=1;
                    $male_last=0;
                    $female_start=0;
                    $female_last=0;
                     $i=1; 
                     $increment=1;
                     
                 $new_sections=$sections;                   
	foreach ($new_sections as $key => $selected_sections_ids){
	 //var_dump('<pre>',$selected_sections_ids);
          //die();
	 $i=$male_start;
	
          $students_male=$this->db->select('student.id')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->where('status',0)
                 ->where('branch',$branch)
                 ->where('gender','Male')
                 ->where('promotion.is_active',1)
                 ->where('promotion.class_id',$selected_class_ids)
                 ->where_in('promotion.section_id',$selected_sections_ids)
                 ->get()->result_array();
        // var_dump('<pre>',$students_male);
        // die();
                 
      $students_female=$this->db->select('student.id')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->where('status',0)
                 ->where('branch',$branch)
                 ->where('gender','Female')
                 ->where('promotion.is_active',1)
                 ->where('promotion.class_id',$selected_class_ids)
                 ->where_in('promotion.section_id',$selected_sections_ids)
                 ->get()->result_array();
                 
       $get_class_no=$this->db->select('*')
                                    ->where('branch',$branch)
                                    ->where('is_delete',0)
                                    ->where_in('class_id',$selected_class_ids)
                                    ->get('class')
                                    ->result();
              
               if(!empty($students_male)){
               
             //Generate seat no for male
            foreach ($students_male as $key => $selected_student_male) {
               
                
                 $length=strlen($i);
                 
              if($length==1){
                 $i ="0".$i;
                 }
              
              if(!empty($get_class_no[0]->prefix))
              {
                      $seat_no=$get_class_no[0]->prefix."-".$i;
              }else
              {
                      $seat_no="0-".$i;
              }
             
          
              //var_dump($seat_no);die;
              $data=array(
                 'student_id'=>$selected_student_male['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
                 'exam'=>$exam
              );
              $insrt_data=$this->db->insert('seating_plan',$data);  
               $male_last=++$i;
              
                
                }
               
            }
            else
            {
               $male_last=$i;
            }
           
            
              if(!empty($students_female)){
                
                //Generate seat no for female
                 $female_start=$male_last;
                   $f=$female_start;
             foreach ($students_female as $key => $selected_student_female) {
                 
                 
                 $length=strlen($f);
              if($length==1){
                 $f ="0".$f;
                 }
                 
              if(!empty($get_class_no[0]->prefix))
              {
                      $seat_no=$get_class_no[0]->prefix."-".$f;
              }else
              {
                      $seat_no="0-".$f;
              }
                
                $data2=array(
                 'student_id'=>$selected_student_female['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
                 'exam'=>$exam
              );
              $insrt_data=$this->db->insert('seating_plan',$data2);
                $female_last=++$f;
           
            }
              $male_start=$female_last;
            }else{
                $male_start=$male_last;
            }
          
         
            }//End section for each
            
          
            //End class foreach
            }
            
     redirect('SeatPlan/generate_seat');

        }
    
    }
	

        	
public function create_plan()
	{   
	    $block = $this->input->post('block');
	    $this->db->where('id',$block);
	    $block_name = $this->db->get('block')->result_array();
        //var_dump($block_nam e[0]['name']);die;
		$branch = $this->user_model->getBranch();
		$nbr = $this->input->post('nbr');
		$class=$this->input->post('cl');
		$gender=$this->input->post('gender');
		$exam =$this->input->post('exam');
		$original_seat= 0;
		if($gender == 1){
		$male_start=1;
		$i;
		foreach($nbr as $key=>$value)
		{
			$data =array(
			 'number'=>$value,
			 'class'=>$class[$key],
			);
			
          
          $get_student=$this->db->select('*')
                 ->from('seating_plans')
                 ->where('is_delete',0)
		 ->where('gender','male')
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
		 ->where('exam', $exam)
                 ->get()->result_array();
			
		$original_seat_n=$this->db->select('*')
                 ->from('seating_plans')
                 ->where('is_delete',0)
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
                 ->get()->result_array();
                 //var_dump($original_seat_n);die();
			 $t_seating_pan_student =count($get_student);
			 $original_seat_no = count($original_seat_n);
			 	//var_dump($original_seat_no);die;	
			 if($t_seating_pan_student == 0)
			 {

				 $t_seating_pan_student=0;
			 }
			else{$t_seating_pan_student;}
			$students_male=$this->db->select('distinct(student.id),section.section_name')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->join('section','section.section_id=promotion.section_id')
                 ->where('student.status',0)
                 ->where('student.branch',$branch)
                 ->where('gender','Male')
                 ->where('promotion.is_active',1)
                 ->where('section.is_delete',0)
                 ->where('promotion.class_id',$data['class'])
                 ->order_By('section.section_name','asc')
                 ->limit($data['number'],$t_seating_pan_student)
                 ->get()->result_array();
				 
				//var_dump("<pre>",$students_male);die;
			$get_class_no=$this->db->select('*')
                                    ->where('branch',$branch)
                                    ->where('is_delete',0)
                                    ->where_in('class_id',$data['class'])
                                    ->get('class')
                                    ->result();
                                    //var_dump("<pre>",$original_seat_no[0]['original_seat_no']);die();
              if(empty($original_seat_no)){
              	//var_dump("no");die;
              $original_seat = 1;
               }
               else
               {
               	$original_seat =  $original_seat_no;
               	$original_seat++;
               //	var_dump($original_seat);die;
               }
            if(!empty($students_male)){
               
             //Generate seat no for male
            foreach ($students_male as $key => $selected_student_male) {
               
                
                /* $length=strlen($male_start);
                 
              if($length==1){
                 $i ="0".$male_start;
                 }
              */

             if(empty($get_class_no[0]->prefix))
             {
                 $get_class_no[0]->prefix=0;
             }else
             {
                 $get_class_no[0]->prefix=$get_class_no[0]->prefix;
             }
              $seat_no=$get_class_no[0]->prefix."-".$original_seat;
              //var_dump($seat_no);die;
              $datas=array(
                 'student_id'=>$selected_student_male['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
				 'class_id' =>$data['class'],
				 'block' => $block,
				 'gender' =>'Male',
				 'exam' =>$exam,
				 //'original_seat_no' => $original_seat,
              );
              
              $insrt_data=$this->db->insert('seating_plans',$datas);  
               //$male_start++;
              	$original_seat++;
                
                }	
			
			}
			   
		  }
		 redirect('SeatPlan/generate_seating_plan');
		}
		
		else
		{
		$fe_male_start=1;
		$i;
		foreach($nbr as $key=>$value)
		{
			$data =array(
			 'number'=>$value,
			 'class'=>$class[$key],
			 
			);
			$get_student=$this->db->select('id')
                 ->from('seating_plans')
                 ->where('is_delete',0)
				 ->where('gender','fe-male')
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
                 ->get()->result_array();
			
			$original_seat_n=$this->db->select('*')
                 ->from('seating_plans')
                 ->where('is_delete',0)
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
			
                 ->get()->result_array();
                 $original_seat_no = count($original_seat_n);	

			 $t_seating_pan_student =count($get_student);
			if($t_seating_pan_student == 0)
			 {

				 $t_seating_pan_student=0;
			 }
			else {$t_seating_pan_student; }
			$students_fe_male=$this->db->select('distinct(student.id), student.student_name,student.father_name')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->join('section','section.section_id=promotion.section_id')
                 ->where('student.status',0)
                 ->where('student.branch',$branch)
                 ->where('gender','female')
                 ->where('promotion.is_active',1)
                  ->where('section.is_delete',0)
                 ->where('promotion.class_id',$data['class'])
                 ->order_By('section.section_name','asc')
                 ->limit($data['number'],$t_seating_pan_student)
                 ->get()->result_array();
				 //var_dump("<pre>",$students_fe_male);die();
				
			$get_class_no=$this->db->select('*')
                                    ->where('branch',$branch)
                                    ->where('is_delete',0)
                                    ->where_in('class_id',$data['class'])
                                    ->get('class')
                                    ->result();
                                    //var_dump($original_seat_no);die();
                if(empty($original_seat_no)){
              	//var_dump("no");die;
              $original_seat = 1;
               }
               else
               {
               	$original_seat =  $original_seat_no;
               	$original_seat++;
               //	var_dump($original_seat);die;
               }
            if(!empty($students_fe_male)){
               
             //Generate seat no for male
            foreach ($students_fe_male as $key => $selected_student_fe_male) {
               
                
                /* $length=strlen($male_start);
                 
              if($length==1){
                 $i ="0".$male_start;
                 }
              */
              if(empty($get_class_no[0]->prefix))
             {
                 $get_class_no[0]->prefix=0;
             }else
             {
                 $get_class_no[0]->prefix=$get_class_no[0]->prefix;
             }
              $seat_no=$get_class_no[0]->prefix."-".$original_seat;
              //var_dump($seat_no);die;
              $datas=array(
                 'student_id'=>$selected_student_fe_male['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
				 'class_id' =>$data['class'],
				 'block' => $block,
				 'gender' =>'Fe-Male',
				 'exam' => $exam,
				 //'original_seat_no' => $original_seat,
              );
              
              $insrt_data=$this->db->insert('seating_plans',$datas);  
               //$fe_male_start++;
              $original_seat++;
                
                }	
			
			}
			   
		}
		 redirect('SeatPlan/generate_seating_plan');
		}
	}

        
      	/*public function create_plan()
	{   
	    $block = $this->input->post('block');
	    $this->db->where('id',$block);
	    $block_name = $this->db->get('block')->result_array();
        //var_dump($block_nam e[0]['name']);die;
		$branch = $this->user_model->getBranch();
		$nbr = $this->input->post('nbr');
		$class=$this->input->post('cl');
		$gender=$this->input->post('gender');
		$exam =$this->input->post('exam');
		$original_seat= 0;
		if($gender == 1){
		$male_start=1;
		$i;
		foreach($nbr as $key=>$value)
		{
			$data =array(
			 'number'=>$value,
			 'class'=>$class[$key],
			);
			
          
          $get_student=$this->db->select('*')
                 ->from('seating_plans')
                 ->where('is_delete',0)
		 ->where('gender','male')
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
		 ->where('exam', $exam)
                 ->get()->result_array();
			
		$original_seat_n=$this->db->select('*')
                 ->from('seating_plans')
                 ->where('is_delete',0)
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
                 ->get()->result_array();
                 //var_dump($original_seat_n);die();
			 $t_seating_pan_student =count($get_student);
			 $original_seat_no = count($original_seat_n);
			 	//var_dump($original_seat_no);die;	
			 if($t_seating_pan_student == 0)
			 {
				 $t_seating_pan_student=1;
			 }
else{$t_seating_pan_student++;}
			$students_male=$this->db->select('distinct(student.id),section.section_name')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->join('section','section.section_id=promotion.section_id')
                 ->where('student.status',0)
                 ->where('student.branch',$branch)
                 ->where('gender','Male')
                 ->where('promotion.is_active',1)
                 ->where('promotion.class_id',$data['class'])
                 ->order_By('section.section_name','asc')
                 ->limit($data['number'],$t_seating_pan_student)
                 ->get()->result_array();
				 
				//var_dump("<pre>",$students_male);die;
			$get_class_no=$this->db->select('*')
                                    ->where('branch',$branch)
                                    ->where('is_delete',0)
                                    ->where_in('class_id',$data['class'])
                                    ->get('class')
                                    ->result();
                                    //var_dump("<pre>",$original_seat_no[0]['original_seat_no']);die();
              if(empty($original_seat_no)){
              	//var_dump("no");die;
              $original_seat = 1;
               }
               else
               {
               	$original_seat =  $original_seat_no;
               	$original_seat++;
               //	var_dump($original_seat);die;
               }
            if(!empty($students_male)){
               
             //Generate seat no for male
            foreach ($students_male as $key => $selected_student_male) {
               
             
              $seat_no=$get_class_no[0]->class_number."-".$original_seat;
              //var_dump($seat_no);die;
              $datas=array(
                 'student_id'=>$selected_student_male['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
				 'class_id' =>$data['class'],
				 'block' => $block,
				 'gender' =>'Male',
				 'exam' =>$exam,
				 //'original_seat_no' => $original_seat,
              );
              
              $insrt_data=$this->db->insert('seating_plans',$datas);  
               //$male_start++;
              	$original_seat++;
                
                }	
			
			}
			   
		  }
		 redirect('SeatPlan/generate_seating_plan');
		}
		
		else
		{
		$fe_male_start=1;
		$i;
		foreach($nbr as $key=>$value)
		{
			$data =array(
			 'number'=>$value,
			 'class'=>$class[$key],
			 
			);
			$get_student=$this->db->select('id')
                 ->from('seating_plans')
                 ->where('is_delete',0)
				 ->where('gender','fe-male')
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
                 ->get()->result_array();
			
			$original_seat_n=$this->db->select('*')
                 ->from('seating_plans')
                 ->where('is_delete',0)
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
			
                 ->get()->result_array();
                 $original_seat_no = count($original_seat_n);	

			 $t_seating_pan_student =count($get_student);
			if($t_seating_pan_student == 0)
			 {
				 $t_seating_pan_student=1;
				}
                      else{$t_seating_pan_student++;}
			$students_fe_male=$this->db->select('distinct(student.id)')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->join('section','section.class_id=promotion.class_id')
                 ->where('student.status',0)
                 ->where('student.branch',$branch)
                 ->where('gender','female')
                 ->where('promotion.is_active',1)
                 ->where('promotion.class_id',$data['class'])
                 ->order_By('section.section_name','asc')
                 ->limit($data['number'],$t_seating_pan_student)
                 ->get()->result_array();
				 
				
			$get_class_no=$this->db->select('*')
                                    ->where('branch',$branch)
                                    ->where('is_delete',0)
                                    ->where_in('class_id',$data['class'])
                                    ->get('class')
                                    ->result();
                                    //var_dump($original_seat_no);die();
                if(empty($original_seat_no)){
              	//var_dump("no");die;
              $original_seat = 1;
               }
               else
               {
               	$original_seat =  $original_seat_no;
               	$original_seat++;
               //	var_dump($original_seat);die;
               }
            if(!empty($students_fe_male)){
               
             //Generate seat no for male
            foreach ($students_fe_male as $key => $selected_student_fe_male) {
               
                
             
              $seat_no=$get_class_no[0]->class_number."-".$original_seat;
              //var_dump($seat_no);die;
              $datas=array(
                 'student_id'=>$selected_student_fe_male['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
				 'class_id' =>$data['class'],
				 'block' => $block,
				 'gender' =>'Fe-Male',
				 'exam' => $exam,
				 //'original_seat_no' => $original_seat,
              );
              
              $insrt_data=$this->db->insert('seating_plans',$datas);  
               //$fe_male_start++;
              $original_seat++;
                
                }	
			
			}
			   
		}
		 redirect('SeatPlan/generate_seating_plan');
		}
	}*/
	
	public function create_plans()
	{   
	    $block = $this->input->post('block');
		//var_dump($block);die;
		$branch = $this->user_model->getBranch();
		$nbr = $this->input->post('nbr');
		$class=$this->input->post('cl');
		$gender=$this->input->post('gender');
		$exam =$this->input->post('exam');
		if($gender == 1){
		$male_start=1;
		$i;
		foreach($nbr as $key=>$value)
		{
			$data =array(
			 'number'=>$value,
			 'class'=>$class[$key],
			);
			
          
          $get_student=$this->db->select('id')
                 ->from('seating_plans')
                 ->where('is_delete',0)
				 ->where('gender','male')
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
                 ->get()->result_array();
			
			
			 $t_seating_pan_student =count($get_student);
			 /*if($t_seating_pan_student == 0)
			 {
				 $t_seating_pan_student=1;
			 }*/
			 //$t_seating_pan_student=$t_seating_pan_student+2;
			 $students_male=$this->db->select('student.id')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->where('status',0)
                 ->where('branch',$branch)
                 ->where('gender','Male')
                 ->where('promotion.is_active',1)
                 ->where('promotion.class_id',$data['class'])
                 ->limit($data['number'],$t_seating_pan_student)
                 ->get()->result_array();
				 
				
			$get_class_no=$this->db->select('*')
                                    ->where('branch',$branch)
                                    ->where('is_delete',0)
                                    ->where_in('class_id',$data['class'])
                                    ->get('class')
                                    ->result();
              
            if(!empty($students_male)){
               
             //Generate seat no for male
            foreach ($students_male as $key => $selected_student_male) {
               
                
                /* $length=strlen($male_start);
                 
              if($length==1){
                 $i ="0".$male_start;
                 }
              */
             
              $seat_no=$get_class_no[0]->class_number."-".$male_start;
              //var_dump($seat_no);die;
              $datas=array(
                 'student_id'=>$selected_student_male['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
				 'class_id' =>$data['class'],
				 'block' => $block,
				 'gender' =>'Male',
				 'exam' =>$exam,
              );
              
              $insrt_data=$this->db->insert('seating_plans',$datas);  
               $male_start++;
              
                
                }	
			
			}
			   
		  }
		 redirect('SeatPlan/generate_seating_plan');
		}
		
		else
		{
		$fe_male_start=1;
		$i;
		foreach($nbr as $key=>$value)
		{
			$data =array(
			 'number'=>$value,
			 'class'=>$class[$key],
			 
			);
			$get_student=$this->db->select('id')
                 ->from('seating_plans')
                 ->where('is_delete',0)
				 ->where('gender','fe-male')
                 ->where('branch',$branch)
                 ->where('class_id',$data['class'])
				 ->where('exam', $exam)
                 ->get()->result_array();
			
			
			 $t_seating_pan_student =count($get_student);
			 if($t_seating_pan_student == 0)
			 {
				 $t_seating_pan_student=1;
				}
			 $students_fe_male=$this->db->select('student.id')
                 ->from('student')
                 ->join('promotion','promotion.student_id=student.id')
                 ->where('status',0)
                 ->where('branch',$branch)
                 ->where('gender','female')
                 ->where('promotion.is_active',1)
                 ->where('promotion.class_id',$data['class'])
                 ->limit($data['number'],$t_seating_pan_student)
                 ->get()->result_array();
				 
				
			$get_class_no=$this->db->select('*')
                                    ->where('branch',$branch)
                                    ->where('is_delete',0)
                                    ->where_in('class_id',$data['class'])
                                    ->get('class')
                                    ->result();
              
            if(!empty($students_fe_male)){
               
             //Generate seat no for male
            foreach ($students_fe_male as $key => $selected_student_fe_male) {
               
                
                /* $length=strlen($male_start);
                 
              if($length==1){
                 $i ="0".$male_start;
                 }
              */
             
              $seat_no=$get_class_no[0]->class_number."-".$fe_male_start;
              //var_dump($seat_no);die;
              $datas=array(
                 'student_id'=>$selected_student_fe_male['id'],
                 'seat_no'=>$seat_no,
                 'branch'=>$branch,
				 'class_id' =>$data['class'],
				 'block' => $block,
				 'gender' =>'Fe-Male',
				 'exam' => $exam,
              );
              
              $insrt_data=$this->db->insert('seating_plans',$datas);  
               $fe_male_start++;
              
                
                }	
			
			}
			   
		}
		 redirect('SeatPlan/generate_seating_plan');
		}
	}
    
    public function view_seat()
    {
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['seat_plan'] = $this->db->query("SELECT * FROM `seating_plan` WHERE `branch`=$branch")->result_array();
        else
        $data['seat_plan'] = $this->db->query("SELECT *
                                               FROM seating_plan 
                                               inner join student on student.id=seating_plan.student_id
                                               inner join promotion on promotion.student_id=seating_plan.student_id
                                               inner join class on class.class_id=promotion.class_id
                                               inner join section on section.section_id=promotion.section_id
                                               WHERE seating_plan.id IN (SELECT MAX(seating_plan.id) AS id
                                                                         FROM seating_plan 
                                                                         WHERE seating_plan.is_delete = 0 AND seating_plan.branch=$branch and class.orderr<=5 AND promotion.is_active=1 AND student.status=0 GROUP BY seating_plan.student_id) 
                                                                         ORDER BY class.orderr ASC,section.section_id ASC,gender DESC")->result_array();
            // $data['seat_plan'] = $this->db->query("SELECT * FROM `seating_plan` 
            // inner join student on student.id=seating_plan.student_id
            // inner join promotion on promotion.student_id=seating_plan.student_id
            // inner join class on class.class_id=promotion.class_id
            // inner join section on section.section_id=promotion.section_id
            //  WHERE seating_plan.branch=$branch and promotion.is_active=1  and seating_plan.is_delete = 0
             
            //   ORDER BY class.class_number DESC,section.section_id ASC,gender DESC
              
            //   ")->result_array();
            
        $this->load->view('header',$data);
	    $this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/view_seat_plan',$data);
    
    }
    
    public function jr_class()
    {
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
     
		$data['class'] = $this->db->query("SELECT * from class where branch = $branch and class.orderr<=5 and is_delete = 0")->result_array();
	
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('SeatPlan/jr_class_selection',$data);
    }
    
    public function print_sitting_plan_jrclass()
    {
        $data['is_super'] = $this->user_model->is_super();
        $branch=$this->report_model->getBranch()[0];
        $data['branch_name']=$this->report_model->getBranch()[0]['name'];
        $data['b_header']= $this->report_model->BranchHeader();
        $branch=$this->user_model->getbranch();
        $data['branch']=$branch; 
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;

        $class_id=$this->input->post('class');
        $section=$this->input->post('section');
        
        if(!empty($class_id) && empty($section))
        {
            $data['seat_plan'] = $this->db->query("SELECT student_name,father_name,grno,class_name,section_name,gender,seat_no
            FROM seating_plan 
            inner join student on student.id=seating_plan.student_id
            inner join promotion on promotion.student_id=seating_plan.student_id
            inner join class on class.class_id=promotion.class_id
            inner join section on section.section_id=promotion.section_id
            WHERE seating_plan.id IN (SELECT MAX(seating_plan.id) AS id
                         FROM seating_plan 
                         WHERE seating_plan.is_delete = 0 AND seating_plan.branch=$branch AND promotion.is_active=1 and class.class_id=$class_id AND student.status=0 GROUP BY seating_plan.student_id) 
             ORDER BY class.orderr ASC,section.section_id ASC")->result_array();
        }if(!empty($class_id) && !empty($section)){
            $data['seat_plan'] = $this->db->query("SELECT student_name,father_name,grno,class_name,section_name,gender,seat_no
            FROM seating_plan 
            inner join student on student.id=seating_plan.student_id
            inner join promotion on promotion.student_id=seating_plan.student_id
            inner join class on class.class_id=promotion.class_id
            inner join section on section.section_id=promotion.section_id
            WHERE seating_plan.id IN (SELECT MAX(seating_plan.id) AS id
                         FROM seating_plan 
                         WHERE seating_plan.is_delete = 0 AND seating_plan.branch=$branch AND promotion.is_active=1 and class.class_id=$class_id AND section.section_id=$section AND student.status=0 GROUP BY seating_plan.student_id) 
             ORDER BY class.orderr ASC,section.section_id ASC")->result_array();
        }if(empty($class_id)){
            $data['seat_plan'] = $this->db->query("SELECT student_name,father_name,grno,class_name,section_name,gender,seat_no
            FROM seating_plan 
            inner join student on student.id=seating_plan.student_id
            inner join promotion on promotion.student_id=seating_plan.student_id
            inner join class on class.class_id=promotion.class_id
            inner join section on section.section_id=promotion.section_id
            WHERE seating_plan.id IN (SELECT MAX(seating_plan.id) AS id
                         FROM seating_plan 
                         WHERE seating_plan.is_delete = 0 AND seating_plan.branch=$branch AND promotion.is_active=1 and class.orderr<=5 AND student.status=0 GROUP BY seating_plan.student_id) 
             ORDER BY class.orderr ASC,section.section_id ASC")->result_array();
        }
            
            
        $this->load->view('SeatPlan/print_sitting_plan_jrclass',$data);
    }
    

}