<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * staff Class
 *
 * @package     edusol
 * @subpackage  Exam
 * @author      Sabeeh Murtaza
 * @link        http://facebook.com/sabeehking
 */
class Senior_exam extends CI_Controller {

    private $userInfo = array();
    private $is_super;
    private $branch;

    public function __construct()
    {
        parent::__construct();
        $this->user_model->check_login("admin");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        $this->is_super = $this->user_model->is_super();
        $this->branch = $this->user_model->getBranch();
        $this->load->model("voucher_model");
        $this->load->model("api_model");
        $this->load->model("report_model");
    }

    /* senior_exam Type */

    public function type($p=1,$c=0)
{
    $this->user_model->check_permissions("senior_exam/type");
    $data['edit_delete']=$this->user_model->checkEditDelete('senior_exam/type');
    $data['is_super'] = $this->is_super;
    $data['menu'] = $this->load_model->menu();

    // Use senior_exam_type instead of exam_type
    $this->db->select("senior_exam_type.id, senior_exam_type.name, senior_exam_type.description, branch.name as b_name"); 
    $this->db->from('senior_exam_type');
    $this->db->join('branch','branch.id=senior_exam_type.branch_id');
    $this->db->where('senior_exam_type.is_delete','0'); 

    if (!$this->is_super) {
        $this->db->where('senior_exam_type.branch_id', $this->branch);
    }

    $this->db->order_by('senior_exam_type.id','desc'); 

    if ($this->is_super)
        $data['branch'] = $this->db->query("SELECT id, name FROM `branch` WHERE is_delete='0'")->result_array();
    else
        $data['branch'] = $this->db->query("SELECT id, name FROM `branch` WHERE is_delete='0' AND id='".$this->branch."'")->result_array();

    $query = $this->db->get();
    $data['base_url'] = base_url();
    $data['userInfo'] = $this->userInfo;
    $data['types'] = $query->result_array();

    $this->load->view('header', $data);
    $this->load->view('sidebar', $data);
    $this->load->view('senior_exam/type', $data);
}

    
    
        /* Result Card */
    public function section_wise_report_card(){
            $this->user_model->check_permissions("senior_exam/section_wise_report_card");
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
             if($this->is_super)
            $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0'")->result_array();
            else{
            $data['branch']=$this->db->query("SELECT id,name FROM branch where is_delete=0 AND id='$branch'")->result_array();}
            $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
            $data['exam']=$this->db->query("SELECT `exam`.id,`exam`.name FROM `exam` INNER JOIN `exam_type` ON `exam_type`.`id`=`exam`.`etype_id` where `exam`.is_delete= 0 AND `exam_type`.is_delete= 0 AND `exam_type`.branch_id='$branch'")->result_array();
            
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('senior_exam/section_reportcard',$data);
            $this->load->view('footer',$data);

    }
    
    public function check_ExameTypenames($id,$names,$branch)
    {
     $name=rawurldecode($names);
    $this->db->select();
	$this->db->from('senior_exam_type');
	$this->db->where('senior_exam_type.id!=',$id);
	$this->db->where('senior_exam_type.branch_id',$branch);
	$this->db->where('senior_exam_type.name',$name);
	$this->db->where('senior_exam_type.is_delete',0);
	$query = $this->db->get();
	//var_dump($query->num_rows());die;
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    public function check_ExameTypename($names,$branch)
    {
     $name=rawurldecode($names);
    $this->db->select();
	$this->db->from('senior_exam_type');
	$this->db->where('senior_exam_type.branch_id',$branch);
	$this->db->where('senior_exam_type.name',$name);
	$this->db->where('senior_exam_type.is_delete',0);
	$query = $this->db->get();
	//var_dump($query->num_rows());die;
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
        public function saveexamtyp(){

                $examtype = $this->input->post('senior_examtype');
                $name = $this->input->post("name");
                $des= $this->input->post('des');
            
                if(!empty($examtype) AND !empty($name) AND !empty($des))
                {
                    
                    $data = array(
                    'exam_type'=>$examtype,
                    'name'=>$name,
                    'description'=>$des
                    );

                    $this->db->insert('senior_examsubtype',$data);
                    
                    $this->user_model->check_permissions('senior_exam/indexsub');
                    $edit_delete=$this->user_model->checkEditDelete('senior_exam/indexsub');
                    
                    $branch=$this->user_model->getbranch(); 
                
                    $this->db->select("senior_examsubtype.*,senior_exam_type.name as etype_name"); 
                    $this->db->from('senior_examsubtype');
                    $this->db->order_by("id", "desc");
                    $this->db->join('senior_exam_type','senior_exam_type.id=senior_examsubtype.senior_exam_type');
                    $this->db->where('senior_examsubtype.is_delete','0'); 
                    $this->db->where('senior_exam_type.is_delete','0'); 

                    $query = $this->db->get();
                    $exams = $query->result_array();
                    if(!empty($exams))
                    {
                            $i=0; 
                            foreach ($exams as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[name]</td>
                                          <td>$value[etype_name]</td>
                                          <td>$value[description]</td>";
                                          echo "<td>";
                                          if($edit_delete['edit'] == 1){
                                                     
                                                    echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                          }
                                          if($edit_delete['delete'] == 1){
                                                     
                                                    echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                                          }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                               } 
                               
                    }    
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
    public function saveexam(){

                $examtype = $this->input->post('senior_examtype');
                $name = $this->input->post("name");
                $s = $this->input->post('start');
                $start =  str_replace('/', '-', $s);
                $s_date= date('Y-m-d', strtotime($start));
                $e = $this->input->post('end');
                $end =  str_replace('/', '-', $e);
                $e_date= date('Y-m-d', strtotime($end));
                if(!empty($examtype) AND !empty($name) AND !empty($s_date) AND !empty($e_date))
                {
                    
                    $data = array(
                    'class_id'=>'0',
                    'etype_id'=>$examtype,
                    'name'=>$name,
                    'start'=>$s_date,
                    'end'=>$e_date
                    );

                    $this->db->insert('senior_exam',$data);
                    
                    $this->user_model->check_permissions('senior_exam/index');
                    $edit_delete=$this->user_model->checkEditDelete('senior_exam/index');
                    
                    $branch=$this->user_model->getbranch(); 
                
                    $this->db->select("senior_exam.id,senior_exam.name,senior_exam.start,senior_exam.end,branch.name as b_name, senior_exam_type.name as etype_name,is_publish"); 
                    $this->db->from('senior_exam');
                    $this->db->order_by("id", "desc");
                    $this->db->join('senior_exam_type','senior_exam_type.id=exam.etype_id');
                    $this->db->join('branch','branch.id=exam_type.branch_id');
                    $this->db->where('senior_exam.is_delete','0'); 
                    $this->db->where('senior_exam_type.is_delete','0'); 
                     if(!$this->is_super)
                    $this->db->where('senior_exam_type.branch_id',$branch);
                    $query = $this->db->get();
                    $exams = $query->result_array();
                    if(!empty($exams))
                    {
                            $i=0; 
                            foreach ($exams as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[name]</td>
                                          <td>$value[etype_name]</td>
                                          <td>";
                                       $datest=date("d-m-Y",@strtotime( $value['start']));
                                       echo $datest;
                                          echo "</td><td>";
                                          $dateen=date("d-m-Y",@strtotime( $value['end']));
                                           echo $dateen;
                                         echo "</td><td>";
                             $publish=$value['is_publish'];
                             if($publish=='1'){
                              echo"<a href='https://demovilla.xyz/demovilla/Exam/unpublish/$value[id]' style='color:green;'><i class='fa fa-lg fa-check-circle' aria-hidden='true'></i>Published&nbsp;<span class='label label-info'>Click for UnPublish</span></a>";
                              } 
                            
                             if($publish=='0')
                                { 
                             echo"<a href='https://demovilla.xyz/demovilla/Exam/unpublish/$value[id]' style='color:red;'><i class='fa fa-lg fa-times-circle' aria-hidden='true'></i>Not-Published&nbsp;<span class='label label-info'>Click for Publish</span></a>";  
                                }
                            echo"</td>";
                                          if($this->user_model->is_super()){
                                          echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                          echo "<td>";
                                          if($edit_delete['edit'] == 1){
                                                     
                                                    echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                          }
                                          if($edit_delete['delete'] == 1){
                                                     
                                                    echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                                          }
                                         echo "</td>";
                                         
                                   echo"</tr>";
                                
                               } 
                               
                    }    
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
        public function updateexam2(){
                $id = $this->input->post("id");
                $examtype = $this->input->post("examtype");
                $name = $this->input->post("name");
                $des= $this->input->post('des');
         
                
                if(!empty($id) AND !empty($name) AND !empty($des)  AND !empty($examtype))
                {
                    
                    
                    $data = array(
                    'exam_type'=>$examtype,
                    'name'=>$name,
                    'description'=>$des
                    );
                                      
                    $this->db->where('id',$id);
                    $this->db->update('senior_examsubtype',$data);
                    
                    $this->user_model->check_permissions('senior_exam/indexsub');
                    $edit_delete=$this->user_model->checkEditDelete('senior_exam/indexsub');
                    
                    $branch=$this->user_model->getbranch(); 
                
                    $this->db->select("senior_examsubtype.*,senior_exam_type.name as etype_name"); 
                    $this->db->from('senior_examsubtype');
                    $this->db->order_by("id", "desc");
                    $this->db->join('senior_exam_type','senior_exam_type.id=examsubtype.exam_type');
                    $this->db->where('senior_examsubtype.is_delete','0'); 
                    $this->db->where('senior_exam_type.is_delete','0'); 
                    $query = $this->db->get();
                    $exams = $query->result_array();
                    if(!empty($exams))
                    {
                            $i=0; 
                            foreach ($exams as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[name]</td>
                                          <td>$value[etype_name]</td>
                                          <td>$value[description]";
                                          echo "<td>";
                                          if($edit_delete['edit'] == 1){
                                                     
                                                    echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                          }
                                          if($edit_delete['delete'] == 1){
                                                     
                                                    echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                                          }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                               } 
                               
                    }   
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
    
    public function updateexam(){
                $id = $this->input->post("id");
                //$class = $this->input->post("classs");
                $examtype = $this->input->post("examtype");
                $name = $this->input->post("name");
                //$start =  date("Y-m-d", strtotime($this->input->post("start",true)));
                 $s = $this->input->post('start');
                $start =  str_replace('/', '-', $s);
                $s_date= date('Y-m-d', strtotime($start));
               // $end =  date("Y-m-d", strtotime($this->input->post("end",true)));
                 $e = $this->input->post('end');
                $end =  str_replace('/', '-', $e);
                $e_date= date('Y-m-d', strtotime($end));
                
                if(!empty($id) AND !empty($name) AND !empty($s_date) AND !empty($e_date)  AND !empty($examtype))
                {
                    
                    
                    $data = array(
                    'class_id'=>'0',
                    'etype_id'=>$examtype,
                    'name'=>$name,
                    'start'=>$s_date,
                    'end'=>$e_date
                    );
                                      
                    $this->db->where('id',$id);
                    $this->db->update('exam',$data);
                    
                    $this->user_model->check_permissions('senior_exam/index');
                    $edit_delete=$this->user_model->checkEditDelete('senior_exam/index');
                    
                    $branch=$this->user_model->getbranch(); 
                
                    $this->db->select("senior_exam.id,senior_exam.name,senior_exam.start,senior_exam.end,branch.name as b_name, senior_exam_type.name as etype_name,is_publish"); 
                    $this->db->from('senior_exam');
                    $this->db->order_by("id", "desc");
                    $this->db->join('senior_exam_type','senior_exam_type.id=senior_exam.etype_id');
                    $this->db->join('branch','branch.id=exam_type.branch_id');
                    //$this->db->join('class','class.class_id=exam.class_id');
                    $this->db->where('senior_exam.is_delete','0'); 
                    $this->db->where('senior_exam_type.is_delete','0'); 
                     if(!$this->is_super)
                    $this->db->where('senior_exam_type.branch_id',$branch);
                    $query = $this->db->get();
                    $exams = $query->result_array();
                    if(!empty($exams))
                    {
                            $i=0; 
                            foreach ($exams as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[name]</td>
                                          <td>$value[etype_name]</td>
                                          <td>";
                                       $datest=date("d-m-Y",@strtotime( $value['start']));
                                       echo $datest;
                                          echo "</td><td>";
                                          $dateen=date("d-m-Y",@strtotime( $value['end']));
                                           echo $dateen;
                                         echo "</td><td>";
                             $publish=$value['is_publish'];
                             if($publish=='1'){
                              echo"<a href='https://demovilla.xyz/demovilla/Exam/unpublish/$value[id]' style='color:green;'><i class='fa fa-lg fa-check-circle' aria-hidden='true'></i>Published&nbsp;<span class='label label-info'>Click for UnPublish</span></a>";
                              } 
                            
                             if($publish=='0')
                                { 
                             echo"<a href='https://demovilla.xyz/demovilla/Exam/unpublish/$value[id]' style='color:red;'><i class='fa fa-lg fa-times-circle' aria-hidden='true'></i>Not-Published&nbsp;<span class='label label-info'>Click for Publish</span></a>";  
                                }
                            echo"</td>";
                                          
                                          if($this->user_model->is_super()){
                                          echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                          echo "<td>";
                                          if($edit_delete['edit'] == 1){
                                                     
                                                    echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                          }
                                          if($edit_delete['delete'] == 1){
                                                     
                                                    echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                                          }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                                
                                   
                                
                               } 
                               
                    }   
                    
                }
                else
                {
                    echo "";
                }
    
        
    }
    
     public function get_record_exam2($id){
       
                        $this->db->select("senior_examsubtype.*"); 
                        $this->db->from('senior_examsubtype');
                        $this->db->join('senior_exam_type','senior_examsubtype.exam_type=senior_exam_type.id');
                        $this->db->where("senior_.is_delete","0");
                        $this->db->where("senior_examsubtype.id",$id);
                        $this->db->order_by('id','desc');
                        $query = $this->db->get()->row_array();
      
                     
        echo json_encode($query);
                
                
                
   }
   
     public function get_record_exam($id){
        $branch=$this->user_model->getbranch();
        if($branch != 0){
                         $this->db->select("senior_exam.*,senior_exam_type.branch_id"); 
                         $this->db->from('senior_exam');
                         $this->db->join('senior_exam_type','senior_exam.etype_id=senior_exam_type.id');
                         $this->db->where('senior_exam_type.branch_id',$branch);
                         $this->db->where("senior_exam.is_delete","0");
                         $this->db->where("senior_.id",$id);
                         $this->db->order_by('id','desc');
                         $query = $this->db->get()->row_array();
                    }
                   else{
                        $this->db->select("senior_exam.*,exam_type.branch_id"); 
                        $this->db->from('senior_exam');
                        $this->db->join('senior_exam_type','senior_exam.etype_id=senior_exam_type.id');
                        $this->db->where("senior_exam.is_delete","0");
                        $this->db->where("senior_exam.id",$id);
                        $this->db->order_by('id','desc');
                        $query = $this->db->get()->row_array();
                   }
                     
        echo json_encode($query);
                
                
                
   }
   
    public function delete_record_exam2()
   {
                    $id  = $this->input->post('id');
                    $data = array(
                        'is_delete'=> 1
                        );
                    $this->db->where('id',$id);
                    $this->db->update('senior_examsubtype',$data);
                    
                    $this->user_model->check_permissions('senior_exam/indexsub');
                    $edit_delete=$this->user_model->checkEditDelete('senior_exam/indexsub');
                    
                    $branch=$this->user_model->getbranch(); 
                
                    $this->db->select("senior_examsubtype.*senior_,exam_type.name as etype_name"); 
                    $this->db->from('senior_examsubtype');
                    $this->db->order_by("senior_examsubtype.id", "desc");
                    $this->db->join('senior_exam_type','senior_exam_type.id=senior_examsubtype.senior_exam_type');
                    $this->db->where('senior_examsubtype.is_delete','0'); 
                    $this->db->where('senior_exam_type.is_delete','0'); 
                    $query = $this->db->get();
                    $exams = $query->result_array();
                    if(!empty($exams))
                    {
                            $i=0; 
                            foreach ($exams as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[name]</td>
                                         
                                          <td>$value[etype_name]</td>
                                          <td>$value[description]</td>";
                                        echo "<td>";
                                          if($edit_delete['edit'] == 1){
                                                     
                                                    echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                          }
                                          if($edit_delete['delete'] == 1){
                                                     
                                                    echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                                          }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                               } 
                               
                    }
                    else
                    {
                        echo "";
                    }
       
   }
   
   public function delete_record_exam()
   {
                    $id  = $this->input->post('id');
                    $data = array(
                        'is_delete'=> 1
                        );
                    $this->db->where('id',$id);
                    $this->db->update('senior_exam',$data);
                    
                    $this->user_model->check_permissions('senior_exam/index');
                    $edit_delete=$this->user_model->checkEditDelete('senior_exam/index');
                    
                    $branch=$this->user_model->getbranch(); 
                
                    $this->db->select("senior_exam.id,senior_exam.name,senior_exam.start,senior_exam.end,branch.name as b_name,  senior_exam_type.name as etype_name,is_publish"); 
                    $this->db->from('senior_exam');
                    $this->db->order_by("id", "desc");
                    $this->db->join('senior_exam_type','senior_exam_type.id=senior_exam.etype_id');
                    $this->db->join('branch','branch.id=senior_exam_type.branch_id');
                    //$this->db->join('class','class.class_id=exam.class_id');
                    $this->db->where('senior_exam.is_delete','0'); 
                    $this->db->where('senior_exam_type.is_delete','0'); 
                     if(!$this->is_super)
                    $this->db->where('senior_exam_type.branch_id',$branch);
                    $query = $this->db->get();
                    $exams = $query->result_array();
                    if(!empty($exams))
                    {
                            $i=0; 
                            foreach ($exams as $key => $value)
                            { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                          <td>$i</td>
                                          <td>$value[name]</td>
                                          <td>$value[etype_name]</td>
                                          <td>";
                                       $datest=date("d-m-Y",@strtotime( $value['start']));
                                       echo $datest;
                                          echo "</td><td>";
                                          $dateen=date("d-m-Y",@strtotime( $value['end']));
                                           echo $dateen;
                                         echo "</td><td>";
                             $publish=$value['is_publish'];
                             if($publish=='1'){
                              echo"<a href='https://demovilla.xyz/demovilla/Exam/unpublish/$value[id]' style='color:green;'><i class='fa fa-lg fa-check-circle' aria-hidden='true'></i>Published&nbsp;<span class='label label-info'>Click for UnPublish</span></a>";
                              } 
                            
                             if($publish=='0')
                                { 
                             echo"<a href='https://demovilla.xyz/demovilla/Exam/unpublish/$value[id]' style='color:red;'><i class='fa fa-lg fa-times-circle' aria-hidden='true'></i>Not-Published&nbsp;<span class='label label-info'>Click for Publish</span></a>";  
                                }
                            echo"</td>";
                                          if($this->user_model->is_super()){
                                          echo "<td>";echo @$this->db->select('name')->where('id',$value['branch_id'])->where('is_delete',0)->get('branch')->row()->name; }  echo "</td>";
                                          echo "<td>";
                                          if($edit_delete['edit'] == 1){
                                                     
                                                    echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                          }
                                          if($edit_delete['delete'] == 1){
                                                     
                                                    echo "<a href='' onclick='delete_user($value[id],event)'><i class='fa fa-trash'></i></a>";
                                          }
                                         echo "</td>";
                                         
                                echo"</tr>";
                                
                               } 
                               
                    }
                    else
                    {
                        echo "";
                    }
       
   }
    
    public function deleteresulttt()
    {
      $result = $this->db->query("
SELECT  result_subject.id as resultid, result_subject.result_id as back_Id,subject.id, subject.name as subject_name,result_subject.total_marks,result_subject.obtained_marks,result_subject.passing_marks,result_subject.paper_date 
FROM student 
JOIN promotion ON student.id=promotion.student_id
join result on result.promotion_id= promotion.id
join result_subject on result_subject.result_id=result.id
join subject on subject.id=result_subject.subject_id



WHERE promotion.class_id=27
AND promotion.section_id=64
AND promotion.is_active=1 
AND promotion.is_delete=0
AND result_subject.is_delete=0 
and result.exam_id = 58
AND subject.is_deleted='0'

        ")->result_array();
        
// var_dump($result);
 // die();
        foreach($result as $value)
        {
            
$result_subject=$value['resultid'];
$exame=$value['back_Id'];

$this->db->where('id', $result_subject);
$this->db->delete('result_subject');

$this->db->where('id', $exame);
$this->db->delete('result');


        }
        
        
        
        
    }

    public function typeedit($id=0)
    {
        $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
        $data['menu'] = $this->load_model->menu();
        $this->db->select("id,name,description,branch_id"); 
        $this->db->from('senior_exam_type');
        $this->db->where('senior_exam_type.is_delete','0'); 
        $this->db->where('senior_exam_type.id',$id);
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['data'] = $query->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('senior_exam/typeedit',$data);
    }

    public function typeadd()
    {
        if($this->input->post())
        {
            $name = $this->input->post("name",true);
            $branch = $this->input->post("branch",true);
            $description = $this->input->post("description",true);
            $data = array(
                "name"=>$name,
                "branch_id"=>$branch,
                "description"=>$description
            );
            $this->db->insert("senior_exam_type",$data);   
        }
        redirect("senior_exam/type","refresh");
    }

    public function typesave()
    {
        if($this->input->post())
        {
            $name = $this->input->post("name",true);
            $id = $this->input->post("id",true);
            $description = $this->input->post("description",true);
            $data = array(
                "name"=>$name,
                "description"=>$description
            );
            $this->db->where("id",$id);   
            $this->db->update("exam_type",$data);   
        }
        redirect("senior_exam/type","refresh");
    }

    public function typedelete($id)
    {
        if(!empty($id))
        {
$id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
            $data = array(
                'is_delete' => "1",
            );
            $this->db->where("id",$id);
            $this->db->update("senior_exam_type",$data); 
            $this->db->where("etype_id",$id);
            $this->db->update("senior_exam",$data);
        }
        redirect('senior_exam/type','refresh');
    }

    /* senior_Exam */
public function indexsub($p=1,$c=0)
{
    $this->user_model->check_permissions("senior_exam/indexsub");
    $data['edit_delete'] = $this->user_model->checkEditDelete('senior_exam/indexsub');
    $data['is_super'] = $this->is_super;
    $data['menu'] = $this->load_model->menu();

    $total = $this->db->query("SELECT count(*) as total FROM `senior_examsubtype` WHERE is_delete='0'")->result_array()[0]['total'];

    $this->db->select("senior_examsubtype.*, senior_exam_type.name as etype_name"); 
    $this->db->from('senior_examsubtype');
    $this->db->order_by("id", "desc");
    $this->db->join('senior_exam_type', 'senior_exam_type.id = senior_examsubtype.exam_type');
    $this->db->where('senior_examsubtype.is_delete', '0'); 
    $this->db->where('senior_exam_type.is_delete', '0'); 

    if ($this->is_super) {
        $data['branch'] = $this->db->query("SELECT id, name FROM `branch` WHERE is_delete='0'")->result_array();
        $data['exam_type'] = $this->db->query("SELECT id, name FROM `senior_exam_type` WHERE is_delete='0'")->result_array();
    } else {
        $data['branch'] = $this->db->query("SELECT id, name FROM `branch` WHERE is_delete='0' AND id='" . $this->branch . "'")->result_array();
        $data['exam_type'] = $this->db->query("SELECT id, name FROM `senior_exam_type` WHERE is_delete='0' AND branch_id='" . $this->branch . "'")->result_array();
    }

    $query = $this->db->get();
    $data['base_url'] = base_url();
    $data['userInfo'] = $this->userInfo;
    $data['exam'] = $query->result_array();

    $this->load->view('header', $data);
    $this->load->view('sidebar', $data);
    $this->load->view('senior_exam/indexsub', $data);
}

    public function index($p=1,$c=0)
{
    $this->user_model->check_permissions("senior_exam/index");
    $data['edit_delete']=$this->user_model->checkEditDelete('exam/index');
    $data['is_super'] = $this->is_super;
    $data['menu'] = $this->load_model->menu();

    $total = $this->db->query("SELECT count(*) as total FROM `senior_exam` where is_delete='0'")->result_array()[0]['total'];

    //$per_page = 10;
    //$offset = ($p - 1) * $per_page;
    $this->db->select("senior_exam.id, senior_exam.is_publish, senior_exam.name, senior_exam.start, senior_exam.end, branch.name as b_name, senior_exam_type.name as etype_name"); 
    $this->db->from('senior_exam');
    $this->db->order_by("id", "desc");
    $this->db->join('senior_exam_type','senior_exam_type.id=senior_exam.etype_id');
    $this->db->join('branch','branch.id=senior_exam_type.branch_id');
    //$this->db->join('class','class.class_id=senior_exam.class_id');
    $this->db->where('senior_exam.is_delete','0'); 
    $this->db->where('senior_exam_type.is_delete','0'); 

    if(!$this->is_super)
        $this->db->where('senior_exam_type.branch_id',$this->branch);

    if($this->is_super)
    {
        $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0'")->result_array();
        $data['exam_type'] = $this->db->query("SELECT id,name FROM `senior_exam_type` where is_delete='0'")->result_array();
    } else {
        $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0' AND id='".$this->branch."'")->result_array();
        $data['exam_type'] = $this->db->query("SELECT id,name FROM `senior_exam_type` where is_delete='0' AND branch_id='".$this->branch."'")->result_array();
    }

    $query = $this->db->get();
    $data['base_url'] = base_url();
    $data['userInfo'] = $this->userInfo;
    $data['exam'] = $query->result_array();
    //$data['total'] = ceil($total / $per_page);
    $this->load->view('header',$data);
    $this->load->view('sidebar',$data);
    $this->load->view('senior_exam/index',$data);
}

    public function edit($id=1)
    {
$id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
        $data['menu'] = $this->load_model->menu();
        $this->db->select("id,name,start,end"); 
        $this->db->from('senior_exam');
        $this->db->where('senior_exam.is_delete','0'); 
        $this->db->where('senior_exam.id',$id);
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['data'] = $query->result_array()[0];
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('senior_exam/edit',$data);
    }
    
     public function check_useredit1($start,$end)
    {
        $start=date("Y-m-d",strtotime($start));
     $end=date("Y-m-d",strtotime($end));
    $this->db->select();
	$this->db->from('senior_exam');
	$this->db->where('Start',$start);
	$this->db->where('end',$end);
	$this->db->where('is_delete',0);
	$query = $this->db->get();
	//var_dump($query->num_rows());die;
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }

    public function add()
    {

        if($this->input->post())
   
        {
            $name = $this->input->post("name",true);
            $class = $this->input->post("class",true);
            $etype_id = $this->input->post("etype_id",true);
            $start = date("Y-m-d", strtotime($this->input->post("start",true)));
            $end = date("Y-m-d", strtotime($this->input->post("end",true)));
            $data = array(
                "name"=>$name,
                "class_id"=>$class,
                "etype_id"=>$etype_id,
                "start"=>$start,
                "end"=>$end
            );
            $this->db->insert("senior_exam",$data);   
        }
        redirect("senior_exam/index","refresh");
    }

    public function save()
    {
        if($this->input->post())
        {
            $name = $this->input->post("name",true);
            $id = $this->input->post("id",true);
            $start = $this->input->post("start",true);
            $end = $this->input->post("end",true);
            $data = array(
                "name"=>$name,
                "start"=>$start,
                "end"=>$end
            );
            $this->db->where("id",$id);   
            $this->db->update("senior_exam",$data);   
        }
        redirect("senior_exam/index","refresh");
    }

    public function delete($id)
    {
$id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
            if(!empty($id))
            {
                $data = array(
                    'is_delete' => "1",
                );
                $this->db->where("id",$id);
                $this->db->update("senior_exam",$data); 
            }
            redirect('senior_exam/index','refresh');
    }
       

    /* Enter Marks */    

    public function selection()
    {
            $this->user_model->check_permissions("senior_exam/selection");
            $data['menu'] = $this->load_model->menu();
            $this->db->select("id,name"); 
            $this->db->from('branch');
            $this->db->where('is_delete','0');
            if(!$this->is_super)
                $this->db->where('id',$this->branch);
            $query = $this->db->get();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['branch'] = $query->result_array();
            $data['session'] = $this->db->query("SELECT * FROM `session` WHERE `is_delete`='0'")->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('senior_exam/add',$data);
    }

    public function premark()
    {
            if($this->input->post())
            {
                $data['b_id']=$branch= $this->input->post("branch",true);
                $class = $this->input->post("class",true);
                $data['class_order']=$c_ord=$this->db->select('*')
                                              ->from('class')
                                              ->where('class_id',$class)
                                              ->get()->row_array()['orderr'];
                $section = $this->input->post("section",true);
                $exam = $this->input->post("senior_exam",true);
                $sub_typeid= $this->input->post("sub_typeid",true);
                $subject = $this->input->post("subject",true);
                $session = $this->input->post("session",true);
                $data['menu'] = $this->load_model->menu();
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                
                $this->db->distinct()->select("student.sid,student.grno,student.roll_no,student.student_name,promotion.id");
                $this->db->from("promotion");
                $this->db->join("student","student.id=promotion.student_id");
               // $this->db->join('seating_plans','seating_plans.student_id=student.id','left');
                $this->db->where("student.status","0");
                $this->db->where("student.is_delete","0");
                $this->db->where("student.branch",$branch);
                $this->db->where("promotion.is_active","1");
                $this->db->where("promotion.is_delete","0");
                
                $this->db->where("promotion.session_id",$session);
                $this->db->where("promotion.section_id",$section);
                $this->db->where("promotion.class_id",$class);
               // $this->db->where("seating_plans.is_delete",0);
                $this->db->order_by("student.sid","asc");
                $data['student'] = $this->db->get()->result_array();
                
                if(empty($data['student']))
                {
                    $this->db->distinct()->select("student.sid,student.grno,student.roll_no,student.student_name,promotion.id,seating_plan.seat_no");
                    $this->db->from("promotion");
                    $this->db->join("student","student.id=promotion.student_id");
                    $this->db->join('seating_plan','seating_plan.student_id=student.id','left');
                    $this->db->where("student.status","0");
                    $this->db->where("student.branch",$branch);
                    $this->db->where("promotion.is_active","1");
                    $this->db->where("promotion.is_delete","0");
                    
                    $this->db->where("promotion.session_id",$session);
                    $this->db->where("promotion.section_id",$section);
                    $this->db->where("promotion.class_id",$class);
                    $this->db->where("seating_plan.is_delete",0);
                    $this->db->order_by("student.sid", "asc");
                    //$this->db->order_by("seating_plan.id","desc");
                    $data['student'] = $this->db->get()->result_array();
                  
                }
            //var_dump('<pre>',$data['student']);
           // die();
                $this->db->select("result_subject.id,result_subject.total_marks,result_subject.passing_marks,result_subject.obtained_marks,result_subject.paper_date,promotion.id as pid");
                $this->db->from("result_subject");
                $this->db->join("result","result.id=result_subject.result_id");
                $this->db->join("promotion","promotion.id=result.promotion_id");
                $this->db->join("student","student.id=promotion.student_id");
               
                $this->db->where("student.status","0");
                $this->db->where("student.is_delete","0");
                $this->db->where("student.branch",$branch);
                $this->db->where("promotion.is_delete","0");
                $this->db->where("promotion.is_active","1");
                $this->db->where("promotion.session_id",$session);
                $this->db->where("promotion.section_id",$section);
                $this->db->where("promotion.class_id",$class);
                $this->db->where("result.exam_id",$exam);
                $this->db->where("result_subject.subject_id",$subject);
               
                if(!empty($sub_typeid))
                {
                   $this->db->where("result_subject.subexam_id",$sub_typeid); 
                }
                $data['student_marks'] = $this->db->get()->result_array();
                
                
              //  var_dump('<pre>',$data['student_marks']);die;
                $data['subject'] = $subject;
                $data['exam'] = $exam;
                if(!empty($sub_typeid))
                {
                    $sub_typeid=$sub_typeid;
                }else
                {
                    $sub_typeid=" ";
                }
                $data['subexam_id'] = $sub_typeid;
                $data['class'] = $class;
                $data['section'] = $section;
                $data['session'] = $session;
                $this->load->view('header',$data);
                $this->load->view('sidebar',$data);
                $this->load->view('senior_exam/enter',$data);
            }else{
                redirect("senior_exam/selection","refresh");
            }             
    }

public function checkexamdate($date,$exam)
{
     $this->db->select();
	$this->db->from('senior_exam');
	$this->db->where('id',$exam);
	$this->db->where('start<=',$date);
	$this->db->where('end>=',$date);
	$this->db->where('is_delete',0);
	$query = $this->db->get();
   //var_dump($query->num_rows());die;
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
}
    public function enter()
    {
            if($this->input->post())
            {
                $class = $this->input->post("class",true);
                $section = $this->input->post("section",true);
                $subject = $this->input->post("subject",true);
                $exam = $this->input->post("exam",true);
                $sub_typeid= $this->input->post("sub_typeid",true);
                $session = $this->input->post("session",true);
                $dates = $this->input->post("date",true);
                $date = date("Y-m-d", strtotime($dates));
                // var_dump($date);die;
                $total = $this->input->post("total_marks",true);
                $passing = $this->input->post("passing_marks",true);
                $obtained = $this->input->post("obtained_marks",true);
               
                if(!empty($subject))
                {
                    if(!empty($obtained))
                    {
                        $d = [];
                  
                        foreach ($obtained as $key => $value) {
                            $result_id = $this->check_or_create_result($exam,$key);
                            $data = array(
                                "result_id"=>$result_id,
                                "subject_id"=>$subject,
                                'subexam_id'=>$sub_typeid,
                                "total_marks"=>$total,
                                "passing_marks"=>$passing,
                                "obtained_marks"=>$value,
                                "paper_date"=>$date
                            );  
                            $this->db->insert("result_subject",$data);
                            $result_data = $this->updateResult($result_id,$total,$value,$key);
                            $d[] = $this->getResultTotalObtain($result_id);
                        }
                        
                        $arr = $this->makeposition($d);
                        foreach ($arr as $key => $value) {
                             $to_replace['position'] = $value['position'];
                             $this->db->where("id",$value['id'])->update("result",$to_replace);
                        }
                    }
                }
            }
            redirect("senior_exam/selection","refresh");             
    }

public function fetch_subtype($b)
{
      if(!empty($b))
        {
            $fect_catid=$this->db->select('*')
                                 ->from('senior_exam')
                                 ->where('id',$b)
                                 ->get()->row_array()['etype_id'];
            $this->db->select("name,id");
            $this->db->from("senior_examsubtype");
            $this->db->where("senior_exam_type",$fect_catid);
            $this->db->where("is_delete",0);
            $result = $this->db->get()->result_array();
            // var_dump('<pre>',$result);
            // die();
            foreach ($result as $key => $value) {
                echo "<option value='".$value['id']."'>".$value['name']."</option>";
            }
        }
        else
            echo "";
}
    public function update_marks()
    {
            if($this->input->post())
            {
                $class = $this->input->post("class",true);
                $section = $this->input->post("section",true);
                $subject = $this->input->post("subject",true);
                $exam = $this->input->post("exam",true);
                $sub_typeid= $this->input->post("sub_typeid",true);
                $session = $this->input->post("session",true);
                $date = $this->input->post("date",true);
                $total = $this->input->post("total_marks",true);
                $passing = $this->input->post("passing_marks",true);
                $obtained = $this->input->post("obtained_marks",true);
                $action = $this->input->post("action",true);
                // var_dump("<pre>",$this->input->post(),"<hr>");
                if(!empty($subject))
                {
                    if(!empty($obtained))
                    {
                        $d = [];
                        foreach ($obtained as $key => $value) {
                            $result_id = $this->check_or_create_result($exam,$key);
                            $result_subject_id = $action[$key];
                            
                                $data = array(
                                    "result_id"=>$result_id,
                                    "subject_id"=>$subject,
                                    "subexam_id"=>$sub_typeid,
                                    "total_marks"=>$total,
                                    "passing_marks"=>$passing,
                                    "obtained_marks"=>$value,
                                    "paper_date"=>$date
                                );
                            //var_dump("<pre>",$data,"<hr>");     
                            if($result_subject_id!=""){
                                $this->db->where("id",$result_subject_id)->update("result_subject",$data);
                            }else{
                                $this->db->insert("result_subject",$data);
                            }
                                $this->updateResult($result_id,$total,$value,$key);
                            $d[] = $this->getResultTotalObtain($result_id);
                        }
                        $arr = $this->makeposition($d);
                        foreach ($arr as $key => $value) {
                             $to_replace['position'] = $value['position'];
                             $this->db->where("id",$value['id'])->update("result",$to_replace);
                        }
                    }
                }
            }
            redirect("senior_exam/selection","refresh");             
    }


    /* Result Card */
    public function result(){
            $this->user_model->check_permissions("senior_exam/result");
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $branch=$this->user_model->getbranch();
             if($this->is_super)
            $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0'")->result_array();
            else{
            $data['branch']=$this->db->query("SELECT id,name FROM branch where is_delete=0 AND id='$branch'")->result_array();}
            $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
            $data['exam']=$this->db->query("SELECT `exam`.id,`exam`.name FROM `exam` INNER JOIN `exam_type` ON `exam_type`.`id`=`exam`.`etype_id` where `exam`.is_delete= 0 AND `exam_type`.is_delete= 0 AND `exam_type`.branch_id='$branch'")->result_array();
            
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('senior_exam/result',$data);
            $this->load->view('footer',$data);

    }
    public function student_result(){
            $this->user_model->check_permissions("senior_exam/result");
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            
            $student_id =$this->user_model->userInfo('student_id')['student_id'];
        
        
            $branch = $this->db->query("SELECT branch FROM `student` where is_delete='0' AND id = '$student_id'")->result_array();
            $branch = $branch[0]['branch'];
            $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0' and id = '$branch'")->result_array();
            
            $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
            $data['exam']=$this->db->query("SELECT `exam`.id,`exam`.name FROM `exam` 
            INNER JOIN `exam_type` ON `exam_type`.`id`=`exam`.`etype_id` 
            where `exam`.is_delete= 0 AND `exam_type`.is_delete= 0 AND `exam_type`.branch_id='$branch'")->result_array();
            
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('senior_exam/student_result',$data);
            $this->load->view('footer',$data);

    }
    
    
 public function ass_result()
 {
        $this->user_model->check_permissions("senior_exam/ass_result");
        $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $branch=$this->user_model->getbranch();
         if($this->is_super)
        $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0'")->result_array();
        else{
        $data['branch']=$this->db->query("SELECT id,name FROM branch where is_delete=0 AND id='$branch'")->result_array();}
        $data['session']=$this->db->query("SELECT id,name FROM session where is_delete=0")->result_array();
        $data['exam']=$this->db->query("SELECT `exam`.id,`exam`.name FROM `exam` INNER JOIN `exam_type` ON `exam_type`.`id`=`exam`.`etype_id` where `exam`.is_delete= 0 AND `exam_type`.is_delete= 0 AND `exam_type`.branch_id='$branch'")->result_array();
        
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('senior_exam/ass_result',$data);
           // $this->load->view('footer',$data); 
 }
 
 public function get_section_reportcart()
 {
       if($this->input->post()){
            $branch=$this->input->post('branch');
            $class=$this->input->post('class');
            $section=$this->input->post('section');
            $session=$this->input->post('session');
            $data['sessions']=$session;
            $data['clas']=$class;
            $data['section']=$section;
            $data['b']=$branch;
  
            $exam=$this->input->post('exam');
            
             $fect_catid=$this->db->select('*')
                       ->from('exam')
                       ->where('id',$exam)
                       ->get()->row_array()['etype_id'];
                                 
$getnew=$this->db->select('*')
                    ->from('senior_examsubtype')
                    ->where('senior_exam_type',$fect_catid)
                    ->where('is_delete',0)
                    ->get()->result_array();
  $data['tot_subj']=count($getnew);
  
            $data['senior_examtype']=$exam;
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['student']=$this->db->query("SELECT result.id,student.id as stdd,promotion.id as mid,student.sid,student.grno,student.student_name,student.father_name,result.position,result.total_marks,result.obtained_marks from `result` inner join `promotion` on promotion.id=result.promotion_id inner join `student` on 
            `student`.`id`=`promotion`.`student_id` where promotion.class_id='$class' AND promotion.section_id='$section' AND promotion.session_id='$session' AND promotion.is_delete=0 AND student.status=0 AND result.exam_id='$exam' AND `student`.`branch`='$branch' order by result.obtained_marks desc ")->result_array();
            if(!empty($data['student'])){
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('senior_exam/resultviewreport',$data);
            $this->load->view('footer',$data);
            }
            else{
                $this->session->set_flashdata('msg', "Record Not Found !");
                redirect('senior_exam/section_wise_report_card','refresh');
            }
        }
        else
        {
            redirect('senior_exam/section_wise_report_card','refresh');
        }
     
 }
    public function resultview()
    {
        if($this->input->post()){
            $branch=$this->input->post('branch');
            $class=$this->input->post('class');
            $section=$this->input->post('section');
            $session=$this->input->post('session');
            $data['clas']=$class;
            $data['section']=$section;

            $exam=$this->input->post('senior_exam');
            $data['senior_examtype']=$exam;
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['student']=$this->db->query("SELECT result.id,student.sid,student.grno,student.student_name,student.father_name,result.position,result.total_marks,result.obtained_marks from `result` inner join `promotion` on promotion.id=result.promotion_id inner join `student` on 
            `student`.`id`=`promotion`.`student_id` where promotion.class_id='$class' AND promotion.section_id='$section' AND promotion.session_id='$session' AND promotion.is_delete=0 AND student.status=0 AND result.exam_id='$exam' AND `student`.`branch`='$branch' order by result.obtained_marks desc ")->result_array();
// var_dump('<pre>',$data['student']);
// die();
        //   foreach($lop as $row){

        //     $result_subject=$this->db->select('total_marks,obtained_marks,id')
        //                              ->from('result_subject')
        //                              ->where('result_id',$row['id'])
        //                              ->where('subject_id',0000)
        //                              ->order_by('id','asc')
        //                              ->limit(1)
        //                              ->get()->row_array();
       
        //     $result_total=$row['total_marks'];
        //   $res_obtn=$row['obtained_marks'];
        //     $up_res=array(
        //         'total_marks'=>$result_total-$result_subject['total_marks'],
        //         'obtained_marks'=>$res_obtn-$result_subject['obtained_marks']
        //         );
          
        //     $this->db->where('id',$row['id'])
        //              ->update('result',$up_res);
            
        //     $this->db->where('id',$result_subject['id'])
        //              ->delete('result_subject');         
        //   }
 
            if(!empty($data['student'])){
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('senior_exam/resultview',$data);
            $this->load->view('footer',$data);
            }
            else{
                
                

                $this->session->set_flashdata('msg', "Record Not Found !");
                redirect('senior_exam/result','refresh');
            }
        }
        else
        {
            redirect('exam/result','refresh');
        }
    }
    
    public function student_result_view()
    {
        if($this->input->post()){
            $branch=$this->input->post('branch');
            $class=$this->input->post('class');
            $section=$this->input->post('section');
            $session=$this->input->post('session');
            $data['clas']=$class;
            $data['section']=$section;

            $student_id =$this->user_model->userInfo('student_id')['student_id'];
            
            $exam=$this->input->post('exam');
            $data['examtype']=$exam;
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            $data['student']=$this->db->query("SELECT result.id,student.sid,student.grno,student.student_name,student.father_name,result.position,result.total_marks,result.obtained_marks from `result` 
            inner join `promotion` on promotion.id=result.promotion_id inner join `student` on 
            `student`.`id`=`promotion`.`student_id`
            where student.id = '$student_id' AND promotion.class_id='$class' AND promotion.section_id='$section' AND promotion.session_id='$session' AND promotion.is_delete=0 AND student.status=0 AND result.exam_id='$exam' AND `student`.`branch`='$branch' order by result.obtained_marks desc ")->result_array();

            if(!empty($data['student'])){
                $data['base_url'] = base_url();
                $data['userInfo'] = $this->userInfo;
                $this->load->view('header',$data);
                $this->load->view('sidebar',$data);
                $this->load->view('senior_exam/student_result_view',$data);
                $this->load->view('footer',$data);
            }
            else{
                $this->session->set_flashdata('msg', "Record Not Found !");
                redirect('senior_exam/student_result','refresh');
            }
        }
        else
        {
            redirect('senior_exam/student_result','refresh');
        }
    }
    
    public function ass_resultview()
    {
          if($this->input->post()){
            $branch=$this->input->post('branch');
            $class=$this->input->post('class');
            $section=$this->input->post('section');
            $session=$this->input->post('session');
            
            // $sub_typeid=$this->input->post('sub_typeid');
            // $data['sub_typeid']=$sub_typeid;
            // $from=$this->input->post('from');
            // $data['from']=$from;
            // $to=$this->input->post('to');
            // $data['to']=$to;
            
            $data['clas']=$class;
            $data['section']=$section;
            $data['session']=$session;

            $exam=$this->input->post('exam');
            $data['examtype']=$exam;
            $data['is_super'] = $this->is_super;
            $data['menu'] = $this->load_model->menu();
            
            $this->db->select('result.id,student.sid,student.grno,student.student_name,student.father_name,result.position,result.total_marks,result.obtained_marks');
            $this->db->from('result');
            $this->db->join('result_subject','result_subject.result_id=result.id');
            $this->db->join('promotion','promotion.id=result.promotion_id');
            $this->db->join('student','student.id=promotion.student_id');
            $this->db->where('promotion.class_id',$class);
            $this->db->where('promotion.section_id',$section);
            $this->db->where('promotion.session_id',$session);
            $this->db->where('promotion.is_delete',0);
            $this->db->where('student.status',0);
            $this->db->where('result_subject.subexam_id>',0);
            //  if(!empty($sub_typeid))
            //     {
            //         $this->db->where('subexam_id',$sub_typeid);
            //      }
                         
            $this->db->where('result.exam_id',$exam);
            $this->db->where('student.branch',$branch);
            $this->db->group_by('result.id');
            $this->db->order_by('result.obtained_marks','desc');
            $data['student']=$this->db->get()->result_array();
            // var_dump('<pre>',$data['student']);
            // die();
            if(!empty($data['student'])){
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('senior_exam/ass_resultview',$data);
            $this->load->view('footer',$data);
            }
            else{
                $this->session->set_flashdata('msg', "Record Not Found !");
                redirect('senior_exam/ass_result','refresh');
            }
        }
        else
        {
            redirect('exam/ass_result','refresh');
        }
    }


public function printviewreport()
{
    if($this->uri->segment(3)){ 
       $result_id=$this->uri->segment(3);
       $data['rs']=$result_id;
       $branch=$this->report_model->getBranch()[0];
        $data['b']=$branch;
       $pro_id= @$this->db->select('*')
                             ->from('result')
                             ->where('id',$result_id)
                             ->get()->row_array();
        $pr_id= $pro_id['promotion_id']; 
        $exam=$pro_id['exam_id'];
        
        $prom=$this->db->select('*')
                             ->from('promotion')
                             ->where('id',$pr_id)
                             ->get()->row_array(); 
                           
        $class=$prom['class_id'];
        $section=$prom['section_id'];
       

        $student=$prom['student_id'];
        $add_exam="";
        $session=$prom['session_id'];                     
     
        $data['pr_id']=$pr_id;
        $data['stdd_id']=$pr_id;
        $data['exam_id']=$exam;
        $data['addexam_id']=$add_exam;
        $data['cc']=$class;
        $data['ccsec']=$section;
        $data['session_id']=$session;
        
       
      
        $data['percn']=$this->db->select('*')
                                ->from('result')
                                ->where('exam_id',$exam)
                                ->where('promotion_id',$pr_id)
                                ->where('is_delete',0)
                                ->get()->row_array();
         
        $data['subjects_cls']=$this->db->select('*')
                                       ->from('subject')
                                       ->where('class_id',$class)
                                       ->where('is_deleted',0)
                                       ->get()->result_array();
                                      
      
          $data['ad_exm']=$this->db->select('*')
                                 ->from('exam')
                                 ->where('id',$exam)
                                 ->get()->row_array();  
       $datofbirth=$this->db->select('dob')
                                 ->from('promotion')
                                 ->join("student","student.id=promotion.student_id")
                                 ->where("student.status","0")
                                 ->where("student.branch",$branch['id'])
                                 ->where('class_id',$class)
                                 ->where('section_id',$section)
                                 ->where('session_id',$session)
                                 ->where('is_active',1)
                                 ->where('student.is_delete',0)
                                 ->get()->result_array();
          $i=0;
            $sum=0;
        if(!empty($datofbirth))
        {
           
            foreach($datofbirth as $roww=>$keyy){
                
               $birthDate = date("d/m/Y",strtotime($keyy['dob']));
               $birthDate = explode("/", $birthDate);
                $age = (date("md", date("U", mktime(0, 0, 0, $birthDate[0], $birthDate[1], $birthDate[2]))) > date("md")?((date("Y") - $birthDate[2]) - 1): (date("Y") - $birthDate[2]));
                 $sum=$sum+$age;
                $i=$i+1;
            }
        }
  if($sum!=0)
  {
$data['avg_age']=round($sum/$i,2);
}else
{
    $data['avg_age']="";
}
        $tot_std=$this->db->select('count(promotion.id) as stds')
                                 ->from('promotion')
                                 ->join("student","student.id=promotion.student_id")
                                 ->where("student.status","0")
                                 ->where("student.branch",$branch['id'])
                                 ->where('class_id',$class)
                                 ->where('section_id',$section)
                                 ->where('session_id',$session)
                                 ->where('is_active',1)
                                 ->where('student.is_delete',0)
                                 ->get()->row_array();

    if(!empty($tot_std))    
    {
        $data['tot_stds']=$tot_std['stds'];
    }else
    {
        $data['tot_stds']=0;
    }
    $data['dastudent']=@$this->db->where('student_id',$student)->where('session_id',$session)->where('is_active',1)->where('is_delete',0)->get('promotion')->row()->id;
  
  $fect_catid=$this->db->select('*')
                       ->from('exam')
                       ->where('id',$exam)
                       ->get()->row_array()['etype_id'];
                                 
$data['getnew']=$this->db->select('*')
                    ->from('senior_examsubtype')
                    ->where('senior_exam_type',$fect_catid)
                    ->where('is_delete',0)
                    ->get()->result_array();
  $data['tot_subj']=count($data['getnew']); 
     
        $data['seen_exam'] ="";
     
    
        $data['unseen_exam'] ="";
      
        $data['percentage']=$this->input->post('percentage');
      $data['dob']=$this->db->where('id',$student)->get('student')->row()->dob;
    
        $data['students']=$this->db->where('id',$student)->get('student')->row()->student_name;
        $data['class_name']=$this->db->where('class_id',$class)->get('class')->row()->class_name;
        $data['class_name']=$this->db->where('class_id',$class)->get('class')->row()->class_name;
        $data['section_name']=$this->db->where('section_id',$section)->get('section')->row()->section_name;
        $data['first_term']=$this->report_model->StudentWiseExamStudents($branch,$class,$section,$student,$add_exam,$session);
        $data['student']=$this->report_model->StudentWiseExamStudents($branch,$class,$section,$student,$exam,$session);
        $data['highest_grade']=$this->report_model->StudentWiseHighestGrade($branch,$class,$section,$exam,$session);
        $data['highes']=$this->report_model->StudentWiseHighestGraderep($branch,$class,$section,$exam,$session);
       
        $data['lowest_grade']=$this->report_model->StudentWiselowestGrade($branch,$class,$section,$exam,$session);
        $data['lowes']=$this->report_model->StudentWiselowestGraderep($branch,$class,$section,$exam,$session);
        // var_dump('<pre>',$data['lowes']);
        // die();
        $data['all_student_lowest_grade']=$this->report_model->StudentWisealllowestGrade($branch,$class,$section,$exam,$session);
        $data['get_att']=$this->report_model->Studentatt($branch,$class,$section,$student,$session);
         $data['tot_att']=$this->report_model->Studentattot($branch,$class,$section,$student,$session);
     
        $data['get_absent']=$this->report_model->StudentattAbsent($branch,$class,$section,$student,$session);
        $data['branch_name']=$this->report_model->getBranch()[0]['name']; 
        $data['b_header']= $this->report_model->BranchHeader();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         
     //$this->load->view('report/get_report_card',$data);
            $this->load->view('printable/result_report_card',$data);
        }
        else
        {
            redirect('senior_exam/section_wise_report_card','refresh');
        }
}

public function printall_reportcard()
{
     if($this->uri->segment(3)){
            $url=json_decode(base64_decode($this->uri->segment(3)),true); 
          
            $branch=$this->user_model->getbranch();
            $data['b_header'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->row_array();
            foreach ($url as $key => $result_id) {
                $data['data'][$key]['result_subject']=$this->db->query("SELECT subject.name as subject_name,result_subject.total_marks,result_subject.obtained_marks,result_subject.passing_marks,result_subject.paper_date from `result_subject` inner join `subject` on subject.id=result_subject.subject_id where result_subject.is_delete=0 AND result_subject.result_id='$result_id' AND result_subject.subexam_id<=0 AND subject.is_deleted='0'")->result_array();
                $data['data'][$key]['result']=$this->db->query("SELECT result.id as rs_id,student.img,student.id as stid,section.section_name,class.class_name,student.sid,student.student_name,student.father_name,exam.name as exam_name,exam.start,exam.end,result.total_marks,result.total_marks,result.obtained_marks,position,result.attendance,result.grade from `result` inner join `promotion` on result.promotion_id=promotion.id inner join `student` ON `student`.`id`=`promotion`.`student_id` inner join `class` on class.class_id=promotion.class_id inner join `section` on section.section_id=promotion.section_id inner join `exam` on `exam`.`id`=`result`.`exam_id` where student.status='0' AND result.id='$result_id' AND promotion.is_delete='0' AND student.status='0'")->row_array();
            }
            $this->load->view('printable/rep_cart_resultclass',$data);
        }
        else
        {
            redirect('senior_exam/section_wise_report_card','refresh');
        }
}
    public function printview()
    {
        if($this->uri->segment(3)){ 
            $result_id=$this->uri->segment(3);
            $data['rs']=$result_id;
            $pro_id=$this->db->select('*')
                             ->from('result')
                             ->where('id',$result_id)
                             ->get()->row_array();
                             
            $pro=$pro_id['promotion_id'];
            $data['examtype']=$pro_id['exam_id'];
          
            $data['prom']=$p_rs=$this->db->select('*')
                             ->from('promotion')
                             ->where('id',$pro)
                             ->get()->row_array();
           $cl_id=$p_rs['class_id'];    
            $data['class_order']=$this->db->select('*')
                                              ->from('class')
                                              ->where('class_id',$cl_id)
                                              ->get()->row_array()['orderr'];
                             
            $branch=$this->user_model->getbranch();
            $data['b_header'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->row_array();
            $data['result_subject']=$this->db->query("SELECT subject.name as subject_name,result_id,result_subject.total_marks,result_subject.obtained_marks,result_subject.passing_marks,result_subject.paper_date from `result_subject` inner join `subject` on subject.id=result_subject.subject_id where result_subject.is_delete=0 AND subject.is_deleted=0 AND result_subject.result_id='$result_id' group by result_subject.subject_id")->result_array();
           
            $data['ass_subject']=$this->db->query("SELECT subject.name as subject_name,senior_examsubtype.name as ex_nam,result_subject.total_marks,result_subject.obtained_marks,result_subject.passing_marks,result_subject.paper_date from `result_subject` inner join `senior_examsubtype` on senior_examsubtype.id=result_subject.subexam_id inner join `subject` on subject.id=result_subject.subject_id where result_subject.is_delete=0 AND result_subject.result_id='$result_id'")->result_array();
          
            $data['result']=$this->db->query("SELECT student.img,student.id as stid,section.section_name,class.class_name,student.grno,student.sid,student.student_name,student.father_name,senior_exam.name as exam_name,senior_exam.start,senior_exam.end,result.total_marks,result.total_marks,result.obtained_marks,position,result.attendance,result.grade from `result` inner join `promotion` on result.promotion_id=promotion.id inner join `student` ON `student`.`id`=`promotion`.`student_id` inner join `class` on class.class_id=promotion.class_id inner join `section` on section.section_id=promotion.section_id inner join `exam` on `senior_exam`.`id`=`result`.`exam_id` where student.status='0' AND result.id='$result_id' AND promotion.is_delete='0' AND student.status='0'")->row_array();
            $this->load->view('printable/result',$data);
            // AND subexam_id>'0'  AND subexam_id='0'
        }
        else
        {
            redirect('senior_exam/result','refresh');
        }
    }
    
    public function assprintview()
    {
        if($this->uri->segment(3)){ 
            $result_id=$this->uri->segment(3);

            $pro_id=$this->db->select('*')
                             ->from('result')
                             ->where('id',$result_id)
                             ->get()->row_array();
                             
           $pro=$pro_id['promotion_id'];
           $data['senior_examtype']=$pro_id['exam_id'];
           $data['prom']=$this->db->select('*')
                             ->from('promotion')
                             ->where('id',$pro)
                             ->get()->row_array();

            $branch=$this->user_model->getbranch();
            $data['b_header'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->row_array();
            $data['result_subject']=$this->db->query("SELECT subject.name as subject_name,result_id,result_subject.total_marks,result_subject.obtained_marks,result_subject.passing_marks,result_subject.paper_date from `result_subject` inner join `subject` on subject.id=result_subject.subject_id where result_subject.is_delete=0 AND result_subject.result_id='$result_id' AND subexam_id='0'")->result_array();
            $this->db->select('*,senior_examsubtype.name as ex_nam');
                   $this->db->from('result_subject');
                                   $this->db->join('senior_examsubtype','senior_examsubtype.id=result_subject.subexam_id');
                                   $this->db->where('result_id',$result_id);
                                   $this->db->where('subexam_id>',0);
                                   $this->db->group_by('subexam_id');
                         $data['types']=$this->db->get()->result_array();
                    //   var_dump('<pre>',$data['types']);
                    //   die();
                                   $this->db->select('*,subject.name as subject_name');
                                   $this->db->from('result_subject');
                                   $this->db->join('subject','subject.id=result_subject.subject_id');
                                   $this->db->where('result_id',$result_id);
                                   $this->db->where('subexam_id>',0);
                                  
                                   $this->db->group_by('subject_id');
                                  $data['sbs']= $this->db->get()->result_array();                           
// var_dump('<pre>',$data['sbs']);
// die();
            $data['ass_subject']=$this->db->query("SELECT subject.name as subject_name,senior_examsubtype.name as ex_nam,result_subject.total_marks,result_subject.obtained_marks,result_subject.passing_marks,result_subject.paper_date from `result_subject` inner join `examsubtype` on examsubtype.id=result_subject.subexam_id inner join `subject` on subject.id=result_subject.subject_id where result_subject.is_delete=0 AND result_subject.result_id='$result_id' AND subexam_id>'0'")->result_array();
         
            $data['result']=$this->db->query("SELECT student.img,student.id as stid,section.section_name,class.class_name,student.grno,student.sid,student.student_name,student.father_name,senior_exam.name as exam_name,senior_exam.start,senior_exam.end,result.total_marks,result.total_marks,result.obtained_marks,position,result.attendance,result.grade from `result` inner join `promotion` on result.promotion_id=promotion.id inner join `student` ON `student`.`id`=`promotion`.`student_id` inner join `class` on class.class_id=promotion.class_id inner join `section` on section.section_id=promotion.section_id inner join `senior_exam` on `senior_exam`.`id`=`result`.`exam_id` where student.status='0' AND result.id='$result_id' AND promotion.is_delete='0' AND student.status='0'")->row_array();
            $this->load->view('printable/assresult',$data);
        }
        else
        {
            redirect('senior_exam/result','refresh');
        } 
    }

    public function printviewclass()
    {
        if($this->uri->segment(3)){
            $url=json_decode(base64_decode($this->uri->segment(3)),true); 
          
            $branch=$this->user_model->getbranch();
            $data['b_header'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->row_array();
            
            foreach ($url as $key => $result_id) {
                $data['data'][$key]['result_subject']=$this->db->query("SELECT subject.name as subject_name,result_subject.total_marks,result_subject.obtained_marks,result_subject.passing_marks,result_subject.paper_date from `result_subject` inner join `subject` on subject.id=result_subject.subject_id where result_subject.is_delete=0 AND result_subject.result_id='$result_id' AND result_subject.subexam_id<=0 AND subject.is_deleted='0' group by result_subject.subject_id")->result_array();
                $data['data'][$key]['result']=$this->db->query("SELECT result.id as rs_id,student.img,student.id as stid,section.section_name,class.class_name,class.class_id as clap_id,student.sid,student.student_name,student.father_name,senior_exam.name as exam_name,senior_exam.start,senior_exam.id as exm_id,exam.end,result.total_marks,result.total_marks,result.obtained_marks,position,result.attendance,result.grade from `result` inner join `promotion` on result.promotion_id=promotion.id inner join `student` ON `student`.`id`=`promotion`.`student_id` inner join `class` on class.class_id=promotion.class_id inner join `section` on section.section_id=promotion.section_id inner join `exam` on `exam`.`id`=`result`.`exam_id` where student.status='0' AND result.id='$result_id' AND promotion.is_delete='0' AND student.status='0'")->row_array();
            }
            $this->load->view('printable/resultclass',$data);
        }
        else
        {
            redirect('senior_exam/result','refresh');
        }
    }
    
    public function assprintviewclass()
    {
           if($this->uri->segment(3)){
            $url=json_decode(base64_decode($this->uri->segment(3)),true); 
         
            
            
            $pro_id=$this->db->select('*')
                             ->from('result')
                             ->where('id',$url[0])
                             ->get()->row_array();
           $pro=$pro_id['promotion_id'];
           $data['examtype']=$pro_id['exam_id'];
           $data['prom']=$this->db->select('*')
                             ->from('promotion')
                             ->where('id',$pro)
                             ->get()->row_array();
                             
            $branch=$this->user_model->getbranch();
            $data['b_header'] = $this->db->query("SELECT * FROM `branch` WHERE `id`='$branch' AND `is_delete`='0'")->row_array();
            foreach ($url as $key => $result_id) {
                $data['data'][$key]['result_subject']=$this->db->query("SELECT * from `result_subject` where result_subject.is_delete=0 AND result_subject.result_id='$result_id' AND result_subject.subexam_id>0 group by result_id")->result_array();
                $data['data'][$key]['result']=$this->db->query("SELECT student.img,student.id as stid,section.section_name,class.class_name,student.sid,student.student_name,student.father_name,senior_exam.name as exam_name,senior_exam.start,senior_exam.end,result.total_marks,result.total_marks,result.obtained_marks,position,result.attendance,result.grade from `result` inner join `promotion` on result.promotion_id=promotion.id inner join `student` ON `student`.`id`=`promotion`.`student_id` inner join `class` on class.class_id=promotion.class_id inner join `section` on section.section_id=promotion.section_id inner join `exam` on `exam`.`id`=`result`.`exam_id` where student.status='0' AND result.id='$result_id' AND promotion.is_delete='0' AND student.status='0'")->row_array();
            }
            $this->load->view('printable/assresultclass',$data);
        }
        else
        {
            redirect('senior_exam/ass_result','refresh');
        }
    }

    /* Datesheet */

    public function datesheet($date='')
    {
        $this->user_model->check_permissions("senior_exam/datesheet");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($date==''){
              $date = date('d-m-Y');  
            }
            $data['date'] = $date;
        if($this->is_super)
        {
           $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("senior_datesheet/datesheet",$data);
    }

    public function add_datesheet()
    {
        //var_dump("<pre>",$this->input->post());die;
        if($this->input->post())
        {
            
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $section = 0;
            $exam= $this->input->post("exam",true);
            $sub= $this->input->post("sub",true);
            $date = $this->input->post("date",true);
          
            $time = $this->input->post('time_start',true);
            $subj = array_filter($sub);
            $subject = array_values($subj);
            $time_e = $this->input->post('time_end',true);
            if(!empty($subject)){
            foreach ($subject as $key => $value)
            {
                $datee = str_replace('/', '-', $date[$key]);
                $dateto= date('Y-m-d', strtotime($datee));

                        
                    $data = array(
                    "bid"=>$branch,
                    "class_id"=>$class,
                    "section_id"=>$section,
                    "exam_id"=>$exam,
                    "day_exam"=>"Monday",
                    "subject_id"=>$value,
                    "date_exam"=>$dateto,    
                    "start_time"=>$time[$key],
                    "end_time"=>$time_e[$key]
                );
          
                    $this->db->insert("senior_datesheet",$data);
                
                } 
                $this->session->set_flashdata('msg', "Date Sheet Created Successfully!");  
                 
                redirect("senior_exam/datesheet");
            }else
            {
                $this->session->set_flashdata('msgs', "Date Sheet Not Created Successfully!");  
                 
                redirect("senior_exam/datesheet");
            }
            
        }else
        redirect("senior_exam/datesheet","refresh");
    }

    public function viewsheet()
    {
        
       
        $data['edit_delete']=$this->user_model->checkEditDelete('senior_exam/viewsheet');
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
       

            $branch = $this->input->post("branch");
            $data['branch'] = $branch;
            $class = $this->input->post("class");
            $data['class'] = $class;
            $exam = $this->input->post("exam");
            $data['exam'] = $exam;
            $data['b_title'] = $this->db->query("select title from branch where id='$branch'")->result_array();
            
            $data['data'] = $this->db->select('senior_datesheet.*,class.class_name,branch.name as b_name,senior_exam.name as exam_name,subject.name as subject_name')->from("senior_datesheet")->join("class","class.class_id=senior_datesheet.class_id")->join("branch","branch.id=senior_datesheet.bid")->join("senior_exam","senior_exam.id=senior_datesheet.exam_id")->join("subject","subject.id=senior_datesheet.subject_id")->where("senior_datesheet.is_delete","0")->where("senior_datesheet.bid",$branch)->where("senior_datesheet.class_id",$class)->where("senior_datesheet.exam_id",$exam)->get()->result_array();
            if(!empty($data['data'])) {   
            $data["i"]=1;
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view("senior_datesheet/viewsheet",$data);
                }
            else
            {
                $this->session->set_flashdata('msg', "Record Not Found !");
                redirect("senior_exam/date_view","refresh");
            }
    }

    public function edit1($id=0)
    {
        $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
        $data['menu'] = $this->load_model->menu();
        $this->db->select("datesheet_id,bid,class_id,section_id,exam_id,subject_id,date_exam,start_time,end_time"); 
        $this->db->from('senior_datesheet');
        $this->db->where('is_delete','0'); 
        $this->db->where('datesheet_id',$id);
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['data'] = $query->result_array()[0];
        $data['class'] = $this->db->select('class_id,class_name')->from("class")->where("is_delete","0")->where("branch",$data['data']['bid'])->get()->result_array();
        $data['section'] = $this->db->select('section_id,section_name')->from("section")->where("is_delete","0")->where("branch",$data['data']['bid'])->where("class_id",$data['data']['class_id'])->get()->result_array();
        $data['subject'] = $this->db->select('id,name')->from("subject")->where("is_deleted","0")->where("class_id",$data['data']['class_id'])->get()->result_array();
        if($this->is_super){
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }
        else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        //var_dump($data['branch']);die;
        $data['exam'] = $this->db->select('senior_exam.id,senior_exam.name')->from("senior_exam")->join("senior_exam_type","senior_exam_type.id=senior_exam.etype_id")->where("exam_type.branch_id",$data['data']['bid'])->where("senior_exam.is_delete","0")->where("senior_exam_type.is_delete","0")->get()->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('senior_datesheet/edit1',$data);
    }

    public function edit_datesheet()
    {
   
        if($this->input->post())
        {
            
            $id = $this->input->post("id",true);
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $section = 0;
            $subject = $this->input->post("subject",true);
            $exam= $this->input->post("exam",true);
            $day= $this->input->post("day",true);
            $date = $this->input->post("date",true);
              
            $time = $this->input->post("time_start",true);
            $time_e = $this->input->post("time_end",true);
            //echo "<pre>";print_r($this->input->post("time_start",true));exit;
            $data = array(
                //"bid"=>$branch,
                //"class_id"=>$class,
                //"section_id"=>$section,
                //"exam_id"=>$exam,
                "subject_id"=>$subject,
                "date_exam"=>$date,
               // "day_exam"=> $day ,     
                "start_time"=>$time,
                "end_time"=>$time_e
            );
            $this->db->where("datesheet_id",$id); 
            $this->db->update("senior_datesheet",$data); 
            redirect("Senior_exam/date_view","refresh");
        }else
        redirect("Senior_exam/date_view","refresh");
    }
    
    public function delete1($id)
    {
            if(!empty($id))
            {
  $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
                $data = array(
                    'is_delete' => "1"
                );
                $this->db->where("datesheet_id",$id);
                $this->db->update("senior_datesheet",$data); 
            }
            redirect('Senior_exam/viewsheet','refresh');
    }
    
    
    public function delete_exam1($id,$branch,$exam,$class)
    {
            if(!empty($id))
            {
                $data = array(
                    'is_delete' => "1"
                );
                $this->db->where("datesheet_id",$id);
                $this->db->update("senior_datesheet",$data); 
                
                $edit_delete=$this->user_model->checkEditDelete('senior_exam/viewsheet');
                
                $data['b_title'] = $this->db->query("select title from branch where id='$branch'")->result_array();
                
                $exams = $this->db->select('senior_datesheet.*,class.class_name,branch.name as b_name,exam.name as exam_name,subject.name as subject_name')->from("senior_datesheet")->join("class","class.class_id=senior_datesheet.class_id")->join("branch","branch.id=senior_datesheet.bid")->join("exam","senior_exam.id=senior_datesheet.exam_id")->join("subject","subject.id=senior_datesheet.subject_id")->where("senior_datesheet.is_delete","0")->where("senior_datesheet.bid",$branch)->where("senior_datesheet.class_id",$class)->where("senior_datesheet.exam_id",$exam)->get()->result_array();
                    
                if(!empty($exams))
                {
                    $i=0; 
                    foreach ($exams as $key => $value)
                    { 
                                
                                $i++;
                            
                                echo "
                                 <tr>
                                 
                                          <td>$i</td>
                                          <td>$value[class_name]</td>
                                          
                                          <td>$value[subject_name]</td>
                                          <td>$value[exam_name]</td>
                                          <td>$value[date_exam]</td>";
                                         
                                          if($this->user_model->is_super()){
                                          echo "<td>$value[b_name]</td>";}
                                          echo "<td>";
                                          if($edit_delete['edit'] == 1){
                                                     
                                                    echo "<a href='Exam/edit1/base64_encode(json_encode($value[datesheet_id].SALT)); ?>'><i class='fa fa-pencil-square-o'></i></a>";
                                          }
                                          if($edit_delete['delete'] == 1){
                                                     
                                                    echo "<a href='' onclick='deleete($value[datesheet_id],event)'><i class='fa fa-trash'></i></a>";
                                          }
                                         echo "</td>";
                                
                                
                               echo"</tr>";
                               
                    } 
    
            }
            else
                echo "";
            }
            else
                echo "";
            
    }

    public function date() 
    {
        $this->user_model->check_permissions("senior_exam/date");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
            $data['senior_exam'] = $this->db->select('senior_exam.id,senior_exam.name')->from("senior_exam")->join("senior_exam_type","senior_exam.etype_id=senior_exam_type.id")->where("senior_exam_type.is_delete","0")->where("senior_exam.is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
            $data['senior_exam'] = $this->db->select('senior_exam.id,senior_exam.name')->from("senior_exam")->join("senior_exam_type","senior_exam.etype_id=senior_exam_type.id")->where("senior_exam_type.is_delete","0")->where("senior_exam.is_delete","0")->where("senior_exam_type.branch_id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("senior_datesheet/view_datesheet",$data);
    }
    public function date_view() 
    {
        $this->user_model->check_permissions("senior_exam/date");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
            $data['senior_exam'] = $this->db->select('senior_exam.id,senior_exam.name')->from("senior_exam")->join("senior_exam_type","senior_exam.etype_id=senior_exam_type.id")->where("senior_exam_type.is_delete","0")->where("senior_exam.is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
            $data['senior_exam'] = $this->db->select('senior_exam.id,senior_exam.name')->from("senior_exam")->join("senior_exam_type","senior_exam.etype_id=senior_exam_type.id")->where("senior_exam_type.is_delete","0")->where("senior_exam.is_delete","0")->where("senior_exam_type.branch_id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("senior_datesheet/view_datesheet1",$data);
    }

    public function date1()
    {
          $branch=$this->user_model->getbranch();
           
            $data['b_header'] = @$this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
        if($this->input->post())
        {
            $branch = $this->input->post("branch");
            $class = $this->input->post("class");
            $exam = $this->input->post("exam");
            $data['exam'] = $this->db->select('exam.name')->from("exam")->where("exam.id",$exam)->where("exam.is_delete","0")->get()->result_array()[0]['name'];
            $data['b_title'] = $this->db->query("select title from branch where id='$branch'")->result_array()[0]['title'];
            $data['data'] = $this->db->select('senior_datesheet.*,class.class_name,senior_exam.name as exam_name,subject.name as subject_name')->from("senior_datesheet")->join("class","class.class_id=senior_datesheet.class_id")->join("senior_exam","senior_exam.id=datesheet.exam_id")->join("subject","subject.id=senior_datesheet.subject_id")->where("senior_datesheet.is_delete","0")->where("senior_datesheet.bid",$branch)->where("senior_datesheet.class_id",$class)->where("senior_datesheet.exam_id",$exam)->get()->result_array();
            $data['note'] = $this->db->query("SELECT note FROM `note` WHERE branch_id='$branch' and note.is_delete='0'")->result_array();
            if(!empty($data['data'])){
            $this->load->view("senior_datesheet/view_sheet",$data);
            }
            else
            {
                $this->session->set_flashdata('msg', "Record Not Found !");
                redirect("exam/date","refresh");
            }
        
        }
    }

    /* Roll No Slip */ 

    public function rollno()
    {
        $this->user_model->check_permissions("senior_exam/rollno");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("senior_datesheet/rollno",$data);
    }

    public function viewrollno() 
    {
         $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        // Getting Values from URI Segments
        $branch = $this->uri->segment('3');
        $class = $this->uri->segment('4');
        $section = $this->uri->segment('5');
        $exam = $this->uri->segment('6');
        //
        $data['exam']=$exam; 
        $data['class']=$class; 
        $data['section']=$section; 
        $d=$this->db->query("SELECT promotion.id as stid,sid,student_name,father_name,student.grno, branch.name from senior_rollnoslip 
        INNER JOIN branch on branch.id=senior_rollnoslip.branch_id 
        INNER JOIN promotion on promotion.id=senior_rollnoslip.student_id 
        inner join student on student.id=promotion.student_id
        inner join class on class.class_id=promotion.class_id 
        INNER join section on section.section_id=promotion.section_id
        WHERE promotion.is_active='1' AND
        promotion.is_delete='0' 
        AND rollnoslip.class_id='$class' 
        AND rollnoslip.section_id='$section' 
        AND rollnoslip.branch_id='$branch' 
        AND rollnoslip.exam_id='$exam' 
        AND student.status='0'")->result_array();
        $data["data"]=$d;
        $data["i"]=1;


        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("senior_datesheet/viewrollno",$data);
    }

    public function rolldate()
    {
           // $exam = $this->input->post("exam");
           if($this->uri->segment('3')){
            $id=$this->uri->segment('3');
            $exam_id=$this->uri->segment('4');
            $branch=$this->user_model->getbranch();
            $data['branch']=$branch;
            $data['b_header'] = @$this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            //var_dump($data['b_header']);die();
            $rollnoslip = $this->db->query("SELECT seat_no,class_id from senior_rollnoslip where student_id='$id' AND `exam_id`='$exam_id' AND is_delete='0'")->result_array()[0];
            $data['seat_no'] = $rollnoslip['seat_no'];
            $class = $rollnoslip['class_id'];
            $data['class_order']=$this->db->select('*')
                                          ->from('class')
                                          ->where('class_id',$class)
                                          ->get()->row_array()['orderr'];
            $data['classs'] = $rollnoslip['class_id'];
			$data['exams']= $exam_id;
			//var_dump($data['exam']);die;
    $data['student'] = $this->db->query("SELECT student.id,roll_no,student_name,student.grno,father_name,class.class_name,student.sid,student.img,student.dob,section.section_name from student INNER JOIN promotion on promotion.student_id=student.id

 inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id  WHERE promotion.is_active='1' AND promotion.is_delete='0' AND promotion.id='$id'")->result_array()[0];
           
            $data['exam'] = $this->db->select('id,name')->from("exam")->where("is_delete","0")->where('id',$exam_id)->get()->row_array();
            $data['data'] = $this->db->query("SELECT senior_datesheet.date_exam,senior_datesheet.day_exam,senior_datesheet.start_time,senior_datesheet.end_time,subject.name as subject_name,class.class_id FROM `senior_datesheet` INNER JOIN class on senior_datesheet.class_id=class.class_id INNER JOIN subject ON subject.id=senior_datesheet.subject_id  WHERE senior_datesheet.is_delete='0' and senior_datesheet.class_id='$class' and senior_datesheet.exam_id='$exam_id'")->result_array();
			
			//var_dump("<pre>",$data['data']);die;
            $data['note'] = $this->db->query("SELECT note FROM `note` WHERE branch_id='$branch' and note.is_delete='0'")->result_array();
            $this->load->view("senior_datesheet/previewroll",$data);
        }
        else
        {
            redirect('senior_exam/rollno',refresh);
        }
     
    }
    public function rolldatesection()
    {
        if($this->input->post()){
        
           // $exam = $this->input->post("exam");
            $students = $this->input->post('student',true);
            
            if(!empty($students)){
                $class = $this->input->post('class',true);
            $section = $this->input->post('section',true);
            $exam_id = $this->input->post('exam',true);
           
            $branch=$this->user_model->getbranch();
            $data['branch'] = $branch;
            $data['exams']= $exam_id;
            
            $data['class_order']=$this->db->select('*')
                                           ->from('class')
                                           ->where('class_id',$class)
                                           ->get()->row_array()['orderr'];
            $data['classs'] = $class;   
            $data['b_header'] = $this->db->query("SELECT name,title,tagline,short_address,phone_no,email,logo1,logo2 from branch where id='$branch' AND is_delete='0'")->result_array()[0];
            $data['exam'] = $this->db->select('id,name')->from("exam")->where("is_delete","0")->where('id',$exam_id)->get()->row_array();
            $data['data'] = $this->db->query("SELECT datesheet.date_exam,datesheet.day_exam,datesheet.start_time,datesheet.end_time,subject.name as subject_name FROM `datesheet` INNER JOIN class on datesheet.class_id=class.class_id INNER JOIN subject ON subject.id=datesheet.subject_id  WHERE datesheet.is_delete='0' and datesheet.class_id='$class' and datesheet.exam_id='$exam_id'")->result_array();
           
            $data['note'] = $this->db->query("SELECT note FROM `note` WHERE branch_id='$branch' and note.is_delete='0'")->result_array();
            /**/
            $data['students'] = $this->db->query("SELECT student.id,roll_no,student_name,father_name,class.class_name,student.sid,student.img,student.dob,section.section_name from student INNER JOIN promotion on promotion.student_id=student.id inner join class on class.class_id=promotion.class_id INNER join section on section.section_id=promotion.section_id  WHERE promotion.is_active='1' AND promotion.is_delete='0' AND promotion.id IN ('".implode("','",$students)."') AND promotion.class_id='$class' AND promotion.section_id='$section' and student.status='0'")->result_array();
            //$rollnoslip = $this->db->query("SELECT seat_no,class_id from rollnoslip where student_id='$id' AND `exam_id`='$exam_id' AND is_delete='0'")->result_array()[0];
              
            //var_dump($data['exam']);die;
            //$data['seat_no'] = $rollnoslip['seat_no'];
            $this->load->view("printable/rollnoslip_section",$data);
            }else{
                echo "Please select students...";
            }
           
        }
        else
        {
            redirect('senior_exam/rollno','refresh');
        }
     
    }

    public function rollnoslip()
    {
        if($this->input->post())
        {
            $id = $this->input->post("id",true);
            $branch = $this->input->post("branch",true);
            $class = $this->input->post("class",true);
            $section = $this->input->post("section",true);
            $exam = $this->input->post("exam",true);
            $data = $this->db->query("SELECT promotion.id,student.sid FROM `promotion` INNER JOIN student ON student.id=promotion.student_id WHERE student.branch='$branch' and promotion.class_id='$class' and promotion.section_id='$section' and promotion.is_active='1' and promotion.is_delete='0' and student.status='0'")->result_array();
            $series = $this->random_numbers(4);
            foreach ($data as $key => $value) {
                $student_id = $value['id'];
                $exam_date = $this->db->select("start")->from("exam")->where("id",$exam)->get()->row_array()['start'];
                $seat_no = $series++; //date("ymd",strtotime($exam_date))..$value['sid']
                $count = $this->db->select("id")->from("rollnoslip")->where("student_id",$student_id)->where("branch_id",$branch)->where("class_id",$class)->where("section_id",$section)->where("exam_id",$exam)->where("is_delete","0")->count_all_results();
                if($count==0)
                {
                    $data = array(
                        "branch_id"=>$branch,
                        "class_id"=>$class,
                        "exam_id"=>$exam,
                        "section_id"=>$section,
                        "student_id"=>$student_id,
                        "seat_no"=>$seat_no
                    );
                    $this->db->insert("rollnoslip",$data); 
                }
            }
            redirect("Senior_exam/viewrollno/$branch/$class/$section/$exam","refresh");
        }
    }

    /* senior_Notes */

    public function notes()
    {
        $this->user_model->check_permissions("senior_exam/notes");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
           $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("senior_datesheet/notes",$data);
    }

    public function add_note()
    {
        if($this->input->post())
        {
            
            $branch = $this->input->post("branch",true);
            $note = $this->input->post("note",true);
            
            $data = array(
                "branch_id"=>$branch,
                "note"=>$note
                
            );
            $this->db->insert("note",$data); 
            redirect("senior_exam/viewnote");
        }else
        redirect("senior_exam/viewnote","refresh");
    }

    public function viewnote()
    {
        $this->user_model->check_permissions("senior_exam/viewnote");
$data['edit_delete']=$this->user_model->checkEditDelete('senior_exam/viewnote');
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
           $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }else{
            $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        }
        if($this->is_super)
        {
           
           $d=$this->db->select("note.id,note.note,branch.name")-> JOIN( "branch","note.branch_id=branch.id")->from("note")->where("note.is_delete","0")->get()->result_array();
        
        }else{
            $d=$this->db->select("note.id,note.note,branch.name")->JOIN( "branch","note.branch_id=branch.id")->from("note")->where("note.is_delete","0")->where("branch_id",$this->branch)->get()->result_array();
        }
//var_dump($d);die();
        $data["data"]=$d;
        $data["i"]=1;


        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("senior_datesheet/viewnote1",$data);
    }

    public function editnote($id=0)
    {
       $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
        $data['menu'] = $this->load_model->menu();
        $this->db->select("id,,branch_id,note"); 
        $this->db->from('note');
        $this->db->where('is_delete','0'); 
        $this->db->where('id',$id);
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->where("id",$this->branch)->get()->result_array();
        $data['data'] = $query->result_array()[0];
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
       
        $this->load->view("senior_datesheet/editnote",$data);
    }

    public function edit_note()
    { 
        
         if($this->input->post())
        {    
                 $id = $this->input->post("id",true);
                $branch = $this->input->post("branch",true);
                $note = $this->input->post("note",true);
                
             $data = array(
                "branch_id"=>$branch,
                "note"=>$note
                
            );
            $this->db->where("id",$id); 
            $this->db->update("note",$data); 
            redirect("Exam/viewnote");
         }
        else
            redirect("Senior_exam/viewnote","refresh");
    }
   
    public function notedelete($id)
    {
            //base_url()."Exam/notedelete/$id"
                if(!empty($id))
                {
  $id = explode(SALT,json_decode(base64_decode($this->uri->segment(3))))[0];
                    $data = array(
                        'is_delete' => "1"
                    );
                    $this->db->where("id",$id);
                    $this->db->update("note",$data); 
                }
                redirect('Senior_exam/viewnote','refresh');
    }

    /* Functional Helper Functions */

    private function check_or_create_result($exam=0,$promotion=0)
    {
        if($exam!=0 && $promotion!=0)
        {
            
            $this->db->select("id");
            $this->db->from("result");
            $this->db->where("promotion_id",$promotion);
            $this->db->where("exam_id",$exam);
            $this->db->where("is_delete","0");
           $check=$this->db->get();
            if($check->num_rows()==1)
            {
              
                return $check->row()->id;
            }else{
                
                $data['exam_id']=$exam;
                $data['promotion_id']=$promotion;
                $this->db->insert("result",$data);
                return $this->db->insert_id();
            }
        }
    } 

    private function getResultTotalObtain($result=0)
    {
        if($result!=0)
        {
            return $this->db->select("id,total_marks,obtained_marks")->from("result")->where("id",$result)->where("is_delete","0")->get()->row();
        }
    } 

    private function getResultSubjects($result=0)
    {
        if($result!=0)
        {
            return $this->db->select("result_subject.*")->from("result_subject")->join('subject','subject.id=result_subject.subject_id')->where("result_subject.result_id",$result)->where("result_subject.is_delete","0")->where("subject.is_deleted","0")->get()->result();
        }
    } 

    private function updateResult($result_id=0,$total=0,$obtain=0,$promotion=0)
    {
        if($result_id!=0 && $total!=0 && $promotion!=0)
        {
            $result_data = $this->getResultTotalObtain($result_id);
            $result_subjects = $this->getResultSubjects($result_id);
            $student_att=$this->db->query("SELECT COUNT(status_id) as total ,(select COUNT(status_id) from studentatt WHERE status_id=1 AND studentatt.promotion_id='$promotion' AND studentatt.is_deleted=0) as pre FROM studentatt inner JOIN promotion on studentatt.promotion_id=promotion.id where studentatt.is_deleted=0 AND studentatt.promotion_id='$promotion'")->row_array();
            $data1['total_marks'] = 0;
            $data1['obtained_marks'] = 0;
            foreach($result_subjects as $k=>$v)
            {
                $data1['total_marks'] += $v->total_marks;
                $data1['obtained_marks'] += $v->obtained_marks;
                
            }
            $final = round(($data1['obtained_marks'] / $data1['total_marks']) * 100);
             if($final>=80){ $data1['grade'] = "A*";}
            else if($final>=70){ $data1['grade'] = "A";}
            else if($final>=60){ $data1['grade'] = "B";}
            else if($final>=50){ $data1['grade'] = "C";}
            else if($final>=40){ $data1['grade'] = "D";}
            else if($final>=30){ $data1['grade'] = "E";}
            else if($final<=30){ $data1['grade'] = "FAIL";}
            if(empty($student_att['total']))
            {
                $student_att['total']=1;
            }else
            {
                $student_att['total']=$student_att['total'];
            }
            $data1['attendance'] = round(($student_att['pre']/$student_att['total'])*100);
            $this->db->where("id",$result_id)->update("result",$data1);
        }
    } 

    /* Helper Functions */ 

    private function random_numbers($digits) {
        $min = pow(10, $digits - 1);
        $max = pow(10, $digits) - 1;
        return mt_rand($min, $max);
    }
    
    private function marksort($a, $b) {
        $a = $a['obtained_marks'];
        $b = $b['obtained_marks'];
        if ($a == $b)
            return 0;
        return ($a > $b) ? -1 : 1;
    }
    
    private function makeposition($arr) {
      
        $arr = json_decode(json_encode($arr),true);
  
        usort($arr, array($this,"marksort"));
     
        $i = 1;
        $prev_obtain_marks = "1st";
        foreach($arr as $k=>$v)
        {
            if($prev_obtain_marks=="1st" OR $prev_obtain_marks!=$v["obtained_marks"])
            {
                $p = $i;
                $i++;
            }else{
                $p = $i - 1;
            }
            if($p==1 OR $p==21 OR $p==31)
                $subfix = "st";
            else if($p==2 OR $p==22 OR $p==32 OR $p==42 OR $p==52 OR $p==62 OR $p==72 OR $p==82 OR $p==92)
                $subfix = "nd";
            else if($p==3 OR $p==23 OR $p==33 OR $p==43 OR $p==53 OR $p==63 OR $p==73 OR $p==83 OR $p==93)
                $subfix = "rd";
            else
                $subfix = "th";
            $arr[$k]['position'] = $p.$subfix;
            unset($arr[$k]['total_marks']);
            unset($arr[$k]['obtained_marks']);
            $prev_obtain_marks = $v["obtained_marks"];
        }
     
        return $arr;
        // var_dump("<pre>",$arr);die();
    }

    public function ClassWiseResultReport($class=0,$section=0,$exam=0)
    {
        $branch=$this->user_model->getBranch();
        $data['is_super'] = $this->is_super;
        $data['menu'] = $this->load_model->menu();
        $data['student']=$this->db->query("SELECT result.id,student.sid,student.student_name,student.father_name,class.class_name,section.section_name,senior_exam_type.name as Exam_name,result.position  ,result.total_marks,result.obtained_marks from `result` inner join `promotion` on promotion.id=result.promotion_id inner join `student` on 
        `student`.`id`=`promotion`.`student_id` join `class` on class.class_id=`promotion`.`class_id` join section on section.section_id=promotion.section_id join exam_type on exam_type.id=result.exam_id where promotion.class_id='$class' AND promotion.section_id='$section' AND promotion.is_active=1 AND promotion.is_delete=0 AND student.status=0 AND result.exam_id='$exam' AND promotion.class_id='$class' AND promotion.section_id='$section'")->result_array();
        $data['b_header']= $this->db->query("SELECT * FROM `branch` WHERE is_delete='0' AND id='$branch'")->row_array();
        $this->load->view("senior_exam/ClassWiseResultReport",$data);
    }
    

    
    public function DeleteResult()
    {
        $this->db->select('result.*');
        $this->db->from('result');
        $this->db->join('promotion','result.promotion_id=promotion.id');
        $this->db->where('promotion.is_delete',0)
        ->where('promotion.class_id',18)
        ->or_where('promotion.class_id',22);
        $result=$this->db->get()->result_array();
        //var_dump('<pre>',$result);die();
        
        
        
        foreach ($result as $key => $value) {
	    $this->db->where('id', $value['id']);
	    $this->db->delete('result');
	    //delete result_subject
	    $this->db->where('result_id', $value['id']);
	    $this->db->delete('result_subject');
	}
	echo "result successfully deleted";
    }
    
     public function check_Examename($etype_id,$names,$branch)
    {
     $name=rawurldecode($names);
    $this->db->select();
	$this->db->from('exam');
	$this->db->join('exam_type','exam_type.id = exam.etype_id');
	$this->db->where('exam_type.branch_id',$branch);
	$this->db->where('exam.name',$name);
	$this->db->where('exam.etype_id',$etype_id);
	$this->db->where('exam.is_delete',0);
	$this->db->where('exam_type.is_delete',0);
	$query = $this->db->get();
	//var_dump($query->num_rows());die;
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    public function check_Examenames($etype_id,$names,$id,$branch)
    {
     $name=rawurldecode($names);
    $this->db->select();
	$this->db->from('senior_exam');
	$this->db->where('senior_exam.id!=',$id);
	$this->db->join('senior_exam_type','senior_exam_type.id = senior_exam.etype_id');
	$this->db->where('senior_exam_type.branch_id',$branch);
	//$this->db->where('class_id',$class);
	$this->db->where('senior_exam.name',$name);
	$this->db->where('senior_exam.etype_id',$etype_id);
	$this->db->where('senior_exam.is_delete',0);
	$this->db->where('senior_exam_type.is_delete',0);
	$query = $this->db->get();
	//var_dump($query->num_rows());die;
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    
    public function saveType()
    {
            $name = $this->input->post("name",true);
            $branch = $this->input->post("branch",true);
            $description = $this->input->post("description",true);
            $data = array(
                "name"=>$name,
                "branch_id"=>$branch,
                "description"=>$description
            );
            $this->db->insert("exam_type",$data);  
            $edit_delete=$this->user_model->checkEditDelete('exam/type');
            $is_super = $this->is_super;
            $this->db->select("senior_exam_type.id,senior_exam_type.name,senior_exam_type.description,branch.name as b_name"); 
            $this->db->from('senior_exam_type');
            $this->db->join('branch','branch.id=senior_exam_type.branch_id');
            $this->db->where('senior_exam_type.is_delete','0'); 
            if(!$this->is_super)
            $this->db->where('senior_exam_type.branch_id',$this->branch);
            $this->db->order_by('senior_exam_type.id','desc'); 
            
            $query = $this->db->get();
            $examtype = $query->result_array();
            if(!empty($examtype))
            {
                    $i=0; 
                    foreach ($examtype as $key => $value)
                    { 
                        
                        $i++;
                    
                        echo "
                         <tr>
                                  <td>$i</td>
                                  <td>$value[name]</td>
                                  <td>$value[description]</td>";
                                  if($this->user_model->is_super()){
                                  echo "<td>$value[b_name]</td>";}
                                  echo "<td>";
                                  if($edit_delete['edit'] == 1){
                                             
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                  if($edit_delete['delete'] == 1){
                                             
                                            echo "<a href='' onclick='delete_type($value[id],event)'><i class='fa fa-trash'></i></a>";
                                  }
                                 echo "</td>";
                                 
                        echo"</tr>";
                        
                       } 
                       
            }   
            
            else
            {
                echo "";
            }
            
            
            
            
        
    }
    
    
    
    
    public function get_exam_type($id=0)
    {
        $branch=$this->user_model->getbranch();
        if($this->user_model->is_super()){
            $this->db->select("id,name,description as descriptions,branch_id"); 
            $this->db->from('senior_exam_type');
            $this->db->where('senior_exam_type.is_delete','0'); 
            $this->db->where('senior_exam_type.id',$id);
            $query = $this->db->get()->row_array();
        }
        else
        {
            $this->db->select("id,name,description as descriptions,branch_id"); 
            $this->db->from('senior_exam_type');
            $this->db->where('senior_exam_type.is_delete','0'); 
            $this->db->where('senior_exam_type.id',$id);
            $this->db->where('senior_exam_type.branch_id',$branch);
            $query = $this->db->get()->row_array();
        }
        
        echo json_encode($query);
    }
    
            
    public function updateexamType()
    {
            $id = $this->input->post("id",true);
            $name = $this->input->post("name",true);
            $branch = $this->input->post("branch",true);
            $description = $this->input->post("description",true);
            $data = array(
                "name"=>$name,
                "branch_id"=>$branch,
                "description"=>$description
            );
            $this->db->where('id',$id);
            $this->db->update("senior_exam_type",$data);  
            $edit_delete=$this->user_model->checkEditDelete('senior_exam/type');
            $is_super = $this->is_super;
            $this->db->select("senior_exam_type.id,senior_exam_type.name,senior_exam_type.description,branch.name as b_name"); 
            $this->db->from('senior_exam_type');
            $this->db->join('branch','branch.id=senior_exam_type.branch_id');
            $this->db->where('senior_exam_type.is_delete','0'); 
            if(!$this->is_super)
            $this->db->where('senior_exam_type.branch_id',$this->branch);
            $this->db->order_by('senior_exam_type.id','desc'); 
            
            $query = $this->db->get();
            $examtype = $query->result_array();
            if(!empty($examtype))
            {
                    $i=0; 
                    foreach ($examtype as $key => $value)
                    { 
                        
                        $i++;
                    
                        echo "
                         <tr>
                                  <td>$i</td>
                                  <td>$value[name]</td>
                                  <td>$value[description]</td>";
                                  if($this->user_model->is_super()){
                                  echo "<td>$value[b_name]</td>";}
                                  echo "<td>";
                                  if($edit_delete['edit'] == 1){
                                             
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                  if($edit_delete['delete'] == 1){
                                             
                                            echo "<a href='' onclick='delete_type($value[id],event)'><i class='fa fa-trash'></i></a>";
                                  }
                                 echo "</td>";
                                 
                        echo"</tr>";
                        
                       } 
                       
            }   
            
            else
            {
                echo "";
            }
            
            
            
            
        
    }        
    
    
    
    
    
    
    public function delete_exam_type()
    {
            $id = $this->input->post("id",true);
            $data = array(
                'is_delete' => "1",
            );
            $this->db->where("id",$id);
            $this->db->update("senior_exam_type",$data); 
            $this->db->where("etype_id",$id);
            $this->db->update("senior_exam",$data); 
            
            $edit_delete=$this->user_model->checkEditDelete('senior_exam/type');
            $is_super = $this->is_super;
            $this->db->select("senior_exam_type.id,senior_exam_type.name,senior_exam_type.description,branch.name as b_name"); 
            $this->db->from('senior_exam_type');
            $this->db->join('branch','branch.id=senior_exam_type.branch_id');
            $this->db->where('senior_exam_type.is_delete','0'); 
            if(!$this->is_super)
            $this->db->where('senior_exam_type.branch_id',$this->branch);
            $this->db->order_by('senior_exam_type.id','desc'); 
            
            $query = $this->db->get();
            $examtype = $query->result_array();
            if(!empty($examtype))
            {
                    $i=0; 
                    foreach ($examtype as $key => $value)
                    { 
                        
                        $i++;
                    
                        echo "
                         <tr>
                                  <td>$i</td>
                                  <td>$value[name]</td>
                                  <td>$value[description]</td>";
                                  if($this->user_model->is_super()){
                                  echo "<td>$value[b_name]</td>";}
                                  echo "<td>";
                                  if($edit_delete['edit'] == 1){
                                             
                                            echo "<a href='' onclick='edit($value[id],event)'><i class='fa fa-edit'></i></a>";
                                  }
                                  if($edit_delete['delete'] == 1){
                                             
                                            echo "<a href='' onclick='delete_type($value[id],event)'><i class='fa fa-trash'></i></a>";
                                  }
                                 echo "</td>";
                                 
                        echo"</tr>";
                        
                       } 
                       
            }   
            
            else
            {
                echo "";
            }
            
            
            
            
        
    }
    
    public function check_user($name,$class)
    {
    $this->db->select();
	$this->db->from('exam');
	$this->db->where('name',$name);
			$this->db->where('class_id',$class);

	$this->db->where('is_delete',0);
	$query = $this->db->get();
   
	if($query->num_rows() > 0)
			{
				 
				 $data =  1;
			}
		else{
		   
		    $data =  0;
		    }
		echo json_encode($data);
    }
    
    public function create_grading()
    {
        $this->user_model->check_permissions("senior_exam/create_grading");
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->is_super)
        {
           $data['branch'] = $this->db->select('id,name')->from("branch")->where("is_delete","0")->get()->result_array();
        }
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view("grading/create_grade",$data);
    }
    
    
    public function saveGrading()
    {
        //var_dump($this->input->post());die;
        $branch  = $this->input->post('branch',true);
        $minimum = $this->input->post('min',true);
        $maximum = $this->input->post('max',true);
        $grade   = $this->input->post('grade',true);
        $b = array(
            'branch'=>$branch
            );
            
        $this->db->insert("grading",$b);
        $last_id = $this->db->insert_id();
        //var_dump($last_id);die;
        foreach($minimum as $key=>$value)
        {
           $data = array(
                'branch' =>$branch,
                'grade_id'=>$last_id,
                'minimum'=>$value,
                'maximum'=>$maximum[$key],
                'grade' => $grade[$key]
               );
            $this->db->insert("grading_record",$data); 
               
        }
        
        redirect("senior_exam/create_grading","refresh");
        
    }
    
    public function publish($id=""){
        $this->db->where('id',$id);
        $this->db->update('senior_exam',array('is_publish'=>1));
        $result = $this->db->query("SELECT student.id,token FROM student INNER JOIN promotion on promotion.student_id = student.id INNER JOIN result on result.promotion_id = promotion.id WHERE result.exam_id= '$id'")->result_array();
        // echo "<pre>";print_r($result);exit;
        if($result){
            foreach($result as $key=>$value){
                if(!empty($value['token'])){
                    $tokens = array();
                    $tokens[]=$value['token'];
                    $msg = array("id"=>$value['id'],"message" =>"Your Child result is Live.","topic"=>"result" );
                    //  echo "<pre>";print_r($tokens);
                    //  echo "<pre>";print_r($msg);exit;
                    $this->api_model->send_notification($tokens,$msg);

                }
            }
        }
    // //   exit;
        redirect('senior_exam','refresh');
    }
    
    public function unpublish($id=""){
        $this->db->where('id',$id);
        $this->db->update('exam',array('is_publish'=>0));
        redirect('senior_exam','refresh');
    }



    

}

