<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class SmsHajana extends CI_Controller {

    private $userInfo = array();
    
    public function __construct()
    {
        parent::__construct();
        $this->load->library("hajanasms");
        $this->load->model("user_model");
        $this->load->library('PHPExcel');  
        $this->load->library('PHPExcel/IOFactory');
        $this->load->model("api_model");
    
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }
    
    public function send_sms()
    {
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch =$this->user_model->getbranch();
         if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();$this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/send_sms',$data);
    }

    public function send_excel_old()
    {
        if($this->input->post()) {
            $message=$this->input->post('message');
            $bid =$this->input->post('branch');
            
            #upload library loading
            $config['upload_path'] = './files/'; 
            $config['allowed_types'] = 'xlsx|csv|xls';
            $config['max_size'] = '10000'; 
            $config['overwrite'] = true;
            $config['encrypt_name'] = FALSE;

            $this->load->library('upload', $config);
            #=======================

            if ( ! $this->upload->do_upload('excel_sheet'))
            {
                    $error = array('error' => $this->upload->display_errors());
                    var_dump('<pre>',$error);
            }
            else
            {
                    $data = array('upload_data' => $this->upload->data());
                    $file= "./files/".$data['upload_data']['file_name'];
                    $Excel_file = IOFactory::load($file);
                    $sheetData = $Excel_file->getActiveSheet()->toArray(null,true,true,true);
            }
            $numbers=array_column($sheetData,'A');
            $numbers=$this->validate_numbers($numbers);
            
            if(!empty($numbers)) {
                $this->hajanasms->sendManyNumber($numbers,$message);
                 $data=count($numbers);
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
             //$branch = $this->user_model->getBranch();
             $arrayName = array(
                'date' => $da,
                'b_id' => $bid,
                'number' => $data,
                'is_delete'=>0  
                );
             $this->db->insert('sms_logs',$arrayName);
            }
            
            redirect('SmsHajana/send_sms','refresh');
        }
    }
    
    public function send_excel()
    {
        if($this->input->post()) {
            $message=$this->input->post('message');
            $bid =$this->input->post('branch');
            
            #upload library loading
            $config['upload_path'] = './files/'; 
            $config['allowed_types'] = 'xlsx|csv|xls';
            $config['max_size'] = '10000'; 
            $config['overwrite'] = true;
            $config['encrypt_name'] = FALSE;

            $this->load->library('upload', $config);
            #=======================

            if ( ! $this->upload->do_upload('excel_sheet'))
            {
                    $error = array('error' => $this->upload->display_errors());
                    var_dump('<pre>',$error);
            }
            else
            {
                    $data = array('upload_data' => $this->upload->data());
                    $file= "./files/".$data['upload_data']['file_name'];
                    $Excel_file = IOFactory::load($file);
                    $sheetData = $Excel_file->getActiveSheet()->toArray(null,true,true,true);
            }
            $numbers=array_column($sheetData,'A');
            $numbers=$this->validate_numbers($numbers);
       
            if(!empty($numbers)) {
              foreach($numbers as $numb)
               {
                 $this->hajanasms->sendOneNumber($numb,$message);
               }
              
               $data=count($numbers);
               date_default_timezone_set("Asia/Karachi");
               $da=date("Y-m-d");
               $arrayName = array(
                'date' => $da,
                'b_id' => $bid,
                'number' => $data,
                'is_delete'=>0  
                );
             $this->db->insert('sms_logs',$arrayName);
            }
            
            redirect('SmsHajana/send_sms','refresh');
        }
    }
    
    public function class_wise_abst()
    {
        $this->user_model->check_permissions("SmsHajana/section_wise_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/sms_abst',$data);
    }
    
        public function get_abs($c_id='')
    {
         $b=$this->input->post('branch');
         $c_id=$this->input->post('class');
        //var_dump($c_id); die();
          
        $students = $this->db->select('student.id as std_id,promotion.id as pro_id,student.father_contact')->where('student.branch',$b)->where('student.status',0)->where('promotion.is_active',1)
        ->where('promotion.class_id',$c_id)
        ->where('promotion.is_delete',0)->where('class.is_delete',0)->join('promotion','student.id=promotion.student_id')->join('class','promotion.class_id=class.class_id')->get('student')->result_array();
        $abs_num = array();
        foreach ($students as $key => $value) {
            $res = @$this->db->where('date',date('Y-m-d'))->where('student_id',$value['std_id'])->where('status_id',2)->where('promotion_id',$value['pro_id'])->get('studentatt')->result_array();
            if(!empty($res)){
                $abs_num[] = $value['father_contact'];
            }
        }
          $data=count($abs_num);
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
             $branch = $this->user_model->getBranch();
             $arrayName = array(
                'date' => $da,
                'b_id' => $b,
                'number' => $data,
                'is_delete'=>0  
                );
  $this->db->insert('sms_logs',$arrayName);
      //  var_dump('<pre>',$abs_num);die;
        
        
        $branch_name = $this->db->select('name')->where('id',$b)->where('is_delete','0')->get('branch')->row()->name;

        if(!empty($abs_num)){
            $message = "Dear Parents,\nWe hope that your child is healthy and well as he/she has not come to the school today \nDate: ".date('d-m-Y').".\nThank You,Principal\n$branch_name"; 
            // $message = "Dear Parents your child is absent from $branch_name.\nDate: ".date('d-m-Y')."\nThank You";
          $check = @$this->db->select('is_permit')->where('id',36)->get('tsms_permission')->row()->is_permit;
          if($check==1){
            $this->hajanasms->sendManyNumber($abs_num,$message);
          }
        }
        redirect('SmsHajana/class_wise_abst');
    }
    
    public function passout_sms_form()
    {
        $this->user_model->check_permissions("SmsHajana/passout_sms_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/pass_student',$data);
    }
    
    public function sendPassOut()
    {
        if($this->input->post()) {
            $data=$this->input->post();
            $message=$data['msg'];
            $student_ids=$data['students'];
            //var_dump('<pre>',$students);die();
            $students=$this->db->select('father_contact')->where('status !=',0)->where_in('id',$student_ids)->get('student')->result_array();
            foreach ($students as $key => $selected_student) {
                $numbers[]=$selected_student['father_contact'];
            }
            
            
                 $dat=count($numbers);
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
             $arrayName = array(
                'date' => $da,
                'b_id' => $data['branch'],
                'number' => $dat,
                'is_delete'=>0  
                );
             $this->db->insert('sms_logs',$arrayName);
            
            $this->hajanasms->sendManyNumber($numbers,$message);
            redirect('SmsHajana/passout_sms_form','refresh');
        }
    }
    

    public function validate_numbers($numbers='')
    {
        $valid_numbers=array();
        if($numbers!='') {
            foreach ($numbers as $key => $value) {
               if($this->is_valid_number($value))
               $valid_numbers[]=$value;
            }
        }
        return $valid_numbers;
    }

    public function is_valid_number($number='')
    {
        if($number!='') {
                if(!is_numeric($number))
                return false;
                elseif(strlen($number)<11 || strlen($number)>13)
                return false;
                else
                return true;
        }else{
            return false;
        }
    }
    
    public function report_sms() 
    {
         $b= $this->user_model->getBranch();
       //  var_dump($branch); die();
           $da=date('Y-m');
          // var_dump($da); die();
        
    $data['overall'] =  $this->db->query("SELECT sum(number) FROM `sms_logs` where b_id = $b and  left(date,7)='$da'")->row();
    
        //  var_dump( $data['overall'] ); die();
    $data['sing'] =  $this->db->query("SELECT * FROM `sms_logs` where b_id = $b and  left(date,7)='$da'")->row();
       // var_dump($data['overall']); die();   
        
         $this->load->view('HajanaSms/report');
        
        
        
    }

     public function smsForm()
    {
        $this->load->view('HajanaSms/smsform');
    }
    
     public function smsFormMulti()
    {
        $this->load->view('HajanaSms/smsform_multi');
    }

    public function class_wise_form()
    {
       // var_dump("helllo");
        //die();
        $this->user_model->check_permissions("SmsHajana/class_wise_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/sms_class',$data);
    }
    
    public function section_wise_form()
    {
       // var_dump("helllo");
        //die();
        $this->user_model->check_permissions("SmsHajana/section_wise_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/sms_student',$data);
    }
    
    public function sms_lecture()
    {
        // var_dump("helllo");
        //die();
        $this->user_model->check_permissions("SmsHajana/sms_lecture");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/sms_lecture',$data);
    }
    
    public function permisssion()
    {
        // var_dump("helllo");
        // die();
        $this->user_model->check_permissions("SmsHajana/permisssion");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
		$this->load->view('sidebar',$data);
		$this->load->view('HajanaSms/sms_permission',$data);
        
    }
    
    public function save_permission()
    {
        // echo "<pre>";print_r($this->input->post());exit;
        $data = $this->input->post();
        $this->db->update('tsms_permission',array('is_permit'=>0));
        if($data){
            $this->db->where_in('id',$data);
            $this->db->update('tsms_permission',array('is_permit'=>1));
        }
        redirect('SmsHajana/permisssion','refresh');
    }
      public function teacher_form()
    {
       //  var_dump("hello");
        //die();
        $this->user_model->check_permissions("SmsHajana/teacher_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/sms_teacher',$data);
    }
    
         public function staff_form()
    {
        
        //var_dump("hello");
        //die();
        $this->user_model->check_permissions("SmsHajana/teacher_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/sms_staff',$data);
    }
    
    public function sendSectionWise()
    {
        if($this->input->post()) {
            $data=$this->input->post();
           
            // echo "<pre>";print_r($data);exit;
            $message=$data['msg'];
            $student_ids=$data['students'];
            //var_dump('<pre>',$students);die();
            $students=$this->db->select('father_contact')->where('status',0)->where_in('id',$student_ids)->get('student')->result_array();
            foreach ($students as $key => $selected_student) {
                $numbers[]=$selected_student['father_contact'];
            }
            
            
            $dat=count($numbers);
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
             $arrayName = array(
                'date' => $da,
                'b_id' => $data['branch'],
                'number' => $dat,
                'is_delete'=>0  
                );
             $this->db->insert('sms_logs',$arrayName);
            // echo "<pre>";print_r($numbers);exit;
            
            $this->hajanasms->sendManyNumber($numbers,$message);
            redirect('SmsHajana/section_wise_form','refresh');
        }
    }
    
    public function send_sms_lecture(){
        $data=$this->input->post();
         $this->db->select('branch.name as b_name');
            $this->db->where('branch.id', $data['branch']);
            $b_name = $this->db->get('branch')->row()->b_name;
            
        $class=$data['class'];
        $total_lec=$this->db->select('count(id) as ids')
                            ->from('video_lecture')
                            ->where('class',$class)
                            ->where('show_status',0)
                            ->where('is_delete',0)
                            ->get()->row_array()['ids'];

        $student_ids=$data['students'];
        $students=$this->db->select('father_contact,student_name,promotion.id')->from('student')->join('promotion','promotion.student_id=student.id')->where_in('student.id',$student_ids)->where('promotion.is_active',1)->get()->result_array();
            foreach ($students as $key => $value) {
                    $number=$value['father_contact'];
                    $student_name=$value['student_name'];
                    $student_id=$value['id'];
                    $completed_lec=$this->db->select('count(id) as id')
                                            ->from('lecture_log')
                                            ->where('student_id',$student_id)
                                            ->get()->row_array()['id']; 
                    $rem=$total_lec-$completed_lec;
                    if(!empty($number) && !empty($student_id))
                    {
                      $message="Dear Parents, SLMHS-DHK delivered ".$total_lec." lectures and your child ".$student_name." have completed ".$completed_lec." lectures and total remaining lectures are ".$rem."\nRegards\nPrincipal\n$b_name";
                      $this->hajanasms->sendOneNumber($number,$message); 
                    }
                          
                }
        redirect('SmsHajana/sms_lecture','refresh');        
    }
    
    public function sendClassWise()
    {
        if($this->input->post()) {
            $data=$this->input->post();
            
            // echo "<pre>";print_r($data);exit;
            $message=$data['msg'];
            $class_ids=$data['class'];
            //var_dump('<pre>',$students);die();
            $students=$this->db->select('student.father_contact')->join('promotion','promotion.student_id=student.id')->where('student.status',0)->where_in('promotion.class_id',$class_ids)->get('student')->result_array();
            // echo "<pre>";print_r($students);exit;
            foreach ($students as $key => $selected_student) {
                $numbers[]=$selected_student['father_contact'];
            }
            
            
            $dat=count($numbers);
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
             $arrayName = array(
                'date' => $da,
                'b_id' => $data['branch'],
                'number' => $dat,
                'is_delete'=>0  
                );
             $this->db->insert('sms_logs',$arrayName);
            // echo "<pre>";print_r($numbers);exit;
            
            $this->hajanasms->sendManyNumber($numbers,$message);
            redirect('SmsHajana/class_wise_form','refresh');
        }
    }
    
    
         public function sendteachersms()
    {
        if($this->input->post()) {
            $data=$this->input->post();
            $message=$data['msg'];
            $teacher_ids=$data['teacher'];
          //  var_dump('<pre>',$student_ids);die();
            $teacher=$this->db->select('contact')->where_in('id',$teacher_ids)->get('teacher')->result_array();
            
//var_dump('<pre>',$teacher);die();
            foreach($teacher as $key => $selected_teacher) {
                $numbers[]=$selected_teacher['contact'];

            }
            $dat=count($numbers);
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
             //$branch = $this->user_model->getBranch();
             $arrayName = array(
                'date' => $da,
                'b_id' => $data['branch'],
                'number' => $dat,
                'is_delete'=>0  
                );
             $this->db->insert('sms_logs',$arrayName);
            
           // $numbers;
           //var_dump('<pre>',$numbers,$message);die();
            $this->hajanasms->sendManyNumber($numbers,$message);
            redirect('SmsHajana/teacher_form','refresh');
        }
    }
    
             public function sendstaffsms()
    {
        if($this->input->post()) {
            $data=$this->input->post();
            $message=$data['msg'];
            $staff_ids=$data['staff'];
          //  var_dump('<pre>',$student_ids);die();
            $teacher=$this->db->select('contact')->where_in('id',$staff_ids)->get('staff')->result_array();
            
//var_dump('<pre>',$teacher);die();
            foreach ($teacher as $key => $selected_teacher) {
                $numbers[]=$selected_teacher['contact'];

            }
            
            $dat=count($numbers);
            date_default_timezone_set("Asia/Karachi");
            $da=date("Y-m-d");
             $arrayName = array(
                'date' => $da,
                'b_id' => $data['branch'],
                'number' => $dat,
                'is_delete'=>0  
                );
             $this->db->insert('sms_logs',$arrayName);
           // $numbers;
          // var_dump('<pre>',$numbers,$message);die();
            $this->hajanasms->sendManyNumber($numbers,$message);
            redirect('SmsHajana/staff_form','refresh');
        }
    }
    
    

    public function result_sms_form()
    {
        $this->user_model->check_permissions("SmsHajana/result_sms_form");
        $branch = $this->user_model->getBranch();
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        if($this->user_model->is_super())    
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT * FROM `branch` WHERE `is_delete`='0' AND `id`='$branch'")->result_array();
        $data['session'] = $this->db->select("id,name")->from('session')->where("is_delete","0")->get()->result();
        $this->load->view('header',$data);
	$this->load->view('sidebar',$data);
        $this->load->view('HajanaSms/result_sms_form',$data);
    }

    public function sendResult()
    {
        if($this->input->post())
            {
                $b = $this->input->post("branch", true);
                $c = $this->input->post("class", true);
                $s = $this->input->post("section", true);
                $students = $this->input->post("students", true);
                $sess = $this->input->post("session", true);
                $api = $this->input->post("api", true);
                $e_type = $this->input->post("e_type", true);
                $sub_typeid= $this->input->post("sub_typeid",true);
                // echo "<pre>";print_r($sub_typeid);exit;
                $exam = $this->input->post("exam", true);
                $branch_name = $this->db->select("title")->from("branch")->where("id",$b)->get()->row()->title;
                $exam_name = $this->db->select("name")->from("exam")->where("id",$exam)->get()->row()->name;
                $this->db->select('`student`.`grno`,`student`.`id`,`student`.`student_name`,`student`.`father_contact`,`student`.`father_name`,`class`.`class_name`,`section`.`section_name`,`result`.`obtained_marks`,`result`.`total_marks`,SUM(`result_subject`.`obtained_marks`) as sub_obtain,sum(`result_subject`.`total_marks`) as sub_total,`grade`');
                $this->db->from('student');
                $this->db->join('`promotion`','promotion.student_id=student.id');
                $this->db->join('`class`','`class`.`class_id`=`promotion`.`class_id`');
                $this->db->join('`section`','`section`.`section_id`=`promotion`.`section_id`');
                $this->db->join('`result`','`result`.`promotion_id`=`promotion`.`id`');
                $this->db->join('`exam`','`result`.`exam_id`=`exam`.`id`');
                $this->db->join("result_subject","result.id=result_subject.result_id");
                $this->db->where('student.branch',$b);
                $this->db->where('promotion.class_id',$c);
                $this->db->where('promotion.session_id',$sess);
                $this->db->where('promotion.is_delete','0');
                $this->db->where('promotion.section_id',$s);
                $this->db->where('result.exam_id',$exam);
                $this->db->where_in('promotion.student_id',$students);
                $this->db->where('student.status','0');
                if(!empty($sub_typeid))
                {
                   $this->db->where("result_subject.subexam_id",$sub_typeid);
                }
                $student = $this->db->get()->result_array();
                if(!empty($sub_typeid))
                {
                   $sub_type_name = $this->db->select('name')->where('id',$sub_typeid)->get('examsubtype')->row()->name;
                }

                $data = array();
                
                $this->db->select('branch.name as b_name');
                $this->db->where('branch.id', $b);
                $b_name = $this->db->get('branch')->row()->b_name;
                // echo "<pre>";print_r($student);exit;
               // var_dump($student);
            //    die();
                
             
                
                
                
                foreach ($student as $key => $value) {
                    $number=$value['father_contact'];
                    if(!empty($sub_typeid))
                    {
                        $message="Name: ".$value['student_name']."\nFather Name: ".$value['father_name']."\nClass: ".$value['class_name']."\nExam: ".$exam_name."/".$sub_type_name."\nTotal Marks: ".$value['sub_total']."\nObtain Marks: ".$value['sub_obtain']."\nStatus: ".($value['grade']=="F"?"Fail":"Pass")."\nGrade: ".$value['grade']."\nThank You\nPrincipal\n$b_name";
                    }
                    else{
                        $message="Name: ".$value['student_name']."\nFather Name: ".$value['father_name']."\nClass: ".$value['class_name']."\nExam: ".$exam_name."\nTotal Marks: ".$value['total_marks']."\nObtain Marks: ".$value['obtained_marks']."\nStatus: ".($value['grade']=="F"?"Fail":"Pass")."\nGrade: ".$value['grade']."\nThank You\nPrincipal\n$b_name";
                    }
                    $this->hajanasms->sendOneNumber($number,$message);           
                }
redirect("SmsHajana/result_sms_form"); 
}
 }

    
    
    public function sendDailyattendSms()
    {
        $b=$this->user_model->getBranch();
        $branch_name = $this->db->select("name")->from("branch")->where("id",$b)->get()->row()->name;
        $data=$this->input->get();
        
        $Present=$data['present'];
        $Absent=$data['absent'];
        $Leave=$data['leave'];
        $ShortLeave=$data['shrt_leave'];
        $date=date('d-m-Y');
    $number=array("923337241654","923009318468");
    
    //$number=array("923069668966","923014228585");
        
   $message="R/sir Chairman SLMHS DHK Attendance status ".$date." Present Student: ".$Present." Absent Student: ".$Absent." Leave Student:".$Leave." Short Leave: ".$ShortLeave." ".$branch_name;
        
        //var_dump($message);
        //die();
       $this->hajanasms->sendManyNumber($number,$message);
       
       redirect(base_url(),'refresh');
    }
    
    public function absence() 
    {
           $b=$this->user_model->getBranch();
          // var_dump($b);
          // die();
        //$ym = date("Y-m-d");
        $ym = date( "Y-m-d", strtotime("last month") );
        


        //var_dump($ym);
        //die();
        $data=$this->db->select("student_id")->from("studentatt");
        $this->db->join('student','student.id = studentatt.student_id');
        $this->db->where('status_id',2)->where('date',$ym)->where('branch',$b)->get()->result_array();
        
      var_dump("<pre>",$data);
       die();
        foreach($data as $values)
        {
        $fcontact=$this->db->select("father_contact")->from("student")->where('id',$values['student_id'])->get()->result_array();
            $abs_message="Dear Parents your child is absent from Shah Latif Model High School.\nDate: ".$ym."\nThank You\nPrincipal\nSLM";
            var_dump($fcontact,$abs_message);
             //$this->hajanasms->sendOneNumber($number,$abs_message); 
        }
        die();
    }
    public function sendOneNumber()
    {
        if($this->input->post()) {
            $data=$this->input->post();
            // var_dump($data);die();
            $this->hajanasms->sendOneNumber($data['number'],$data['sms']);
            redirect('SmsHajana/smsForm','refresh');
        }
    }

    public function sendMultiNumber()
    {
        if($this->input->post()) {
            $data=$this->input->post();
            $data['number']=array('03344339575','923214313713','+923470467312');
            $this->hajanasms->sendManyNumber($data['number'],$data['sms']);
            //redirect('SmsHajana/smsFormMulti','refresh');
        }
    }
    
     public function sendbirthdaysms()
    {
        if($this->input->post()) {
            $data=$this->input->post();
            $message=$data['msg'];
            $teacher_ids=$data['teacher'];
          
            $teacher=$this->db->select('contact')->where_in('id',$teacher_ids)->get('teacher')->result_array();
            

            foreach($teacher as $key => $selected_teacher) {
                $numbers[]=$selected_teacher['contact'];

            }
           // $numbers;
           //var_dump('<pre>',$numbers,$message);die();
           // $this->hajanasms->sendManyNumber($numbers,$message);
            //redirect('SmsHajana/teacher_form','refresh');
        }
    }
    
     public function sendClosingSms()
    {
        $b=$this->user_model->getBranch();
        $branch_name = $this->db->select("name")->from("branch")->where("id",$b)->get()->row()->name;
        $data=$this->input->get();
        $income=$data['income'];
        $expense=$data['expense'];
        $students=$data['students'];
        $cash_deposit=$data['cash_deposit'];
        $cash_hand=$data['cash_hand'];
        $date=date('d-m-Y');
        $number = $this->db->select('contact,b_h_contact')->where('id',$b)->get('branch')->row_array();
        //$number=array("+923323929729");
        $message="Closing Account ".$date." Income: ".$income." Expense: ".$expense." Cash Deposit: ".$cash_deposit." Cash in Hand: ".$cash_hand."\n Total Students: ".$students." \n".$branch_name;
        
       // var_dump($number,$message);
      //die();
        
        
        
        $this->hajanasms->sendManyNumber($number,$message);
       redirect(base_url(),'refresh');
    }

    public function sendAbsentSms()
    {
        $b=$this->user_model->getBranch();
        $students = $this->db->select('student.id as std_id,promotion.id as pro_id,student.father_contact')->where('student.branch',$b)->where('student.status',0)->where('promotion.is_active',1)->where('promotion.is_delete',0)->where('class.is_delete',0)->join('promotion','student.id=promotion.student_id')->join('class','promotion.class_id=class.class_id')->get('student')->result_array();
        $abs_array = array();
        $abs_num = array();
        foreach ($students as $key => $value) {
            $res = $this->db->where('date',date('Y-m-d'))->where('student_id',$value['std_id'])->where('promotion_id',$value['pro_id'])->get('studentatt')->result_array();
            if(empty($res)){
                $abs_array[] = array(
                                    'student_id'=>$value['std_id'],
                                    'promotion_id'=>$value['pro_id'],
                                    'status_id'=>'2',
                                    'date'=>date('Y-m-d')
                                );
                $abs_num[] = $value['father_contact'];
            }
        }
        // var_dump('<pre>',$abs_num);die();

        if(!empty($abs_array) && !empty($abs_num)){
            $message = "Dear Parents your child is absent from Shah Latif Model High School.\nDate: ".date('d-m-Y')."\nThank You\nPrincipal\nSLM";
            $this->db->insert_batch('studentatt',$abs_array);
            $this->db->hajanasms->sendManyNumber($abs_num,$message);
        }
        redirect('home/');
    }

}?>