<?php
defined('BASEPATH') OR exit('No direct script access allowed');
/**
 * teacher Class
 *
 * @package     edusol
 * @subpackage  teacher
 * @author      Atif Razzaq
 * @link        http://atifrazzaq.arteck.xyz
 */
class teacher extends CI_Controller {

    private $userInfo = array();


    public function __construct()
    {
        parent::__construct();
        $this->load->model("user_model");
        $this->load->model("teacher_model");
        $this->user_model->check_login("admin");

        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
    }
            //Index method for insertion of teacher
    public function index()
    {   
        $branch=$this->user_model->getbranch();
        $this->user_model->check_permissions("teacher/index");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
         $data['department']=$this->db->where('department.is_delete',0)->get('department')->result_array(); 
         $data['class']=$this->db->where('class.is_delete',0)->where('class.branch',$branch)->order_by("orderr", "asc")->get('class')->result_array();  
        // var_dump('<pre>',$data['class']);
        // die();
        $this->db->select("id,name"); 
        $this->db->from('branch');
        
        $this->db->where('is_delete','0');
       if(!$this->user_model->is_super()){
        $branch=$this->user_model->getbranch();
        $this->db->where('id',$branch);
       } 
        if($this->user_model->is_super())
            $data['branch'] = $this->db->query("SELECT id,name FROM `branch` where is_delete='0'")->result_array();
        else
            $data['branch'] = $this->db->query("SELECT branch.id,branch.name FROM `branch`  where branch.is_delete='0' AND branch.id='".$branch."'")->result_array();
           
        $query = $this->db->get();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('teacher/teacher_add',$data);
        $this->load->view('footer',$data);
    }
             //show method is for showing teachers
    public function show()
    {
    	
        $this->user_model->check_permissions("teacher/show");
    $data['edit_delete']=$this->user_model->checkEditDelete('teacher/show');

        if($this->user_model->is_super()){
	        $query = $this->db->query("SELECT teacher.id,teacher.firstname,teacher.lastname,designation,teacher.contact,qualification,teacher.img,doj,dob,salery,specialization, branch.name as b_name,department.name FROM `teacher` JOIN branch on teacher.branch=branch.id   LEFT JOIN `department` on teacher.dpt=department.id WHERE  status='0' AND teacher.is_delete='0' ");
        
    }
    else{
    	$b=$this->user_model->getbranch();
	        $query = $this->db->query("SELECT teacher.id,teacher.firstname,teacher.lastname,designation,teacher.contact,qualification,teacher.img,doj,dob,salery,specialization, branch.name as b_name,department.name FROM `teacher` JOIN branch on teacher.branch=branch.id  LEFT JOIN `department` on teacher.dpt=department.id WHERE teacher.branch = '$b' AND status='0' AND teacher.is_delete='0' ");
       $data['branch']=$this->db->select("*")->from("branch")->where('id',$b)->get()->result_array();
    }   
    $data['is_super'] = $this->user_model->is_super();
        $data['userInfo'] = $this->userInfo;
        $data['base_url'] = base_url();
        $data['student'] = $query->result_array();
	$data['menu'] = $this->load_model->menu();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('teacher/teacher_view',$data);
    }
    
    public function admin_name($name)
    {
        $name=$this->db->select('*')
                       ->from('admin')
                       ->where('username',$name)
                       ->get()->row_array();
         if(!empty($name))
         {
             echo 1;
         }else
         {
             echo 0;
         }
    }
    
    public function admin_nameids($name,$id)
    {
        $name=$this->db->select('*')
                       ->from('admin')
                       ->where('username',$name)
                       ->where('id!=',$id)
                       ->get()->row_array();
         if(!empty($name))
         {
             echo 1;
         }else
         {
             echo 0;
         }
    }
    
    public function against($br)
    {
         if($br==0)
         {
	        $query = $this->db->query("SELECT teacher.id,teacher.firstname,teacher.lastname,designation,teacher.contact,qualification,teacher.img,doj,dob,salery,specialization, branch.name as b_name FROM `teacher` JOIN branch on teacher.branch=branch.id WHERE  status='0' AND teacher.is_delete='0' ");
         }
         else{
        $query = $this->db->query("SELECT teacher.id,teacher.firstname,teacher.lastname,designation,teacher.contact,qualification,teacher.img,doj,dob,salery,specialization, branch.name as b_name FROM `teacher` JOIN branch on teacher.branch=branch.id WHERE teacher.branch = '$br' AND status='0' AND teacher.is_delete='0' ");

         }
        $stds = $query->result_array();
        $return = "";
        $i = 1;
        foreach ($stds as $key => $value) {
            $return .= "<tr>";
            $return .= "<td>".$i++."</td>";
            $return .= "<td>".$value['firstname']." ".$value['lastname']."</td>";
            $return .= "<td>".$value['designation']."</td>";
            $return .= "<td>".$value['contact']."</td>";
            $return .="<td>"."<img src='$value[img]' width='40px' height='40px'>"."</td>";
            $return .= "<td>".$value['qualification']."</td>";
            $return .= "<td>".$value['specialization']."</td>";
            $newdate = date('d-m-Y',  strtotime($value['dob']));
              $newdate = date('d-m-Y',  strtotime($value['doj']));
            $return .= "<td>".$newdate."</td>";
            $return .= "<td>".$value['b_name']."</td>";
            
            
            $return .= "<td><a href='".base_url()."teacher/teacher_info/".$value['stid']."'><i class='fa fa-eye'></i></a>
            <a href='".base_url()."teacher/edit/".$value['stid']."'><i class='fa fa-edit'></i></a></td>";
            
            $return .= "</tr>";
        }
        echo $return;
    }

        //save method is for saving teachers
    public function save()
    {
        if($this->input->post())
        {
            $url = $this->do_upload();
            $this->load->library('upload');
            $data = $this->input->post();
            $db_insert = $this->teacher_model->save($data,$url);
            redirect("teacher/show","refresh");
        }
        else
        {
            redirect("teacher/index","refresh");

        }
    }
                //edit method is for getting values and shoeing in form
    public function edit($action,$p=1)
    {
           
           
             if($this->uri->segment(3))
             {
                $data['department']=$this->db->where('is_delete',0)->get('department')->result_array();   
                $branch=$this->user_model->getbranch();
                if($this->user_model->is_super())
                    $data['branch'] = $this->db->select("name,id")->from("branch")->get()->result_array();
                else
                    $data['branch'] = $this->db->select("name,id")->from("branch")->where("id",$branch)->get()->result_array();
            
                $data['menu'] = $this->load_model->menu();
                $id = $this->uri->segment(3);
                $id = explode(SALT,json_decode(base64_decode($id)))[0]; 
                
                $cur_month=date('Y-m');  
                $increments=$this->db->select('sum(amount) as amount')
                                   ->from('increments')
                                   ->where('refrence',"teacher")
                                   ->where('bothid',$id)
                                   ->where('month<=',$cur_month)
                                   ->where('is_del',0)
                                   ->get()->row_array()['amount'];
                                   
                if(!empty($increments)) 
                {
                    $data['increment']=$increments;
                }else
                {
                    $data['increment']=0;
                }
                 $data['values']= $this->db->where('id',$id)->get('teacher')->result_array()[0];
                 $data['admin']=$this->db->where('teacher_id',$id)->where('is_delete',0)->get('admin')->row_array();
                 $data['class']=$this->db->where('class.is_delete',0)->get('class')->result_array(); 
                 $data['userInfo'] = $this->userInfo;
                 $data['base_url'] = base_url();
                  // calling pages view
                 $this->load->view('header',$data);
                 $this->load->view('sidebar',$data);
                 $this->load->view('teacher/teacher_edit',$data);

             }
             else
             {
                redirect("teacher/show");
             }
      
    }
     public function delete($id)
    {
         $this->db->where('id',$id);
         $this->db->update('teacher',array('is_delete'=>1));
          
          $check_admin=$this->db->select('*')
                                ->from('admin')
                                ->where('teacher_id',$id)
                                ->where('is_delete',0)
                                ->get()->row_array();
          
          if(!empty($check_admin)){
              $this->db->where('teacher_id',$id);
              $this->db->update('admin',array('is_delete'=>1));
              
              $this->db->where('teacher_id',$id);
              $this->db->update('teacheralloc',array('is_deleted'=>1));
          }                        
         redirect("teacher/show","refresh");
    }
  
            //update method is for updating teacher record
    public function update()
    {
       
         //var_dump($this->input->post());die();
        if($this->input->post()){
            $url = $this->do_upload();
            $this->load->library('upload');
             $data = $this->input->post();
            
             if($url=='')
                    {
                
                  $q=$this->db->select('img')->where('id',$data['id'])->get('teacher')->row();
                        $url=$q->img;
                    }
           // var_dump($url);
           //die();
           
   
            $db_update = $this->teacher_model->update($data,$url);
            redirect("teacher/show","refresh");
        }
        else
        {
            redirect("teacher/show","refresh");
        }

   }

           //update method is for updating teacher record
    public function update_profile()
    {
       
         //var_dump($this->input->post());die();
        if($this->input->post()){
             $data = $this->input->post();
        
       $db_update = $this->teacher_model->update_profile($data);
            redirect("teacher/show","refresh");
        }
        else
        {
            redirect("teacher/show","refresh");
        }

   }
   
    private function do_upload()
    {

        $type = explode('.', $_FILES['img']['name']);
        $type = $type[count($type)-1];
        $url = "./images/".uniqid(rand()).'.'.$type;
        if (in_array($type, array("png","jpg","jpeg","gif","PNG","JPG","JPEG",)))
            if(move_uploaded_file($_FILES["img"]["tmp_name"], $url))
                return $url;
        return ""; 
    }  
                      //status is for showing teacher status
   public function status($q="all",$p=1)
   {
        $this->user_model->check_permissions("teacher/status");
        $data['is_super'] = $this->user_model->is_super();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->user_model->getbranch();      

       $query = $this->db->query("SELECT teacher.id,rol,dol,teacher.firstname,teacher.lastname,
                                  teacher.designation,teacher.contact,teacher.qualification,teacher.doj,teacher.dob,
                                  teacher.salery,teacher.specialization ,status.name
                                  FROM `teacher` 
                                  inner join `status` on teacher.status = status.id 
                                  WHERE teacher.branch = '$branch' AND teacher.is_delete='0'");//$sq1 LIMIT $offset, $per_page

        
        $data['teachers'] = $query->result_array();
        //  $data['end'] = ceil($total / $per_page);
            //calling  pages views
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('teacher/status',$data);


   }
            // status_update is for  upadte status of teacher
   public function status_update()
   {
        if($this->input->post())
        {
           $data=$this->input->post();
           $this->teacher_model->status_update($data);
           redirect('teacher/status');
        }
        else
        {
           redirect('teacher/status');

        }
   }

        //rollback is for back to 0 position
   public function rollback()
   {
            if($this->uri->segment(3))
            {
                $data = $this->uri->segment(3);
                $this->teacher_model->rollback($data);
                redirect('teacher/status','refresh');
            } 
            else
            {
                redirect('teacher/status','refresh');

            }
   }


    public function best_teachers()
    {
	$this->user_model->check_permissions("teacher/index");
        $data['base_url'] = base_url();
        $branch=$this->user_model->getbranch();
      //  var_dump($branch);
//        die();
            //menu and user information
        $data['menu'] = $this->load_model->menu();
        $data['userInfo'] = $this->userInfo;
        $branch=$this->user_model->getbranch();
	$query = $this->db->query("SELECT id,firstname,lastname FROM `teacher` WHERE branch = $branch AND status='0' AND is_delete='0'");
            // For view pages
        $data['teachers'] = $query->result_array();

        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('teacher/best_teachers',$data);
    }
    
    public function save_best_teachers()
    {
        if($this->input->post())
        {
            $data = $this->input->post();
            $db_insert = $this->teacher_model->best_teachers($data);
            redirect("teacher/best_teachers","refresh");
        }
        else
        {
            redirect("teacher/best_teachers","refresh");

        }
    }    
}
