<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * staff Class
 *
 * @package     edusol
 * @subpackage  Exam
 * @author      Sabeeh Murtaza
 * @link        http://facebook.com/sabeehking
 */
class Web extends CI_Controller {

    private $userInfo = array();
    private $is_super;
    private $branch;

    public function __construct()
    {
        parent::__construct();
        $this->user_model->check_login("admin");
        $this->userInfo = $this->user_model->userInfo("first_name,last_name");
        $this->is_super = $this->user_model->is_super();
        $this->branch = $this->user_model->getBranch();
    }

  public function slider()
    {       
         $this->user_model->check_permissions('web/slider');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/slider');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['slider']=$this->db->select('*')
                                     ->from('slider')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/slider',$data);
           // $this->load->view('footer',$data);
    }
   
   
  public function news()
  {       
         $this->user_model->check_permissions('web/news');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/news');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['news']=$this->db->select('*')
                                     ->from('news')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/news',$data);
           // $this->load->view('footer',$data);
    }
    
    public function save_news()
    {
        $data=$this->input->post();
        $this->db->insert('news',$data);
        $this->session->set_flashdata('succes_msg','Image successfully uploades');
        redirect('web/news');
    }
    
    public function edit_news($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['news']=$this->db->select('*')
                                 ->from('news')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/news_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_news()
    {
        $id=$this->input->post('edit_id');
        $title=$this->input->post('title');
        $description=$this->input->post('description');
        $date=$this->input->post('date');
        
        $data=array(
            'title'=>$title,
            'description'=>$description,
            'date'=>$date,
            );
        $this->db->where('id',$id)
                 ->update('news',$data);
        
        $this->session->set_flashdata('succes_msg','Recod successfully Updates');
                    redirect('web/news');         
    }
    
    public function delete_news($id)
    {
        $data=array(
            'is_delete'=>1
            );
        $this->db->where('id',$id)  
                 ->update('news',$data);
        
        $this->session->set_flashdata('succes_msg','Recod successfully Delete');
                    redirect('web/news');          
    }
    
    public function save_slider(){
           $url=$this->do_upload();
          
           $data = array(
                'img' => $url,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );

               $msg= $this->db->insert('slider',$data);
               if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Image successfully uploades');
                    redirect('web/slider');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/slider');
               }
      }
      
    public function delete_slider($id)
    {
        $data=array(
            'is_delete'=>1
            );
            $this->db->where('id',$id)
                     ->update('slider',$data);
         $this->session->set_flashdata('succes_msg','Image successfully delete');
                    redirect('web/slider');             
                     
    }
    
    public function Chairman_Message()
    {       
         $this->user_model->check_permissions('web/Chairman_Message');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/Chairman_Message');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['message']=$this->db->select('*')
                                     ->from('chairman_message')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/chairman_message',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_message($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['message']=$this->db->select('*')
                                 ->from('chairman_message')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/chairman_message_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_message(){
           $url=$this->do_upload();
           $name=$this->input->post('name');
           $description=$this->input->post('description');
           
           $id=$this->input->post('edit_id');
          if(!empty($url))
          {
            $data = array(
                'name' => $name,
                'description'=>$description,
                'image'=>$url,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('chairman_message',$data);
          }else{
             $data = array(
                'name' => $name,
                'description'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('chairman_message',$data); 
          }
           

               
               if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Message successfully Update');
                    redirect('web/Chairman_Message');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/Chairman_Message');
               }
      }

    public function do_upload()
    {
         
          $type = explode('.', $_FILES["img"]["name"]);
          $type = $type[count($type)-1];
          $url = "assets/web_images/".uniqid(rand()).'.'.$type;
             if (in_array($type, array("png","jpg","jpeg","gif","PNG","JPG","JPEG","GIF")))
               if(move_uploaded_file($_FILES["img"]["tmp_name"], $url))
               return $url;
             return null;

    }
    
    
    public function About()
    {       
         $this->user_model->check_permissions('web/About');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/About');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['about']=$this->db->select('*')
                                     ->from('about')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/about',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_about($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['about']=$this->db->select('*')
                                 ->from('about')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/about_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_about()
    {
           $description=$this->input->post('description');
           
           $id=$this->input->post('edit_id');
         
             $data = array(
                'description'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('about',$data); 
          
            if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Description successfully Update');
                    redirect('web/About');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/About');
               }
      }
      
     public function vision()
    {       
         $this->user_model->check_permissions('web/vision');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/vision');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['vision']=$this->db->select('*')
                                     ->from('vision')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/vision',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_vision($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['vision']=$this->db->select('*')
                                 ->from('vision')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/vision_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_vision()
    {
           $description=$this->input->post('description');
           
           $id=$this->input->post('edit_id');
         
             $data = array(
                'description'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('vision',$data); 
          
            if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Description successfully Update');
                    redirect('web/vision');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/vision');
               }
      }  
    
      public function mission()
    {       
         $this->user_model->check_permissions('web/mission');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/mission');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['mission']=$this->db->select('*')
                                     ->from('mission')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/mission',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_mission($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['mission']=$this->db->select('*')
                                 ->from('mission')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/mission_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_mission()
    {
           $description=$this->input->post('description');
           
           $id=$this->input->post('edit_id');
         
             $data = array(
                'description'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('mission',$data); 
          
            if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Description successfully Update');
                    redirect('web/mission');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/mission');
               }
      }  
      
     public function video()
    {       
         $this->user_model->check_permissions('web/video');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/video');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['video']=$this->db->select('*')
                                     ->from('video')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/video',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_video($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['video']=$this->db->select('*')
                                 ->from('video')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/video_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_video()
    {
           $description=$this->input->post('link');
           
           $id=$this->input->post('edit_id');
         
             $data = array(
                'link'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('video',$data); 
          
            if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Link successfully Update');
                    redirect('web/video');
               }else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/video');
               }
    }   
    
      public function twitter()
    {       
         $this->user_model->check_permissions('web/twitter');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/twitter');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['twitter']=$this->db->select('*')
                                     ->from('twitter')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/twitter',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_twitter($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['twitter']=$this->db->select('*')
                                 ->from('twitter')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/twitter_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_twitter()
    {
           $description=$this->input->post('link');
           
           $id=$this->input->post('edit_id');
         
             $data = array(
                'link'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('twitter',$data); 
          
            if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Link successfully Update');
                    redirect('web/twitter');
               }else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/twitter');
               }
    } 
    
    public function facebook()
    {       
         $this->user_model->check_permissions('web/facebook');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/facebook');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['facebook']=$this->db->select('*')
                                     ->from('facebook')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/facebook',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_facebook($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['facebook']=$this->db->select('*')
                                 ->from('facebook')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/facebook_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_facebook()
    {
           $description=$this->input->post('link');
           
           $id=$this->input->post('edit_id');
         
             $data = array(
                'link'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('facebook',$data); 
          
            if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Link successfully Update');
                    redirect('web/facebook');
               }else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/facebook');
               }
    } 
   
    public function about_us()
    {       
         $this->user_model->check_permissions('web/about_us');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/about_us');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['about_us']=$this->db->select('*')
                                     ->from('about_us')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/about_us',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_about_us($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['about_us']=$this->db->select('*')
                                 ->from('about_us')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/about_us_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_about_us()
    {
           $description=$this->input->post('description');
           
           $id=$this->input->post('edit_id');
         
             $data = array(
                'description'=>$description,
                'created_by'=>$this->user_model->userInfo("id")['id']
                );  
            $msg= $this->db->where('id',$id)
                           ->update('about_us',$data); 
          
            if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Description successfully Update');
                    redirect('web/about_us');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/about_us');
               }
      }  
   
    public function gallery()
    {       
         $this->user_model->check_permissions('web/gallery');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/gallery');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['gallery']=$this->db->select('*')
                                     ->from('gallery')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/gallery',$data);
           // $this->load->view('footer',$data);
    }
    
    public function save_gallery()
    {
        $title=$this->input->post('title');
        $description=$this->input->post('description');

        $countfiles = count($_FILES['img']['name']);  
        if(!empty($countfiles)){
           foreach($_FILES['img']['name'] as $key=>$val){
                $type = explode('.', $_FILES["img"]["name"][$key]);
                $type = $type[count($type)-1];
                $url = "assets/web_images/".uniqid(rand()).'.'.$type;
                if (in_array($type, array("png","jpg","jpeg","gif","PNG","JPG","JPEG","GIF")))
               {
                   if(move_uploaded_file($_FILES["img"]["tmp_name"][$key], $url))
                   {
                             $data = array(
                                'title'=>$title,
                                'description'=>$description,
                                'img' => $url
                                );
                
                               $msg= $this->db->insert('gallery',$data);
                   }
               }
           }
        }    

             
         
               if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Image successfully upload');
                    redirect('web/gallery');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/gallery');
               }
    }
    
    public function edit_gallery($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['gallery']=$this->db->select('*')
                                 ->from('gallery')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/gallery_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_gallery()
    {
           $url=$this->do_upload();
           $title=$this->input->post('title');
           $description=$this->input->post('description');
           
           $id=$this->input->post('edit_id');
          if(!empty($url))
          {
            $data = array(
                'title' => $title,
                'description'=>$description,
                'img'=>$url
                );  
            $msg= $this->db->where('id',$id)
                           ->update('gallery',$data);
          }else{
             $data = array(
                'title' => $title,
                'description'=>$description
                );  
            $msg= $this->db->where('id',$id)
                           ->update('gallery',$data); 
          }
           

               
               if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Gallery successfully Update');
                    redirect('web/gallery');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/gallery');
               }
      }
      
    public function delete_gallery($id)
    {
        $data=array(
            'is_delete'=>1
            );
        $this->db->where('id',$id) 
                 ->update('gallery',$data);
       $this->session->set_flashdata('succes_msg','Record successfully delete');
       redirect('web/gallery');              
    }
    
    public function admissions()
    {       
         $this->user_model->check_permissions('web/gallery');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/gallery');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['admissions']=$this->db->select('*')
                                     ->from('admissions')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/admissions',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_admissions($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['admissions']=$this->db->select('*')
                                 ->from('admissions')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/admissions_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_admissions()
    {
           $url=$this->do_upload();
           $id=$this->input->post('edit_id');
           
          if(!empty($url))
          {
            $data = array(
                'img'=>$url
                );  
            $msg= $this->db->where('id',$id)
                           ->update('admissions',$data);
          }

           $this->session->set_flashdata('succes_msg','Image successfully Update');
            redirect('web/admissions');
    }
    
     public function contact_us()
    {       
         $this->user_model->check_permissions('web/contact_us');
         $data['edit_delete']=$this->user_model->checkEditDelete('web/contact_us');
            $data['branch'] = $this->user_model->getBranch();
            $data['menu'] = $this->load_model->menu();
            $data['base_url'] = base_url();
            $data['userInfo'] = $this->userInfo;
            $data['contact']=$this->db->select('*')
                                     ->from('contact_us')
                                     ->where('is_delete',0)
                                     ->get()->result_array();
            $this->load->view('header',$data);
            $this->load->view('sidebar',$data);
            $this->load->view('web/contact_us',$data);
            $this->load->view('footer',$data);
    }
    
    public function edit_contact($id)
    {
        $data['branch'] = $this->user_model->getBranch();
        $data['menu'] = $this->load_model->menu();
        $data['base_url'] = base_url();
        $data['userInfo'] = $this->userInfo;
        $data['contact']=$this->db->select('*')
                                 ->from('contact_us')
                                 ->where('id',$id)
                                 ->get()->row_array();
        $this->load->view('header',$data);
        $this->load->view('sidebar',$data);
        $this->load->view('web/contact_edit',$data);
        $this->load->view('footer',$data);
    }
    
    public function update_contact()
    {
           $data=$this->input->post();
           
           $id=$this->input->post('id');
        
          
            $msg= $this->db->where('id',$id)
                           ->update('contact_us',$data);
          if($msg)
               {
                   $this->session->set_flashdata('succes_msg','Record successfully Update');
                    redirect('web/contact_us');
               }
               else
               {
                 $this->session->set_flashdata('error_msg','Error occur');
                    redirect('web/contact_us');
               }
      }
    
}