

CREATE TABLE `admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(30) NOT NULL,
  `last_name` varchar(30) NOT NULL,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `contact_no` varchar(20) NOT NULL,
  `role_id` int(11) NOT NULL DEFAULT '0',
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `role_id_2` (`role_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
INSERT INTO admin VALUES
("1","Rehan","Ahmed","rehan_ahmed","rehan@softvilla.com.pk","500f98179cacb15af39972bdd701646a","00000000000","1","0");--


--

CREATE TABLE `api` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `code` varchar(50) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `branch_id` (`branch_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `attendancestatus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `status` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `branch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `address` varchar(300) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `b_head` varchar(100) NOT NULL,
  `b_h_contact` varchar(20) NOT NULL,
  `c_person` varchar(200) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `certificate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `file` varchar(255) NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT '1',
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `certificate_issued` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `cert_id` int(11) NOT NULL,
  `date` varchar(100) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `std_id` (`std_id`,`cert_id`),
  KEY `cert_id` (`cert_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `city` (
  `city_id` int(11) NOT NULL AUTO_INCREMENT,
  `city_name` text NOT NULL,
  `district_id` int(11) NOT NULL,
  `country_id` int(11) NOT NULL,
  `province_id` int(11) NOT NULL,
  `is_delete` int(11) DEFAULT '0',
  PRIMARY KEY (`city_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `class` (
  `class_id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) NOT NULL,
  `class_name` text NOT NULL,
  `description` text NOT NULL,
  `tution_fee` bigint(20) NOT NULL,
  `admin_fee` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `country` (
  `country_id` int(11) NOT NULL AUTO_INCREMENT,
  `country_name` text NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`country_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `district` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `province_id` int(11) NOT NULL,
  `country_id` int(11) NOT NULL,
  `is_delete` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `exam` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `branch_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `start` date NOT NULL,
  `end` date NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `fee_def` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `amount` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `branch_id` (`branch_id`),
  KEY `class_id` (`class_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `fee_installment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice` int(11) NOT NULL,
  `fee_id` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_id` int(11) NOT NULL,
  `student_id` int(11) NOT NULL,
  `fee_pack` int(11) NOT NULL,
  `admin_fee` int(11) NOT NULL,
  `recieved` int(11) NOT NULL,
  `remaining` int(11) NOT NULL,
  `advance` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `date` date NOT NULL,
  `date_expire` date NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `leave_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `std_id` int(11) NOT NULL,
  `branch` int(11) NOT NULL,
  `conduct` varchar(50) NOT NULL,
  `progress` varchar(50) NOT NULL,
  `dol` varchar(10) NOT NULL,
  `rol` varchar(100) NOT NULL,
  `remarks` varchar(300) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `std_id` (`std_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `icon` varchar(50) NOT NULL,
  `order` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order` (`order`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=latin1;

--
INSERT INTO menu VALUES
("1","Admin","fa-users","1","0"),
("2","Branch","fa-building-o","2","0"),
("3","Teachers","fa-graduation-cap","6","0"),
("4","SMS","fa-envelope","12","0"),
("5","Class","fa-building-o","3","0"),
("6","Status","fa-building-o","15","1"),
("7","Section","fa-building-o","4","0"),
("8","Staff","fa-graduation-cap","7","0"),
("9","Student","fa-users","5","0"),
("10","Definition","fa-book","14","0"),
("11","Fee","fa-file-o","8","0"),
("12","Settings","fa-gear","16","0"),
("13","Attendance","fa-bar-chart","10","0"),
("14","Subject","fa-book","9","0"),
("15","Certificate","fa-bookmark-o","13","0"),
("16","Examination","fa-graduation-cap","11","0"),
("17","Transport","fa-bus","17","0");--


--

CREATE TABLE `permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) NOT NULL,
  `menu_id` int(11) NOT NULL,
  `submenu_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `admin_id` (`admin_id`,`menu_id`,`submenu_id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

--
INSERT INTO permission VALUES
("1","1","1","1"),
("2","1","1","2"),
("3","1","1","3"),
("4","1","1","4"),
("5","1","2","5"),
("6","1","2","6"),
("7","1","12","26");--


--

CREATE TABLE `pro_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) NOT NULL,
  `std_id` int(11) NOT NULL,
  `examination` varchar(20) NOT NULL DEFAULT ' ',
  `seat_no` varchar(20) NOT NULL DEFAULT ' ',
  `grade` varchar(10) NOT NULL DEFAULT ' ',
  `marks` varchar(11) NOT NULL DEFAULT ' ',
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `std_id` (`std_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `promotion` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `session_id` int(11) NOT NULL,
  `is_active` int(11) NOT NULL DEFAULT '1',
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `province` (
  `province_id` int(11) NOT NULL AUTO_INCREMENT,
  `province_name` text NOT NULL,
  `country_id` int(11) NOT NULL,
  `is_delete` int(11) DEFAULT '0',
  PRIMARY KEY (`province_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `result` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exam_id` int(11) NOT NULL,
  `teacheralloc_id` int(11) NOT NULL,
  `promotion_id` int(11) NOT NULL,
  `total_marks` int(11) NOT NULL,
  `passing_marks` int(11) NOT NULL,
  `obtained_marks` int(11) NOT NULL,
  `paper_date` date NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `role` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `remarks` varchar(500) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `branch_id` (`branch_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

--
INSERT INTO role VALUES
("1","0","Super","This is super admin role","0");--


--

CREATE TABLE `section` (
  `section_id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) NOT NULL,
  `section_name` text NOT NULL,
  `description` text NOT NULL,
  `class_id` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL,
  PRIMARY KEY (`section_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `session` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `staff` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) NOT NULL,
  `firstname` text NOT NULL,
  `lastname` text NOT NULL,
  `cnic` text NOT NULL,
  `contact` text NOT NULL,
  `salery` bigint(20) NOT NULL,
  `designation` text NOT NULL,
  `qualification` text NOT NULL,
  `dob` date NOT NULL,
  `doj` date NOT NULL,
  `address` text NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `staffatt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `staff_id` int(11) NOT NULL,
  `status_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `is_deleted` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `stop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `fee` bigint(20) NOT NULL,
  `city_id` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `student` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grno` text NOT NULL,
  `roll_no` bigint(20) NOT NULL,
  `branch` int(11) NOT NULL,
  `student_name` text NOT NULL,
  `father_name` text NOT NULL,
  `surname` text NOT NULL,
  `gender` text NOT NULL,
  `guardian_name` text NOT NULL,
  `previous_school` text NOT NULL,
  `relation_with_guardian` text NOT NULL,
  `father_cnic` text NOT NULL,
  `guardian_cnic` text NOT NULL,
  `mark_identification` text NOT NULL,
  `religion` text NOT NULL,
  `mother_tongue` text NOT NULL,
  `dob` date NOT NULL,
  `date_of_admission` date NOT NULL,
  `taluka` text NOT NULL,
  `district` text NOT NULL,
  `father_occupation` text NOT NULL,
  `guardian_occupation` text NOT NULL,
  `income_family` text NOT NULL,
  `img` text NOT NULL,
  `perment_address` text NOT NULL,
  `postal_address` text NOT NULL,
  `father_contact` text NOT NULL,
  `student_contact` text NOT NULL,
  `guardian_contact` text NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `studentatt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `student_id` int(11) NOT NULL,
  `status_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `is_deleted` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `is_deleted` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `submenu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `link` varchar(200) NOT NULL,
  `menu_id` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=latin1;

--
INSERT INTO submenu VALUES
("1","All Users","admin/user/view","1","0"),
("2","Add User","admin/user/add","1","0"),
("3","Manage Roles","admin/role/manage","1","0"),
("4","Permissions","admin/permission/manage","1","0"),
("5","Add Branch","branch/add","2","0"),
("6","View Branch","branch/view","2","0"),
("7","Add Teacher","teacher/index","3","0"),
("8","View Teachers","teacher/show","3","0"),
("9","Teachers Status","teacher/status","3","0"),
("10","Manage API\'s","sms/api/manage","4","0"),
("11","Add Class","classes/create","5","0"),
("12","View Classes","classes/index","5","0"),
("13","View / ADD Status","status/index","3","0"),
("14","Add Section","section/create","7","0"),
("15","View Sections","section/index","7","0"),
("16","Add Staff","staff/index","8","0"),
("17","View Staff","staff/show","8","0"),
("18","Add Student","student/index","9","0"),
("19","View Student","student/show","9","0"),
("20","Country","country/index","10","0"),
("21","Province","province/index","10","0"),
("22","District","district/index","10","0"),
("23","City","city/index","10","0"),
("24","Fee Definition","fee/add","11","0"),
("25","Fee View","fee/view","11","0"),
("26","Backup","backup/index","12","0"),
("27","SMS To Teachers","sms/view/teacher","4","0"),
("28","SMS To Students","sms/view/student","4","0"),
("29","Mark Student Attendance","student/studentatt_add","13","0"),
("30","View Student Attendance","student/studentatt_show","13","0"),
("31","Mark Teacher Attendance","Teacherattendancecr/index","13","0"),
("32","View Teacher Attendance","Teacherattendancecr/view","13","0"),
("33","Mark Staff Attendance","staff/staffatt_add","13","0"),
("34","View Staff Attendance","staff/staffatt_view","13","0"),
("37","Subject","subject/index","14","0"),
("38","Subject Assign To Teacher","subject/allocation","14","0"),
("39","Create Voucher","voucher/index","11","0"),
("40","Voucher List","voucher/listv","11","0"),
("41","SMS To Absent Students","sms/view/absent","4","0"),
("42","Create Cetrificate","certificate/index","15","0"),
("43","Edit Certificate","certificate/edit","15","0"),
("44","Add leave info","certificate/leave","15","0"),
("45","View leave info","certificate/view_leave","15","0"),
("46","Add Provisional info","certificate/provisional","15","0"),
("47","View Provisional info","certificate/provisional_view","15","0"),
("48","Manage Exams","exam/index","16","0"),
("49","Enter Marks","exam/selection","16","0"),
("50","Stop","transport/stop","17","0"),
("51","Transport Form","transport/coster_service","17","0");--


--

CREATE TABLE `teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `branch` int(11) NOT NULL,
  `firstname` text NOT NULL,
  `lastname` text NOT NULL,
  `cnic` text NOT NULL,
  `contact` text NOT NULL,
  `salery` bigint(20) NOT NULL,
  `designation` text NOT NULL,
  `qualification` text NOT NULL,
  `specialization` text NOT NULL,
  `dob` date NOT NULL,
  `doj` date NOT NULL,
  `address` text NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  `is_delete` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `teacheralloc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` int(11) NOT NULL,
  `subject_id` int(11) NOT NULL,
  `class_id` int(11) NOT NULL,
  `section_id` int(11) NOT NULL,
  `is_deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `teacherattendance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `teacher_id` int(11) NOT NULL,
  `status_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `is_deleted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--


--

CREATE TABLE `transport` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `grno` bigint(20) NOT NULL,
  `student_id` int(11) NOT NULL,
  `stop_id` int(11) NOT NULL,
  `is_active` int(11) NOT NULL,
  `is_delete` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--


--